/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstAccessSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUIManager;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodePhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeSummaryWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwCloneDepCalcWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterChecksWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterHostNameCheckWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwWelcomeWCDE;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class OiicAddNodeSession
extends OiicPullSession {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    public static final int WELCOME_IND = 0;
    public static final int ADDNODE_IND = 1;
    public static final int CLUSTER_CHECK_IND = 2;
    public static final int HOSTNAME_CHECK_IND = 3;
    public static final int ACCESS_SETUP = 4;
    public static final int CLONE_DEP_IND = 5;
    public static final int INST_SUMMARY_IND = 6;
    public static final int ADDNODE_PROGRESS_IND = 7;
    private static final String ADDNODE_README_LOC = "install/addnodereadme.txt";

    public void resetStreams() {
        try {
            OiixTeePrintStream.restoreSystemOut();
            OiixTeePrintStream.restoreSystemErr();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getReadmeLoc() {
        String sOracleHome = (String)this.getSessionVarValue("ORACLE_HOME");
        return OiixPathOps.concatPath(sOracleHome, ADDNODE_README_LOC);
    }

    public OiicAddNodeSession(OiicInstaller install, boolean silentMode) throws OiifbEndIterateException {
        super(install, silentMode);
        this.setAreaControls(null);
        this.initialize();
    }

    public OiicAddNodeSession(OiicInstaller install) throws OiifbEndIterateException {
        this(install, false);
    }

    public void dispose() {
        super.dispose();
        OiifbUIManager.setSession(null);
    }

    public void disposeUnusedUIObjects() {
    }

    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwWelcomeWCDE welcome = new OiifwWelcomeWCDE(this.m_sessionContext, 1);
        iterEls.addElement(welcome);
        OiifwAddNodeWCDE addNode = new OiifwAddNodeWCDE(this.m_sessionContext, 2);
        iterEls.addElement(addNode);
        OiifwClusterChecksWCCE clsCheck = new OiifwClusterChecksWCCE(this.m_sessionContext, 3);
        iterEls.addElement(clsCheck);
        OiifwClusterHostNameCheckWCCE hostCheck = new OiifwClusterHostNameCheckWCCE(this.m_sessionContext, 4);
        iterEls.addElement(hostCheck);
        OiicInstAccessSetupWCCE setupAccess = new OiicInstAccessSetupWCCE(this.m_sessionContext, 5);
        iterEls.addElement(setupAccess);
        OiifwCloneDepCalcWCCE depCalc = new OiifwCloneDepCalcWCCE(this.m_sessionContext, 6);
        iterEls.addElement(depCalc);
        OiifwAddNodeSummaryWCDE summary = new OiifwAddNodeSummaryWCDE(this.m_sessionContext, 7);
        iterEls.addElement(summary);
        OiifwAddNodePhaseWCDE addnodeWCDE = new OiifwAddNodePhaseWCDE(this.m_sessionContext);
        iterEls.addElement(addnodeWCDE);
        return iterEls;
    }

    public void initSession() throws OiifbEndIterateException {
        this.m_namespaceTable = new Hashtable();
        this.m_sessionContext = new OiicSessionContext(this);
        this.m_namespaceTable.put(this.m_sessionContext, new Hashtable());
        this.m_sessionContext.setVariables();
        this.setInventoryLocation(this.getInvLoc());
        this.setSessionMode("AddNode");
        if (!this.isAPIMode()) {
            OiisVariable homeVar = this.m_sessionContext.getVariable("ORACLE_HOME");
            OiisVariable fromLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
            String sHomeLoc = (String)homeVar.getValue();
            if (sHomeLoc == null || sHomeLoc.equals("")) {
                String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OH_LOCATION_NOT_SPECIFIED");
                OiicExitCode.setExitCode(-2);
                throw new OiifbEndIterateException(sErr);
            }
            try {
                String invDir = OiixPathOps.concatPath(sHomeLoc, "inventory");
                String sCompsFileLoc = OiiiInstallAreaControl.getXMLCompsFileLoc(sHomeLoc);
                fromLocVar.setValue(sCompsFileLoc);
                fromLocVar.setAdvice(true);
                OiisVariable oRootShLoc = this.m_sessionContext.getVariable("ROOTSH_LOCATION");
                oRootShLoc.setValue(OiixPathOps.concatPath(sHomeLoc, "root.sh"));
                oRootShLoc.setAdvice(true);
                OiisVariable oRootShStatus = this.m_sessionContext.getVariable("ROOTSH_STATUS");
                oRootShStatus.setValue(new Integer(3));
                oRootShStatus.setAdvice(true);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            OiiodDepEngine depEngine = new OiiodDepEngine(this);
            this.setDepEngine(depEngine);
        }
    }

    public void cleanupScratchPath() {
        String compLoc = System.getProperty("oracle.installer.scratchPath");
        String cleanLoc = OiixPathOps.getNativeForm(compLoc);
        OiixFileOps.recdelete(new File(cleanLoc));
    }

    public void releaseReaderLock() {
        try {
            OiiiTargetAreaControl otac = this.getTargetAreaControl();
            if (otac != null) {
                otac.releaseReaderLock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
        String invLoc = this.getInvLoc();
        if (invLoc != null) {
            return;
        }
        try {
            OiipgPropertyLoader pl = new OiipgPropertyLoader();
            invLoc = sInvLoc;
            if (invLoc == null) {
                invLoc = pl.getLocationFileLoc();
            }
            if (invLoc != null) {
                OiipgFileSystem.checkWritablePath(invLoc);
                OiiiInstallAreaControl.initAreaControl(invLoc);
                OiiiInstallAreaControl targetAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                this.m_installInv = targetAreaControl.getInstallInventory();
                if (this.m_installInv != null) {
                    this.setTargetAreaControl(targetAreaControl);
                    String logLoc = targetAreaControl.genFileSysLoc("logs");
                    OiiolTextLogger.setLogLoc(logLoc, "addNodeActions");
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTVER") + OiicBaseApp.getInstallerVersion().toString() + System.getProperty("line.separator"));
                } else {
                    invLoc = null;
                    String sMsg = OiixResourceBundle.getString("S_INV_SETUP_ERR");
                    throw new OiifbEndIterateException(sMsg);
                }
            }
            this.setInvLoc(invLoc);
            if (!Boolean.getBoolean("oracle.installer.ignoreLogMsg")) {
                String logStr = OiixResourceBundle.getString("S_LOG_LOC_PROMPT");
                String curLogFile = OiiolTextLogger.getCurLogFileName();
                if (curLogFile != null && curLogFile != "") {
                    Object[] arr = new String[]{curLogFile};
                    OiiolTextLogger.writeMessageToConsole(MessageFormat.format(logStr, arr));
                }
            }
        }
        catch (IOException e) {
            this.setInvLoc(null);
        }
        catch (OiipgPathException pge) {
            if (pge.getLevel() == OiipgPathException.INVALID_PATH) {
                File f = new File(invLoc);
                f.delete();
            }
            Object[] args = new Object[]{invLoc};
            String sMsg = OiixResourceBundle.getString("S_INV_START_SETUP_ERR", args);
            throw new OiifbEndIterateException(sMsg);
        }
    }

    protected void setTargetAreaControl(OiiiTargetAreaControl targetAreaControl) {
        super.setTargetAreaControl(targetAreaControl);
        this.m_installInv = ((OiiiInstallAreaControl)targetAreaControl).getInstallInventory();
    }

    public void setupAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        OiifbUIManager.setSession(this);
        if (this.getTargetAreaControl() != null) {
            this.grabLocks();
            this.getPgActionsPhase().initialize();
        }
        super.setupAccessObjects();
        OiixPlatform.optimize();
    }

    public OiisVariable getSessionVariable(String varName) {
        if (this.m_sessionContext != null) {
            return this.m_sessionContext.getVariable(varName);
        }
        return null;
    }

    void disposePreStateObjects() {
        OiicSessionInterfaceManager.getInterfaceManager().disposePreStateChangeElements();
    }

    public void finalize() {
        this.dispose();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void initialize() throws OiifbEndIterateException {
        try {
            super.initialize();
        }
        catch (OiifbEndIterateException ee) {
            OiiolTextLogger.appendText(ee.getMessage());
            OiicExitCode.setExitCode(-1);
            throw ee;
        }
        if (!this.isAPIMode()) {
            OiisVariable homeVar = this.m_sessionContext.getVariable("ORACLE_HOME");
            String sHomeLoc = (String)homeVar.getValue();
            OiiiOracleHomeInfo homeInfo = this.m_installInv.getHomeWithLocation((String)homeVar.getValue());
            this.setOHIndex(homeInfo.getIndex());
            try {
                OiisVariable logLocVar = this.m_sessionContext.getVariable("LOG_LOCATION");
                logLocVar.setValue(OiixPathOps.concatPath(sHomeLoc, "cfgtoollogs"), true);
                OiiolTextLogger.setConfigLogLoc(sHomeLoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initSessionWithDepEngine() throws OiifbEndIterateException {
        OiisVariable homeVar = this.m_sessionContext.getVariable("ORACLE_HOME");
        OiisVariable fromLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
        String sHomeLoc = (String)homeVar.getValue();
        if (sHomeLoc == null || sHomeLoc.equals("")) {
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OH_LOCATION_NOT_SPECIFIED");
            OiicExitCode.setExitCode(-2);
            throw new OiifbEndIterateException(sErr);
        }
        try {
            String invDir = OiixPathOps.concatPath(sHomeLoc, "inventory");
            String sCompsFileLoc = OiiiInstallAreaControl.getXMLCompsFileLoc(sHomeLoc);
            fromLocVar.setValue(sCompsFileLoc);
            fromLocVar.setAdvice(true);
            OiisVariable oRootShLoc = this.m_sessionContext.getVariable("ROOTSH_LOCATION");
            oRootShLoc.setValue(OiixPathOps.concatPath(sHomeLoc, "root.sh"));
            oRootShLoc.setAdvice(true);
            OiisVariable oRootShStatus = this.m_sessionContext.getVariable("ROOTSH_STATUS");
            oRootShStatus.setValue(new Integer(3));
            oRootShStatus.setAdvice(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        OiiodDepEngine depEngine = new OiiodDepEngine(this);
        this.setDepEngine(depEngine);
        homeVar = this.m_sessionContext.getVariable("ORACLE_HOME");
        sHomeLoc = (String)homeVar.getValue();
        OiiiOracleHomeInfo homeInfo = this.m_installInv.getHomeWithLocation((String)homeVar.getValue());
        if (homeInfo == null) {
            Object[] args = new String[]{(String)homeVar.getValue()};
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_ORACLE_HOME", args);
            OiicExitCode.setExitCode(-2);
            throw new OiifbEndIterateException(sErr);
        }
        this.setOHIndex(homeInfo.getIndex());
        try {
            OiisVariable logLocVar = this.m_sessionContext.getVariable("LOG_LOCATION");
            logLocVar.setValue(OiixPathOps.concatPath(sHomeLoc, "cfgtoollogs"), true);
            OiiolTextLogger.setConfigLogLoc(sHomeLoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

