/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgRegistryException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicAttachHome
extends OiicBaseInventoryApp {
    private static OiicAttachHome s_oiicAttachHome = null;
    private static final String appName = "attachhome";
    private String sOBase = null;
    private String sOHomeLoc = null;
    private final String sComponent = "oui";
    private String sOHomeName;
    private String sFileName;
    private String chkpointFile;
    private static OicsICheckPointIndexSession cpis = null;
    private OicsICheckPointSession cps = null;

    private OiicAttachHome() {
        super(appName);
        Properties props = System.getProperties();
        props.put("oracle.installer.attachHome", "true");
        props.put("oracle.installer.silent", "true");
    }

    private OiicAttachHome(String app) {
        super(app);
        Properties props = System.getProperties();
        props.put("oracle.installer.attachHome", "true");
        props.put("oracle.installer.silent", "true");
    }

    public static OiicAttachHome getOiicAttachHomeInstance() {
        if (s_oiicAttachHome == null) {
            s_oiicAttachHome = new OiicAttachHome();
        }
        return s_oiicAttachHome;
    }

    protected OiiiOracleHomeInfo getOracleHomeInfo(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiiiMultipleSOHException, OiiiMissingDependeeException, IOException {
        int[] depOhs = new int[]{0};
        OiiiInstallInventory instinv = iac.getInstallInventory();
        this.m_sOracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        this.m_sOracleHomeName = (String)oContext.getVarValue("ORACLE_HOME_NAME");
        this.m_sCompositeHome = (String)oContext.getVarValue("COMPOSITE_HOME");
        this.m_sCompositeHomeType = (String)oContext.getVarValue("COMPOSITE_HOME_TYPE");
        OiiiOracleHomeInfo homeInfo = null;
        homeInfo = !this.m_bIsCompositeHomeOnly ? instinv.attachHomeEx(this.m_sOracleHomeName, this.m_sOracleHome, 0, depOhs, this.m_sCompositeHome, this.m_sCompositeHomeType) : instinv.attachCompositeHomeEx(this.m_sCompositeHomeType, this.m_sCompositeHome);
        return homeInfo;
    }

    protected void updateOHProperties(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext, boolean bSharedHome) throws OiisVarSettingException, OiifbCancelException, OiipgClusterException {
        String checkpointLoc;
        if (!this.m_bIsCompositeHomeOnly) {
            super.updateOHProperties(homeInfo, oContext, bSharedHome);
        }
        String string = checkpointLoc = this.computeCheckPointLoc(oContext) == null ? null : this.computeCheckPointLoc(oContext);
        if (checkpointLoc != null) {
            this.initializeCheckPointIndexSession(checkpointLoc, "oui");
        }
        this.initializeCheckPointSession(oContext);
        OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session for attachhome.");
        super.updateOHProperties(homeInfo, oContext, bSharedHome);
        homeInfo.updateDirtyFlags(2048L);
    }

    protected String getLogPrefix() {
        return "AttachHome";
    }

    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiiiMultipleSOHException, OiiiMissingDependeeException, IOException, Exception, OiifbCancelException, OiisVarSettingException, OiipgClusterException {
        OiiiOracleHomeInfo homeInfo = this.getOracleHomeInfo(iac, oContext);
        OicsICheckPointProperty cpp = null;
        OicsICheckPoint cp2 = null;
        String chkPointName2 = null;
        String invLoc = (String)oContext.getVarValue("INVENTORY_LOCATION");
        boolean bSharedHome = this.isSharedHome(homeInfo.getLocation(), this.m_sLocalNode);
        this.updateOHProperties(homeInfo, oContext, bSharedHome);
        OiisVariable ohVar = oContext.getVariable("ORACLE_HOME");
        String oracleHomeString = (String)ohVar.getValue();
        OiiiInstallInventory instInvPlugin = iac.getInstallInventory();
        OiiiOracleHomeInfo homeInfoPlugin = instInvPlugin.getHomeWithLocation(oracleHomeString);
        if (homeInfo != null) {
            boolean bPluginHome = Boolean.getBoolean("oracle.installer.plugin");
            if (bPluginHome) {
                homeInfoPlugin.setPluginHome(true);
            } else {
                homeInfoPlugin.setPluginHome(false);
            }
        }
        if (cpis != null) {
            cpp = this.sOBase != null ? OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)this.sOBase) : OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)"");
            chkPointName2 = "oracle.installer.attachHome";
            this.cps = cpis.initCheckPointSession(this.sFileName);
            if (this.cps != null && (cp2 = this.cps.getCheckPoint(chkPointName2)) == null) {
                cp2 = OicsCheckPointFactory.constructCheckPoint((int)1, (String)chkPointName2, (String)"This is the attachHome inventory operation");
                cp2.setCheckPointState(2);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME_NAME", (String)this.sOHomeName);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME", (String)this.sOHomeLoc);
                cp2.addCheckPointProperty(cpp);
                if (this.cps != null && cp2 != null) {
                    this.cps.addCheckPoint(cp2);
                }
            }
        }
        String[] clusterNodes = (String[])oContext.getVarValue("CLUSTER_NODES");
        try {
            boolean updateInstalltime;
            if (!this.m_bIsCompositeHomeOnly && (updateInstalltime = Boolean.getBoolean("oracle.installer.updateInstallTime"))) {
                OiiiInstallInventory instInv = iac.getInstallInventory();
                Vector installIEs = instInv.getAllCompsVect(homeInfo.getIndex(), OiixPlatform.getCurrentPlatform());
                int nComps = installIEs.size();
                Date newInstallTime = new Date(System.currentTimeMillis());
                for (int i = 0; i < nComps; ++i) {
                    OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
                    ie.setInstallTime(newInstallTime);
                }
            }
            iac.saveInstallInventory(null);
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            System.out.println(msg);
            OiiolTextLogger.appendText(msg);
            throw ex;
        }
        if (cp2 != null && this.cps != null) {
            cpp = OicsCheckPointFactory.constructStringProperty((String)"LOCALNODE", (String)this.m_sLocalNode);
            cp2.addCheckPointProperty(cpp);
            cpp = OicsCheckPointFactory.constructStringProperty((String)"CLUSTER_NODES", (String)OiixFunctionOps.implodeList(clusterNodes, ","));
            cp2.addCheckPointProperty(cpp);
            cp2.setCheckPointState(3);
            this.cps.addCheckPoint(cp2);
            this.cps.saveCheckPointSession();
            try {
                this.cps.closeCheckPointSession();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
        this.createRegEntries(oContext);
        if (this.m_saRemoteNodes != null && this.m_saRemoteNodes.length > 0) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            if (sCustomInvPtrLoc != null && sCustomInvPtrLoc.trim().length() > 0) {
                this.setupRemoteInvPtrLoc(clusterNodes, sCustomInvPtrLoc);
            }
            boolean bGenerateGUID = Boolean.getBoolean("oracle.installer.generateGUID");
            if (bSharedHome) {
                bGenerateGUID = false;
            }
            this.clsCmdAttachHome(clusterNodes, this.m_saRemoteNodes, this.m_sOracleHome, this.m_sOracleHomeName, homeInfo.isCRSHome(), this.m_sLocalNode, invLoc, sCustomInvPtrLoc, bSharedHome, bGenerateGUID);
        }
    }

    private void createRegEntries(OiicSessionContext oContext) throws IOException {
        String sHomeName = (String)oContext.getVarValue("ORACLE_HOME_NAME");
        boolean is10gRegistrySetupRequired = OiipgOracleHomes.is10gRegistrySetupRequired(sHomeName);
        OiipgOracleHomes.setupRegEntriesAndContext(oContext, !is10gRegistrySetupRequired);
        if (is10gRegistrySetupRequired) {
            String sHomeKey = (String)oContext.getVarValue("ORACLE_HOME_KEY");
            String[] asRegKeys = new String[]{"ORACLE_HOME", "ORACLE_HOME_NAME", "ORACLE_GROUP_NAME"};
            String sHomeLoc = (String)oContext.getVarValue("ORACLE_HOME");
            String sHomeFolder = (String)oContext.getVarValue("ORACLE_HOME_FOLDER");
            String[] asRegValues = new String[]{sHomeLoc, sHomeName, sHomeFolder};
            try {
                OiipgOracleHomes.setup10gStyleRegEntries(sHomeKey, asRegKeys, asRegValues);
            }
            catch (OiipgRegistryException e) {
                OiifmAlert.displayError(e.getErrorMessage());
            }
        }
    }

    public void clsCmdAttachHome(String[] nodeList, String[] nodesToRunOn, String oracleHome, String oracleHomeName, boolean bCRS, String currentNodeName, String invLoc, String invPtrLoc, boolean bSharedHome, boolean bGenerateGUID) {
        this.m_clsRunCmd = new OiipgClusterRunCmd(nodesToRunOn);
        String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
        String cmd = "";
        cmd = !bGenerateGUID ? "-attachHome -noClusterEnabled -nogenerateGUID ORACLE_HOME=" + oracleHome + " ORACLE_HOME_NAME=" + oracleHomeName + " CLUSTER_NODES=" + sNodeList : "-attachHome -noClusterEnabled ORACLE_HOME=" + oracleHome + " ORACLE_HOME_NAME=" + oracleHomeName + " CLUSTER_NODES=" + sNodeList;
        if (bCRS) {
            cmd = cmd + " CRS=true ";
        }
        this.runRemoteInvOpCmd(cmd, nodesToRunOn, oracleHome, oracleHomeName, currentNodeName, invLoc, invPtrLoc, bSharedHome);
    }

    public void performValidations(OiicSessionContext oContext) {
        try {
            super.performValidations(oContext);
        }
        catch (OiisVarSettingException e) {
            e.printStackTrace();
        }
        String oracleHomeName = (String)oContext.getVarValue("ORACLE_HOME_NAME");
        if (!this.m_bIsCompositeHomeOnly && oracleHomeName == null) {
            String sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_NAME_MISSING_ATTACHHOME_ERROR");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
    }

    private void initializeCheckPointSession(OiicSessionContext s_context) {
        if (s_context != null) {
            String checkpointLoc;
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicattachhome.");
            if (s_context.getVarValue("ORACLE_BASE") != null) {
                this.sOBase = (String)s_context.getVarValue("ORACLE_BASE");
            }
            if (s_context.getVarValue("ORACLE_HOME") != null) {
                this.sOHomeLoc = (String)s_context.getVarValue("ORACLE_HOME");
            }
            if (s_context.getVarValue("ORACLE_HOME_NAME") != null) {
                this.sOHomeName = (String)s_context.getVarValue("ORACLE_HOME_NAME");
            }
            String string = checkpointLoc = this.computeCheckPointLoc(s_context) == null ? null : this.computeCheckPointLoc(s_context);
            if (checkpointLoc != null) {
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(checkpointLoc, "checkpoints"));
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, "oui"));
                this.chkpointFile = "checkpoint_" + this.sOHomeName + ".xml";
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, this.chkpointFile));
                if (cpis != null) {
                    OiicExitOps.getExitOps().addIndexSessionObj(cpis);
                }
            }
        }
    }

    private String computeCheckPointLoc(OiicSessionContext s_context) {
        String oracleBase = null;
        String oracleHome = null;
        if (s_context.getVarValue("ORACLE_BASE") != null) {
            oracleBase = (String)s_context.getVarValue("ORACLE_BASE");
        }
        if (s_context.getVarValue("ORACLE_HOME") != null) {
            oracleHome = (String)s_context.getVarValue("ORACLE_HOME");
        }
        if (oracleBase != null) {
            return oracleBase;
        }
        if (oracleHome != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }

    private void initializeCheckPointIndexSession(String checkPointLoc, String moduleName) {
        if (checkPointLoc != null && moduleName != null) {
            cpis = OicsCheckPointFactory.getIndexSession((String)checkPointLoc, (String)moduleName);
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicattachhome.");
            OiiolTextLogger.appendText("Checkpoint:Location is- " + checkPointLoc);
        }
    }

    public static void main(String[] args) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Entering OiicAttachHome.main()", OiiolTextLogger.LOG_TRACE);
        }
        OiicAttachHome oAttachHome = OiicAttachHome.getOiicAttachHomeInstance();
        oAttachHome.main_helper(args);
    }
}

