/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicAttachSuite
extends OiicBaseInventoryApp {
    private static OiicAttachSuite s_oiicAttachSuite = null;
    private static final String appName = "attachsuite";

    private OiicAttachSuite() {
        super(appName);
        Properties props = System.getProperties();
        props.put("oracle.installer.attachSuite", "true");
        props.put("oracle.installer.silent", "true");
    }

    private OiicAttachSuite(String app) {
        super(app);
        Properties props = System.getProperties();
        props.put("oracle.installer.attachSuite", "true");
        props.put("oracle.installer.silent", "true");
    }

    public static OiicAttachSuite getOiicAttachSuiteInstance() {
        if (s_oiicAttachSuite == null) {
            s_oiicAttachSuite = new OiicAttachSuite();
        }
        return s_oiicAttachSuite;
    }

    protected void updateOHProperties(OiiiOracleHomeInfo homeInfo, String suite) {
        homeInfo.addSuite(suite);
    }

    protected String getLogPrefix() {
        return "AttachSuite";
    }

    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws IOException, Exception, OiifbCancelException, OiisVarSettingException {
        String[] oracleHomesList = (String[])oContext.getVarValue("ORACLE_HOMES");
        String suiteName = (String)oContext.getVarValue("SUITE_NAME");
        String oracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        OiiiInstallInventory instinv = iac.getInstallInventory();
        if (oracleHomesList.length > 1) {
            for (int i = 0; i < oracleHomesList.length; ++i) {
                String homeLoc = oracleHomesList[i];
                OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(homeLoc);
                this.updateOHProperties(homeInfo, suiteName);
            }
        } else {
            OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(oracleHome);
            this.updateOHProperties(homeInfo, suiteName);
        }
        try {
            iac.saveInstallInventory(null);
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            System.out.println(msg);
            OiiolTextLogger.appendText(msg);
            throw ex;
        }
        OiicExitOps.getExitOps().exit();
    }

    public void performValidations(OiicSessionContext oContext) {
        String sError;
        String[] oracleHomesList = (String[])oContext.getVarValue("ORACLE_HOMES");
        String suiteName = (String)oContext.getVarValue("SUITE_NAME");
        String oracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        if (suiteName == null) {
            sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUITE_NAME_MISSING_ATTACHSUITE_ERROR");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
        if (oracleHomesList.length < 1 && oracleHome == null) {
            sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_MISSING_ATTACHSUITE_ERROR");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
    }

    public static void main(String[] args) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Entering OiicAttachSuite.main()", OiiolTextLogger.LOG_TRACE);
        }
        OiicAttachSuite oAttachSuite = OiicAttachSuite.getOiicAttachSuiteInstance();
        oAttachSuite.main_helper(args);
    }
}

