/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAttachHome;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallAddOn;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiio.oiiol.OiiolCopyLogInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiicBaseInventoryApp
extends OiicBaseApp {
    protected OiipgClusterRunCmd m_clsRunCmd = null;
    private static OiicBaseInventoryApp m_oBaseInvApp = null;
    protected String m_sLocalNode = null;
    protected String m_sOracleHome = null;
    protected String m_sOracleHomeName = null;
    protected String m_sCompositeHome = null;
    protected String m_sCompositeHomeType = null;
    protected String[] m_saRemoteNodes = null;
    protected boolean m_bIsCompositeHomeOnly = false;
    private OiicSessionContext m_sessionContext = null;
    private List nodesFailed;
    private List nodesPassed;
    private boolean errorIgnore = false;

    protected abstract String getLogPrefix();

    protected OiicBaseInventoryApp(String app) {
        super(app);
        m_oBaseInvApp = this;
    }

    public static OiicBaseInventoryApp getOiicBaseInventoryApp() {
        return m_oBaseInvApp;
    }

    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    protected boolean isCFSPropertySpecified() {
        return Boolean.getBoolean("oracle.installer.cfs");
    }

    public OiicSessionContext getSessionContext() {
        return this.m_sessionContext;
    }

    protected void runRemoteInvOpCmd(String cmd, String[] nodesToRunOn, String oracleHome, String oracleHomeName, String currentNodeName, String invLoc, String invPtrLoc, boolean bSharedHome) {
        this.nodesFailed = Collections.synchronizedList(new ArrayList());
        this.nodesPassed = Collections.synchronizedList(new ArrayList());
        this.errorIgnore = false;
        if (invLoc != null) {
            cmd = cmd + " \"INVENTORY_LOCATION=" + invLoc + "\"";
        }
        if (invPtrLoc != null && invPtrLoc.trim().length() > 0) {
            cmd = cmd + " -invPtrLoc \"" + invPtrLoc + "\"";
        }
        if (bSharedHome) {
            cmd = cmd + " -cfs ";
        }
        String errMessage = cmd;
        RemoteCommandThread[] t = new RemoteCommandThread[nodesToRunOn.length];
        for (int i = 0; i < nodesToRunOn.length; ++i) {
            t[i] = new RemoteCommandThread(nodesToRunOn[i], cmd, oracleHome, oracleHomeName, currentNodeName);
            t[i].start();
        }
        this.waitForAllCommandsToComplete(nodesToRunOn);
        while (nodesToRunOn.length != this.nodesPassed.size() + this.nodesFailed.size()) {
        }
        if (this.nodesFailed.size() > 0) {
            errMessage = errMessage + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22008");
            OiicExitCode.setExitCode(-1);
            String[] nodesFailedStrArr = OiixVectorOps.list2StrArr(this.nodesFailed);
            errMessage = this.constructAlertMessage(errMessage, nodesFailedStrArr, oracleHome);
            if (!this.errorIgnore) {
                OiifmAlert.displayError(errMessage);
            }
        }
    }

    private void waitForAllCommandsToComplete(String[] nodesToRunOn) {
        while (nodesToRunOn.length == this.nodesPassed.size() + this.nodesFailed.size()) {
        }
    }

    public abstract void doOperation(OiiiInstallAreaControl var1, OiicSessionContext var2) throws OiifbCancelException, OiiiInventoryUpdateException, IOException, OiixException, OiiiMultipleSOHException, OiiiMissingDependeeException, Exception, OiisVarSettingException, OiipgClusterException;

    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
        this.processClusterNodeNameVar();
    }

    private void processClusterNodeNameVar() {
        if (this.isVarInCommandLineTable("CLUSTER_NODES")) {
            String clusterNodesStr = this.getFromCommandLineTable("CLUSTER_NODES");
            if (clusterNodesStr == null) {
                return;
            }
            clusterNodesStr = clusterNodesStr.trim();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                OiiolTextLogger.appendText("CLUSTER_NODES specified by user on command line is " + clusterNodesStr, OiiolTextLogger.LOG_BASIC);
            }
            if (clusterNodesStr.equals("")) {
                this.addToCommandLineTable("CLUSTER_NODES", "{}");
            } else if (clusterNodesStr.charAt(0) != '{') {
                String[] clusterNodes = OiixFunctionOps.explodeString(clusterNodesStr, ",");
                String clusterNodesFinal = "{";
                for (int i = 0; i < clusterNodes.length; ++i) {
                    clusterNodesFinal = clusterNodesFinal + "\"";
                    clusterNodesFinal = clusterNodesFinal + clusterNodes[i];
                    clusterNodesFinal = clusterNodesFinal + "\"";
                    if (i == clusterNodes.length - 1) continue;
                    clusterNodesFinal = clusterNodesFinal + ",";
                }
                clusterNodesFinal = clusterNodesFinal + "}";
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText("CLUSTER_NODES modified to suit SessionContext is " + clusterNodesFinal, OiiolTextLogger.LOG_BASIC);
                }
                this.addToCommandLineTable("CLUSTER_NODES", clusterNodesFinal);
            }
        }
    }

    public void performValidations(OiicSessionContext oContext) throws OiisVarSettingException {
        String oracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        String compositeHome = (String)oContext.getVarValue("COMPOSITE_HOME");
        if (oracleHome == null && compositeHome != null) {
            this.m_bIsCompositeHomeOnly = true;
        }
        if (!this.m_bIsCompositeHomeOnly && oracleHome == null) {
            String sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22006");
            OiiolTextLogger.writeMessageToConsole(sError);
            OiicExitCode.setExitCode(-1);
            boolean installAddOns = System.getProperty("oracle.installer.installaddons", "false").equalsIgnoreCase("true");
            boolean isBigCluster = System.getProperty("oracle.installer.bigCluster", "false").equalsIgnoreCase("true");
            if (installAddOns || isBigCluster) {
                if (OiicExitCode.getExitCode() != 0) {
                    OiicInstallAddOn.PLUGIN_STATUS = false;
                }
            } else if (!OiicBaseInventoryApp.isAPI()) {
                System.exit(OiicExitCode.getExitCode());
            }
        }
    }

    protected void setHomeLocalNode(OiiiOracleHomeInfo homeInfo, String localNode, boolean bSharedHome) {
        if (bSharedHome) {
            homeInfo.setLocalNode(null);
        } else {
            homeInfo.setLocalNode(localNode);
        }
    }

    protected boolean isSharedHome(String sOHPath, String localNode) {
        boolean bCFS = this.isCFSPropertySpecified();
        if (localNode != null && !bCFS && !Boolean.getBoolean("oracle.installer.local")) {
            OiipgCFSDriveCheck oCFSDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
            bCFS = oCFSDriveCheck.isDriveOnCFS(sOHPath);
        }
        return bCFS;
    }

    protected void updateOHProperties(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext, boolean bSharedHome) throws OiisVarSettingException, OiifbCancelException, OiipgClusterException {
        String[] clusterNodes = this.setClusterNodes(homeInfo, oContext);
        Vector oClusterNodes = OiixVectorOps.strArr2Vect(clusterNodes);
        boolean isBigCluster = Boolean.getBoolean("oracle.installer.bigCluster");
        this.m_sLocalNode = oContext.setLocalNodeName(homeInfo);
        boolean found = true;
        if (clusterNodes != null && clusterNodes.length > 0) {
            found = false;
            for (int i = 0; i < clusterNodes.length; ++i) {
                if (!clusterNodes[i].equalsIgnoreCase(this.m_sLocalNode)) continue;
                found = true;
                break;
            }
        }
        if (clusterNodes != null && clusterNodes.length > 0 && !found) {
            if (!isBigCluster) {
                throw new OiipgClusterException("OUI-25023", OiixResourceBundle.getString("OUI-25023"));
            }
            OiiolTextLogger.appendText("Since this is big cluster, ignoring check for LOCAL_NODE");
        }
        this.setHomeLocalNode(homeInfo, this.m_sLocalNode, bSharedHome);
        this.m_saRemoteNodes = oContext.setRemoteNodeList();
        Vector oRemoteNodes = OiixVectorOps.strArr2Vect(this.m_saRemoteNodes);
        if (this.m_saRemoteNodes != null && this.m_saRemoteNodes.length > 0) {
            String sRemoteNodes = OiixFunctionOps.implodeList(this.m_saRemoteNodes, ",");
            boolean foundLocalNode = false;
            if (this.m_saRemoteNodes != null && this.m_saRemoteNodes.length > 0) {
                foundLocalNode = false;
                for (int i = 0; i < this.m_saRemoteNodes.length; ++i) {
                    if (!this.m_saRemoteNodes[i].equalsIgnoreCase(this.m_sLocalNode)) continue;
                    foundLocalNode = true;
                    break;
                }
            }
            if (foundLocalNode) {
                Object[] args = new String[]{this.m_sLocalNode, sRemoteNodes};
                throw new OiipgClusterException("OUI-25024", OiixResourceBundle.getString("OUI-25024", args));
            }
            if (!OiixVectorOps.vectorSubset(oRemoteNodes, oClusterNodes, false)) {
                String sClusterNodes = OiixFunctionOps.implodeList(clusterNodes, ",");
                Object[] args = new String[]{sRemoteNodes, sClusterNodes};
                throw new OiipgClusterException("OUI-25022", OiixResourceBundle.getString("OUI-25022", args));
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("updateOHProperties::Oracle home information is:" + homeInfo.toString(), OiiolTextLogger.LOG_DETAILED);
        }
        OiisVariable ohVar = oContext.getVariable("ORACLE_HOME");
        String oracleHomeString = (String)ohVar.getValue();
        OiiiInstallInventory inv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
        OiiiOracleHomeInfo oldOHInfo = inv.getHomeWithLocation(oracleHomeString);
        String oldGUIDVal = oldOHInfo.getGUID();
        if (this.requireGUIDRecalculation(oldGUIDVal)) {
            String newGUIDVal = this.calculateGUIDValue(oracleHomeString);
            oldOHInfo.setGUID(newGUIDVal);
            oldOHInfo.setGUIDValueResetRequired(true);
        }
        OiisVariable crsVar = oContext.getVariable("CRS");
        boolean bCRS = homeInfo.isCRSHome();
        if (crsVar.isValueSetByUser()) {
            bCRS = (Boolean)crsVar.getValue();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("updateOHProperties::CRS home property set to :" + bCRS, OiiolTextLogger.LOG_DETAILED);
            }
            homeInfo.setCRSHome(bCRS);
        }
        if (!Boolean.getBoolean("oracle.installer.remoteInvocation") || !Boolean.getBoolean("oracle.installer.cfs")) {
            homeInfo.setDirty(true);
        } else if (Boolean.getBoolean("oracle.installer.updateNodeList")) {
            homeInfo.setDirty(true);
        } else {
            homeInfo.setDirty(false);
            homeInfo.clearHomeInvDirtyFlags();
        }
    }

    protected String[] setClusterNodes(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext) throws OiisVarSettingException, OiifbCancelException {
        OiisVariable clusterNodesVar = oContext.getVariable("CLUSTER_NODES");
        if (clusterNodesVar.isValueSetByUser() || OiicBaseInventoryApp.isAPI()) {
            String[] clusterList = (String[])clusterNodesVar.getValue();
            if (System.getProperty("oracle.installer.bigCluster", "false").equalsIgnoreCase("true")) {
                homeInfo.setNodeListBigCluster(OiixVectorOps.vect2StrArr(homeInfo.getNodeListBigCluster()));
            } else {
                homeInfo.setNodeList(clusterList);
            }
        } else {
            oContext.setVarValue("CLUSTER_NODES", OiixVectorOps.list2StrArr(homeInfo.getNodeList()));
        }
        return (String[])clusterNodesVar.getValue();
    }

    protected OiiiOracleHomeInfo getOracleHomeInfo(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiixException, IOException, OiiiMissingDependeeException {
        OiiiInstallInventory instinv = iac.getInstallInventory();
        this.m_sOracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(this.m_sOracleHome);
        if (homeInfo == null) {
            Object[] args = new String[]{this.m_sOracleHome};
            throw new OiixException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25016", args));
        }
        this.m_sOracleHomeName = homeInfo.getName();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("getOracleHomeInfo::Oracle home information is:" + homeInfo.toString(), OiiolTextLogger.LOG_DETAILED);
        }
        return homeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main_helper(String[] args) {
        OiicExitCode.setExitCode(0);
        OiicSessionContext oContext = null;
        try {
            this.processCommandLine(args);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                OiiolTextLogger.appendText("Done processing command line arguments", OiiolTextLogger.LOG_BASIC);
            }
            if (this.isHelpOptionSpecified()) {
                this.displayHelp();
            } else {
                oContext = new OiicSessionContext(this);
                OiicBaseInventoryApp.updateBaseArgsTable(oContext);
                this.m_sessionContext = oContext;
                oContext.setVariables();
                boolean installAddOns = Boolean.getBoolean("oracle.installer.installaddons");
                if (installAddOns) {
                    this.setUpPluginVars(oContext);
                }
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText("Done creating session context and setting session variables as per command line", OiiolTextLogger.LOG_BASIC);
                }
                OiicStandardInventorySession invSession = new OiicStandardInventorySession(this.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiiInstallAreaControl iac = this.getInstallAreaControl(oContext, installAddOns, invSession);
                ArrayList homeInfoList = new ArrayList();
                String[] multipleHomes = (String[])oContext.getVarValue("MULTIPLE_HOMES");
                this.doOperation(oContext, iac, homeInfoList, multipleHomes);
                if (OiicExitCode.getExitCode() == -1 && multipleHomes != null && multipleHomes.length != 0) {
                    ArrayList<String> allHomesList = new ArrayList<String>();
                    for (int count = 0; count < multipleHomes.length; ++count) {
                        allHomesList.add(multipleHomes[count]);
                    }
                    this.logFailedMultipleHomes(allHomesList, homeInfoList);
                }
                invSession.endSession();
                if (this.m_clsRunCmd != null) {
                    this.m_clsRunCmd.dispose();
                }
            }
        }
        catch (Throwable e) {
            this.processErorr(e);
        }
        finally {
            if (!this.isHelpOptionSpecified()) {
                this.endLogging();
                this.exitCode();
            }
        }
    }

    private void exitCode() {
        boolean isBigCluster = System.getProperty("oracle.installer.bigCluster", "false").equalsIgnoreCase("true");
        if (OiicBaseInventoryApp.isAPI() || isBigCluster) {
            OiicExitOps.getExitOps().doExitOperations();
        } else {
            OiicExitOps.getExitOps().exit();
        }
    }

    private void endLogging() {
        boolean installAddOns = Boolean.getBoolean("oracle.installer.installaddons");
        String sMsg = null;
        int iExitCode = OiicExitCode.getExitCode();
        String op = this.getLogPrefix();
        Object[] args1 = new String[]{op};
        switch (iExitCode) {
            case 0: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_SUCCESS", args1);
                if (installAddOns) break;
                OiiolTextLogger.writeMessageToConsole(sMsg);
                break;
            }
            case -1: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_FAILURE", args1);
                if (!installAddOns) {
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                }
                OiiolTextLogger.writeMessageToStdErr(sMsg);
            }
        }
        if (sMsg != null) {
            OiiolTextLogger.appendText(sMsg);
        }
        OiiolTextLogger.closeLog();
        this.copyLogsToCallingNode(this.m_sLocalNode);
    }

    private void processErorr(Throwable e) {
        System.err.println("Exception " + e + " occurred..");
        e.printStackTrace();
        OiicExitCode.setExitCode(-1);
        String sMsg = "";
        String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
        String sLogLoc = OiiolTextLogger.getCurLogFileName();
        sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
        String sErrLoc = OiixTeePrintStream.getErrFileLoc();
        sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
        String sOutLoc = OiixTeePrintStream.getOutFileLoc();
        sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
        sMsg = OiixResourceBundle.getString("S_CALL_SUPPORT", new Object[]{sLogLoc, sErrLoc, sOutLoc});
        sMsg = OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_MSG") + " " + sMsg;
        OiifmAlert.displayError(sMsg, OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_TITLE"));
    }

    private void doOperation(OiicSessionContext oContext, OiiiInstallAreaControl iac, ArrayList homeInfoList, String[] multipleHomes) throws Exception {
        try {
            if (OiicExitCode.getExitCode() == 0) {
                if (multipleHomes != null && multipleHomes.length != 0) {
                    for (int count = 0; count < multipleHomes.length; ++count) {
                        String oracleHomeName = iac.getInstallInventory().getDefaultHomeName(null);
                        oContext.setVarValue("ORACLE_HOME_NAME", oracleHomeName);
                        oContext.setVarValue("ORACLE_HOME", multipleHomes[count]);
                        this.doOperation(iac, oContext);
                        homeInfoList.add(multipleHomes[count]);
                    }
                } else {
                    this.doOperation(iac, oContext);
                }
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                OiiolTextLogger.appendText("Done calling doOperation.", OiiolTextLogger.LOG_BASIC);
            }
            this.registerCopyLogInfo();
        }
        catch (IOException e) {
            if (!(this instanceof OiicAttachHome)) {
                OiiolTextLogger.appendException(e);
            }
            this.updateExitCodeOrThrow(e);
        }
        catch (OiiiMultipleSOHException e) {
            int logLevel = OiiolTextLogger.getLogLevel();
            if (logLevel == OiiolTextLogger.LOG_DETAILED || logLevel == OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendException(e);
            } else {
                OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_BASIC);
            }
            this.updateExitCodeOrThrow(e);
        }
        catch (OiipgClusterException e) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendException(e);
            } else {
                OiiolTextLogger.appendText(e.getErrorMessage(), OiiolTextLogger.LOG_SEVERE);
            }
            this.updateExitCodeOrThrow(e);
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            this.updateExitCodeOrThrow(e);
        }
    }

    private OiiiInstallAreaControl getInstallAreaControl(OiicSessionContext oContext, boolean installAddOns, OiicStandardInventorySession invSession) throws OiisVarSettingException, OiifbCancelException, OiifbEndIterateException {
        OiiiInstallAreaControl iac = null;
        try {
            String invLoc;
            invSession.initSession(1);
            if (oContext.getVarValue("MULTIPLE_HOMES") == null || ((String[])oContext.getVarValue("MULTIPLE_HOMES")).length == 0) {
                this.performValidations(oContext);
            }
            if ((invLoc = (String)oContext.getVarValue("INVENTORY_LOCATION")) != null) {
                System.setProperty("oracle.installer.inventory_location", invLoc);
            }
            iac = OiiiInstallAreaControl.getInstallAreaControl();
            oContext.setVarValue("INVENTORY_LOCATION", iac.getAreaRoot());
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                OiiolTextLogger.appendText("Created OiicStandardInventorySession.", OiiolTextLogger.LOG_BASIC);
            }
            String sInvLoc = iac.getAreaRoot();
            String ptrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            int curPlatId = OiixPlatform.getCurrentPlatform();
            int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
            switch (curPlatGroup) {
                case -3: {
                    break;
                }
                case -1: {
                    if (installAddOns) break;
                    System.out.println("The inventory pointer is located at " + ptrLoc);
                }
            }
            if (installAddOns) {
                System.out.println("The inventory is located at " + sInvLoc);
            }
            OiicPullSession.createDuplicateStreams(sInvLoc);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
            invSession.endSession();
        }
        catch (OiitTargetLockNotAvailableException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            String ptrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            Object[] arg = new Object[]{ptrLoc};
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_INVENTORY_PTR_NOT_EXIST", arg);
            System.out.println(msg);
            OiiolTextLogger.appendText(msg);
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
        return iac;
    }

    private static void updateBaseArgsTable(OiicSessionContext oContext) {
        Hashtable baseArgs;
        Map argsMap;
        OiicBaseApp baseApp;
        if (Boolean.getBoolean("oracle.installer.ouiApiMode") && (baseApp = OiicBaseApp.getBaseApp()) != null && (argsMap = baseApp.getCommandLineArgs()) != null && (baseArgs = oContext.getCommandLineArgsTable()) != null && baseArgs.size() > 0) {
            argsMap.putAll(baseArgs);
        }
    }

    private void logFailedMultipleHomes(ArrayList allHomesList, ArrayList homeInfoList) throws IOException {
        String method = "Detach";
        if (this instanceof OiicAttachHome) {
            method = "Attach";
        }
        String logLocation = OiiolTextLogger.getLogDir();
        String logFile = OiixPathOps.concatPath(OiixPathOps.getStandardForm(logLocation), "FailedHomeList_" + method + "Home" + OiixUtilityOps.getSessionTimeStamp() + ".txt");
        BufferedWriter outStream = new BufferedWriter(new FileWriter(logFile));
        outStream.write("Multiple" + method + " Home failed for homes" + "\r\n");
        allHomesList.removeAll(homeInfoList);
        Iterator iter = allHomesList.iterator();
        while (iter.hasNext()) {
            String homeName = (String)iter.next();
            outStream.write(homeName + "\r\n");
        }
        outStream.close();
    }

    protected String constructAlertMessage(String errMessage, String[] nodeListStrArr, String oracleHome) {
        String nodeList = OiixFunctionOps.implodeList(nodeListStrArr, ",");
        Object[] args = new String[]{this.getLogPrefix(), nodeList, OiiolTextLogger.getCurLogFileName()};
        Object[] args_new = new String[]{this.getLogPrefix()};
        String oracleHomeStandard = OiixPathOps.getStandardForm(oracleHome);
        oracleHomeStandard = OiixPathOps.directorify(oracleHomeStandard);
        oracleHomeStandard = oracleHomeStandard + "oui";
        String ouiHome = OiixPathOps.getNativeForm(oracleHomeStandard);
        errMessage = OiipgBootstrap.getOUIExecLoc(ouiHome) + " " + errMessage;
        errMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-220072") + errMessage;
        errMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25010", args) + "\n" + errMessage;
        errMessage = errMessage + "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25011", args_new);
        return errMessage;
    }

    protected String getCustomUnixInvPtrLoc() {
        String sCustomInvPtrLoc = null;
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            sCustomInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", "");
        }
        return sCustomInvPtrLoc;
    }

    protected String[] setupRemoteInvPtrLoc(String[] asClusterNodes, String sLoc) {
        String[] asNodes = OiipgClusterInvSetup.getCleanMachines(asClusterNodes);
        ArrayList oCleanNodes = new ArrayList();
        try {
            OiipgClusterOps.transferFileToNodes(asNodes, sLoc, new File(sLoc).getParent());
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        catch (OiipgRemoteFileOperationException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        return OiixVectorOps.list2StrArr(oCleanNodes);
    }

    public boolean requireGUIDRecalculation(String oldGUIDVal) {
        boolean bGUIDValueImproper = oldGUIDVal == null || oldGUIDVal.equals("");
        boolean bGenerateGUID = Boolean.getBoolean("oracle.installer.generateGUID");
        boolean bIsAttachHome = Boolean.getBoolean("oracle.installer.attachHome");
        boolean bIsAttachHomeWithGenerateGUID = bIsAttachHome && bGenerateGUID;
        boolean bIsAddNodeMode = Boolean.getBoolean("oracle.installer.addNode");
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("OiicBaseInventoryApp : GUID : values of recalculation parameters:oldGUIDVal:" + oldGUIDVal + ":" + bGUIDValueImproper + bIsAttachHomeWithGenerateGUID + bIsAddNodeMode, OiiolTextLogger.LOG_DETAILED);
        }
        boolean bGUIDValueResetRequired = bGUIDValueImproper || bIsAttachHomeWithGenerateGUID || bIsAddNodeMode;
        return bGUIDValueResetRequired;
    }

    private void registerCopyLogInfo() {
        String sInvLoc;
        String sHomeLoc;
        OiicSessionContext oContext = this.getSessionContext();
        if (oContext != null && (sHomeLoc = (String)oContext.getVarValue("ORACLE_HOME")) != null && (sInvLoc = (String)oContext.getVarValue("INVENTORY_LOCATION")) != null) {
            String timestamp = OiixUtilityOps.getSessionTimeStamp();
            String nodename = null;
            if (Boolean.getBoolean("oracle.installer.remoteInvocation")) {
                nodename = System.getProperty("oracle.installer.invokingNodeName");
            }
            OiiolCopyLogInfo logCopyInfo = new OiiolCopyLogInfo(sInvLoc, sHomeLoc, timestamp, nodename);
            OiiolTextLogger.registerCopyLogInfo(logCopyInfo);
        }
    }

    public String calculateGUIDValue(String homeloc) {
        String ip = OiinNetOps.getNetOps().getHostAddress();
        String sLocalNode = null;
        OiisVariable localNode = this.m_sessionContext.getVariable("LOCAL_NODE");
        Object oLocalNode = localNode.getValue();
        sLocalNode = oLocalNode != null && oLocalNode instanceof String ? (String)oLocalNode : " ";
        String sGUID = OiiiOracleHomeInfo.calculateGUIDValue(ip, homeloc, sLocalNode);
        return sGUID;
    }

    private void setUpPluginVars(OiicSessionContext oContext) {
        try {
            String oracleHomeFromSys = System.getProperty("ORACLE_HOME");
            String dependeeHomeFromSys = System.getProperty("DEPENDEE_HOME");
            OiicBaseInventoryApp.setVar(oContext, "ORACLE_HOME_NAME");
            OiicBaseInventoryApp.setVar(oContext, "ORACLE_HOME");
            OiicBaseInventoryApp.setVar(oContext, "COMPOSITE_HOME");
            OiicBaseInventoryApp.setVar(oContext, "DEPENDEE_HOME");
            if (dependeeHomeFromSys != null && oracleHomeFromSys != null) {
                String arrar = oracleHomeFromSys + ":" + dependeeHomeFromSys;
                String[] strArgArr = new String[]{arrar};
                oContext.setVarValue("HOME_DEPENDENCY_LIST", strArgArr);
            }
        }
        catch (OiisVarSettingException ovse) {
        }
        catch (OiifbCancelException oiifbCancelException) {
            // empty catch block
        }
    }

    private static void setVar(OiicSessionContext oContext, String var) throws OiisVarSettingException, OiifbCancelException {
        String val = System.getProperty(var);
        if (val != null) {
            oContext.setVarValue(var, val);
        }
    }

    protected String computeLocalNode() {
        String localNode = null;
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        if (detectCluster != null && detectCluster.isCluster()) {
            localNode = detectCluster.getLocalNodeName();
        }
        if (localNode == null) {
            try {
                StringTokenizer tokenizer;
                localNode = OiixNetOps.getFullHostName();
                if (OiinNetOps.isFQDN((String)localNode) && (tokenizer = new StringTokenizer(localNode, ".")).hasMoreTokens()) {
                    localNode = tokenizer.nextToken();
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendText("Exception thrown while trying to compute local node.");
            }
        }
        return localNode;
    }

    protected void setRemoteNodes(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext) throws OiisVarSettingException, OiifbCancelException {
        OiisVariable clusterNodesVar = oContext.getVariable("CLUSTER_NODES");
        String[] remoteNodes = new String[]{};
        String[] clusterList = (String[])clusterNodesVar.getValue();
        if (clusterList != null && clusterList.length > 0) {
            remoteNodes = this.removeElement(clusterList, this.computeLocalNode());
        }
        oContext.setVarValue("REMOTE_NODES", remoteNodes);
    }

    private String[] removeElement(String[] input, String element) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < input.length; ++i) {
            String item = input[i];
            if (element.equalsIgnoreCase(item)) continue;
            result.add(item);
        }
        return result.toArray(new String[0]);
    }

    private void updateExitCodeOrThrow(Exception e) throws Exception {
        if (Boolean.getBoolean("oracle.installer.ignoreExitCode")) {
            throw e;
        }
        OiicExitCode.setExitCode(-1);
    }

    public List getFailedNodesList() {
        return this.nodesFailed;
    }

    class RemoteCommandThread
    extends Thread {
        String[] tempNodes = new String[1];
        String node;
        String cmd;
        String oracleHome;
        String oracleHomeName;
        String invokingNodeName;

        public RemoteCommandThread(String node, String cmd, String oracleHome, String oracleHomeName, String invokingNodeName) {
            this.node = node;
            this.cmd = cmd;
            this.oracleHome = oracleHome;
            this.oracleHomeName = oracleHomeName;
            this.invokingNodeName = invokingNodeName;
        }

        public void run() {
            OiipgClusterRunCmd m_clsRunCmdTemp = new OiipgClusterRunCmd();
            String sLocalCmd = "";
            this.tempNodes[0] = this.node;
            sLocalCmd = this.cmd + " LOCAL_NODE=" + this.node;
            try {
                m_clsRunCmdTemp.runCmd(sLocalCmd, this.tempNodes, this.oracleHomeName, this.invokingNodeName);
            }
            catch (OiipgRemoteOpsException e) {
                boolean bIsAddNodeMode = Boolean.getBoolean("oracle.installer.addNode");
                int index = e.getMessage().indexOf("OUI-10197");
                if (bIsAddNodeMode && index != -1) {
                    OiicBaseInventoryApp.this.errorIgnore = true;
                    if (OiicPullSession.isDebugMode()) {
                        OiiolTextLogger.appendText(e.getMessage());
                    }
                }
                this.logFailureOfRemoteOperation(e);
                return;
            }
            catch (OiipgRemoteFileOperationException e) {
                this.logFailureOfRemoteOperation(e);
                return;
            }
            OiicBaseInventoryApp.this.nodesPassed.add(this.node);
        }

        private void logFailureOfRemoteOperation(Exception e) {
            OiicPullSession.setRemoteOperationSuccess(false);
            OiiolTextLogger.appendException(e);
            OiicBaseInventoryApp.this.nodesFailed.add(this.node);
        }
    }
}

