/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicDetachHome;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterChecks;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInteractiveOps;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixServiceOps;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicCleanup
extends OiicBaseApp {
    public static final String HKLM = "HKEY_LOCAL_MACHINE";
    public static final String SW_ORACLE_HOME_KEY_PREFIX = "SOFTWARE\\ORACLE\\KEY_";
    public static final String SW_ORACLE_HOME_PREFIX = "SOFTWARE\\ORACLE";
    public static final String OH_FOLDER_REG_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String ENV_REG_SUBKEY = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    public static final String ENV_REG_KEY = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    public static final String OBASE_CLEANUP_PTR = "oracle.installer.OBaseCleanupPtrLoc";
    public static final String REGISTRY_CLEANUP_PTR = "WindowsRegistryCleanupList";
    public static final String NODES_LAST_HOME = "NodesWithLastHome";
    private static final int SERVICE_RUNNING = 4;
    private static OiicCleanup s_oiicCleanup = null;
    private OiicSessionContext m_oContext = null;
    private OiicStandardInventorySession invSession = null;
    private String[] m_sRemoteNodes = null;
    private String[] m_sRemoteNodesOracleBase = null;
    private String[] m_sRemoteNodesHomeAttached = null;
    private boolean m_bCleanupRemoteCI = false;
    private boolean m_bCleanupRemoteOracleBase = true;
    private boolean m_bCleanupLocalCI = false;
    private boolean m_bCleanupLocalOracleBase = true;
    private String m_sOracleHome = null;
    private String m_sOracleBase = null;
    private String m_sOracleHomeName = null;
    private boolean s_bIsWindows = false;
    private HashMap m_oInvLocations = null;
    private String m_sInvLocation = null;
    private static final String s_baseAppPrefix = "oui";
    private String m_logLocation = "";
    private boolean s_bApiMode = false;
    private boolean s_bDetachHomeLocal = false;
    private boolean s_bDetachHomeRemote = false;
    private boolean bSharedHome = false;
    private boolean bSharedOracleBase = false;
    private String m_sLocalNode = null;
    private boolean s_bForce = false;
    private boolean s_bForceOBase = false;
    private String m_sDefInvPtrLoc = null;
    public static final String m_sDefInvPtrFileName = "oraInst.loc";
    private String m_sInvPtrLoc = null;
    private String m_sInvPtrLocDir = null;
    private Vector nodesWithSameDefaultOraInst = null;
    private Vector nodesToRemoveOraInst = null;
    private Vector nodesLastHome = null;
    private boolean localNodeSameDefaultOraInst = false;
    private boolean localNodeRemoveOraInst = false;
    private boolean localNodeLastHome = false;
    private List cleanSummary = new ArrayList();
    private String m_sLogDir = null;
    boolean doLocalInvOps = true;
    OiiiClusterInstallInventory m_clusterInstInv = null;
    private String[] m_sOHServices = null;
    private Vector homeDeinstallExcludeListVector = null;
    private Vector oracleBaseDirListVector = null;
    private Vector miscRegistryListVector = null;

    public static OiicCleanup getOiicCleanupInstance() {
        if (s_oiicCleanup == null) {
            s_oiicCleanup = new OiicCleanup();
        }
        return s_oiicCleanup;
    }

    public OiicCleanup() {
        super(s_baseAppPrefix);
    }

    public static void main(String[] args) {
        OiicCleanup oCleanup = OiicCleanup.getOiicCleanupInstance();
        oCleanup.main_helper(args);
    }

    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
    }

    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean main_helper(String[] args) {
        String sMsg2222;
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        System.setProperty("oracle.installer.noGUI", "yes");
        this.s_bIsWindows = -3 == OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        OiicExitCode.setExitCode(0);
        this.nodesToRemoveOraInst = new Vector();
        this.nodesLastHome = new Vector();
        this.nodesWithSameDefaultOraInst = new Vector();
        try {
            this.processCommandLine(args);
            if (this.isHelpOptionSpecified()) {
                this.displayHelp();
            } else {
                boolean validateFlag = true;
                if (!this.validateInputVariables()) {
                    OiicExitCode.setExitCode(-1);
                    validateFlag = false;
                }
                if (validateFlag) {
                    if (this.m_oContext == null) {
                        this.m_oContext = new OiicSessionContext(this);
                        this.m_oContext.setVariables();
                    }
                    String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_START");
                    OiiolTextLogger.writeMessageToConsole(message);
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                        OiiolTextLogger.appendText("Done creating session context and setting session variables as per command line", OiiolTextLogger.LOG_BASIC);
                    }
                    if (!this.s_bApiMode) {
                        if (Boolean.getBoolean("oracle.installer.force")) {
                            this.setForceFlag(true);
                        } else {
                            this.setForceFlag(false);
                        }
                    }
                    try {
                        this.doOperation();
                    }
                    catch (OiitTargetLockNotAvailableException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (OiiiInventoryDoesNotExistException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (OiiiInventoryUpdateException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (OiipgRemoteOpsException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                        OiicExitCode.setExitCode(-1);
                    }
                }
            }
            Object var9_14 = null;
            sMsg2222 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            String sMsg2222 = null;
            int iExitCode = OiicExitCode.getExitCode();
            boolean retVal = true;
            switch (iExitCode) {
                case 0: {
                    sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_SUCCESS");
                    retVal = true;
                    break;
                }
                case -1: {
                    sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_FAILURE");
                    retVal = false;
                }
            }
            if (sMsg2222 != null) {
                OiiolTextLogger.writeToLogAndConsole(sMsg2222);
                this.logSummaryMessage(sMsg2222);
            }
            if (this.s_bApiMode && this.m_sLogDir != null && this.m_sLogDir != "") {
                OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_sLogDir);
                try {
                    OiiolTextLogger.setLogLoc(this.m_sLogDir, OiicCleanup.getLogPrefix());
                }
                catch (IOException e2) {
                    OiiolTextLogger.appendException(e2);
                }
            }
            if (OiiolTextLogger.getCurLogFileName() != null) {
                String logLocMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SESSION_LOG_LOC_PROMPT", new String[]{OiiolTextLogger.getCurLogFileName()});
                OiiolTextLogger.appendText(logLocMsg);
            }
            if (!this.s_bIsWindows) {
                if (this.m_sLocalNode == null) {
                    if (this.localNodeRemoveOraInst) {
                        Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc};
                        String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_LOCALNODE", args1);
                        if (this.s_bApiMode) {
                            this.logSummaryMessage(lastMsg);
                        } else {
                            OiiolTextLogger.writeToLogAndConsole(lastMsg);
                        }
                    }
                    if (this.localNodeLastHome) {
                        System.setProperty(NODES_LAST_HOME, OiixNetOps.getFullHostName());
                    }
                } else {
                    String nodesStr;
                    String[] nodesArr;
                    if (this.nodesToRemoveOraInst.size() > 0) {
                        nodesArr = OiixVectorOps.vect2StrArr(this.nodesToRemoveOraInst);
                        nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                        Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc, nodesStr};
                        String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_NODES", args1);
                        if (this.s_bApiMode) {
                            this.logSummaryMessage(lastMsg);
                        } else {
                            OiiolTextLogger.writeToLogAndConsole(lastMsg);
                        }
                    }
                    if (this.nodesLastHome.size() > 0) {
                        nodesArr = OiixVectorOps.vect2StrArr(this.nodesLastHome);
                        nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                        System.setProperty(NODES_LAST_HOME, nodesStr);
                    }
                }
            }
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_END");
            OiiolTextLogger.writeMessageToConsole(message);
            if (this.s_bIsWindows && !this.s_bApiMode) {
                OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EXIT_CONTINUE"));
            }
            if (this.invSession != null) {
                OiiolTextLogger.appendText("Ending the Inventory Session which was created");
                this.invSession.endSession();
            }
            this.invSession = null;
            this.m_sRemoteNodes = null;
            this.m_sRemoteNodesHomeAttached = null;
            this.m_bCleanupRemoteCI = false;
            this.m_bCleanupRemoteOracleBase = true;
            this.m_bCleanupLocalCI = false;
            this.m_bCleanupLocalOracleBase = true;
            this.m_sOracleHome = null;
            this.m_sOracleBase = null;
            this.m_sOracleHomeName = null;
            this.s_bIsWindows = false;
            this.m_oInvLocations = null;
            this.m_sInvLocation = null;
            this.m_logLocation = "";
            this.s_bApiMode = false;
            this.s_bDetachHomeLocal = false;
            this.s_bDetachHomeRemote = false;
            this.bSharedHome = false;
            this.bSharedOracleBase = false;
            this.m_sLocalNode = null;
            this.s_bForce = false;
            this.s_bForceOBase = false;
            this.m_sDefInvPtrLoc = null;
            this.m_sInvPtrLoc = null;
            this.nodesWithSameDefaultOraInst = null;
            this.nodesToRemoveOraInst = null;
            this.nodesLastHome = null;
            this.localNodeSameDefaultOraInst = false;
            this.localNodeRemoveOraInst = false;
            this.localNodeLastHome = false;
            this.m_sLogDir = null;
            this.m_sOHServices = null;
            return retVal;
        }
        int iExitCode = OiicExitCode.getExitCode();
        boolean retVal = true;
        switch (iExitCode) {
            case 0: {
                sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_SUCCESS");
                retVal = true;
                break;
            }
            case -1: {
                sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_FAILURE");
                retVal = false;
            }
        }
        if (sMsg2222 != null) {
            OiiolTextLogger.writeToLogAndConsole(sMsg2222);
            this.logSummaryMessage(sMsg2222);
        }
        if (this.s_bApiMode && this.m_sLogDir != null && this.m_sLogDir != "") {
            OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_sLogDir);
            try {
                OiiolTextLogger.setLogLoc(this.m_sLogDir, OiicCleanup.getLogPrefix());
            }
            catch (IOException e2) {
                OiiolTextLogger.appendException(e2);
            }
        }
        if (OiiolTextLogger.getCurLogFileName() != null) {
            String logLocMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SESSION_LOG_LOC_PROMPT", new String[]{OiiolTextLogger.getCurLogFileName()});
            OiiolTextLogger.appendText(logLocMsg);
        }
        if (!this.s_bIsWindows) {
            if (this.m_sLocalNode == null) {
                if (this.localNodeRemoveOraInst) {
                    Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc};
                    String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_LOCALNODE", args1);
                    if (this.s_bApiMode) {
                        this.logSummaryMessage(lastMsg);
                    } else {
                        OiiolTextLogger.writeToLogAndConsole(lastMsg);
                    }
                }
                if (this.localNodeLastHome) {
                    System.setProperty(NODES_LAST_HOME, OiixNetOps.getFullHostName());
                }
            } else {
                String nodesStr;
                String[] nodesArr;
                if (this.nodesToRemoveOraInst.size() > 0) {
                    nodesArr = OiixVectorOps.vect2StrArr(this.nodesToRemoveOraInst);
                    nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                    Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc, nodesStr};
                    String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_NODES", args1);
                    if (this.s_bApiMode) {
                        this.logSummaryMessage(lastMsg);
                    } else {
                        OiiolTextLogger.writeToLogAndConsole(lastMsg);
                    }
                }
                if (this.nodesLastHome.size() > 0) {
                    nodesArr = OiixVectorOps.vect2StrArr(this.nodesLastHome);
                    nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                    System.setProperty(NODES_LAST_HOME, nodesStr);
                }
            }
        }
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_END");
        OiiolTextLogger.writeMessageToConsole(message);
        if (this.s_bIsWindows && !this.s_bApiMode) {
            OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EXIT_CONTINUE"));
        }
        if (this.invSession != null) {
            OiiolTextLogger.appendText("Ending the Inventory Session which was created");
            this.invSession.endSession();
        }
        this.invSession = null;
        this.m_sRemoteNodes = null;
        this.m_sRemoteNodesHomeAttached = null;
        this.m_bCleanupRemoteCI = false;
        this.m_bCleanupRemoteOracleBase = true;
        this.m_bCleanupLocalCI = false;
        this.m_bCleanupLocalOracleBase = true;
        this.m_sOracleHome = null;
        this.m_sOracleBase = null;
        this.m_sOracleHomeName = null;
        this.s_bIsWindows = false;
        this.m_oInvLocations = null;
        this.m_sInvLocation = null;
        this.m_logLocation = "";
        this.s_bApiMode = false;
        this.s_bDetachHomeLocal = false;
        this.s_bDetachHomeRemote = false;
        this.bSharedHome = false;
        this.bSharedOracleBase = false;
        this.m_sLocalNode = null;
        this.s_bForce = false;
        this.s_bForceOBase = false;
        this.m_sDefInvPtrLoc = null;
        this.m_sInvPtrLoc = null;
        this.nodesWithSameDefaultOraInst = null;
        this.nodesToRemoveOraInst = null;
        this.nodesLastHome = null;
        this.localNodeSameDefaultOraInst = false;
        this.localNodeRemoveOraInst = false;
        this.localNodeLastHome = false;
        this.m_sLogDir = null;
        this.m_sOHServices = null;
        return retVal;
        {
            catch (Throwable e) {
                System.err.println("Exception " + e + " occurred..");
                e.printStackTrace();
                OiicExitCode.setExitCode(-1);
                String sMsg3 = "";
                String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
                String sLogLoc = OiiolTextLogger.getCurLogFileName();
                sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
                String sErrLoc = OiixTeePrintStream.getErrFileLoc();
                sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
                String sOutLoc = OiixTeePrintStream.getOutFileLoc();
                sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
                sMsg3 = OiixResourceBundle.getString("S_CALL_SUPPORT", new Object[]{sLogLoc, sErrLoc, sOutLoc});
                sMsg3 = OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_MSG") + " " + sMsg3;
                OiifmAlert.displayError(sMsg3, OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_TITLE"));
                Object var9_15 = null;
                sMsg2222 = null;
                iExitCode = OiicExitCode.getExitCode();
                retVal = true;
                switch (iExitCode) {
                    case 0: {
                        sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_SUCCESS");
                        retVal = true;
                        break;
                    }
                    case -1: {
                        sMsg2222 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUI_CLEANUP_FAILURE");
                        retVal = false;
                    }
                }
                if (sMsg2222 != null) {
                    OiiolTextLogger.writeToLogAndConsole(sMsg2222);
                    this.logSummaryMessage(sMsg2222);
                }
                if (this.s_bApiMode && this.m_sLogDir != null && this.m_sLogDir != "") {
                    OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_sLogDir);
                    try {
                        OiiolTextLogger.setLogLoc(this.m_sLogDir, OiicCleanup.getLogPrefix());
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                }
                if (OiiolTextLogger.getCurLogFileName() != null) {
                    String logLocMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SESSION_LOG_LOC_PROMPT", new String[]{OiiolTextLogger.getCurLogFileName()});
                    OiiolTextLogger.appendText(logLocMsg);
                }
                if (!this.s_bIsWindows) {
                    if (this.m_sLocalNode == null) {
                        if (this.localNodeRemoveOraInst) {
                            Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc};
                            String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_LOCALNODE", args1);
                            if (this.s_bApiMode) {
                                this.logSummaryMessage(lastMsg);
                            } else {
                                OiiolTextLogger.writeToLogAndConsole(lastMsg);
                            }
                        }
                        if (this.localNodeLastHome) {
                            System.setProperty(NODES_LAST_HOME, OiixNetOps.getFullHostName());
                        }
                    } else {
                        String nodesStr;
                        String[] nodesArr;
                        if (this.nodesToRemoveOraInst.size() > 0) {
                            nodesArr = OiixVectorOps.vect2StrArr(this.nodesToRemoveOraInst);
                            nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                            Object[] args1 = new String[]{"rm -rf " + this.m_sDefInvPtrLoc, nodesStr};
                            String lastMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_ORAINST_ON_NODES", args1);
                            if (this.s_bApiMode) {
                                this.logSummaryMessage(lastMsg);
                            } else {
                                OiiolTextLogger.writeToLogAndConsole(lastMsg);
                            }
                        }
                        if (this.nodesLastHome.size() > 0) {
                            nodesArr = OiixVectorOps.vect2StrArr(this.nodesLastHome);
                            nodesStr = OiixFunctionOps.implodeList(nodesArr, ",");
                            System.setProperty(NODES_LAST_HOME, nodesStr);
                        }
                    }
                }
                message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_END");
                OiiolTextLogger.writeMessageToConsole(message);
                if (this.s_bIsWindows && !this.s_bApiMode) {
                    OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EXIT_CONTINUE"));
                }
                if (this.invSession != null) {
                    OiiolTextLogger.appendText("Ending the Inventory Session which was created");
                    this.invSession.endSession();
                }
                this.invSession = null;
                this.m_sRemoteNodes = null;
                this.m_sRemoteNodesHomeAttached = null;
                this.m_bCleanupRemoteCI = false;
                this.m_bCleanupRemoteOracleBase = true;
                this.m_bCleanupLocalCI = false;
                this.m_bCleanupLocalOracleBase = true;
                this.m_sOracleHome = null;
                this.m_sOracleBase = null;
                this.m_sOracleHomeName = null;
                this.s_bIsWindows = false;
                this.m_oInvLocations = null;
                this.m_sInvLocation = null;
                this.m_logLocation = "";
                this.s_bApiMode = false;
                this.s_bDetachHomeLocal = false;
                this.s_bDetachHomeRemote = false;
                this.bSharedHome = false;
                this.bSharedOracleBase = false;
                this.m_sLocalNode = null;
                this.s_bForce = false;
                this.s_bForceOBase = false;
                this.m_sDefInvPtrLoc = null;
                this.m_sInvPtrLoc = null;
                this.nodesWithSameDefaultOraInst = null;
                this.nodesToRemoveOraInst = null;
                this.nodesLastHome = null;
                this.localNodeSameDefaultOraInst = false;
                this.localNodeRemoveOraInst = false;
                this.localNodeLastHome = false;
                this.m_sLogDir = null;
                this.m_sOHServices = null;
                return retVal;
            }
        }
    }

    public void doOperation() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiipgRemoteOpsException, OiisVarSettingException, OiifbEndIterateException {
        String registryList;
        String oracleBaseDirList;
        String homeDeleteExcludeList;
        OiipgClusterRunCmd.getClusterCmdObj();
        ClusterCmd.setDeconfigNonClusterMode((boolean)true);
        if (!this.s_bApiMode) {
            this.promptUserForSessionVariables();
        }
        this.setClassVariables();
        if (this.s_bApiMode) {
            System.setProperty("oracle.installer.scratchPath", OiixPathOps.getNativeForm(OiipgBootstrap.initScratchLoc("OraInstall")));
        }
        if (!this.validateHomeVariables()) {
            return;
        }
        if (!this.s_bIsWindows) {
            this.m_sInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
            if (this.m_sInvPtrLoc != null) {
                Properties sysProps = System.getProperties();
                sysProps.remove("oracle.installer.invPtrLoc");
                OiipgPropertyLoader.setUnixPtrFileLocFromSysProps();
                this.m_sDefInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
                System.setProperty("oracle.installer.invPtrLoc", this.m_sInvPtrLoc);
            } else {
                this.m_sDefInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            }
            if (!this.validateInvPtrLoc()) {
                return;
            }
        }
        if (this.m_sRemoteNodes != null && this.m_sRemoteNodes.length != 0 && this.s_bApiMode) {
            OiiolTextLogger.appendText("Copying OUI and JRE to ScratchPath");
            this.copyOuiJreToScratch();
            if (!this.s_bIsWindows && this.m_sInvPtrLoc != null && this.m_sInvPtrLoc != "") {
                this.setRemoteInvPtrLoc();
            }
        }
        if (!this.s_bIsWindows && this.m_sInvPtrLoc == null && this.s_bApiMode) {
            this.doLocalInvOps = false;
        }
        if (this.s_bIsWindows) {
            this.getAllOHServices();
        }
        if (this.s_bIsWindows) {
            this.cleanupOHServicesLocal();
        }
        if ((homeDeleteExcludeList = this.getRemoveExcludeList()) != null && homeDeleteExcludeList != "") {
            this.homeDeinstallExcludeListVector = this.readFileIntoVector(homeDeleteExcludeList);
        }
        if ((oracleBaseDirList = this.getOracleBaseDirList()) != null && oracleBaseDirList != "") {
            this.oracleBaseDirListVector = this.readFileIntoVector(oracleBaseDirList);
        }
        if (this.s_bIsWindows && (registryList = this.getMiscRegistryList()) != null && registryList != "") {
            this.miscRegistryListVector = this.readFileIntoVector(registryList);
        }
        this.cleanupOHLocal();
        if (this.s_bIsWindows) {
            this.cleanupPathLocal();
        }
        if (!this.s_bIsWindows && this.checkForSameInventoryLocation(this.m_sInvPtrLoc, this.m_sDefInvPtrLoc)) {
            if (this.m_sLocalNode == null) {
                this.localNodeSameDefaultOraInst = true;
            } else {
                this.nodesWithSameDefaultOraInst.add(this.m_sLocalNode);
            }
        }
        if (this.doLocalInvOps) {
            this.determineCleanupCILocal();
        }
        if (this.m_bCleanupLocalCI) {
            this.cleanupCILocal();
        }
        this.determineCleanupOracleBaseLocal();
        if (this.m_bCleanupLocalOracleBase) {
            this.cleanupOracleBaseLocal();
        }
        if (!Boolean.getBoolean("oracle.installer.local")) {
            this.updateRemoteNodes();
            if (this.s_bIsWindows) {
                this.cleanupOHServicesRemote();
            }
            this.cleanupOHRemote();
            if (this.s_bIsWindows) {
                this.cleanupPathRemote();
            }
            if (this.doLocalInvOps) {
                this.determineCleanupCIRemote();
            }
            if (this.m_bCleanupRemoteCI) {
                this.cleanupCIRemote();
            }
            if (this.m_bCleanupRemoteOracleBase) {
                this.determineCleanupOracleBaseRemote();
            }
            if (this.m_bCleanupRemoteOracleBase) {
                this.cleanupOracleBaseRemote();
            }
        }
    }

    private void updateRemoteNodes() {
        OiicClusterInstallInfo cInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        cInfo.setClusterNodes(this.m_sRemoteNodes);
        try {
            this.m_sRemoteNodes = OiipgClusterChecks.checkUserEquivalence(this.m_sRemoteNodes, cInfo);
            this.m_oContext.setVarValue("REMOTE_NODES", this.m_sRemoteNodes);
        }
        catch (OiipgClusterException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    private static String getLogPrefix() {
        return "Cleanup";
    }

    private void determineCleanupCIRemote() {
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes);
        this.m_oInvLocations = this.m_clusterInstInv.getInventoryLocsRemote();
        if (this.m_oInvLocations != null && this.m_oInvLocations.size() > 0) {
            String bDelete;
            if (this.getForceFlag()) {
                this.m_bCleanupRemoteCI = true;
            } else if (!Boolean.getBoolean("oracle.installer.silent") && !this.s_bApiMode && (bDelete = OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22012"))) != null && bDelete.trim().toLowerCase().equals("yes")) {
                this.m_bCleanupRemoteCI = true;
            }
        }
    }

    private void determineCleanupCILocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbEndIterateException, OiisVarSettingException, OiifbCancelException {
        if (this.invSession == null) {
            try {
                OiiolTextLogger.appendText("Creating a new Inventory Session");
                this.invSession = new OiicStandardInventorySession(OiicCleanup.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText("Initializing the inventory session with access 1");
                this.invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        this.m_oContext.setVarValue("INVENTORY_LOCATION", iAreaControl.getAreaRoot());
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        this.m_sInvLocation = iAreaControl.getAreaRoot();
        Vector homesAttached = instinv.getHomes();
        if (homesAttached == null || homesAttached.size() == 0) {
            if (this.getForceFlag()) {
                this.m_bCleanupLocalCI = true;
            } else {
                String bDelete;
                this.m_bCleanupLocalCI = false;
                if (!Boolean.getBoolean("oracle.installer.silent") && !this.s_bApiMode && (bDelete = OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22013"))) != null && bDelete.trim().toLowerCase().equals("yes")) {
                    this.m_bCleanupLocalCI = true;
                }
            }
        }
        if (this.m_bCleanupLocalCI) {
            this.m_logLocation = !Boolean.getBoolean("oracle.installer.silent") && !this.s_bApiMode ? OiixInteractiveOps.fetchUserInput(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22019")) : new File(System.getProperty("oracle.installer.scratchPath")).getParent();
        }
        if (this.m_logLocation == null || this.m_logLocation.equals("")) {
            this.m_logLocation = OiiolTextLogger.getLogDir();
        }
    }

    private void promptUserForSessionVariables() {
        if (!Boolean.getBoolean("oracle.installer.silent")) {
            String[] sessionVars = new String[]{"ORACLE_HOME", "ORACLE_HOME_NAME", "REMOTE_NODES"};
            for (int i = 0; i < Array.getLength(sessionVars); ++i) {
                OiisVariable var = this.m_oContext.getVariable(sessionVars[i]);
                if (var.isValueSetByUser()) continue;
                this.m_oContext.setSessionVarValFromUser(var);
            }
        }
    }

    private void setClassVariables() {
        this.m_sOracleHome = (String)this.m_oContext.getVarValue("ORACLE_HOME");
        this.m_sOracleBase = (String)this.m_oContext.getVarValue("ORACLE_BASE");
        this.m_sOracleHomeName = (String)this.m_oContext.getVarValue("ORACLE_HOME_NAME");
        this.m_sRemoteNodes = (String[])this.m_oContext.getVarValue("REMOTE_NODES");
        this.m_sLocalNode = (String)this.m_oContext.getVarValue("LOCAL_NODE");
    }

    private void cleanupRegKeysLocal(String oracleHomeName) {
        String key = HKLM;
        String subKey = SW_ORACLE_HOME_KEY_PREFIX + oracleHomeName;
        Object[] args = new String[]{key, subKey};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
        try {
            if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                OiipwWin32NativeCalls.RegDeleteKey(key, subKey);
            }
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
            Object[] args1 = new String[]{message, result};
            String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(doneMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS", args);
            this.logSummaryMessage(summaryMessage);
        }
        catch (OiilNativeException e) {
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
            Object[] args1 = new String[]{message, result};
            String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(failedMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED", args);
            this.logSummaryMessage(summaryMessage);
            OiiolTextLogger.appendText("OUI-22016", args);
            OiiolTextLogger.appendException(e);
            OiicExitCode.setExitCode(-1);
        }
    }

    private void deleteOHRemote() {
        if (this.doLocalInvOps) {
            this.determineRemoteNodesForDetachHome();
            Object[] args = null;
            if (this.m_sRemoteNodesHomeAttached != null && this.m_sRemoteNodesHomeAttached.length > 0) {
                args = new String[]{OiixFunctionOps.implodeList(this.m_sRemoteNodesHomeAttached, ","), this.m_sOracleHome};
            }
            this.detachOHRemote();
            if (args != null) {
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_REMOTE_NODES", args);
                String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                Object[] args1 = new String[]{message, result};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_REMOTE_NODES_SUMMARY_SUCCESS", args);
                this.logSummaryMessage(summaryMessage);
            }
        }
        if (this.bSharedHome) {
            this.recdelete(new File(this.m_sOracleHome), this.homeDeinstallExcludeListVector);
        } else {
            Object[] args2;
            String result;
            System.setProperty("oracle.installer.racFilesLoc", this.m_logLocation);
            OiipgClusterLogger clusterLogger = OiipgClusterLogger.getClusterLogger();
            OiipgClusterLogger.logRmdirCommands(this.m_sOracleHome);
            clusterLogger.updateListFiles(this.m_sOracleHome);
            Object[] args1 = new String[]{OiixFunctionOps.implodeList(this.m_sRemoteNodes, ","), this.m_sOracleHome};
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args1);
            try {
                OiipgClusterOps.removeListedDirsFromNodes(this.m_sRemoteNodes, clusterLogger.getRmdirListFile());
                String result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                Object[] args22 = new String[]{message, result2};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args22);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS", args1);
                this.logSummaryMessage(summaryMessage);
            }
            catch (OiipgRemoteFileOperationException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args2 = new String[]{message, result};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args1);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getBriefMessage());
                OiicExitCode.setExitCode(-1);
            }
            catch (OiipgRemoteOpsException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args2 = new String[]{message, result};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args1);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                OiicExitCode.setExitCode(-1);
            }
        }
    }

    private void cleanupOHLocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiisVarSettingException {
        if (this.m_sOracleHome == null || this.m_sOracleHome.equals("")) {
            Object[] args1 = new String[]{" oracle home location"};
            OiiolTextLogger.writeMessageToConsole("OIIC-22014", args1);
            return;
        }
        Object[] args = new String[]{this.m_sOracleHome};
        if (this.doLocalInvOps) {
            try {
                OiiolTextLogger.appendText("Creating a new Inventory Session");
                this.invSession = new OiicStandardInventorySession(OiicCleanup.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText("Initializing the inventory session with access 1");
                this.invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
            }
            OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
            OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
            OiiiOracleHomeInfo ohi = instinv.getHomeWithLocation(this.m_sOracleHome);
            if (ohi != null) {
                OiipgDetectCluster detectCluster;
                if (this.m_sOracleHomeName == null || this.m_sOracleHomeName.equals("")) {
                    this.m_sOracleHomeName = ohi.getName();
                }
                if (this.m_sLocalNode == null || this.m_sLocalNode.equals("")) {
                    this.m_sLocalNode = ohi.getLocalNode();
                }
                if ((this.m_sLocalNode == null || this.m_sLocalNode.equals("")) && (detectCluster = OiipgDetectCluster.getDetectCluster()) != null && detectCluster.isCluster()) {
                    this.m_sLocalNode = detectCluster.getLocalNodeName();
                    if (this.m_sLocalNode != null) {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1024", new String[]{this.m_sLocalNode}));
                    }
                }
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE", args);
                try {
                    OiiolTextLogger.appendText("Trying to remove the home forcefully");
                    instinv.removeHomeForce(ohi, true);
                    OiiolTextLogger.appendText("Remove home has been done. Now saving the inventory");
                    iAreaControl.saveInstallInventory();
                    this.s_bDetachHomeLocal = true;
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args1 = new String[]{message, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
                    this.logSummaryMessage(summaryMessage);
                }
                catch (Exception e) {
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args1 = new String[]{message, result};
                    String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DETACH_HOME_ON_LOCAL_NODE_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getMessage());
                    OiicExitCode.setExitCode(-1);
                }
            }
        }
        this.bSharedHome = this.isDriveOnCFS(this.m_sOracleHome);
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        try {
            String summaryMessage;
            Object[] args1;
            String result;
            File ohLocalFile = new File(this.m_sOracleHome);
            boolean retVal = true;
            if (ohLocalFile.exists()) {
                retVal = this.recdelete(ohLocalFile, this.homeDeinstallExcludeListVector);
            }
            if (retVal) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                args1 = new String[]{message, result};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
                this.logSummaryMessage(summaryMessage);
            } else {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args1 = new String[]{message, result};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage);
            }
        }
        catch (Exception e) {
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
            Object[] args1 = new String[]{message, result};
            String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(failedMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args);
            this.logSummaryMessage(summaryMessage);
            OiiolTextLogger.appendException(e);
            OiiolTextLogger.writeMessageToConsole(e.getMessage());
            OiicExitCode.setExitCode(-1);
        }
        if (this.s_bIsWindows) {
            if (!this.s_bDetachHomeLocal && this.m_sOracleHomeName != null && this.m_sOracleHomeName != "") {
                this.cleanupRegKeysLocal(this.m_sOracleHomeName);
            }
            if (this.m_sOracleHomeName != null && this.m_sOracleHomeName != "") {
                this.cleanupFoldersLocal(this.m_sOracleHomeName);
            }
        }
    }

    private void cleanupOHRemote() {
        if (this.m_sRemoteNodes == null || this.m_sRemoteNodes.length == 0) {
            return;
        }
        this.deleteOHRemote();
        if (this.s_bIsWindows) {
            if (!this.s_bDetachHomeRemote && this.m_sOracleHomeName != null && this.m_sOracleHomeName != "") {
                this.cleanupRegKeysRemote(this.m_sOracleHomeName);
            }
            if (this.m_sOracleHomeName != null && this.m_sOracleHomeName != "") {
                this.cleanupFoldersRemote(this.m_sOracleHomeName);
            }
        }
    }

    private void cleanupFoldersRemote(String oracleHomeName) {
        String folderPath = "Oracle - " + oracleHomeName;
        for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
            String failedMessage;
            String summaryMessage;
            Object[] args1;
            String result;
            Object[] args = null;
            String message = "";
            try {
                String path = OiipwClusterWindowsOps.getRegStringDataOnNode("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common Programs", this.m_sRemoteNodes[i]) + "\\" + folderPath;
                args = new String[]{this.m_sRemoteNodes[i], path};
                message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
                if (OiipgClusterOps.fileExistsOnNode(this.m_sRemoteNodes[i], path)) {
                    OiipgClusterOps.removeDirectoryFromNode(this.m_sRemoteNodes[i], path, System.getProperty("oracle.installer.scratchPath"));
                }
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                args1 = new String[]{message, result};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS", args);
                this.logSummaryMessage(summaryMessage);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args1 = new String[]{message, result};
                failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                OiiolTextLogger.appendException(e);
                OiicExitCode.setExitCode(-1);
                continue;
            }
            catch (OiipgRemoteFileOperationException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args1 = new String[]{message, result};
                failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                OiiolTextLogger.appendException(e);
                OiicExitCode.setExitCode(-1);
            }
        }
    }

    private void cleanupFoldersLocal(String oracleHomeName) {
        String folderPath = "Oracle - " + oracleHomeName;
        try {
            folderPath = OiipwWin32NativeCalls.RegGetValue(HKLM, OH_FOLDER_REG_KEY, "Common Programs") + "\\" + folderPath;
        }
        catch (OiilNativeException e) {
            OiiolTextLogger.appendException(e);
            Object[] args = new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Common Programs"};
            OiiolTextLogger.writeToLogAndConsole("OUI-22017", args);
            return;
        }
        Object[] args2 = new String[]{folderPath};
        File folderPathFile = new File(folderPath);
        if (folderPathFile.isDirectory()) {
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args2);
            try {
                if (folderPathFile.exists()) {
                    OiixFileOps.cleanupdelete(folderPathFile);
                }
                String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                Object[] args3 = new String[]{message, result};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args3);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS", args2);
                this.logSummaryMessage(summaryMessage);
            }
            catch (Exception e) {
                String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                Object[] args3 = new String[]{message, result};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args3);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args2);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getMessage());
                OiicExitCode.setExitCode(-1);
            }
        }
    }

    public void cleanupRegKeysRemote(String oracleHomeName) {
        String key = HKLM;
        String subKey = SW_ORACLE_HOME_KEY_PREFIX + oracleHomeName;
        try {
            OiipwClusterWindowsOps.registryDeleteKey(key, subKey, this.m_sRemoteNodes);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendText(e.getBasicMessage());
        }
    }

    private void cleanupCIRemote() {
        String summaryMessage;
        Object[] args1;
        String result;
        if (this.m_oInvLocations == null || this.m_oInvLocations.size() == 0) {
            return;
        }
        Set invLocs = this.m_oInvLocations.keySet();
        Iterator iter = invLocs.iterator();
        String[] sampleStringList = new String[invLocs.size()];
        String[] remoteNodesForInvDel = invLocs.toArray(sampleStringList);
        while (iter.hasNext()) {
            String summaryMessage2;
            Object[] args2;
            String result2;
            String failedMessage;
            Object[] args12;
            String nodeName = (String)iter.next();
            this.nodesLastHome.add(nodeName);
            String invLocOnNode = (String)this.m_oInvLocations.get(nodeName);
            Object[] args = new String[]{nodeName, invLocOnNode};
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
            try {
                if (OiipgClusterOps.fileExistsOnNode(nodeName, invLocOnNode)) {
                    OiipgClusterOps.removeDirectoryFromNode(nodeName, invLocOnNode, System.getProperty("oracle.installer.scratchPath"));
                }
                String result3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                args12 = new String[]{message, result3};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args12);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                String summaryMessage3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS", args);
                this.logSummaryMessage(summaryMessage3);
                if (this.nodesWithSameDefaultOraInst.indexOf(nodeName) != -1) {
                    this.nodesToRemoveOraInst.add(nodeName);
                }
            }
            catch (OiipgRemoteOpsException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args1 = new String[]{message, result};
                failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole("OUI-20024", args);
                OiicExitCode.setExitCode(-1);
            }
            catch (OiipgRemoteFileOperationException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args1 = new String[]{message, result};
                failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole("OUI-20024", args);
                OiicExitCode.setExitCode(-1);
            }
            if (!this.s_bIsWindows) continue;
            String parentDirOnNode = new File(invLocOnNode).getParent();
            args12 = new String[]{nodeName, parentDirOnNode};
            String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args12);
            try {
                String[] listofFiles = OiipgClusterOps.listDirectory(nodeName, parentDirOnNode);
                if (listofFiles != null && listofFiles.length != 0) continue;
                if (OiipgClusterOps.fileExistsOnNode(nodeName, parentDirOnNode)) {
                    OiipgClusterOps.removeDirFromNode(nodeName, parentDirOnNode);
                }
                result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                args2 = new String[]{message1, result2};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS", args12);
                this.logSummaryMessage(summaryMessage2);
            }
            catch (OiipgRemoteOpsException e) {
                result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args2 = new String[]{message1, result2};
                String failedMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                OiiolTextLogger.writeToLogAndConsole(failedMessage2);
                summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args12);
                this.logSummaryMessage(summaryMessage2);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole("OUI-20024", args12);
                OiicExitCode.setExitCode(-1);
            }
        }
        if (this.s_bIsWindows) {
            Object[] args13;
            String key = HKLM;
            String subKey = "Software\\Oracle";
            String value = "inst_loc";
            Object[] args = new String[]{key, subKey + "\\" + value, OiixFunctionOps.implodeList(remoteNodesForInvDel, ",")};
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args);
            try {
                OiipwClusterWindowsOps.registryDeleteValue(key, subKey, value, remoteNodesForInvDel);
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                args1 = new String[]{message, result};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS", args);
                this.logSummaryMessage(summaryMessage);
            }
            catch (OiipgRemoteOpsException e) {
                String result4 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args13 = new String[]{message, result4};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args13);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage4 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", args);
                this.logSummaryMessage(summaryMessage4);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
            }
            this.cleanupMiscRegistriesRemote(remoteNodesForInvDel);
            ArrayList<String> remoteNodesForTopLevelRegKeyDel = new ArrayList<String>();
            for (int i = 0; i < remoteNodesForInvDel.length; ++i) {
                try {
                    String[] subKeys = OiipwClusterWindowsOps.getRegSubKey(key + "\\" + subKey, remoteNodesForInvDel[i]);
                    if (subKeys != null && subKeys.length != 0) continue;
                    remoteNodesForTopLevelRegKeyDel.add(remoteNodesForInvDel[i]);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                }
            }
            String[] remoteNodesForTopLevelRegKeyDelStrList = OiixVectorOps.list2StrArr(remoteNodesForTopLevelRegKeyDel);
            args13 = new String[]{key, subKey + "\\" + value, OiixFunctionOps.implodeList(remoteNodesForTopLevelRegKeyDelStrList, ",")};
            String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args13);
            try {
                if (remoteNodesForTopLevelRegKeyDelStrList != null && remoteNodesForTopLevelRegKeyDelStrList.length > 0) {
                    OiipwClusterWindowsOps.registryDeleteKey(key, subKey, remoteNodesForTopLevelRegKeyDelStrList);
                    String result5 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args2 = new String[]{message1, result5};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage5 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS", args13);
                    this.logSummaryMessage(summaryMessage5);
                }
            }
            catch (OiipgRemoteOpsException e) {
                String result6 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                Object[] args2 = new String[]{message1, result6};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage6 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", args13);
                this.logSummaryMessage(summaryMessage6);
                OiiolTextLogger.appendException(e);
                OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
            }
        }
    }

    private void cleanupCILocal() {
        Object[] args = new String[]{this.m_sInvLocation};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        OiiolTextLogger.copyLogs(OiiolTextLogger.getLogDir(), this.m_logLocation);
        try {
            OiiolTextLogger.setLogLoc(this.m_logLocation, OiicCleanup.getLogPrefix());
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
        File invLocFile = new File(this.m_sInvLocation);
        try {
            if (invLocFile.exists()) {
                OiixFileOps.cleanupdelete(invLocFile);
            }
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
            Object[] args1 = new String[]{message, result};
            String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(doneMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
            this.logSummaryMessage(summaryMessage);
            if (this.m_sLocalNode == null) {
                this.localNodeLastHome = true;
                if (this.localNodeSameDefaultOraInst) {
                    this.localNodeRemoveOraInst = true;
                }
            } else {
                this.nodesLastHome.add(this.m_sLocalNode);
                if (this.nodesWithSameDefaultOraInst.indexOf(this.m_sLocalNode) != -1) {
                    this.nodesToRemoveOraInst.add(this.m_sLocalNode);
                }
            }
        }
        catch (Exception e) {
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
            Object[] args1 = new String[]{message, result};
            String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(failedMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args);
            this.logSummaryMessage(summaryMessage);
            OiicExitCode.setExitCode(-1);
        }
        if (this.s_bIsWindows) {
            Object[] args4;
            String result;
            File parentdir = invLocFile.getParentFile();
            String[] listofFiles = parentdir.list();
            boolean bDelete = true;
            Object[] args1 = new String[]{parentdir.toString()};
            String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args1);
            if (listofFiles == null || listofFiles.length == 0) {
                String summaryMessage;
                Object[] args2;
                String result2;
                if (parentdir.exists()) {
                    bDelete = parentdir.delete();
                }
                if (bDelete) {
                    result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    args2 = new String[]{message1, result2};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS", args1);
                    this.logSummaryMessage(summaryMessage);
                } else {
                    result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    args2 = new String[]{message1, result2};
                    String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args1);
                    this.logSummaryMessage(summaryMessage);
                    OiicExitCode.setExitCode(-1);
                }
            }
            String key = HKLM;
            String subKey = "Software\\Oracle";
            String value = "inst_loc";
            Object[] args2 = new String[]{key, subKey + "\\" + value};
            String message2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args2);
            try {
                if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                    OiipwWin32NativeCalls.RegDeleteValue(key, subKey, value);
                }
                String result3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                Object[] args3 = new String[]{message2, result3};
                String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args3);
                OiiolTextLogger.writeToLogAndConsole(doneMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS", args2);
                this.logSummaryMessage(summaryMessage);
            }
            catch (OiilNativeException e) {
                String result4 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                Object[] args3 = new String[]{message2, result4};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args3);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED", args2);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiicExitCode.setExitCode(-1);
            }
            this.cleanupMiscRegistriesLocal();
            Object[] args3 = new String[]{key, subKey};
            String message3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args3);
            try {
                String[] subKeys = OiipwWin32NativeCalls.RegGetAllSubkeys(key, subKey);
                if (subKeys == null || subKeys.length == 0) {
                    if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                        OiipwWin32NativeCalls.RegDeleteKey(key, subKey);
                    }
                    result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    args4 = new String[]{message3, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args4);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS", args3);
                    this.logSummaryMessage(summaryMessage);
                }
            }
            catch (OiilNativeException e) {
                result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                args4 = new String[]{message3, result};
                String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args4);
                OiiolTextLogger.writeToLogAndConsole(failedMessage);
                String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED", args3);
                this.logSummaryMessage(summaryMessage);
                OiiolTextLogger.appendException(e);
                OiicExitCode.setExitCode(-1);
            }
        }
    }

    private void copyOuiJreToScratch() throws IOException {
        String ouiLoc = System.getProperty("oracle.installer.oui_loc");
        String jreLoc = System.getProperty("oracle.installer.jre_loc");
        String scratchLoc = System.getProperty("oracle.installer.scratchPath");
        File ouiFile = new File(OiixPathOps.getAbsolutePath(ouiLoc));
        String ouiLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + s_baseAppPrefix);
        File scratchOuiFile = new File(ouiLocNew);
        OiixFileOps.copyDir(ouiFile, scratchOuiFile);
        System.setProperty("oracle.installer.oui_loc", ouiLocNew);
        File jreFile = new File(OiixPathOps.getAbsolutePath(jreLoc));
        String jreLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + "jre");
        File scratchJreFile = new File(jreLocNew);
        OiixFileOps.copyDir(jreFile, scratchJreFile);
        System.setProperty("oracle.installer.jre_loc", jreLocNew);
        String parentLoc = ouiFile.getParent();
        String srvmLoc = OiixPathOps.getStandardForm(parentLoc + "/" + "srvm");
        String srvmLocNew = OiixPathOps.getStandardForm(scratchLoc + "/" + "srvm");
        File srvmFile = new File(srvmLoc);
        File scratchSrvmFile = new File(srvmLocNew);
        if (srvmFile.exists()) {
            OiixFileOps.copyDir(srvmFile, scratchSrvmFile);
        }
    }

    public void setApiModeFlag() {
        this.s_bApiMode = true;
    }

    private boolean isSharedHome(String sOHPath, String localNode) {
        boolean bCFS = this.isCFSPropertySpecified();
        if (localNode != null && !bCFS && !Boolean.getBoolean("oracle.installer.local")) {
            OiipgCFSDriveCheck oCFSDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
            bCFS = oCFSDriveCheck.isDriveOnCFS(sOHPath);
        }
        return bCFS;
    }

    private boolean isCFSPropertySpecified() {
        return Boolean.getBoolean("oracle.installer.cfs");
    }

    private void detachOHRemote() {
        System.setProperty("oracle.installer.bootstrap", "true");
        String invLoc = (String)this.m_oContext.getVarValue("INVENTORY_LOCATION");
        if (this.m_sRemoteNodesHomeAttached != null && this.m_sRemoteNodesHomeAttached.length > 0) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            if (sCustomInvPtrLoc != null && sCustomInvPtrLoc.trim().length() > 0) {
                this.setupRemoteInvPtrLoc(this.m_sRemoteNodesHomeAttached, sCustomInvPtrLoc);
            }
            OiicDetachHome detachHome = OiicDetachHome.getOiicDetachHomeInstance();
            detachHome.clsCmdDetachHome(this.m_sRemoteNodesHomeAttached, this.m_sOracleHome, this.m_sOracleHomeName, this.m_sLocalNode, invLoc, sCustomInvPtrLoc, this.bSharedHome);
            this.s_bDetachHomeRemote = true;
        }
    }

    private String[] setupRemoteInvPtrLoc(String[] asClusterNodes, String sLoc) {
        String[] asNodes = OiipgClusterInvSetup.getCleanMachines(asClusterNodes);
        if (asNodes == null || asNodes.length <= 0) {
            return asNodes;
        }
        ArrayList oCleanNodes = new ArrayList();
        try {
            OiipgClusterOps.transferFileToNodes(asNodes, sLoc, new File(sLoc).getParent());
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        catch (OiipgRemoteFileOperationException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        return OiixVectorOps.list2StrArr(oCleanNodes);
    }

    private String getCustomUnixInvPtrLoc() {
        String sCustomInvPtrLoc = null;
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            sCustomInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", "");
        }
        return sCustomInvPtrLoc;
    }

    private boolean validateHomeVariables() {
        if (this.m_sOracleHome == null || this.m_sOracleHome.equals("")) {
            Object[] args1 = new String[]{" ORACLE_HOME"};
            OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
            OiicExitCode.setExitCode(-1);
            return false;
        }
        if (this.s_bIsWindows && (this.m_sOracleHomeName == null || this.m_sOracleHomeName.equals(""))) {
            this.m_sOracleHomeName = this.getOracleHomeName(this.m_sOracleHome);
        }
        return true;
    }

    private boolean validateInputVariables() {
        if (this.s_bApiMode) {
            String ouiLoc = System.getProperty("oracle.installer.oui_loc");
            String jreLoc = System.getProperty("oracle.installer.jre_loc");
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            if (ouiLoc == null || ouiLoc.equals("")) {
                Object[] args1 = new String[]{" 'oracle.installer.oui_loc'"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            if (jreLoc == null || jreLoc.equals("")) {
                Object[] args1 = new String[]{" 'oracle.installer.jre_loc'"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            if (this.m_sRemoteNodes != null && this.m_sRemoteNodes.length != 0 && (scratchPath == null || scratchPath.equals(""))) {
                Object[] args1 = new String[]{" BOOTSTRAP_LOCATION"};
                OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
                OiicExitCode.setExitCode(-1);
                return false;
            }
        }
        return true;
    }

    private boolean validateInvPtrLoc() {
        if (!this.s_bIsWindows && this.m_sInvPtrLoc != null && !this.m_sInvPtrLoc.equals("")) {
            File invPtrFile = new File(this.m_sInvPtrLoc);
            if (!invPtrFile.exists()) {
                Object[] args1 = new String[]{this.m_sInvPtrLoc};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_INVPTRLOC_ERROR", args1);
                OiiolTextLogger.writeToLogAndConsole(message);
                this.logSummaryMessage(message);
                OiicExitCode.setExitCode(-1);
                return false;
            }
            this.m_sInvPtrLocDir = invPtrFile.getParent();
        }
        return true;
    }

    private void determineRemoteNodesForDetachHome() {
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes);
        HashMap remoteNodesHomesAttached = this.m_clusterInstInv.getRemoteHomesAttached();
        Vector<String> remoteNodes = new Vector<String>();
        if (remoteNodesHomesAttached != null) {
            Set nodes = remoteNodesHomesAttached.keySet();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                String nodeName = (String)iter.next();
                List homesAttachedOnNode = this.m_clusterInstInv.getHomes(nodeName);
                if (homesAttachedOnNode == null || homesAttachedOnNode.size() <= 0 || homesAttachedOnNode.indexOf(this.m_sOracleHome) == -1) continue;
                remoteNodes.add(nodeName);
            }
        }
        if (remoteNodes.size() > 0) {
            String[] sampleStringList = new String[remoteNodes.size()];
            this.m_sRemoteNodesHomeAttached = remoteNodes.toArray(sampleStringList);
        }
    }

    public void setForceFlag(boolean forceFlag) {
        this.s_bForce = forceFlag;
    }

    public void setForceFlagOBase(boolean forceFlagOBase) {
        OiiolTextLogger.writeToLogAndConsole("Setting the force flag to cleanup the Oracle Base");
        this.s_bForceOBase = forceFlagOBase;
    }

    public boolean getForceFlag() {
        return this.s_bForce;
    }

    public boolean getForceFlagOBase() {
        return this.s_bForceOBase;
    }

    public void setDefInvPtrLoc(String defInvPtrLoc) {
        this.m_sDefInvPtrLoc = defInvPtrLoc;
    }

    private void setRemoteInvPtrLoc() throws OiipgRemoteOpsException, OiifbCancelException, IOException {
        if (this.m_sInvPtrLoc.equals(this.m_sDefInvPtrLoc)) {
            return;
        }
        for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
            boolean found = false;
            String remoteNode = this.m_sRemoteNodes[i];
            String localPath = OiixPathOps.concatPath(System.getProperty("oracle.installer.scratchPath"), "oraInst.loc_" + remoteNode);
            String defLocalPath = OiixPathOps.concatPath(System.getProperty("oracle.installer.scratchPath"), "oraInst.loc_default_" + remoteNode);
            String filePath = OiixPathOps.concatPath(this.m_sOracleHome, m_sDefInvPtrFileName);
            if (OiipgClusterOps.fileExistsOnNode(remoteNode, filePath)) {
                OiipgClusterOps.transferFileFromNode(remoteNode, filePath, localPath);
                found = true;
            }
            if (!found && OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sDefInvPtrLoc)) {
                OiipgClusterOps.transferFileFromNode(remoteNode, this.m_sDefInvPtrLoc, localPath);
                found = true;
            }
            if (!found) {
                OiixFileOps.copyFile(this.m_sInvPtrLoc, localPath, true);
                found = true;
            }
            if (!found) continue;
            if (!OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sInvPtrLocDir)) {
                OiipgClusterOps.createDirInNode(remoteNode, this.m_sInvPtrLocDir);
            }
            OiipgClusterOps.transferFileToNode(localPath, remoteNode, this.m_sInvPtrLoc);
            if (!OiipgClusterOps.fileExistsOnNode(remoteNode, this.m_sDefInvPtrLoc)) continue;
            OiipgClusterOps.transferFileFromNode(remoteNode, this.m_sDefInvPtrLoc, defLocalPath);
            if (!this.checkForSameInventoryLocation(localPath, defLocalPath)) continue;
            this.nodesWithSameDefaultOraInst.add(remoteNode);
        }
    }

    private String getOracleHomeName(String oracleHome) {
        try {
            String[] keys = OiixRegistryOps.RegGetAllSubkeys(HKLM, SW_ORACLE_HOME_PREFIX);
            for (int i = 0; i < keys.length; ++i) {
                String oh;
                if (!keys[i].startsWith("KEY_") || !(oh = OiixRegistryOps.RegGetValue(HKLM, "SOFTWARE\\ORACLE\\" + keys[i], "ORACLE_HOME")).equals(oracleHome)) continue;
                String ohname = OiixRegistryOps.RegGetValue(HKLM, "SOFTWARE\\ORACLE\\" + keys[i], "ORACLE_HOME_NAME");
                return ohname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean checkForSameInventoryLocation(String path1, String path2) {
        try {
            if (path1 == null && path2 != null) {
                return true;
            }
            FileInputStream fin1 = new FileInputStream(path1);
            Properties prop1 = new Properties();
            prop1.load(fin1);
            fin1.close();
            String invLoc1 = prop1.getProperty("inventory_loc");
            FileInputStream fin2 = new FileInputStream(path2);
            Properties prop2 = new Properties();
            prop2.load(fin2);
            fin2.close();
            String invLoc2 = prop2.getProperty("inventory_loc");
            return invLoc1.equalsIgnoreCase(invLoc2);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List getCleanSummary() {
        return this.cleanSummary;
    }

    private void logSummaryMessage(String message) {
        if (this.s_bApiMode) {
            this.cleanSummary.add(message);
        }
    }

    public void setLogDir(String logDir) {
        this.m_sLogDir = logDir;
    }

    private boolean isDriveOnCFS(String path) {
        String sVolName = null;
        String[] m_asNodeArray = null;
        OiiolTextLogger.appendText("Calling isDriveOnCFS:" + path);
        if (!OiipgDetectCluster.isClusterEnabled()) {
            OiiolTextLogger.appendText("Cluster mode is disabled:Drive is considered to be on on CFS by default");
            return true;
        }
        File fPath = new File(path);
        sVolName = fPath.isDirectory() ? path : fPath.getParent();
        OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName);
        if (sVolName == null) {
            OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName + ":returning false");
            return false;
        }
        sVolName = OiixPathOps.getStandardForm(sVolName);
        sVolName = OiixPathOps.directorify(sVolName);
        ArrayList<String> oClusterNodes = new ArrayList<String>();
        if (this.m_sLocalNode != null) {
            oClusterNodes.add(this.m_sLocalNode);
        }
        if (this.m_sRemoteNodes != null && this.m_sRemoteNodes.length > 0) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                oClusterNodes.add(this.m_sRemoteNodes[i]);
            }
        }
        if (oClusterNodes != null) {
            int numElems = oClusterNodes.size();
            m_asNodeArray = new String[numElems];
            for (int i = 0; i < numElems; ++i) {
                m_asNodeArray[i] = (String)oClusterNodes.get(i);
            }
        }
        if (m_asNodeArray != null && m_asNodeArray.length > 1 && this.m_sLocalNode != null) {
            try {
                String sNativeVolName = OiixPathOps.getNativeForm(sVolName);
                OiiolTextLogger.appendErrorText("sNativeVolName:" + sNativeVolName);
                OiiolTextLogger.appendErrorText("m_asNodeArray:" + OiixFunctionOps.implodeList(m_asNodeArray, ","));
                OiiolTextLogger.appendErrorText("m_sLocalNode:" + this.m_sLocalNode);
                if (Cluster.isSharedPath((String)sNativeVolName, (String[])m_asNodeArray, (String)this.m_sLocalNode)) {
                    OiiolTextLogger.appendText("In isDriveOnCFS()/isSharedPath : sVolName :" + sVolName + ":returning true");
                    return true;
                }
                OiiolTextLogger.appendText("In isDriveOnCFS()/isSharedPath : sVolName :" + sVolName + ":returning false");
                return false;
            }
            catch (SharedDeviceException e) {
                e.printStackTrace();
            }
            catch (InvalidNodeListException e) {
                e.printStackTrace();
            }
        }
        OiiolTextLogger.appendText("In isDriveOnCFS() : sVolName :" + sVolName + ":returning false");
        return false;
    }

    private boolean recdelete(File delDir, Vector excludeList) {
        boolean retVal = true;
        boolean childRetVal = true;
        if (!delDir.exists()) {
            return retVal;
        }
        String[] conts = delDir.list();
        int contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        for (int i = 0; i < contslen; ++i) {
            File subFile = new File(delDir, conts[i]);
            if (excludeList != null && excludeList.indexOf(conts[i]) > -1) {
                String excludeFile = subFile.getAbsolutePath();
                Object[] argsNew = new String[]{excludeFile};
                String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME_DELETE_EXCLUDE", argsNew);
                OiiolTextLogger.writeToLogAndConsole(msgNew);
                continue;
            }
            if (subFile.isDirectory()) {
                boolean dirDeleteRetVal = this.recdelete(subFile, excludeList);
                if (dirDeleteRetVal) continue;
                childRetVal = false;
                continue;
            }
            if (subFile.delete() || !subFile.exists()) continue;
            Object[] args1 = new String[]{subFile.getAbsolutePath()};
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_FILE", args1);
            OiiolTextLogger.writeToLogAndConsole(message);
            childRetVal = false;
            retVal = false;
        }
        conts = delDir.list();
        contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        boolean checkTopLevel = true;
        if (contslen > 0) {
            checkTopLevel = false;
            for (int i = 0; i < contslen; ++i) {
                boolean found = false;
                if (excludeList != null && excludeList.indexOf(conts[i]) > -1) {
                    found = true;
                }
                if (found) continue;
                checkTopLevel = true;
                break;
            }
        }
        if (checkTopLevel && !delDir.delete() && delDir.exists()) {
            Object[] args1 = new String[]{delDir.getAbsolutePath()};
            String message = null;
            message = childRetVal ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_DIRECTORY_IN_USE", args1) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_FAILED_DELETE_DIRECTORY_NOT_EMPTY", args1);
            OiiolTextLogger.writeToLogAndConsole(message);
            retVal = false;
        }
        return retVal;
    }

    private void cleanupMiscRegistriesRemote(String[] nodes) {
        if (this.miscRegistryListVector != null && this.miscRegistryListVector.size() > 0) {
            String[] regArr = OiixVectorOps.vect2StrArr(this.miscRegistryListVector);
            for (int i = 0; i < regArr.length; ++i) {
                String entry = regArr[i];
                String key = this.getRegKey(entry);
                String subKey = this.getRegSubKey(entry);
                Object[] args1 = new String[]{key, subKey, OiixFunctionOps.implodeList(nodes, ",")};
                String message1 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE", args1);
                try {
                    if (nodes == null || nodes.length <= 0) continue;
                    OiipwClusterWindowsOps.registryDeleteKeyRecursivelyOnNodes(key + subKey, nodes);
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args2 = new String[]{message1, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_SUCCESS", args1);
                    this.logSummaryMessage(summaryMessage);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args2 = new String[]{message1, result};
                    String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args2);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_REMOTE_SUMMARY_FAILED", args1);
                    this.logSummaryMessage(summaryMessage);
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole(e.getBasicMessage());
                }
            }
        }
    }

    private void cleanupMiscRegistriesLocal() {
        if (this.miscRegistryListVector != null && this.miscRegistryListVector.size() > 0) {
            String[] regArr = OiixVectorOps.vect2StrArr(this.miscRegistryListVector);
            for (int i = 0; i < regArr.length; ++i) {
                String entry = regArr[i];
                String key = this.getRegKey(entry);
                String subKey = this.getRegSubKey(entry);
                Object[] args = new String[]{key, subKey};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL", args);
                try {
                    if (OiipwWin32NativeCalls.RegKeyExists(key, subKey)) {
                        OiipwWin32NativeCalls.RegDeleteKey(key, subKey);
                    }
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args1 = new String[]{message, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_SUCCESS", args);
                    this.logSummaryMessage(summaryMessage);
                    continue;
                }
                catch (OiilNativeException e) {
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args1 = new String[]{message, result};
                    String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETE_REGKEY_LOCAL_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiiolTextLogger.appendText("OUI-22016", args);
                    OiiolTextLogger.appendException(e);
                    OiicExitCode.setExitCode(-1);
                }
            }
        }
    }

    private String getRegKey(String entry) {
        int index = entry.indexOf("\\");
        return entry.substring(0, index);
    }

    private String getRegSubKey(String entry) {
        int index = entry.indexOf("\\");
        int startIndex = index + 2;
        return entry.substring(startIndex);
    }

    private void cleanupOracleBaseLocal() {
        String summaryMessage;
        String result;
        if (this.m_sOracleBase != null && this.m_sOracleBase != "") {
            this.bSharedOracleBase = this.isDriveOnCFS(this.m_sOracleBase);
        }
        Object[] args = new String[]{this.m_sOracleBase};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE", args);
        File oracleBaseFile = new File(this.m_sOracleBase);
        boolean retVal = true;
        boolean emptyBase = false;
        if (oracleBaseFile.exists()) {
            String[] conts = oracleBaseFile.list();
            int contslen = 0;
            if (conts != null) {
                contslen = conts.length;
            }
            if (contslen == 0) {
                emptyBase = true;
            } else {
                emptyBase = true;
                if (!this.getForceFlagOBase() || !this.m_bCleanupLocalCI) {
                    for (int i = 0; i < contslen; ++i) {
                        File subFile = new File(oracleBaseFile, conts[i]);
                        if (this.oracleBaseDirListVector == null) continue;
                        if (this.oracleBaseDirListVector.indexOf(conts[i]) > -1) {
                            retVal = this.recdelete(subFile, this.homeDeinstallExcludeListVector);
                            continue;
                        }
                        String path = "";
                        String ohCanPath = "";
                        try {
                            path = OiixPathOps.getStandardForm(subFile.getCanonicalPath());
                            ohCanPath = OiixPathOps.getStandardCanonicalPath(this.m_sOracleHome);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (ohCanPath.indexOf(path) < 0) {
                            emptyBase = false;
                            continue;
                        }
                        if (!this.getForceFlagOBase() || !this.m_bCleanupLocalCI) continue;
                        retVal = this.recdelete(subFile, this.homeDeinstallExcludeListVector);
                    }
                }
            }
            if (emptyBase) {
                retVal = this.recdelete(oracleBaseFile, this.homeDeinstallExcludeListVector);
            } else {
                Object[] argsNew = new String[]{this.m_sOracleBase};
                String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_NOT_EMPTY_LOCAL_NODE", argsNew);
                OiiolTextLogger.writeToLogAndConsole(msgNew);
                return;
            }
        }
        if (retVal) {
            result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
            Object[] args1 = new String[]{message, result};
            String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(doneMessage);
            summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
            this.logSummaryMessage(summaryMessage);
        } else {
            result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
            Object[] args1 = new String[]{message, result};
            String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(failedMessage);
            summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_LOCAL_NODE_SUMMARY_FAILED", args);
            this.logSummaryMessage(summaryMessage);
            OiicExitCode.setExitCode(-1);
        }
    }

    private void cleanupOracleBaseRemote() {
        if (!this.bSharedOracleBase && this.m_sRemoteNodesOracleBase != null && this.m_sRemoteNodesOracleBase.length > 0) {
            for (int i = 0; i < this.m_sRemoteNodesOracleBase.length; ++i) {
                String failedMessage;
                String summaryMessage;
                String result;
                String nodeName = this.m_sRemoteNodesOracleBase[i];
                Object[] args = new String[]{nodeName, this.m_sOracleBase};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES", args);
                try {
                    boolean emptyBase = false;
                    if (OiipgClusterOps.fileExistsOnNode(nodeName, this.m_sOracleBase)) {
                        String[] conts = OiipgClusterOps.listDirectory(nodeName, this.m_sOracleBase);
                        int contslen = 0;
                        if (conts != null) {
                            contslen = conts.length;
                        }
                        if (contslen == 0) {
                            emptyBase = true;
                        } else {
                            emptyBase = true;
                            if (!this.getForceFlagOBase() || !this.m_bCleanupRemoteCI) {
                                for (int j = 0; j < contslen; ++j) {
                                    String path = OiixPathOps.getStandardForm(this.m_sOracleBase + "/" + conts[j]);
                                    if (this.oracleBaseDirListVector == null) continue;
                                    if (this.oracleBaseDirListVector.indexOf(conts[j]) > -1) {
                                        OiipgClusterOps.removeDirectoryFromNode(nodeName, path, System.getProperty("oracle.installer.scratchPath"));
                                        continue;
                                    }
                                    if (this.m_sOracleHome.indexOf(path) < 0) {
                                        emptyBase = false;
                                        continue;
                                    }
                                    if (!this.getForceFlagOBase() || !this.m_bCleanupRemoteCI) continue;
                                    OiipgClusterOps.removeDirectoryFromNode(nodeName, path, System.getProperty("oracle.installer.scratchPath"));
                                }
                            }
                        }
                        if (emptyBase) {
                            OiipgClusterOps.removeDirectoryFromNode(nodeName, this.m_sOracleBase, System.getProperty("oracle.installer.scratchPath"));
                        } else {
                            Object[] argsNew = new String[]{this.m_sOracleBase, nodeName};
                            String msgNew = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_NOT_EMPTY_REMOTE_NODE", argsNew);
                            OiiolTextLogger.writeToLogAndConsole(msgNew);
                            continue;
                        }
                    }
                    result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args1 = new String[]{message, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_SUCCESS", args);
                    this.logSummaryMessage(summaryMessage);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args1 = new String[]{message, result};
                    failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole("OUI-20024", args);
                    OiicExitCode.setExitCode(-1);
                    continue;
                }
                catch (OiipgRemoteFileOperationException e) {
                    result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args1 = new String[]{message, result};
                    failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_DELETING_DIRECTORY_ON_REMOTE_NODES_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiiolTextLogger.appendException(e);
                    OiiolTextLogger.writeMessageToConsole("OUI-20024", args);
                    OiicExitCode.setExitCode(-1);
                }
            }
        }
    }

    private void determineCleanupOracleBaseLocal() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbEndIterateException, OiisVarSettingException, OiifbCancelException {
        File localInvFile;
        if (this.m_sOracleBase == null || this.m_sOracleBase == "") {
            this.m_bCleanupLocalOracleBase = false;
            this.m_bCleanupRemoteOracleBase = false;
            return;
        }
        if (this.m_sOracleBase != null && this.m_sOracleBase != "") {
            this.bSharedOracleBase = this.isDriveOnCFS(this.m_sOracleBase);
        }
        if (this.invSession == null) {
            try {
                OiiolTextLogger.appendText("Creating a new Inventory Session");
                this.invSession = new OiicStandardInventorySession(OiicCleanup.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText("Initializing the inventory session with access 1");
                this.invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        this.m_oContext.setVarValue("INVENTORY_LOCATION", iAreaControl.getAreaRoot());
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        this.m_sInvLocation = iAreaControl.getAreaRoot();
        Vector homesAttached = instinv.getHomes();
        if (homesAttached != null) {
            for (int i = 0; i < homesAttached.size(); ++i) {
                OiiiOracleHomeInfo ohInfo = (OiiiOracleHomeInfo)homesAttached.elementAt(i);
                if (ohInfo == null) continue;
                String obase = ohInfo.getAdditionalOracleHomeProperty("ORACLE_BASE");
                String ohLoc = ohInfo.getLocation();
                if (obase != null && obase != "" && obase.equalsIgnoreCase(this.m_sOracleBase)) {
                    this.m_bCleanupLocalOracleBase = false;
                    Object[] args = new String[]{this.m_sOracleBase, ohLoc};
                    String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_LOCAL_NODE", args);
                    OiiolTextLogger.writeToLogAndConsole(msg);
                    break;
                }
                if (ohLoc == null || ohLoc == "" || !ohLoc.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) continue;
                this.m_bCleanupLocalOracleBase = false;
                Object[] args = new String[]{this.m_sOracleBase, ohLoc};
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_LOCAL_NODE", args);
                OiiolTextLogger.writeToLogAndConsole(msg);
                break;
            }
        }
        if ((localInvFile = new File(this.m_sInvLocation)).exists() && this.m_sInvLocation.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) {
            this.m_bCleanupLocalOracleBase = false;
            Object[] args = new String[]{this.m_sOracleBase};
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_CI_LOCAL_NODE", args);
            OiiolTextLogger.writeToLogAndConsole(msg);
        }
    }

    private void determineCleanupOracleBaseRemote() {
        Vector<String> oBaseNodes = new Vector<String>();
        if (this.m_sRemoteNodes != null) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                oBaseNodes.add(this.m_sRemoteNodes[i]);
            }
        }
        this.m_clusterInstInv = new OiiiClusterInstallInventory(this.m_sRemoteNodes);
        HashMap remoteNodesHomesAttached = this.m_clusterInstInv.getRemoteHomesAttached();
        if (remoteNodesHomesAttached != null) {
            Set nodes = remoteNodesHomesAttached.keySet();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                boolean oBaseUsed = false;
                String nodeName = (String)iter.next();
                List homesAttachedOnNode = this.m_clusterInstInv.getHomes(nodeName);
                if (homesAttachedOnNode != null && homesAttachedOnNode.size() > 0) {
                    for (int i = 0; i < homesAttachedOnNode.size(); ++i) {
                        String msg;
                        Object[] args;
                        String remoteHomeLoc = (String)homesAttachedOnNode.get(i);
                        OiiiRemoteHome remoteHome = this.m_clusterInstInv.getRemoteHome(nodeName, remoteHomeLoc);
                        if (remoteHome == null) continue;
                        String obase = remoteHome.getAdditionalOracleHomeProperty("ORACLE_BASE");
                        if (obase != null && obase != "" && obase.equalsIgnoreCase(this.m_sOracleBase)) {
                            oBaseUsed = true;
                            args = new String[]{this.m_sOracleBase, nodeName, remoteHomeLoc};
                            msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_REMOTE_NODE", args);
                            OiiolTextLogger.writeToLogAndConsole(msg);
                            break;
                        }
                        if (remoteHomeLoc == null || remoteHomeLoc == "" || !remoteHomeLoc.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) continue;
                        oBaseUsed = true;
                        args = new String[]{this.m_sOracleBase, nodeName, remoteHomeLoc};
                        msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_REMOTE_NODE", args);
                        OiiolTextLogger.writeToLogAndConsole(msg);
                        break;
                    }
                }
                boolean remoteInvExist = false;
                try {
                    remoteInvExist = OiipgClusterOps.fileExistsOnNode(nodeName, this.m_sInvLocation);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (remoteInvExist && this.m_sInvLocation.toLowerCase().startsWith(this.m_sOracleBase.toLowerCase())) {
                    oBaseUsed = true;
                    Object[] args = new String[]{this.m_sOracleBase, nodeName};
                    String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_BASE_IN_USE_CI_REMOTE_NODE", args);
                    OiiolTextLogger.writeToLogAndConsole(msg);
                }
                if (!oBaseUsed) continue;
                oBaseNodes.remove(nodeName);
            }
        }
        this.m_sRemoteNodesOracleBase = OiixVectorOps.list2StrArr(oBaseNodes);
    }

    private void getAllOHServices() {
        String[] services = null;
        Vector<String> ohServices = new Vector<String>();
        try {
            services = (String[])OiixServiceOps.getAllOracleServices();
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    try {
                        String service = services[i];
                        String exeName = OiixServiceOps.getServiceExeName(service);
                        String homeLoc = this.m_sOracleHome + "\\";
                        if (exeName.toLowerCase().indexOf(homeLoc.toLowerCase()) <= -1) continue;
                        ohServices.add(service);
                        continue;
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendText(e.getMessage());
                    }
                }
                if (ohServices.size() > 0) {
                    this.m_sOHServices = OiixVectorOps.vect2StrArr(ohServices);
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
    }

    private void cleanupOHServicesLocal() {
        if (this.m_sOHServices != null && this.m_sOHServices.length > 0) {
            for (int i = 0; i < this.m_sOHServices.length; ++i) {
                String summaryMessage;
                String failedMessage;
                Object[] args1;
                String result;
                String summaryMessage2;
                String doneMessage;
                Object[] args12;
                String result2;
                String message;
                Object[] args;
                String service = this.m_sOHServices[i];
                int status = 0;
                try {
                    status = OiixServiceOps.queryService(service);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (status == 4) {
                    args = new String[]{service};
                    message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOPPING_SERVICE_ON_LOCAL_NODE", args);
                    try {
                        OiixServiceOps.ntStopService(service);
                        result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                        args12 = new String[]{message, result2};
                        doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args12);
                        OiiolTextLogger.writeToLogAndConsole(doneMessage);
                        summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOP_SERVICE_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
                        this.logSummaryMessage(summaryMessage2);
                    }
                    catch (Exception e) {
                        result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                        args1 = new String[]{message, result};
                        failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                        OiiolTextLogger.writeToLogAndConsole(failedMessage);
                        summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOP_SERVICE_ON_LOCAL_NODE_SUMMARY_FAILED", args);
                        this.logSummaryMessage(summaryMessage);
                        OiicExitCode.setExitCode(-1);
                    }
                }
                args = new String[]{service};
                message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_SERVICE_ON_LOCAL_NODE", args);
                try {
                    OiixServiceOps.ntDeleteService(service);
                    result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    args12 = new String[]{message, result2};
                    doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args12);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_SERVICE_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
                    this.logSummaryMessage(summaryMessage2);
                    continue;
                }
                catch (Exception e) {
                    result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    args1 = new String[]{message, result};
                    failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_SERVICE_ON_LOCAL_NODE_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiicExitCode.setExitCode(-1);
                }
            }
        }
    }

    private void cleanupOHServicesRemote() {
        if (this.m_sRemoteNodes != null && this.m_sRemoteNodes.length > 0 && this.m_sOHServices != null && this.m_sOHServices.length > 0) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                String nodeName = this.m_sRemoteNodes[i];
                for (int j = 0; j < this.m_sOHServices.length; ++j) {
                    String summaryMessage;
                    String failedMessage;
                    Object[] args1;
                    String result;
                    String summaryMessage2;
                    String doneMessage;
                    Object[] args12;
                    String result2;
                    String message;
                    Object[] args;
                    String service = this.m_sOHServices[j];
                    boolean status = false;
                    try {
                        status = OiipwClusterWindowsOps.checkServiceRunningOnNode(service, nodeName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (status) {
                        args = new String[]{service, nodeName};
                        message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOPPING_SERVICE_ON_REMOTE_NODE", args);
                        try {
                            OiipwClusterWindowsOps.stopServiceOnNode(service, nodeName);
                            result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                            args12 = new String[]{message, result2};
                            doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args12);
                            OiiolTextLogger.writeToLogAndConsole(doneMessage);
                            summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOP_SERVICE_ON_REMOTE_NODE_SUMMARY_SUCCESS", args);
                            this.logSummaryMessage(summaryMessage2);
                        }
                        catch (Exception e) {
                            result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                            args1 = new String[]{message, result};
                            failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                            OiiolTextLogger.writeToLogAndConsole(failedMessage);
                            summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STOP_SERVICE_ON_REMOTE_NODE_SUMMARY_FAILED", args);
                            this.logSummaryMessage(summaryMessage);
                            OiicExitCode.setExitCode(-1);
                        }
                    }
                    args = new String[]{service, nodeName};
                    message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_SERVICE_ON_REMOTE_NODE", args);
                    try {
                        OiipwClusterWindowsOps.deleteServiceOnNode(service, nodeName);
                        result2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                        args12 = new String[]{message, result2};
                        doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args12);
                        OiiolTextLogger.writeToLogAndConsole(doneMessage);
                        summaryMessage2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_SERVICE_ON_REMOTE_NODE_SUMMARY_SUCCESS", args);
                        this.logSummaryMessage(summaryMessage2);
                        continue;
                    }
                    catch (Exception e) {
                        result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                        args1 = new String[]{message, result};
                        failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                        OiiolTextLogger.writeToLogAndConsole(failedMessage);
                        summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_SERVICE_ON_REMOTE_NODE_SUMMARY_FAILED", args);
                        this.logSummaryMessage(summaryMessage);
                        OiicExitCode.setExitCode(-1);
                    }
                }
            }
        }
    }

    private void cleanupPathLocal() {
        String varName = "Path";
        Object[] args = new String[]{this.m_sOracleHome};
        String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE", args);
        try {
            String value = OiixRegistryOps.RegGetValue(HKLM, ENV_REG_SUBKEY, varName);
            String newValue = this.removeHomeFromPath(value);
            if (value.equals(newValue)) {
                OiiolTextLogger.appendText("Path variable has no reference to Oracle Home '" + this.m_sOracleHome + "' on local node, no changes required.");
                return;
            }
            OiixRegistryOps.RegSetWideCharsetValue(HKLM, ENV_REG_SUBKEY, varName, newValue, true, false);
            OiixEnvironmentOps.SendIniChangeMessage();
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
            Object[] args1 = new String[]{message, result};
            String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(doneMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE_SUMMARY_SUCCESS", args);
            this.logSummaryMessage(summaryMessage);
        }
        catch (Exception e) {
            String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
            Object[] args1 = new String[]{message, result};
            String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
            OiiolTextLogger.writeToLogAndConsole(failedMessage);
            String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_LOCAL_NODE_SUMMARY_FAILED", args);
            this.logSummaryMessage(summaryMessage);
            OiicExitCode.setExitCode(-1);
        }
    }

    private void cleanupPathRemote() {
        if (this.m_sRemoteNodes != null && this.m_sRemoteNodes.length > 0) {
            for (int i = 0; i < this.m_sRemoteNodes.length; ++i) {
                String node = this.m_sRemoteNodes[i];
                Object[] args = new String[]{this.m_sOracleHome, node};
                String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVING_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE", args);
                try {
                    String varName = "Path";
                    String value = OiipwClusterWindowsOps.getRegStringDataOnNode(ENV_REG_KEY, varName, node);
                    if (value == null) continue;
                    String newValue = this.removeHomeFromPath(value);
                    if (value.equals(newValue)) {
                        OiiolTextLogger.appendText("Path variable has no reference to Oracle Home '" + this.m_sOracleHome + "' on node '" + node + ", no changes required.");
                        continue;
                    }
                    String[] nodes = new String[]{node};
                    String srcLoc = System.getProperty("DC_HOME");
                    OiipwClusterWindowsOps.registrySetValue(HKLM, ENV_REG_SUBKEY, varName, newValue, true, nodes);
                    OiipwClusterWindowsOps.updateEnv(nodes, srcLoc);
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_DONE");
                    Object[] args1 = new String[]{message, result};
                    String doneMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(doneMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE_SUMMARY_SUCCESS", args);
                    this.logSummaryMessage(summaryMessage);
                    continue;
                }
                catch (Exception e) {
                    String result = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_OPERATION_FAILED");
                    Object[] args1 = new String[]{message, result};
                    String failedMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLEANUP_MESSAGE_RESULT", args1);
                    OiiolTextLogger.writeToLogAndConsole(failedMessage);
                    String summaryMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOVE_ORACLE_HOME_FROM_PATH_ON_REMOTE_NODE_SUMMARY_FAILED", args);
                    this.logSummaryMessage(summaryMessage);
                    OiicExitCode.setExitCode(-1);
                }
            }
        }
    }

    private String removeHomeFromPath(String path) {
        if (path == null || path == "") {
            return path;
        }
        String delimiter = ";";
        Vector<String> newPath = new Vector<String>();
        String[] tokens = OiixFunctionOps.explodeString(path, delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.toLowerCase().startsWith(this.m_sOracleHome.toLowerCase())) continue;
            newPath.add(token);
        }
        String[] newPathString = OiixVectorOps.vect2StrArr(newPath);
        return OiixFunctionOps.implodeList(newPathString, delimiter);
    }

    private String getRemoveExcludeList() {
        String dcRemExclList;
        String homeRemExclList = OiixPathOps.getStandardForm(this.m_sOracleHome + "/crs/install/installRemove.excl");
        String exclList = null;
        String retExclList = null;
        String toolDir = System.getProperty("DC_HOME");
        if (new File(homeRemExclList).exists()) {
            exclList = homeRemExclList;
        } else if (toolDir != null && toolDir != "" && new File(dcRemExclList = OiixPathOps.getStandardForm(toolDir + "/crs/install/installRemove.excl")).exists()) {
            exclList = dcRemExclList;
        }
        if (exclList != null) {
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            retExclList = OiixPathOps.getStandardForm(scratchPath + "/removeHomeExcludeList");
            try {
                OiixFileOps.copyFile(exclList, retExclList, true);
            }
            catch (Exception e) {
                retExclList = null;
            }
        }
        OiiolTextLogger.appendText("RemoveHomeExcludeList is: " + retExclList);
        return retExclList;
    }

    private String getOracleBaseDirList() {
        String retObaseList = null;
        String sysPropVal = System.getProperty(OBASE_CLEANUP_PTR);
        if (sysPropVal != null && sysPropVal != "" && new File(sysPropVal).exists()) {
            retObaseList = sysPropVal;
        }
        OiiolTextLogger.appendText("OracleBaseDirList is: " + retObaseList);
        return retObaseList;
    }

    private String getMiscRegistryList() {
        String retRegistryList = null;
        String sysPropVal = System.getProperty(REGISTRY_CLEANUP_PTR);
        if (sysPropVal != null && sysPropVal != "" && new File(sysPropVal).exists()) {
            retRegistryList = sysPropVal;
        }
        OiiolTextLogger.appendText("WindowsRegistryCleanupList is: " + retRegistryList);
        return retRegistryList;
    }

    private Vector readFileIntoVector(String fileName) {
        Vector<String> ret = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String str = reader.readLine();
            while (str != null) {
                if (ret == null) {
                    ret = new Vector<String>();
                }
                ret.add(str);
                str = reader.readLine();
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

