/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCompsWizEngine;
import oracle.sysman.oii.oiic.OiicInstOHSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicInvSetupWCCE;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUIManager;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwCloneDepCalcWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterChecksWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterSessionVarWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwHostNameWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwInvLocWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwOCMInfoWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateOraHomeVarsWCCE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageInvEntryNotFoundException;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiil.OiilWinActions;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisComputeAtCloneVars;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicCloneSession
extends OiicPullSession {
    private OiisComputeAtCloneVars m_oComputeAtCloneVars;

    public OiicCloneSession(OiicInstaller install, boolean silentMode) throws OiifbEndIterateException {
        super(install, silentMode);
        this.m_sessionContext = new OiicSessionContext(this);
        this.setAreaControls(null);
    }

    public OiicCloneSession(OiicInstaller install) throws OiifbEndIterateException {
        this(install, false);
    }

    private void validateOraBase(String oracleBasestring) throws IOException {
        File oracleBase = new File(oracleBasestring);
        oracleBasestring = OiixPathOps.getNativeCanonicalPath(oracleBasestring);
        if (!oracleBase.exists()) {
            if (!OiixFileOps.mkdirs(oracleBase)) {
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_BASELOC_REASON"));
            }
        } else if (!oracleBase.isDirectory()) {
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_BASELOC_DIR"));
        }
    }

    private void updateOracleBase() throws IOException {
        OiisVariable obVar = this.m_sessionContext.getVariable("ORACLE_BASE");
        String oracleBasestring = (String)obVar.getValue();
        try {
            oracleBasestring = OiipgFileSystem.checkWritablePath(oracleBasestring);
        }
        catch (OiipgPathException pge) {
            throw new IOException(pge.getMessage() + System.getProperty("line.separator") + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_BASELOC_REASON"));
        }
        try {
            this.validateOraBase(oracleBasestring);
            oracleBasestring = OiixPathOps.getUnexpandedCanonicalPath(oracleBasestring);
            try {
                obVar.setValue(oracleBasestring, true);
            }
            catch (OiifbCancelException e) {
                e.printStackTrace();
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
        }
        catch (NullPointerException npe) {
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_OPEN_BASELOC"));
        }
    }

    public void setupOHAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        OiifbUIManager.setSession(this);
        this.getPgActionsPhase().initialize();
        super.setupAccessObjects();
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.updateOracleBase();
        }
        OiixPlatform.optimize();
    }

    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        int j = 1;
        OiifwInvLocWCCE setupInv = new OiifwInvLocWCCE(this.m_sessionContext, 1, 1);
        iterEls.addElement(setupInv);
        OiicInvSetupWCCE setupHomeInv = new OiicInvSetupWCCE(this.m_sessionContext, ++j);
        iterEls.addElement(setupHomeInv);
        OiifwCloneModeInvSetupWCCE cloneInv = new OiifwCloneModeInvSetupWCCE(this.m_sessionContext, ++j);
        iterEls.addElement(cloneInv);
        OiifwValidateOraHomeVarsWCCE validateHomeVars = new OiifwValidateOraHomeVarsWCCE(this.m_sessionContext, ++j);
        iterEls.addElement(validateHomeVars);
        OiicInstOHSetupWCCE setupAccess = new OiicInstOHSetupWCCE(this.m_sessionContext, ++j);
        iterEls.addElement(setupAccess);
        OiifwOCMInfoWCDE setupOCM = new OiifwOCMInfoWCDE(this.m_sessionContext, ++j);
        iterEls.addElement(setupOCM);
        OiifwCloneDepCalcWCCE depCalc = new OiifwCloneDepCalcWCCE(this.m_sessionContext, ++j);
        iterEls.addElement(depCalc);
        OiifwClusterChecksWCCE oClusterChecks = new OiifwClusterChecksWCCE(this.m_sessionContext, ++j);
        iterEls.add(oClusterChecks);
        OiifwHostNameWCDE hostNameWCDE = new OiifwHostNameWCDE(this.m_sessionContext, ++j);
        iterEls.addElement(hostNameWCDE);
        OiicCompsWizEngine compsWizEngine = new OiicCompsWizEngine(this);
        iterEls.addElement(compsWizEngine);
        OiifwClusterSessionVarWCCE clusterSessionVar = new OiifwClusterSessionVarWCCE(this.m_sessionContext);
        iterEls.addElement(clusterSessionVar);
        OiifwActionsPhaseWCDE actionsPhase = new OiifwActionsPhaseWCDE(this);
        this.setActionsPhaseWCDE(actionsPhase);
        iterEls.addElement(actionsPhase);
        OiicInstPostActionsPhase postActionsPhase = new OiicInstPostActionsPhase(this);
        iterEls.addElement(postActionsPhase);
        return iterEls;
    }

    public void initSession() throws OiifbEndIterateException {
        this.m_namespaceTable = new Hashtable();
        this.m_namespaceTable.put(this.m_sessionContext, new Hashtable());
        this.m_sessionContext.setVariables();
        this.setSessionMode("Clone");
        this.setUnixGroupName(this.m_sessionContext);
        this.setInventoryLocation(this.getInvLoc());
        try {
            OiisVariable homeVar = this.m_sessionContext.getVariable("ORACLE_HOME");
            OiisVariable fromLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
            String sHomeLoc = (String)homeVar.getValue();
            String invDir = OiixPathOps.concatPath(sHomeLoc, "inventory");
            String sCompsFileLoc = OiiiInstallAreaControl.getXMLCompsFileLoc(sHomeLoc);
            fromLocVar.setValue(sCompsFileLoc);
            fromLocVar.setAdvice(true);
            String scriptsDir = OiixPathOps.concatPath(invDir, "Scripts");
            String sComputeAtCloneVarsList = OiixPathOps.concatPath(scriptsDir, "computeAtCloneVars.txt");
            this.m_oComputeAtCloneVars = new OiisComputeAtCloneVars(sComputeAtCloneVarsList);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        OiiodDepEngine depEngine = new OiiodDepEngine(this);
        this.setDepEngine(depEngine);
    }

    public OiisComputeAtCloneVars getComputeAtCloneVarsList() {
        return this.m_oComputeAtCloneVars;
    }

    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
        String invLoc = this.getInvLoc();
        if (invLoc != null) {
            return;
        }
        try {
            invLoc = System.getProperty("oracle.installer.custom_inventory");
            if (invLoc != null && invLoc != "") {
                this.setInvLoc(invLoc);
            } else if (sInvLoc != null) {
                this.setInvLoc(sInvLoc);
            } else {
                OiipgPropertyLoader pl = new OiipgPropertyLoader();
                this.setInvLoc(pl.getLocationFileLoc());
            }
            invLoc = this.getInvLoc();
            if (invLoc != null) {
                OiipgFileSystem.checkWritablePath(invLoc);
                OiiiInstallAreaControl.initAreaControl(invLoc);
                OiiiInstallAreaControl targetAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                this.m_installInv = targetAreaControl.getInstallInventory();
                if (this.m_installInv != null) {
                    this.setTargetAreaControl(targetAreaControl);
                    String logLoc = targetAreaControl.genFileSysLoc("logs");
                    OiiolTextLogger.renameInstallActionsLog(logLoc, "cloneActions");
                    OiiolTextLogger.setLogLoc(logLoc, "cloneActions");
                    boolean bIsAPI = this.isAPIMode();
                    boolean bUseCustomLog = false;
                    String sCustomLogLoc = System.getProperty("oracle.installer.log_loc");
                    if (null != sCustomLogLoc && !targetAreaControl.getAreaRoot().equalsIgnoreCase(sCustomLogLoc)) {
                        logLoc = sCustomLogLoc;
                        bUseCustomLog = true;
                    }
                    if (bIsAPI && null != OiicAPIInstaller.getHandleToAPIInstaller().getCustomLogDir()) {
                        OiicAPIInstaller installerInst = OiicAPIInstaller.getHandleToAPIInstaller();
                        try {
                            logLoc = installerInst.getCustomLogDir();
                            OiiolTextLogger.setLogLoc(installerInst.getCustomLogDir(), installerInst.getCustomLogFileName(), installerInst.getCustomLogFileExtn(), installerInst.getCustomLevel(), installerInst.getCustomFormatter());
                            bUseCustomLog = true;
                        }
                        catch (IOException e) {
                            OiiolTextLogger.setLogLoc(logLoc);
                            bUseCustomLog = false;
                        }
                    }
                    if (bIsAPI && (invLoc != null || invLoc.length() > 0)) {
                        if (bUseCustomLog) {
                            this.setupDuplicateStreamsForLog(logLoc);
                        } else {
                            this.setInvLoc(invLoc);
                            this.setupDuplicateStreams();
                        }
                    }
                    if (!Boolean.getBoolean("oracle.installer.ignoreLogMsg")) {
                        String logStr = OiixResourceBundle.getString("S_LOG_LOC_PROMPT");
                        String curLogFile = OiiolTextLogger.getCurLogFileName();
                        if (curLogFile != null && curLogFile != "") {
                            Object[] arr = new String[]{curLogFile};
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(logStr, arr));
                        }
                    }
                    OiiolTextLogger.setSilentInstallErrLog(logLoc);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_INSTVER") + OiicBaseApp.getInstallerVersion().toString() + System.getProperty("line.separator"));
                    this.initSessionCloneVars();
                } else {
                    invLoc = null;
                }
            }
            this.setInvLoc(invLoc);
        }
        catch (IOException e) {
            this.setInvLoc(null);
        }
        catch (OiipgPathException pge) {
            if (pge.getLevel() == OiipgPathException.INVALID_PATH) {
                File f = new File(invLoc);
                f.delete();
            }
            Object[] args = new Object[]{invLoc};
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_START_SETUP_ERR", args);
            throw new OiifbEndIterateException(sMsg);
        }
    }

    private void setClusterNodes(OiiiOracleHomeInfo homeInfo) throws OiisVarSettingException, OiifbCancelException {
        if (this.isAPIMode()) {
            return;
        }
        OiisVariable nodesVar = this.m_sessionContext.getVariable("CLUSTER_NODES");
        if (!nodesVar.isValueSetByUser()) {
            String[] oEmptyArray = new String[]{};
            nodesVar.setValue(oEmptyArray);
        }
    }

    private void updateOHProperties(OiiiOracleHomeInfo homeInfo) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Entering OiicCloneSession.updateOHProperties", OiiolTextLogger.LOG_TRACE);
        }
        OiisVariable crsVar = this.m_sessionContext.getVariable("CRS");
        boolean bCRS = homeInfo.isCRSHome();
        if (crsVar.isValueSetByUser()) {
            bCRS = crsVar.getValueAsString().equals("true");
        }
        homeInfo.setCRSHome(bCRS);
        OiisVariable nodesVar = this.m_sessionContext.getVariable("CLUSTER_NODES");
        if (nodesVar.isValueSetByUser()) {
            homeInfo.setNodeList((String[])nodesVar.getValue());
        }
        String localNode = (String)this.m_sessionContext.getVarValue("LOCAL_NODE");
        if (Boolean.getBoolean("oracle.installer.cfs")) {
            localNode = null;
        }
        homeInfo.setLocalNode(localNode);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Exiting OiicCloneSession.updateOHProperties" + homeInfo.toString(), OiiolTextLogger.LOG_TRACE);
        }
    }

    public void saveWinActionsXML(OiiiInstallInventory inv) {
        if (!OiixFunctionOps.isPlatformWindows().booleanValue()) {
            return;
        }
        String sHomeInvLoc = OiixPathOps.concatPath(inv.getHomeLocation(this.getOHIndex()), "inventory");
        String sWinXmlTargetLoc = OiilWinActions.getWinActionsFileName(sHomeInvLoc);
        if (!new File(sWinXmlTargetLoc).exists()) {
            return;
        }
        Vector vComps = inv.getAllCompsVect(this.getOHIndex(), OiixPlatform.getCurrentPlatform());
        OiiiCompInstallID[] cidArray = new OiiiCompInstallID[vComps.size()];
        for (int i = 0; i < vComps.size(); ++i) {
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)vComps.elementAt(i);
            cidArray[i] = ie.getCompInstallID();
        }
        OiilWinActions.saveWinActionsXml(cidArray, null, sWinXmlTargetLoc, true);
    }

    public void saveInventoryWithUpdate() throws IOException, OiifbCancelException {
        OiiiInstallCompInvEntry ie;
        int i;
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INIT_SAV_INV"), OiiolTextLogger.LOG_BASIC);
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        Vector installIEs = instInv.getAllCompsVect(this.getOHIndex(), OiixPlatform.getCurrentPlatform());
        int nComps = installIEs.size();
        Date newInstallTime = new Date(System.currentTimeMillis());
        for (i = 0; i < nComps; ++i) {
            ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            ie.setInstallTime(newInstallTime);
        }
        for (i = 0; i < nComps; ++i) {
            ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            if (ie.getCompInstallID().getCompType() != 1) continue;
            OiiiCompInstallID cid = ie.getCompInstallID();
            int ohIndex = this.getHomeIndex(cid);
            OiisCompInstallation ci = this.getCompInstall(cid);
            if (ci == null) continue;
            String sProdHome = ci.getContext().getProdHome();
            ie.setProdHomeLoc(sProdHome);
        }
        for (i = 0; i < nComps; ++i) {
            OiiiInstallPatchInvEntry ipie;
            OiiiCompInstallID baseID;
            OiiiInstallCompInvEntry bcie;
            ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            if (ie.getCompInstallID().getCompType() != 2 || (bcie = instInv.getInstallCompInvEntry(baseID = (ipie = (OiiiInstallPatchInvEntry)ie).getBaseID(), this.getHomeIndex(baseID))) == null) continue;
            ipie.setBaseInvEntry(bcie);
            bcie.setPatchInvEntry(ipie);
            ipie.setProdHomeLoc(bcie.getProdHomeLoc());
        }
        this.saveWinActionsXML(instInv);
        this.getSessionContext().writeGlobalVarsToInv();
        iac.saveInstallInventory();
    }

    protected static String getOutStreamFileName() {
        return "oraClone";
    }

    public void dispose() {
        super.dispose();
        this.releaseLocks();
    }

    private String getDefaultHomeName() {
        OiiiInstallAreaControl oAreaControl = this.getInstallAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        String name = OiiiOracleHomeInfo.getDefHomeName(oInventory, 0);
        int idx = 1;
        boolean bNameExists = true;
        while (bNameExists) {
            String sName = name + idx;
            bNameExists = oInventory.getHomeWithName(sName) != null;
            if (!bNameExists) continue;
            ++idx;
        }
        return name + idx;
    }

    protected class OiifwCloneModeInvSetupWCCE
    implements OiifbCondWizOperation {
        private OiisVariableOwner m_vo = null;
        private int m_nextInd = -1;
        private static final String S_PRECLONE_CHECK = "PRECLONE_CHECK";
        private static final String S_LIBRARIES = "LIBRARIES";
        private static final String S_SCRIPTS = "SCRIPTS";
        private static final String S_TEMPLATES = "TEMPLATES";

        public OiifwCloneModeInvSetupWCCE(OiisVariableOwner vo, int nextInd) {
            this.m_vo = vo;
            this.m_nextInd = nextInd;
        }

        private void loadInstallPropertiesFile() {
            try {
                OiiiInstallAreaControl iac = OiicCloneSession.this.getInstallAreaControl();
                String destdir = iac.getScriptsLoc(OiicCloneSession.this.getOHIndex());
                File dir = new File(destdir);
                String[] files = dir.list();
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".properties");
                    }
                };
                files = dir.list(filter);
                for (int i = 0; i < files.length; ++i) {
                    String name = files[i];
                    name = OiixPathOps.concatPath(destdir, name);
                    OiiolTextLogger.appendText("loading install properties filename: " + name);
                    Properties props = new Properties();
                    FileInputStream fs = new FileInputStream(name);
                    props.load(fs);
                    Properties sysProps = System.getProperties();
                    Enumeration<?> propNames = props.propertyNames();
                    while (propNames.hasMoreElements()) {
                        String propName = (String)propNames.nextElement();
                        String propValue = (String)props.get(propName);
                        OiiolTextLogger.appendText("Set " + propName + " to " + propValue, OiiolTextLogger.LOG_DETAILED);
                        sysProps.put(propName, propValue);
                    }
                    fs.close();
                }
            }
            catch (Exception error) {
                OiiolTextLogger.appendText(error.toString(), OiiolTextLogger.LOG_DETAILED);
            }
        }

        public void initialize() throws OiifbEndIterateException {
            Vector vNonClonable;
            OiisVariable oBaseVar;
            String sBaseLoc;
            OiisVariable homeVar = this.m_vo.getVariable("ORACLE_HOME");
            String sHomeLoc = (String)homeVar.getValue();
            OiisVariable homeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
            OiisVariable chVar = OiicCloneSession.this.m_sessionContext.getVariable("COMPOSITE_HOME");
            String compositeHome = (String)chVar.getValue();
            OiisVariable chTypeVar = OiicCloneSession.this.m_sessionContext.getVariable("COMPOSITE_HOME_TYPE");
            String compositeHomeType = (String)chTypeVar.getValue();
            String sHomeName = (String)homeNameVar.getValue();
            boolean b_AllValuesProvided = true;
            Object[] args = null;
            if (sHomeLoc == null || sHomeLoc.length() == 0) {
                b_AllValuesProvided = false;
                args = new Object[]{"ORACLE_HOME"};
            }
            if (sHomeName == null || sHomeName.length() == 0) {
                if (!System.getProperty("oracle.installer.defaultHomeName", "false").equals("true")) {
                    if (!b_AllValuesProvided) {
                        args = new Object[]{"ORACLE_HOME", "ORACLE_HOME_NAME"};
                    } else {
                        b_AllValuesProvided = false;
                        args = new Object[]{"ORACLE_HOME_NAME"};
                    }
                } else {
                    try {
                        homeNameVar.setValue(OiicCloneSession.this.getDefaultHomeName());
                    }
                    catch (OiisVarSettingException e) {
                        e.printStackTrace();
                    }
                    catch (OiifbCancelException e) {
                        e.printStackTrace();
                    }
                    sHomeName = (String)homeNameVar.getValue();
                }
            }
            if (!b_AllValuesProvided) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_VAR_NOT_SET_CLONE", args);
                OiiolTextLogger.writeToLogAndConsole(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
            try {
                OiisVariable oNodeNames = this.m_vo.getVariable("CLUSTER_NODES");
                if (!oNodeNames.isValueSet()) {
                    oNodeNames.setValue(new String[0]);
                    oNodeNames.setAdvice(false);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new OiifbEndIterateException("" + e);
            }
            String sCompsXMLLoc = OiiiInstallAreaControl.getXMLCompsFileLoc(sHomeLoc);
            if (!new File(sCompsXMLLoc).exists()) {
                Object[] sArgs = new String[]{sHomeLoc};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_CLONE_OH_LOC", sArgs);
                OiiolTextLogger.writeToLogAndConsole(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
            OiixFileOps.setFileModifiedTime(sCompsXMLLoc, -1L);
            OiipgDetectCluster.setClusterEnabled(false);
            OiiiOracleHomeInfo homeInfo = null;
            try {
                homeInfo = OiicCloneSession.this.m_installInv.attachHomeEx((String)homeNameVar.getValue(), (String)homeVar.getValue(), 0, new int[]{0}, compositeHome, compositeHomeType);
                OiicCloneSession.this.setClusterNodes(homeInfo);
                ((OiicSessionContext)this.m_vo).setLocalNodeName(null);
                String[] oEmptyArray = new String[]{};
                OiisVariable oRemoteNodeNames = this.m_vo.getVariable("REMOTE_NODES");
                oRemoteNodeNames.setValue(oEmptyArray);
            }
            catch (OiiiMultipleSOHException e) {
                OiifmAlert.displayError(e.getErrorMessage());
                throw new OiifbEndIterateException(e.getErrorMessage());
            }
            catch (Throwable e) {
                String sErr = e.getMessage();
                int nHomeType = 0;
                Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(nHomeType)};
                String sErrMsg = MessageFormat.format(sErr, sArgs);
                OiifmAlert.displayError(sErrMsg);
                throw new OiifbEndIterateException("" + e);
            }
            try {
                OiisVariable logLocVar = this.m_vo.getVariable("LOG_LOCATION");
                logLocVar.setValue(OiixPathOps.concatPath(sHomeLoc, "cfgtoollogs"), true);
                OiiolTextLogger.setConfigLogLoc(sHomeLoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            OiicCloneSession.this.setOHIndex(homeInfo.getIndex());
            this.loadInstallPropertiesFile();
            String useOB = System.getProperty("oracle.installer.useORACLE_BASE");
            if (useOB != null && useOB.equalsIgnoreCase("true") && ((sBaseLoc = (String)(oBaseVar = this.m_vo.getVariable("ORACLE_BASE")).getValue()) == null || sBaseLoc.length() == 0)) {
                b_AllValuesProvided = false;
                args = new Object[]{"ORACLE_BASE"};
            }
            if (!b_AllValuesProvided) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_VAR_NOT_SET_CLONE", args);
                OiiolTextLogger.writeToLogAndConsole(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
            OiicCloneSession.this.updateOHProperties(homeInfo);
            if (OiixPlatform.isPlatInGroup(-3, OiixPlatform.getCurrentPlatform())) {
                try {
                    boolean bOldStyleReg = OiixOraparam.createOldStyleRegEntries();
                    OiipgOracleHomes.setupRegEntriesAndContext(OiicCloneSession.this.m_sessionContext, bOldStyleReg);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5100", new String[]{ioe.getMessage()});
                    OiiolTextLogger.appendText(sMsg);
                }
            }
            if ((vNonClonable = this.getNonClonableComps(homeInfo.getIndex())) != null && !vNonClonable.isEmpty()) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_COMPS_NOT_CLONABLE"));
                Enumeration enumComps = vNonClonable.elements();
                while (enumComps.hasMoreElements()) {
                    OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)enumComps.nextElement();
                    OiiolTextLogger.appendText("\t" + icie.getFullDisplayName());
                }
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_HOME_NOT_CLONABLE", new Object[]{sHomeLoc});
                if (this.isForceClone()) {
                    OiiolTextLogger.appendText(sMsg);
                    sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FORCE_CLONE_HOME_NOT_CLONABLE");
                    OiiolTextLogger.appendText(sMsg);
                } else {
                    throw new OiifbEndIterateException(sMsg);
                }
            }
            try {
                this.updateLibraries();
            }
            catch (IOException e) {
                throw new OiifbEndIterateException(e);
            }
            try {
                this.saveTemplates();
            }
            catch (IOException e) {
                throw new OiifbEndIterateException(e);
            }
            try {
                this.saveScripts();
            }
            catch (IOException e) {
                throw new OiifbEndIterateException(e);
            }
            catch (OiifbCancelException e) {
                throw new OiifbEndIterateException(e);
            }
            catch (OiitTargetLockNotAvailableException e) {
                throw new OiifbEndIterateException(e);
            }
            catch (OiixJarModifyException e) {
                throw new OiifbEndIterateException(e);
            }
            catch (OiiiStageInvEntryNotFoundException e) {
                throw new OiifbEndIterateException(e);
            }
        }

        private void updateLibraries() throws IOException {
            String sLibsDirectory = OiixOraparam.getOraparamProfileString(S_PRECLONE_CHECK, S_LIBRARIES, "");
            if (sLibsDirectory.length() > 0) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLONE_UPDATE_LIBRARIES", new Object[]{OiixPathOps.getNativeCanonicalPath(sLibsDirectory)}));
                int homeIdx = OiicCloneSession.this.getOHIndex();
                ArrayList al = OiicCloneSession.this.m_installInv.addLibrariesToHome(sLibsDirectory, homeIdx, true);
                int nCnt = al.size();
                if (nCnt > 0) {
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < nCnt; ++i) {
                        sb.append((String)al.get(i));
                        if (i + 1 >= nCnt) continue;
                        sb.append(",\n");
                    }
                    OiiiOracleHomeInfo homeInfo = OiicCloneSession.this.m_installInv.getHomeInfo(homeIdx);
                    Object[] args = new String[]{sLibsDirectory, homeInfo.getLocation(), sb.toString()};
                    throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LIBRARIES_NOT_ADDED", args));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveScripts() throws IOException, OiifbCancelException, OiixJarModifyException, OiiiStageInvEntryNotFoundException, OiitTargetLockNotAvailableException {
            String sScriptsDir = OiixOraparam.getOraparamProfileString(S_PRECLONE_CHECK, S_SCRIPTS, "");
            if (sScriptsDir.length() > 0 && new File(sScriptsDir).exists()) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLONE_UPDATE_SCRIPTS", new Object[]{OiixPathOps.getNativeCanonicalPath(sScriptsDir)}));
                sScriptsDir = OiixPathOps.getStandardForm(sScriptsDir);
                int iHomeIndex = OiicCloneSession.this.getOHIndex();
                OiiiInstallAreaControl iac = OiicCloneSession.this.getInstallAreaControl();
                String sStageInvLoc = OiixPathOps.concatPath(sScriptsDir, "products.xml");
                OiiiSourceAccess oSrcAcc = new OiiiSourceAccess(sStageInvLoc, null);
                OiiiStageInventory si = oSrcAcc.getStageInventory();
                try {
                    OiicCloneSession.this.m_installInv.saveHomeStageInventory(iHomeIndex, si, sScriptsDir, true);
                    Object var8_7 = null;
                    oSrcAcc.dispose();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    oSrcAcc.dispose();
                    throw throwable;
                }
            }
        }

        private void saveTemplates() throws IOException {
            String sTemplatesDirectory = OiixOraparam.getOraparamProfileString(S_PRECLONE_CHECK, S_TEMPLATES, "");
            if (sTemplatesDirectory.length() > 0) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLONE_UPDATE_TEMPLATES", new Object[]{OiixPathOps.getNativeCanonicalPath(sTemplatesDirectory)}));
                String sDestDir = OiicCloneSession.this.getInstallAreaControl().getTemplatesLoc(OiicCloneSession.this.getOHIndex());
                OiixFileOps.copyDir(new File(sTemplatesDirectory), new File(sDestDir), true);
            }
        }

        private boolean isForceClone() {
            String sForceClone = System.getProperty("oracle.installer.forceClone", "false");
            return Boolean.valueOf(sForceClone);
        }

        public int doOperation(boolean back) throws OiifbEndIterateException {
            if (back) {
                return 1;
            }
            return 0;
        }

        public void dispose() {
            OiicCloneSession.this.m_oComputeAtCloneVars = null;
        }

        public void finalize() {
            this.dispose();
        }

        public String getName() {
            return this.getClass().getName();
        }

        public int getNext() {
            return this.m_nextInd;
        }

        private Vector getNonClonableComps(int homeIndex) {
            Enumeration enumComps = OiicCloneSession.this.getInstallAreaControl().getInstallInventory().getAllComps(homeIndex);
            Vector<OiiiInstallCompInvEntry> vNonClonable = new Vector<OiiiInstallCompInvEntry>();
            while (enumComps.hasMoreElements()) {
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)enumComps.nextElement();
                if (icie.isClonable()) continue;
                vNonClonable.addElement(icie);
            }
            return vNonClonable;
        }
    }
}

