/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicClusterNode;
import oracle.sysman.oii.oiic.OiicIClusterNode;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicClusterInstallInfo {
    private boolean m_bAvailable = true;
    private Vector m_vClusterNodes = null;
    private Map m_oClusterNodesMap = null;
    private static OiicClusterInstallInfo s_oClusterInstallInfo;

    private OiicClusterNode addClusterNode(String node) {
        String sKey;
        if (this.m_vClusterNodes == null) {
            this.m_vClusterNodes = new Vector();
        }
        if (this.m_oClusterNodesMap == null) {
            this.m_oClusterNodesMap = new HashMap();
        }
        if (this.m_oClusterNodesMap.containsKey(sKey = this.getKey(node))) {
            return (OiicClusterNode)this.m_oClusterNodesMap.get(sKey);
        }
        OiicClusterNode cNode = new OiicClusterNode(node);
        this.m_vClusterNodes.addElement(cNode);
        this.m_oClusterNodesMap.put(this.getKey(node), cNode);
        return cNode;
    }

    public void addClusterNodes(String[] nodeList) {
        if (nodeList != null && nodeList.length > 0) {
            for (int i = 0; i < nodeList.length; ++i) {
                this.addClusterNode(nodeList[i]);
            }
        }
    }

    public void setClusterNodes(String[] nodeList) {
        if (nodeList != null && nodeList.length > 0) {
            this.m_vClusterNodes = new Vector(nodeList.length);
            this.m_oClusterNodesMap = new HashMap();
            for (int i = 0; i < nodeList.length; ++i) {
                OiicClusterNode cNode = new OiicClusterNode(nodeList[i]);
                this.m_vClusterNodes.addElement(cNode);
                this.m_oClusterNodesMap.put(this.getKey(nodeList[i]), cNode);
            }
            this.resetAvailability();
        }
    }

    private String getKey(String node) {
        return node.toLowerCase();
    }

    public static OiicClusterInstallInfo getClusterInstallInfo() {
        if (s_oClusterInstallInfo == null) {
            s_oClusterInstallInfo = new OiicClusterInstallInfo();
        }
        return s_oClusterInstallInfo;
    }

    public Vector getClusterNodes() {
        return this.m_vClusterNodes;
    }

    public List getPrivateNodeNames(String[] nodes) {
        ArrayList<String> oPrivateNodes = null;
        if (nodes != null && this.m_oClusterNodesMap != null) {
            int iSize = nodes.length;
            oPrivateNodes = new ArrayList<String>(iSize);
            for (int i = 0; i < iSize; ++i) {
                OiicIClusterNode oNode = this.getNode(nodes[i]);
                String sPrivateNodeName = null;
                if (oNode == null) continue;
                sPrivateNodeName = oNode.getPrivateNodeName();
                oPrivateNodes.add(sPrivateNodeName);
            }
        }
        return oPrivateNodes;
    }

    public Vector getPrivateInterconnectInfo() {
        Vector<String> vPrivateNodes = null;
        if (this.m_vClusterNodes != null) {
            int iSize = this.m_vClusterNodes.size();
            vPrivateNodes = new Vector<String>(iSize);
            for (int i = 0; i < iSize; ++i) {
                OiicIClusterNode oNode = (OiicIClusterNode)this.m_vClusterNodes.get(i);
                String sPrivateNodeName = oNode.getPrivateNodeName();
                if (sPrivateNodeName == null) continue;
                vPrivateNodes.add(sPrivateNodeName);
            }
        }
        return vPrivateNodes;
    }

    public String[] getNodesWithErrors(String[] nodes) {
        ArrayList<String> oDownNodes = new ArrayList<String>();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                OiicIClusterNode oNode = this.getNode(nodes[i]);
                if (oNode == null || oNode.isAvailable()) continue;
                oDownNodes.add(oNode.getName());
            }
        }
        return OiixVectorOps.list2StrArr(oDownNodes);
    }

    public boolean isAvailable(String[] nodes) {
        boolean bAvailable = true;
        if (nodes != null) {
            for (int i = 0; i < nodes.length && bAvailable; ++i) {
                OiicIClusterNode oNode = this.getNode(nodes[i]);
                if (oNode == null) continue;
                bAvailable = oNode.isAvailable();
            }
        } else {
            bAvailable = false;
        }
        return bAvailable;
    }

    public boolean isAvailable() {
        return this.m_bAvailable;
    }

    public OiicIClusterNode getNode(String node) {
        return this.getClusterNode(node);
    }

    public OiicClusterNode getClusterNodeForVirtualHostName(String node) {
        OiicClusterNode cNode = null;
        if (this.m_vClusterNodes != null && this.m_vClusterNodes.size() > 0) {
            for (int i = 0; i < this.m_vClusterNodes.size() && !(cNode = (OiicClusterNode)this.m_vClusterNodes.get(i)).getVirtualHostName().equalsIgnoreCase(node); ++i) {
            }
        }
        return cNode;
    }

    public OiicClusterNode getClusterNodeForPrivateNodeName(String node) {
        OiicClusterNode cNode = null;
        if (this.m_vClusterNodes != null && this.m_vClusterNodes.size() > 0) {
            for (int i = 0; i < this.m_vClusterNodes.size() && !(cNode = (OiicClusterNode)this.m_vClusterNodes.get(i)).getPrivateNodeName().equalsIgnoreCase(node); ++i) {
            }
        }
        return cNode;
    }

    public OiicClusterNode getClusterNode(String node) {
        OiicClusterNode cNode = null;
        if (this.m_oClusterNodesMap != null) {
            cNode = (OiicClusterNode)this.m_oClusterNodesMap.get(this.getKey(node));
        }
        return cNode;
    }

    public void setAvailabilityErrorList(String node, String ErrorStr) {
        OiicClusterNode cNode = this.getClusterNode(node);
        if (cNode == null) {
            cNode = this.addClusterNode(node);
        }
        cNode.setAvailabilityErrorList(ErrorStr);
        this.m_bAvailable = false;
    }

    public void setLocalNode(String sNode, boolean bLocalNode) {
        OiicClusterNode oNode;
        if (sNode != null && (oNode = this.getClusterNode(sNode)) != null) {
            oNode.setLocalNode(bLocalNode);
        }
    }

    public void setPrivateNodeName(String sNode, String sPrivateNodeName) {
        OiicClusterNode oNode;
        if (sNode != null && sPrivateNodeName != null && (oNode = this.getClusterNode(sNode)) != null) {
            oNode.setPrivateNodeName(sPrivateNodeName);
        }
    }

    public void setVirtualHostName(String sNode, String sVirtualHostName) {
        OiicClusterNode oNode;
        if (sNode != null && sVirtualHostName != null && (oNode = this.getClusterNode(sNode)) != null) {
            oNode.setVirtualHostName(sVirtualHostName);
        }
    }

    public void resetAvailability() {
        Vector clsNodes = this.getClusterNodes();
        if (clsNodes != null && !clsNodes.isEmpty()) {
            int numNodes = clsNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                OiicClusterNode clusterNode = (OiicClusterNode)clsNodes.get(i);
                clusterNode.resetAvailability();
            }
        }
        this.m_bAvailable = true;
    }

    public static void dispose() {
        s_oClusterInstallInfo = null;
    }
}

