/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiic.OiicIClusterNode;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicClusterNode
implements OiicIClusterNode {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private boolean m_bLocalNode = false;
    private String m_nodeName;
    private String m_sPrivateNodeName = null;
    private String m_sVirtualHostName = null;
    private List m_oAvailabilityErrorList = null;
    private String m_sVersion = null;
    private int m_iAvailable = 0;

    public OiicClusterNode(String nodeName) {
        this.m_nodeName = nodeName;
    }

    public String getName() {
        return this.m_nodeName;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof OiicClusterNode) {
            OiicClusterNode cnode = (OiicClusterNode)o;
            return this.m_nodeName.equals(cnode.getName());
        }
        return false;
    }

    private void debug(String s) {
        System.out.println("OiicClusterNode : " + s);
    }

    void setAvailabilityErrorList(String s) {
        if (!this.isLocalNode()) {
            if (this.m_oAvailabilityErrorList == null) {
                this.m_oAvailabilityErrorList = new ArrayList(1);
            }
            this.m_iAvailable = 1;
            this.m_oAvailabilityErrorList.add(s);
        }
    }

    public List getAvailabilityErrorList() {
        return this.m_oAvailabilityErrorList;
    }

    void resetAvailability() {
        this.m_iAvailable = 0;
    }

    public int getAvailabilityStatus() {
        return this.m_iAvailable;
    }

    public String getAvailabilityStatusStr() {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NODE_STATUS_" + this.m_iAvailable);
    }

    public boolean isAvailable() {
        return this.m_iAvailable == 0;
    }

    void setLocalNode() {
        this.setLocalNode(true);
    }

    void setLocalNode(boolean bLocalNode) {
        this.m_bLocalNode = bLocalNode;
    }

    public boolean isLocalNode() {
        return this.m_bLocalNode;
    }

    void setPrivateNodeName(String sPrivateNodeName) {
        this.m_sPrivateNodeName = sPrivateNodeName;
    }

    public String getPrivateNodeName() {
        return this.m_sPrivateNodeName;
    }

    void setVirtualHostName(String sVirtualHostName) {
        this.m_sVirtualHostName = sVirtualHostName;
    }

    public String getVirtualHostName() {
        return this.m_sVirtualHostName;
    }

    public void setVersion(String sVersion) {
        this.m_sVersion = sVersion;
    }

    public String getVersion() {
        return this.m_sVersion;
    }
}

