/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbLinearIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCurBaseCompContext;
import oracle.sysman.oii.oiis.OiisPatchContext;
import oracle.sysman.oii.oiis.OiisPatchInstallation;
import oracle.sysman.oii.oiis.OiisSerBaseCompContext;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicCompsWizEngine
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x2000004;
    private OiifbLinearIterator iter;
    private OiicPullSession m_session;
    private static final String LOG_PATCH_LANGS = "S_LOG_SETTING_PATCH_LANGUAGES";

    public OiicCompsWizEngine(OiicPullSession session) {
        this.m_session = session;
        this.iter = new OiifbLinearIterator();
    }

    public void initialize() {
    }

    public void dispose() {
        this.iter.dispose();
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (!isBack) {
            OiicSessionPlan oPlan = this.m_session.getSessionPlan();
            Vector vInvs = oPlan.getSuccessfulAdditionsForContext(5);
            Vector compArray = this.getCompContexts(vInvs);
            this.setBaseContextForPatches(compArray, vInvs);
            this.iter.setElements(compArray);
            this.m_session.createComponentNamespaces(compArray);
        }
        int nRet = this.iter.iterate(isBack);
        OiixProgressListener progressListener = this.m_session.getProgressListener();
        if (progressListener != null) {
            progressListener.onDoneProgress();
        }
        return nRet;
    }

    private void setBaseContextForPatches(Vector contextList, Vector vInvs) {
        int size = contextList.size();
        for (int i = 0; i < size; ++i) {
            File oXMLContext;
            OiisCompContext context = (OiisCompContext)contextList.elementAt(i);
            if (!(context instanceof OiisPatchContext)) continue;
            OiisPatchContext pContext = (OiisPatchContext)context;
            OiiiPatchInstallID pid = (OiiiPatchInstallID)pContext.getCompInstallID();
            OiiiCompInstallID baseCid = pid.getCompInstallID();
            OiisPatchInstallation pInstall = (OiisPatchInstallation)this.m_session.getCompInstall(pid);
            if (OiixVectorOps.vectIndexOf(vInvs, (Object)baseCid) != -1) {
                OiisCompInstallation baseInstall = this.m_session.getCompInstall(baseCid);
                if (baseInstall == null) continue;
                OiisCurBaseCompContext bContext = new OiisCurBaseCompContext(baseInstall.getContext());
                pInstall.setBaseContext(bContext);
                Vector vBaseLangs = baseInstall.getProperties().getLanguages();
                Vector vPatchLangs = this.getPatchSupportedLanguages(pInstall, vBaseLangs);
                int patchIndex = OiixVectorOps.vectIndexOf(vInvs, (Object)pid);
                if (patchIndex != -1) {
                    OiiiInstallPatchInvEntry pEntry = (OiiiInstallPatchInvEntry)vInvs.elementAt(patchIndex);
                    pEntry.setLanguages(vPatchLangs);
                    Object[] args = new Object[]{vPatchLangs.toString(), pEntry.getFullDisplayName()};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString(LOG_PATCH_LANGS, args));
                }
                pInstall.getProperties().setLanguages(vPatchLangs);
                try {
                    OiisVariable oVar = bContext.getVariable("PROD_HOME");
                    pContext.setProdHome((String)oVar.getValue());
                    pInstall.setProdHomeLoc((String)oVar.getValue());
                }
                catch (Exception e) {}
                continue;
            }
            int nOHIndex = this.m_session.getHomeIndex(baseCid);
            OiiiInstallInventory instInv = (OiiiInstallInventory)this.m_session.getTargetAreaControl().getAreaInventory();
            OiiiInstallCompInvEntry invEntry = instInv.getInstallCompInvEntry(baseCid, this.m_session.getOHIndex());
            if (invEntry == null) continue;
            Vector vBaseLangs = invEntry.getLanguages();
            Vector vPatchLangs = this.getPatchSupportedLanguages(pInstall, vBaseLangs);
            int patchIndex = OiixVectorOps.vectIndexOf(vInvs, (Object)pid);
            if (patchIndex != -1) {
                OiiiInstallPatchInvEntry pEntry = (OiiiInstallPatchInvEntry)vInvs.elementAt(patchIndex);
                pEntry.setLanguages(vPatchLangs);
                Object[] args = new Object[]{vPatchLangs.toString(), pEntry.getFullDisplayName()};
                OiiolTextLogger.appendText(OiixResourceBundle.getString(LOG_PATCH_LANGS, args));
            }
            pInstall.getProperties().setLanguages(vPatchLangs);
            OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)this.m_session.getTargetAreaControl();
            boolean bXMLContextPresent = false;
            String sContextLoc = "";
            String sXMLContextLoc = "";
            String sXMLCompLoc = invEntry.getLocationInXMLInventory();
            if (sXMLCompLoc != null && (oXMLContext = new File(sXMLContextLoc = oAreaControl.getXMLContextLoc(nOHIndex, sXMLCompLoc))).exists()) {
                bXMLContextPresent = true;
            }
            if (!bXMLContextPresent) {
                String sCompLoc = invEntry.getLocation();
                sContextLoc = oAreaControl.getContextLoc(sCompLoc);
            }
            try {
                OiisSerBaseCompContext bContext = new OiisSerBaseCompContext(this.m_session);
                if (bXMLContextPresent) {
                    bContext.readXMLContext(sXMLContextLoc);
                } else {
                    bContext.readContext(sContextLoc);
                }
                pInstall.setBaseContext(bContext);
                pContext.setProdHome(invEntry.getProdHomeLoc());
                pInstall.setProdHomeLoc(invEntry.getProdHomeLoc());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector getCompContexts(Vector vInvs) {
        long lTime = 0L;
        OiisCompContext context = null;
        String sConstMsg = OiixResourceBundle.getString("S_CONTEXT_LOAD_PROG_MSG");
        MessageFormat msgFmt = new MessageFormat(sConstMsg);
        OiixProgressListener progressListener = this.m_session.getProgressListener();
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        Vector<OiisCompContext> contexts = new Vector<OiisCompContext>();
        OiiodDepEngine oDepEngine = this.m_session.getDepEngine();
        oDepEngine.waitForPreLoadComps();
        boolean numDlgs = false;
        OiiiSourceAccess sacc = this.m_session.getSourceAccess();
        OiicSessionPlan oPlan = this.m_session.getSessionPlan();
        int nCnt = vInvs.size();
        for (int i = 0; i < nCnt; ++i) {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)vInvs.elementAt(i);
            OiiiCompInstallID c = icie.getCompInstallID();
            OiiiStageCompInvEntry scie = sacc.getStageInventory().getStageCompInvEntry(c);
            if (scie != null) {
                if (progressListener != null) {
                    String sName = scie.getName();
                    String[] obj = new String[]{sName};
                    String sMsg = msgFmt.format(obj);
                    progressListener.setStatus(sMsg);
                }
                OiisCompInstallation oCompIns = this.m_session.getCompInstall(c);
                Vector langsToInstall = new Vector();
                OiiodDepEngineHelper.getLangsToInstall(this.m_session, c, scie, langsToInstall, new Vector());
                icie.setLanguages(langsToInstall);
                oCompIns.getProperties().setLanguages(langsToInstall);
                context = oCompIns.getContext();
                if (context != null) {
                    context.setProgressListener(progressListener);
                    contexts.addElement(context);
                }
            } else {
                System.out.println("Null scie found for:" + c);
            }
            if (progressListener == null) continue;
            progressListener.addBytes(1);
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("CompsWizEngine, Component Context Loading ", System.currentTimeMillis() - lTime);
        }
        return contexts;
    }

    private Vector getPatchSupportedLanguages(OiisPatchInstallation pInstall, Vector vBaseLangs) {
        Vector vPatchLangs = pInstall.getProperties().getSupportedLangs();
        Vector<Locale> vLangs = new Vector<Locale>();
        int nBase = vBaseLangs.size();
        int nPatch = vPatchLangs.size();
        block0: for (int i = 0; i < nBase; ++i) {
            Locale lBase = (Locale)vBaseLangs.elementAt(i);
            for (int j = 0; j < nPatch; ++j) {
                Locale lPatch = (Locale)vPatchLangs.elementAt(j);
                if (!lPatch.getLanguage().equals(lBase.getLanguage()) || vLangs.contains(lBase)) continue;
                vLangs.addElement(lBase);
                continue block0;
            }
        }
        return vLangs;
    }
}

