/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifj.OiifjInventoryDialog;
import oracle.sysman.oii.oiif.oiifj.OiifjRemoveDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifm.OiifmProgressCancelHandler;
import oracle.sysman.oii.oiif.oiifp.OiifpWizIntroPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiDeinstallObjects;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDialogLibLoader;
import oracle.sysman.oii.oiis.OiisLibraryLoader;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisQueryLibLoader;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicDeinstallSession
extends OiicDelSession
implements OiicInstallTimeSession,
OiifbWizOperation,
OiiiInventoryEnvUpdater,
OiifrProgressActionListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    OiifwActionsPhaseWCDE m_actionsPhase = null;
    private OiicInstaller m_installer;
    private boolean m_bSilentDeinstall = false;
    private String m_sInvLoc;
    private OiifbSyncObject m_invSetupSync = new OiifbSyncObject();
    private OiiiTargetAreaControl m_targetAreaControl;
    private Hashtable m_hDeinstallTable;
    private Vector m_vDeinstallList;
    int m_nDeinstallOHIndex = 0;
    int m_nDeinstallATIndex = -1;
    private List m_lstHomesToRemove;
    private boolean m_bClusterRmHomes = false;
    private OiifbSyncObject m_syncObj = null;
    private boolean m_removeOraHome = false;
    private List m_homesToDelete;
    private String m_customDeinstallCommand = null;
    private boolean m_bCustomDeinstall = false;
    private int m_customDeinstallHomes = 0;
    private Hashtable[] m_IDsToLibLoaders = new Hashtable[3];

    public OiicDeinstallSession(OiifjRemoveDlg remDlg) {
        super(remDlg);
        for (int i = 0; i < 3; ++i) {
            this.m_IDsToLibLoaders[i] = new Hashtable();
        }
        this.m_sessionContext = new OiicSessionContext(this);
        this.initializeCluster();
    }

    public OiicDeinstallSession(OiicInstaller oi, boolean bSilentDeinstall) {
        this(null);
        this.m_installer = oi;
        this.m_bSilentDeinstall = bSilentDeinstall;
        this.m_sessionContext = new OiicSessionContext(this);
        this.initializeCluster();
    }

    private void initializeCluster() {
        String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
        if (val.equalsIgnoreCase("true")) {
            return;
        }
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        if (detectCluster.isClusterMode()) {
            OiiolTextLogger.appendText("***OiicDeinstallSession:: Detect Cluster called and isClusterMode returned true.");
        }
    }

    public OiifmMainFrame getMainFrame() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            OiifmGraphicInterfaceManager graphicInterfaceManager = (OiifmGraphicInterfaceManager)interfaceManager;
            return graphicInterfaceManager.getMainFrame();
        }
        return null;
    }

    public OiifwWizDialog getWizardDialog() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            OiifmGraphicInterfaceManager graphicInterfaceManager = (OiifmGraphicInterfaceManager)interfaceManager;
            return graphicInterfaceManager.getWizardDialog();
        }
        return null;
    }

    public void startInstall() throws OiifbEndIterateException {
        OiicActionsThread oActionsThread = new OiicActionsThread(this);
        oActionsThread.start();
    }

    public OiisActionLibLoader getActionLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException {
        return (OiisActionLibLoader)this.getLibLoader(lid, 0, homeIndex);
    }

    public OiisLibraryLoader getLibLoader(OiiiLibraryID lid, int libType, int homeIndex) throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory installInv = iac.getInstallInventory();
        lid.optimizePlatList();
        if (!this.m_IDsToLibLoaders[libType].containsKey(lid)) {
            String localFileLoc;
            OiiiLibInvEntry localLib = installInv.getCompatLibInvEntry(lid, libType, homeIndex);
            if (localLib == null) {
                return null;
            }
            String localLoc = localLib.getLocation();
            OiiiLibraryID newLID = localLib.getLibraryID();
            if (this.m_IDsToLibLoaders[libType].containsKey(newLID)) {
                return (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(newLID);
            }
            if (new File(localLoc).isAbsolute()) {
                localFileLoc = localLoc;
            } else {
                String sInvDir = iac.getInventoryLocForHome(homeIndex);
                localFileLoc = OiixPathOps.concatPath(sInvDir, localLoc);
            }
            OiisLibraryLoader lLoader = null;
            switch (libType) {
                case 0: {
                    lLoader = new OiisActionLibLoader(localFileLoc);
                    break;
                }
                case 1: {
                    lLoader = new OiisQueryLibLoader(localFileLoc);
                    break;
                }
                case 2: {
                    lLoader = new OiisDialogLibLoader(localFileLoc);
                }
            }
            this.m_IDsToLibLoaders[libType].put(newLID, lLoader);
            this.m_IDsToLibLoaders[libType].put(lid, lLoader);
            lid = newLID;
        }
        return (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(lid);
    }

    public void clearAllLibLoaders() {
        for (int i = 0; i < this.m_IDsToLibLoaders.length; ++i) {
            int size = this.m_IDsToLibLoaders[i].size();
            Enumeration em = this.m_IDsToLibLoaders[i].keys();
            for (int j = 0; j < size; ++j) {
                OiisLibraryLoader l = (OiisLibraryLoader)this.m_IDsToLibLoaders[i].remove(em.nextElement());
                l.unload();
                l = null;
            }
        }
    }

    public OiisCompInstallation getCompInstall(OiiiCompInstallID cid) {
        return null;
    }

    public OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid) {
        return null;
    }

    public int getOHIndex() {
        return this.m_nDeinstallOHIndex;
    }

    public void setOHIndex(int iOHIndex) {
        this.m_nDeinstallOHIndex = iOHIndex;
    }

    public int getAppltopIndex() {
        return 0;
    }

    public boolean isInstallMode() {
        return false;
    }

    public boolean isDeinstallMode() {
        return true;
    }

    public boolean isCloneMode() {
        return false;
    }

    public boolean isAddNodeMode() {
        return false;
    }

    public void initialize() throws OiifbEndIterateException {
        this.m_sessionContext.setVariables();
        this.setAreaControls(null);
    }

    public void initialize(boolean noBack) throws OiifbEndIterateException {
        this.m_sessionContext.setVariables();
        this.setAreaControls(null);
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiicExitCode.setExitCode(0);
        this.m_nDeinstallOHIndex = 0;
        this.m_nDeinstallATIndex = -1;
        this.computeDeinstallList();
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        if (!this.m_bSilentDeinstall && !isAPIMode) {
            OiisVariable ovConf = this.m_sessionContext.getVariable("SHOW_DEINSTALL_CONFIRMATION");
            OiisVariable ovProg = this.m_sessionContext.getVariable("SHOW_DEINSTALL_PROGRESS");
            boolean bShowConf = (Boolean)ovConf.getValue();
            boolean bShowProg = (Boolean)ovProg.getValue();
            OiifjInventoryDialog invDlg = new OiifjInventoryDialog((Frame)((Object)this.getMainFrame()), false, true, bShowConf, bShowProg);
            invDlg.setDelSession(this);
            OiifpWizIntroPanel owip = new OiifpWizIntroPanel();
            OiifwWizDialog wd = this.getWizardDialog();
            if (null != wd) {
                String sWelcome = System.getProperty("oracle.installer.welcome");
                if (sWelcome.equalsIgnoreCase("true")) {
                    wd.addWizardPanel(owip);
                    wd.setEnabled(false);
                    wd.setEnabledButton(2, false);
                    wd.setEnabledButton(4, false);
                    wd.setEnabledButton(0, false);
                    wd.setEnabledButton(8, false);
                    wd.setEnabledButton(1, false);
                    wd.hideSplashScr();
                }
                invDlg.doModal(true);
                invDlg.dispose();
            }
        } else {
            this.deinstallComponents();
        }
        if (isAPIMode) {
            this.releaseReaderLock();
            OiiiInstallAreaControl oiac = OiiiInstallAreaControl.getInstallAreaControl();
            if (null != oiac) {
                OiiolTextLogger.appendText("disposing the install area control");
                oiac.dispose();
            }
        }
        return 0;
    }

    public void dispose() {
        this.m_actionsPhase = null;
        this.m_hDeinstallTable = null;
        this.m_vDeinstallList = null;
        this.m_remDlg = null;
    }

    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
        this.m_sInvLoc = sInvLoc;
        if (this.m_sInvLoc == null) {
            try {
                this.m_sInvLoc = new OiipgPropertyLoader().getLocationFileLoc();
            }
            catch (IOException e) {
                this.m_sInvLoc = null;
            }
            try {
                if (this.m_sInvLoc != null) {
                    OiipgFileSystem.checkWritablePath(this.m_sInvLoc);
                }
            }
            catch (OiipgPathException pge) {
                if (pge.getLevel() == OiipgPathException.INVALID_PATH) {
                    File f = new File(this.m_sInvLoc);
                    f.delete();
                }
                String sMsg = OiixResourceBundle.getString("S_INV_LOC_INVALID_ERR");
                throw new OiifbEndIterateException(sMsg);
            }
        }
        if (this.m_sInvLoc != null && this.getTargetAreaControl() == null) {
            try {
                OiiiInstallAreaControl.initAreaControl(this.m_sInvLoc);
                OiiiInstallAreaControl targetAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                if (targetAreaControl.getInstallInventory() != null) {
                    this.setTargetAreaControl(targetAreaControl);
                    targetAreaControl.setInvEnvUpdater(this);
                    this.signalLoadInv();
                    String logLoc = targetAreaControl.genFileSysLoc("logs");
                    boolean bIsAPI = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
                    boolean bUseCustomLog = false;
                    String sCustomLogLoc = System.getProperty("oracle.installer.log_loc");
                    if (null != sCustomLogLoc && !targetAreaControl.getAreaRoot().equalsIgnoreCase(sCustomLogLoc)) {
                        logLoc = sCustomLogLoc;
                        bUseCustomLog = true;
                    }
                    if (bIsAPI && null != OiicAPIInstaller.getHandleToAPIInstaller().getCustomLogDir()) {
                        OiicAPIInstaller installerInst = OiicAPIInstaller.getHandleToAPIInstaller();
                        try {
                            logLoc = installerInst.getCustomLogDir();
                            OiiolTextLogger.setLogLoc(installerInst.getCustomLogDir(), installerInst.getCustomLogFileName(), installerInst.getCustomLogFileExtn());
                            bUseCustomLog = true;
                        }
                        catch (IOException e) {
                            OiiolTextLogger.setLogLoc(logLoc);
                        }
                    } else {
                        OiiolTextLogger.setLogLoc(logLoc);
                    }
                    if (!OiicPullSession.isSilentMode() && !bIsAPI) {
                        System.setProperty("oracle.installer.console", "false");
                        this.setupDuplicateStreams();
                    } else if (bIsAPI) {
                        if (bUseCustomLog) {
                            OiicPullSession.createDuplicateStreamsForLog(logLoc);
                        } else {
                            this.setupDuplicateStreams();
                        }
                    }
                    OiiolTextLogger.setSilentInstallErrLog(logLoc);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTVER") + OiicBaseApp.getInstallerVersion().toString() + System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                System.getProperties().setProperty("oracle.installer.cleanUpOnExit", "false");
                throw new OiifbEndIterateException(e);
            }
        }
        if (this.m_sInvLoc == null && this.m_bSilentDeinstall) {
            String sMsg = OiixResourceBundle.getString("S_INV_LOC_NULL_ERR");
            System.out.println(sMsg);
            throw new OiifbEndIterateException(sMsg);
        }
    }

    protected void setTargetAreaControl(OiiiTargetAreaControl targetAreaControl) {
        this.m_targetAreaControl = targetAreaControl;
        OiiiInstallAreaControl.setInventoryAreaControl(this.m_targetAreaControl);
    }

    public OiiiTargetAreaControl getTargetAreaControl() {
        return this.m_targetAreaControl;
    }

    public void waitOnLoadInv() {
        this.m_invSetupSync.sync();
    }

    public void signalLoadInv() {
        this.m_invSetupSync.signal();
    }

    public void updateEnv(OiiiInstallInventory instInv) {
        Vector oHomes = instInv.getHomes();
        if (oHomes == null) {
            return;
        }
        OiisVariable homeKeyVar = this.getSessionVariable("ORACLE_HOME_KEY");
        if (homeKeyVar != null) {
            OiipgOracleHomes.setHomeCounters((String)homeKeyVar.getValue());
        }
    }

    public OiisVariable getSessionVariable(String varName) {
        if (this.m_sessionContext != null) {
            return this.m_sessionContext.getVariable(varName);
        }
        return null;
    }

    private void deinstallComponents() throws OiifbEndIterateException {
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiAreaInventory inventory = invAreaControl.getAreaInventory();
        Vector delComps = this.getFullDeinstallList();
        OiiiDeinstallObjects odo = this.getAllCompsForDeinstall(inventory, delComps);
        this.silentDeinstall(odo.getCompsVect(), odo.getOneoffsVect(), inventory, invAreaControl);
    }

    private List getHomesToRemove() {
        if (this.m_lstHomesToRemove == null) {
            String[] saHomesToRemove;
            OiisVariable oRemoveHomesVar;
            this.m_lstHomesToRemove = new ArrayList();
            boolean clusterRmHomes = false;
            OiiiInstallInventory instInv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
            if (this.m_removeOraHome) {
                OiiiOracleHomeInfo oHomeInfo = instInv.getHomeInfo(this.m_nDeinstallOHIndex);
                Vector nodeList = oHomeInfo.getNodeList();
                if (nodeList != null && nodeList.size() > 0) {
                    clusterRmHomes = true;
                }
                OiiolTextLogger.appendText("Adding to remove homes list: " + oHomeInfo.getLocation(), OiiolTextLogger.LOG_DETAILED);
                this.m_lstHomesToRemove.add(oHomeInfo);
            }
            if ((oRemoveHomesVar = this.m_sessionContext.getVariable("REMOVE_HOMES")) != null && (saHomesToRemove = (String[])oRemoveHomesVar.getValue()) != null && saHomesToRemove.length > 0) {
                for (int i = 0; i < saHomesToRemove.length; ++i) {
                    Vector nodeList;
                    OiiiOracleHomeInfo homeInfo = instInv.getHomeWithLocation(saHomesToRemove[i]);
                    if (homeInfo == null) {
                        String sMsg = OiixResourceBundle.getString("S_HOME_LOC_NOT_FOUND", new Object[]{saHomesToRemove[i]});
                        OiiolTextLogger.writeToLogAndConsole(sMsg);
                        continue;
                    }
                    if (clusterRmHomes && saHomesToRemove.length > 1) {
                        OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22004"));
                        OiicExitCode.setExitCode(-1);
                        System.exit(-1);
                    }
                    if ((nodeList = homeInfo.getNodeList()) != null && nodeList.size() > 0) {
                        clusterRmHomes = true;
                        if (this.m_lstHomesToRemove.size() > 1) {
                            OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22004"));
                            OiicExitCode.setExitCode(-1);
                            System.exit(-1);
                        }
                    }
                    this.m_lstHomesToRemove.add(homeInfo);
                }
            }
        }
        return this.m_lstHomesToRemove;
    }

    public void silentDeinstall(Vector delComps, Vector delOneoffs, OiiiAreaInventory inventory, OiiiInstallAreaControl invAreaControl) throws OiifbEndIterateException {
        List lstHomesToRemove;
        boolean bSilentMode = OiicPullSession.isSilentMode();
        String sDet = OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS");
        String sDispMsg = OiixResourceBundle.getString("S_STARTING_DEINSTALL");
        if (bSilentMode) {
            System.out.println(sDispMsg);
        }
        this.logMessage(sDispMsg);
        if (!(delComps != null && delComps.size() != 0 || (lstHomesToRemove = this.getHomesToRemove()) != null && !lstHomesToRemove.isEmpty())) {
            sDispMsg = OiixResourceBundle.getString("S_DEINSTALL_LIST_EMPTY");
            if (bSilentMode) {
                System.out.println(sDispMsg);
                Object[] objs = new String[]{OiiolTextLogger.getErrorLogFileName()};
                sDet = MessageFormat.format(sDet, objs);
                System.out.println(sDet);
                this.logMessage(sDet);
            }
            this.logMessage(sDispMsg);
            return;
        }
        boolean bLockGrabbed = this.grabWriterLock(invAreaControl);
        if (!bLockGrabbed) {
            return;
        }
        OiicSessionPlan sessionPlan = new OiicSessionPlan();
        Vector vErrorComps = new Vector(5, 5);
        StringBuffer sMsg = new StringBuffer("");
        if (!this.prepareForDeinstall(inventory, delComps, delOneoffs, this.m_lstHomesToRemove, sessionPlan, vErrorComps, sMsg)) {
            this.logMessage(sMsg.toString());
            if (bLockGrabbed) {
                invAreaControl.releaseWriterLock();
            }
            return;
        }
        this.m_syncObj = new OiifbSyncObject();
        this.startInstall();
        if (!this.m_syncObj.signalHappenedBeforeSync()) {
            this.m_syncObj.sync();
        }
        if (bLockGrabbed) {
            invAreaControl.releaseWriterLock();
        }
        sDispMsg = OiixResourceBundle.getString("S_DEINSTALL_END");
        if (bSilentMode) {
            System.out.println(sDispMsg);
            Object[] objs = new String[]{OiiolTextLogger.getErrorLogFileName()};
            sDet = MessageFormat.format(sDet, objs);
            System.out.println(sDet);
        }
        this.logMessage(sDispMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, Vector delComps, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        Vector delOneoffs = new Vector();
        return this.prepareForDeinstall(inventory, delComps, delOneoffs, sessionPlan, vErrorComps, errMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, Vector delComps, Vector delOneoffs, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        ArrayList delHomes = new ArrayList();
        return this.prepareForDeinstall(inventory, delComps, delOneoffs, delHomes, sessionPlan, vErrorComps, errMsg);
    }

    public boolean prepareForDeinstall(OiiiAreaInventory inventory, List delComps, List delOneoffs, List delHomes, OiicSessionPlan sessionPlan, Vector vErrorComps, StringBuffer errMsg) {
        boolean bRet = true;
        sessionPlan.clearPlan();
        this.setSessionPlan(sessionPlan);
        if (vErrorComps == null) {
            vErrorComps = new Vector<String>(5, 5);
        }
        OiiiVersion higherVersion = null;
        Iterator dels = delComps.iterator();
        while (dels.hasNext()) {
            OiiiVersion installedVer;
            OiiiCompIdOhPair delID = (OiiiCompIdOhPair)dels.next();
            OiiiInstallCompInvEntry oEntry = (OiiiInstallCompInvEntry)inventory.getCompInvEntry(delID.getCompID(), delID.getOHIndex());
            if (oEntry != null && (installedVer = oEntry.getDeinstallVersion()).laterThan(OiicInstaller.getInstallerVersion())) {
                if (higherVersion == null || installedVer.laterThan(higherVersion)) {
                    higherVersion = installedVer;
                }
                vErrorComps.addElement(oEntry.getFullDisplayName());
            }
            sessionPlan.addRemoval(delID);
        }
        Iterator eOneoffs = delOneoffs.iterator();
        while (eOneoffs.hasNext()) {
            OiiiOneoffIdOhPair ooPair = (OiiiOneoffIdOhPair)eOneoffs.next();
            sessionPlan.addRemoval(ooPair.getOneoffID(), (Object)ooPair);
        }
        Iterator iterHomes = delHomes.iterator();
        while (iterHomes.hasNext()) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)iterHomes.next();
            sessionPlan.addRemoval(homeInfo);
        }
        if (vErrorComps.size() > 0) {
            String sMsg = OiixResourceBundle.getString("S_INST_INSTVER_ERR");
            Object[] objs = new String[]{higherVersion.toString()};
            sMsg = MessageFormat.format(sMsg, objs);
            errMsg.append(sMsg);
            bRet = false;
        }
        return bRet;
    }

    public boolean grabWriterLock(OiiiInstallAreaControl invAreaControl) {
        boolean bLockGrabbed = true;
        try {
            invAreaControl.grabWriterLock(false);
        }
        catch (Exception e) {
            String errString = e.getMessage();
            if (errString == null || errString.length() == 0) {
                errString = OiixResourceBundle.getString("S_INV_SETUP_ERR");
            }
            String sTitle = OiixResourceBundle.getString("S_INVENTORY_LOC");
            Object[] objs = new String[]{errString};
            String sMessage = MessageFormat.format(OiixResourceBundle.getString("S_DEINSTALL_FAILED"), objs);
            OiifmAlert.displayAlert(sTitle, sMessage, 30, 1, 1, 20);
            this.logMessage(sMessage);
            bLockGrabbed = false;
        }
        return bLockGrabbed;
    }

    void releaseReaderLock() {
        try {
            OiiiTargetAreaControl otac = this.getTargetAreaControl();
            if (otac != null) {
                otac.releaseReaderLock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getDeinstallList() {
        return this.m_vDeinstallList;
    }

    public void clearDeinstallList() {
        if (this.m_vDeinstallList != null) {
            this.m_vDeinstallList.removeAllElements();
        }
    }

    public Vector getDeinstallList(int ohIndex) {
        Integer iIndex = new Integer(ohIndex);
        Vector vComps = (Vector)this.m_hDeinstallTable.get(iIndex);
        return vComps;
    }

    private Vector getFullDeinstallList() {
        Enumeration enumHomes = this.m_hDeinstallTable.keys();
        Vector vDeinstall = new Vector();
        while (enumHomes.hasMoreElements()) {
            Integer oHomeIndex = (Integer)enumHomes.nextElement();
            Vector vComps = (Vector)this.m_hDeinstallTable.get(oHomeIndex);
            if (vComps == null) continue;
            OiixVectorOps.unionInPlace(vDeinstall, vComps);
        }
        return vDeinstall;
    }

    public boolean isCompInDeinstallList(OiiiCompIdOhPair currIdOhPair) {
        boolean bRet = false;
        if (currIdOhPair == null) {
            return bRet;
        }
        int ohIndex = currIdOhPair.getOHIndex();
        OiiiCompInstallID oci = currIdOhPair.getCompID();
        if (ohIndex != this.m_nDeinstallOHIndex && ohIndex != this.m_nDeinstallATIndex && ohIndex != 0) {
            return bRet;
        }
        if (oci.getCompType() != 1) {
            return bRet;
        }
        Vector vComps = this.getDeinstallList();
        if (vComps == null) {
            return bRet;
        }
        int iSize = vComps.size();
        if (iSize == 0) {
            return bRet;
        }
        String compName = oci.getName();
        String compVer = oci.getVersion().getVerString();
        for (int i = 0; i < iSize; ++i) {
            String[] deinsComp = (String[])vComps.elementAt(i);
            if (!compName.equals(deinsComp[0]) || !compVer.equals(deinsComp[1])) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private void createDeinstallTable(OiiiAreaInventory inventory) {
        List lstHomesToRemove;
        Integer ohIndex = new Integer(this.m_nDeinstallOHIndex);
        Integer atIndex = new Integer(this.m_nDeinstallATIndex);
        if (inventory == null) {
            return;
        }
        OiiiInstallInventory oii = (OiiiInstallInventory)inventory;
        if (this.m_vDeinstallList != null) {
            Vector vInvComps;
            Vector vComps = this.getDeinstallList();
            vComps = (Vector)vComps.clone();
            if (this.m_nDeinstallOHIndex != 0) {
                Properties dProps = null;
                OiicBaseApp oInstaller = null;
                oInstaller = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? OiicAPIInstaller.getAPIInstallerInstance() : OiicInstaller.getOiicInstallerInstance();
                dProps = oInstaller.getDefaultsOverriden();
                boolean bCanSetOHProp = false;
                if (dProps != null && dProps.getProperty("oracle.installer.compsdeinstall") != null) {
                    bCanSetOHProp = true;
                }
                OiiiOracleHomeInfo oHomeInfo = oii.getHomeInfo(this.m_nDeinstallOHIndex);
                oii.setOHProperties(oHomeInfo);
                boolean compsDeinstall = oii.allowCompsDeinstall(oHomeInfo, bCanSetOHProp);
                if (!compsDeinstall) {
                    this.m_removeOraHome = true;
                    this.addtoDeinstallTable(oHomeInfo, this.m_hDeinstallTable, inventory);
                }
            }
            if (!this.m_removeOraHome) {
                vInvComps = inventory.getAllCompsVect(this.m_nDeinstallOHIndex);
                Vector vOhComps = this.createCompOHList(inventory, vComps, vInvComps, this.m_nDeinstallOHIndex);
                this.m_hDeinstallTable.put(ohIndex, vOhComps);
            }
            if (this.m_nDeinstallATIndex != -1) {
                vInvComps = inventory.getAllCompsVect(this.m_nDeinstallATIndex);
                Vector vATComps = this.createCompOHList(inventory, vComps, vInvComps, this.m_nDeinstallATIndex);
                this.m_hDeinstallTable.put(atIndex, vATComps);
            }
            if (this.m_nDeinstallOHIndex != 0) {
                vInvComps = inventory.getAllCompsVect(0);
                Vector vIndComps = this.createCompOHList(inventory, vComps, vInvComps, 0);
                this.m_hDeinstallTable.put(new Integer(0), vIndComps);
            }
        }
        if (!(lstHomesToRemove = this.getHomesToRemove()).isEmpty()) {
            Iterator iter = lstHomesToRemove.iterator();
            while (iter.hasNext()) {
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)iter.next();
                this.addtoDeinstallTable(homeInfo, this.m_hDeinstallTable, inventory);
                oii.setOHProperties(homeInfo);
            }
        }
        this.checkForMultipleClusterHomes(this.m_hDeinstallTable);
        this.customDeinstallCheck(lstHomesToRemove);
        if (this.m_bCustomDeinstall) {
            if (this.m_customDeinstallHomes > 1) {
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22026");
                OiifmAlert.displayError(msg);
                OiicExitCode.setExitCode(-1);
                System.exit(-1);
            } else if (this.m_customDeinstallHomes == 1) {
                Object[] args = new String[]{this.m_customDeinstallCommand};
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22025", args);
                OiifmAlert.displayError(msg);
                OiicExitCode.setExitCode(-1);
                System.exit(-1);
            }
        }
    }

    private void addtoDeinstallTable(OiiiOracleHomeInfo homeInfo, Hashtable ht, OiiiAreaInventory inventory) {
        int nhomeIndex = homeInfo.getIndex();
        Vector lstTLComps = inventory.getTopLevelComps(nhomeIndex);
        if (lstTLComps != null && !lstTLComps.isEmpty()) {
            Vector<OiiiCompIdOhPair> lstIdOh = new Vector<OiiiCompIdOhPair>(lstTLComps.size());
            Iterator iterTL = lstTLComps.iterator();
            while (iterTL.hasNext()) {
                OiiiCompInstallID cid = (OiiiCompInstallID)iterTL.next();
                if (cid instanceof OiiiPatchSetInstallID) continue;
                OiiiCompIdOhPair idOhPair = new OiiiCompIdOhPair(cid, nhomeIndex);
                lstIdOh.add(idOhPair);
            }
            this.m_hDeinstallTable.put(new Integer(nhomeIndex), lstIdOh);
        }
    }

    private void checkForMultipleClusterHomes(Hashtable ht) {
        boolean clusterRmHomes = false;
        int clusterRmHomeIndex = -10;
        ArrayList<Integer> ohList = new ArrayList<Integer>();
        Enumeration en = ht.keys();
        OiiiInstallAreaControl oiac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inv = oiac.getInstallInventory();
        while (en.hasMoreElements()) {
            Integer indexInt;
            OiiiOracleHomeInfo ohInfo;
            Object nextElement = en.nextElement();
            int index = (Integer)nextElement;
            List nextObject = (List)ht.get(nextElement);
            if (nextObject.size() == 0 || (ohInfo = inv.getHomeInfo(index)) == null) continue;
            if (clusterRmHomes) {
                if (clusterRmHomeIndex != index) {
                    OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22004"));
                    OiicExitCode.setExitCode(-1);
                    System.exit(-1);
                }
            } else {
                Vector nodeList = ohInfo.getNodeList();
                if (nodeList != null && nodeList.size() > 0) {
                    if (ohList.size() > 0) {
                        OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22004"));
                        OiicExitCode.setExitCode(-1);
                        System.exit(-1);
                    } else {
                        clusterRmHomes = true;
                        clusterRmHomeIndex = index;
                    }
                }
            }
            if (ohList.contains(indexInt = new Integer(index))) continue;
            ohList.add(indexInt);
        }
    }

    private Vector createCompOHList(OiiiAreaInventory inventory, Vector vComps, Vector vInvComps, int ohIndex) {
        Vector retCompsList = new Vector();
        if (vInvComps == null) {
            this.logMessage(OiixResourceBundle.getString("S_NO_INST_PRODS_PROMPT"));
            return retCompsList;
        }
        if (vComps == null || vComps.size() == 0) {
            return retCompsList;
        }
        Vector<OiiiCompInstallID> compIdsVect = new Vector<OiiiCompInstallID>();
        int iInvCompsSize = vInvComps.size();
        block0: for (int i = 0; i < iInvCompsSize; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)vInvComps.elementAt(i);
            String[] sInvCompEntry = new String[]{cie.getCompInstallID().getName(), cie.getVersion().getVerString()};
            int iSize = vComps.size();
            for (int k = 0; k < iSize; ++k) {
                String[] compEntry = (String[])vComps.elementAt(k);
                if (!compEntry[0].equals(sInvCompEntry[0]) || !compEntry[1].equals(sInvCompEntry[1])) continue;
                compIdsVect.addElement(cie.getCompInstallID());
                vComps.removeElementAt(k);
                continue block0;
            }
        }
        Vector compOhVect = OiiiCompIdOhPair.createCompIdOhVector(compIdsVect, ohIndex);
        return compOhVect;
    }

    private OiiiDeinstallObjects getAllCompsForDeinstall(OiiiAreaInventory inventory, Vector compOhVect) {
        Vector retCompsList = new Vector();
        Vector retOneoffsList = new Vector();
        Hashtable hOneoffs = new Hashtable();
        boolean debug = Boolean.getBoolean("oracle.installer.debug");
        if (compOhVect != null) {
            int compOhSize = compOhVect.size();
            for (int j = 0; j < compOhVect.size(); ++j) {
                OiiiCompIdOhPair currIdOhPair = (OiiiCompIdOhPair)compOhVect.elementAt(j);
                if (debug) {
                    OiiolTextLogger.appendText(" Calling getRefsToDeinstall for " + currIdOhPair);
                }
                Vector refComps = OiiodDepEngineHelper.getRefsToDeinstall(inventory, currIdOhPair, compOhVect, retOneoffsList);
                int refCompsSize = refComps.size();
                for (int n = 0; n < refCompsSize; ++n) {
                    if (compOhVect.contains(refComps.elementAt(n))) continue;
                    if (debug) {
                        OiiolTextLogger.appendText("Adding to  Deinstall referencers List " + refComps.elementAt(n));
                    }
                    compOhVect.addElement(refComps.elementAt(n));
                }
            }
            if (debug) {
                OiiolTextLogger.appendText(" Calling getDependeesToDeinstall");
            }
            retCompsList = OiiodDepEngineHelper.getDependeesToDeinstall(inventory, compOhVect, retOneoffsList, hOneoffs);
        }
        return new OiiiDeinstallObjects(retCompsList, retOneoffsList);
    }

    protected void computeDeinstallList() throws OiifbEndIterateException {
        this.m_hDeinstallTable = new Hashtable();
        this.m_vDeinstallList = new Vector(1, 1);
        OiisVariable ovOHName = this.m_sessionContext.getVariable("ORACLE_HOME_NAME");
        OiisVariable ovOH = this.m_sessionContext.getVariable("ORACLE_HOME");
        String sOHName = (String)ovOHName.getValue();
        String sOHLoc = (String)ovOH.getValue();
        OiisVariable ovATName = this.m_sessionContext.getVariable("APPLTOP_NAME");
        OiisVariable ovAT = this.m_sessionContext.getVariable("APPLTOP");
        String sATName = (String)ovATName.getValue();
        String sATLoc = (String)ovAT.getValue();
        OiiiInstallAreaControl oiac = OiiiInstallAreaControl.getInstallAreaControl();
        if (oiac == null) {
            return;
        }
        OiiiInstallInventory oii = oiac.getInstallInventory();
        Vector vHomes = oii.getHomes();
        if (vHomes == null) {
            throw new OiifbEndIterateException(OiixResourceBundle.getString("S_LOG_INV_READ_HOMELIST_ERROR"));
        }
        int iSize = vHomes.size();
        if (iSize == 0) {
            return;
        }
        if (sOHName != null || sOHLoc != null) {
            this.m_nDeinstallOHIndex = this.getHomeIndex(vHomes, sOHName, sOHLoc, 0);
            if (this.m_nDeinstallOHIndex == -1) {
                this.m_nDeinstallOHIndex = 0;
            }
        }
        if (sATName != null || sATLoc != null) {
            this.m_nDeinstallATIndex = this.getHomeIndex(vHomes, sATName, sATLoc, 1);
        }
        OiisVariable retVar = null;
        try {
            int adv;
            String[] compList;
            int listLen;
            Object oVal;
            if (this.m_sessionContext != null && (retVar = this.m_sessionContext.getVariable("DEINSTALL_LIST")) != null && retVar.getType() == OiisVariable.STRINGLIST && (oVal = retVar.getValue()) != null && oVal instanceof String[] && (listLen = (compList = (String[])oVal).length) >= (adv = 2) && listLen % 2 == 0) {
                for (int i = 0; i < listLen; i += adv) {
                    String compName = compList[i];
                    String compVer = compList[i + 1];
                    this.m_vDeinstallList.addElement(new String[]{compName, compVer});
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        OiiiAreaInventory oai = oiac.getAreaInventory();
        this.createDeinstallTable(oai);
    }

    private int getHomeIndex(Vector vHomes, String sHomeName, String sHomeLoc, int nHomeType) {
        int iRet = -1;
        if (vHomes == null) {
            return iRet;
        }
        int iSize = vHomes.size();
        for (int j = 0; j < iSize; ++j) {
            OiiiOracleHomeInfo oohi = (OiiiOracleHomeInfo)vHomes.elementAt(j);
            String sLoc = oohi.getLocation();
            String sName = oohi.getName();
            int curHomeType = oohi.getHomeType();
            if (curHomeType != nHomeType || (sHomeName == null || !sHomeName.equalsIgnoreCase(sName)) && (sHomeLoc == null || !sHomeLoc.equalsIgnoreCase(sLoc))) continue;
            iRet = oohi.getIndex();
            break;
        }
        return iRet;
    }

    public void setupDuplicateStreams() throws OiifbEndIterateException {
        OiicPullSession.createDuplicateStreams(this.m_sInvLoc);
    }

    public void setTotalBytes(long bytes) {
    }

    public void setStatus(String status) {
    }

    public void addBytes(int bytes) {
    }

    public void removeBytes(int bytes) {
    }

    public void onDoneProgress() {
    }

    public void onCurrentComponent(String Comp) {
    }

    public void onStartDeinstall() {
    }

    public void onStartInstall() {
    }

    public void onStartLink() {
    }

    public void onStartInstallPhase2() {
    }

    public void onStartClusterOps() {
    }

    public void onDoneDeinstall() {
    }

    public void onDoneInstall() {
    }

    public void onDoneLink() {
    }

    public void onDoneInstallPhase2() {
    }

    public void onDoneClusterOps() {
    }

    public void onSuspend() {
    }

    public void onResume() {
    }

    public void addPercentage(int percent) {
    }

    public boolean isNewProgressUsed() {
        return true;
    }

    private void logMessage(String msg) {
        if (OiicPullSession.isSilentMode()) {
            OiiolTextLogger.appendErrorText(msg);
        } else {
            OiiolTextLogger.appendText(msg);
        }
    }

    public void setTitle(String title) {
    }

    public String setLocalNode(OiiiOracleHomeInfo homeInfo) throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext oContext = this.getSessionContext();
        return oContext.setLocalNodeName(homeInfo);
    }

    public String[] setRemoteNodes() throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext oContext = this.getSessionContext();
        return oContext.setRemoteNodeList();
    }

    public List getHomesToDelete() {
        return this.m_homesToDelete;
    }

    public void setHomesToDelete(List homelocs) {
        this.m_homesToDelete = homelocs;
    }

    public void onStartPhase(int phase) {
    }

    public void onDonePhase(int phase) {
    }

    private void customDeinstallCheck(List lstHomesToRemove) {
        this.m_bCustomDeinstall = false;
        this.m_customDeinstallHomes = 0;
        boolean forceDeinstall = Boolean.getBoolean("oracle.installer.forceDeinstall");
        if (forceDeinstall) {
            return;
        }
        if (!lstHomesToRemove.isEmpty()) {
            Iterator iter = lstHomesToRemove.iterator();
            while (iter.hasNext()) {
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)iter.next();
                Properties homeProps = homeInfo.getHomeProperties();
                if (homeProps == null) continue;
                ++this.m_customDeinstallHomes;
                String customDeinstall = homeProps.getProperty("oracle.install.customizedeinstall");
                if (customDeinstall == null || !customDeinstall.equalsIgnoreCase("true")) continue;
                this.m_bCustomDeinstall = true;
                this.m_customDeinstallCommand = homeProps.getProperty("oracle.install.customdeinstallcommand");
                HashMap<String, String> oSearchReplaceMap = new HashMap<String, String>();
                String delimiter = "%";
                String key = delimiter + "ORACLE_HOME" + delimiter;
                String value = homeInfo.getLocation();
                oSearchReplaceMap.put(key, value);
                this.m_customDeinstallCommand = OiixInstantiateOps.processString(this.m_customDeinstallCommand, oSearchReplaceMap, delimiter);
                if (this.m_customDeinstallHomes <= 1) continue;
                break;
            }
        }
    }

    private class OiicActionsThread
    extends Thread {
        OiicInstallTimeSession m_session;
        OiicSessionInterfaceManager interfaceManager;

        public OiicActionsThread(OiicDeinstallSession session) {
            super("deinstallThread");
            this.interfaceManager = null;
            this.m_session = session;
        }

        public void run() {
            block5: {
                try {
                    OiicDeinstallSession.this.m_actionsPhase = new OiifwActionsPhaseWCDE(this.m_session);
                    if (OiicDeinstallSession.this.m_remDlg != null) {
                        OiicDeinstallSession.this.m_remDlg.addProgressUIListener(new OiifmProgressCancelHandler(OiicDeinstallSession.this.m_actionsPhase));
                    }
                    OiicInstallTimeSession oSession = null;
                    if (null == this.interfaceManager) {
                        this.interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                        oSession = this.interfaceManager.getSession();
                        this.interfaceManager.setSession(this.m_session);
                    }
                    OiicDeinstallSession.this.m_actionsPhase.initialize();
                    OiicDeinstallSession.this.m_actionsPhase.doOperation(false);
                    this.interfaceManager.setSession(oSession);
                    OiicDeinstallSession.this.logMessage(OiixResourceBundle.getString("S_DEINSTALL_SUCCESS"));
                    if (OiicDeinstallSession.this.m_syncObj != null) {
                        OiicDeinstallSession.this.m_syncObj.signal();
                    }
                }
                catch (OiifbEndIterateException ex) {
                    ex.printStackTrace();
                    if (OiicDeinstallSession.this.m_syncObj == null) break block5;
                    OiicDeinstallSession.this.m_syncObj.signal();
                }
            }
        }
    }
}

