/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicDetachHome
extends OiicBaseInventoryApp {
    private static final String appName = "detachhome";
    private static OiicDetachHome s_oDetachHome = null;
    private String sOBase = null;
    private String sOHomeLoc = null;
    private final String sComponent = "oui";
    private String sOHomeName;
    private String sFileName;
    private String chkpointFile;
    private static OicsICheckPointIndexSession cpis = null;
    private OicsICheckPointSession cps = null;

    private OiicDetachHome() {
        super(appName);
    }

    private OiicDetachHome(String app) {
        super(app);
    }

    public static OiicDetachHome getOiicDetachHomeInstance() {
        if (s_oDetachHome == null) {
            s_oDetachHome = new OiicDetachHome();
        }
        return s_oDetachHome;
    }

    protected String getLogPrefix() {
        return "DetachHome";
    }

    protected void setHomeLocalNode(OiiiOracleHomeInfo homeInfo, String localNode) {
    }

    protected String[] setClusterNodes(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext) throws OiisVarSettingException, OiifbCancelException {
        String[] clusterNodes = OiixVectorOps.list2StrArr(homeInfo.getNodeList());
        oContext.setVarValue("CLUSTER_NODES", clusterNodes);
        return clusterNodes;
    }

    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiifbCancelException, OiiiInventoryUpdateException, IOException, OiixException, OiiiMissingDependeeException, OiisVarSettingException, OiipgClusterException {
        Vector list;
        OiiiOracleHomeInfo homeInfo = this.getOracleHomeInfo(iac, oContext);
        if (homeInfo == null) {
            return;
        }
        ArrayList depHomes = null;
        boolean allDepHomes = Boolean.getBoolean("oracle.installer.allDepHomes");
        boolean depHomesOnly = Boolean.getBoolean("oracle.installer.depHomesOnly");
        if ((allDepHomes || depHomesOnly) && (list = homeInfo.getRefHomeList()) != null) {
            depHomes = new ArrayList(list.size());
            depHomes.addAll(list);
        }
        if (!depHomesOnly) {
            this.detachHome(iac, oContext, homeInfo);
        }
        if ((allDepHomes || depHomesOnly) && depHomes != null) {
            for (int i = 0; i < depHomes.size(); ++i) {
                oContext.setVarValue("ORACLE_HOME", depHomes.get(i));
                homeInfo = this.getOracleHomeInfo(iac, oContext);
                this.detachHome(iac, oContext, homeInfo);
            }
        }
    }

    private void detachHome(OiiiInstallAreaControl iac, OiicSessionContext oContext, OiiiOracleHomeInfo homeInfo) throws OiixException, IOException, OiiiMissingDependeeException, OiisVarSettingException, OiifbCancelException, OiipgClusterException {
        String checkpointLoc;
        String invLoc = (String)oContext.getVarValue("INVENTORY_LOCATION");
        OicsICheckPointProperty cpp = null;
        OicsICheckPoint cp2 = null;
        String chkPointName2 = null;
        String string = checkpointLoc = this.computeCheckPointLoc(oContext) == null ? null : this.computeCheckPointLoc(oContext);
        if (checkpointLoc != null) {
            this.initializeCheckPointIndexSession(checkpointLoc, "oui");
        }
        this.initializeCheckPointSession(oContext);
        OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session for detachHome.");
        if (cpis != null) {
            cpp = this.sOBase != null ? OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)this.sOBase) : OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)"");
            chkPointName2 = "oracle.installer.detachHome";
            this.cps = cpis.initCheckPointSession(this.sFileName);
            if (this.cps != null && (cp2 = this.cps.getCheckPoint(chkPointName2)) == null) {
                cp2 = OicsCheckPointFactory.constructCheckPoint((int)1, (String)chkPointName2, (String)"This is the detachHome inventory operation");
                cp2.setCheckPointState(2);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME_NAME", (String)this.sOHomeName);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME", (String)this.sOHomeLoc);
                cp2.addCheckPointProperty(cpp);
                if (this.cps != null && cp2 != null) {
                    this.cps.addCheckPoint(cp2);
                }
            }
        }
        OiiiInstallInventory instinv = iac.getInstallInventory();
        boolean bSharedHome = false;
        if (!this.m_bIsCompositeHomeOnly) {
            instinv.setAllCompsVect(homeInfo.getIndex(), null);
            bSharedHome = this.isSharedHome(homeInfo.getLocation(), this.m_sLocalNode);
            this.updateOHProperties(homeInfo, oContext, bSharedHome);
        }
        try {
            if (!this.m_bIsCompositeHomeOnly) {
                instinv.detachHome(homeInfo);
            } else {
                instinv.detachCompositeHome(homeInfo);
            }
        }
        catch (IOException e) {
            OiicExitCode.setExitCode(-1);
            OiiolTextLogger.appendText(e.getMessage());
            return;
        }
        iac.saveInstallInventory(null);
        if (this.m_saRemoteNodes != null && this.m_saRemoteNodes.length > 0) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            if (sCustomInvPtrLoc != null && sCustomInvPtrLoc.trim().length() > 0) {
                this.setupRemoteInvPtrLoc(this.m_saRemoteNodes, sCustomInvPtrLoc);
            }
            this.clsCmdDetachHome(this.m_saRemoteNodes, this.m_sOracleHome, this.m_sOracleHomeName, this.m_sLocalNode, invLoc, sCustomInvPtrLoc, bSharedHome);
        }
        if (cp2 != null && this.cps != null) {
            cpp = OicsCheckPointFactory.constructStringProperty((String)"LOCALNODE", (String)this.m_sLocalNode);
            cp2.addCheckPointProperty(cpp);
            cp2.setCheckPointState(3);
            this.cps.addCheckPoint(cp2);
            this.cps.saveCheckPointSession();
            try {
                this.cps.closeCheckPointSession();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
    }

    protected OiiiOracleHomeInfo getOracleHomeInfo(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiixException, IOException, OiiiMissingDependeeException {
        OiiiInstallInventory instinv = iac.getInstallInventory();
        this.m_sOracleHome = (String)oContext.getVarValue("ORACLE_HOME");
        this.m_sCompositeHome = (String)oContext.getVarValue("COMPOSITE_HOME");
        OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(this.m_sOracleHome);
        OiiiOracleHomeInfo compositeHomeInfo = instinv.getCompositeHomeWithLocation(this.m_sCompositeHome);
        instinv.getHomeWithLocation(this.m_sOracleHome);
        if (homeInfo == null && !this.m_bIsCompositeHomeOnly) {
            Object[] args = new String[]{this.m_sOracleHome};
            throw new OiixException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25016", args));
        }
        if (compositeHomeInfo == null && this.m_bIsCompositeHomeOnly) {
            Object[] args = new String[]{this.m_sCompositeHome};
            throw new OiixException(OiixResourceBundle.getString("S_ERROR_INCORRECT_COMPOSITE_HOME", args));
        }
        if (!this.m_bIsCompositeHomeOnly) {
            this.m_sOracleHomeName = homeInfo.getName();
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            if (homeInfo != null) {
                OiiolTextLogger.appendText("getOracleHomeInfo::Oracle home information is:" + homeInfo.toString(), OiiolTextLogger.LOG_DETAILED);
            } else {
                OiiolTextLogger.appendText("getCompositeHomeInfo::Composite home information is:" + compositeHomeInfo.toString(), OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (this.m_bIsCompositeHomeOnly) {
            return compositeHomeInfo;
        }
        return homeInfo;
    }

    public void clsCmdDetachHome(String[] nodesToRunOn, String oracleHome, String oracleHomeName, String currentNode, String invLoc, String invPtrLoc, boolean bSharedHome) {
        this.m_clsRunCmd = new OiipgClusterRunCmd(nodesToRunOn);
        String cmd = "-detachHome -noClusterEnabled ORACLE_HOME=" + oracleHome;
        this.runRemoteInvOpCmd(cmd, nodesToRunOn, oracleHome, oracleHomeName, currentNode, invLoc, invPtrLoc, bSharedHome);
    }

    public static void main(String[] args) {
        OiicDetachHome oDetachHome = OiicDetachHome.getOiicDetachHomeInstance();
        oDetachHome.main_helper(args);
    }

    public boolean requireGUIDRecalculation(String oldGUIDVal) {
        return false;
    }

    private void initializeCheckPointSession(OiicSessionContext s_context) {
        if (s_context != null) {
            String checkpointLoc;
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicdetachHome.");
            if (s_context.getVarValue("ORACLE_BASE") != null) {
                this.sOBase = (String)s_context.getVarValue("ORACLE_BASE");
            }
            if (s_context.getVarValue("ORACLE_HOME") != null) {
                this.sOHomeLoc = (String)s_context.getVarValue("ORACLE_HOME");
            }
            if (s_context.getVarValue("ORACLE_HOME_NAME") != null) {
                this.sOHomeName = (String)s_context.getVarValue("ORACLE_HOME_NAME");
            }
            String string = checkpointLoc = this.computeCheckPointLoc(s_context) == null ? null : this.computeCheckPointLoc(s_context);
            if (checkpointLoc != null) {
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(checkpointLoc, "checkpoints"));
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, "oui"));
                this.chkpointFile = "checkpoint_" + this.sOHomeName + ".xml";
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, this.chkpointFile));
                if (cpis != null) {
                    OiicExitOps.getExitOps().addIndexSessionObj(cpis);
                }
            }
        }
    }

    private String computeCheckPointLoc(OiicSessionContext s_context) {
        String oracleBase = null;
        String oracleHome = null;
        if (s_context.getVarValue("ORACLE_BASE") != null) {
            oracleBase = (String)s_context.getVarValue("ORACLE_BASE");
        }
        if (s_context.getVarValue("ORACLE_HOME") != null) {
            oracleHome = (String)s_context.getVarValue("ORACLE_HOME");
        }
        if (oracleBase != null) {
            return oracleBase;
        }
        if (oracleHome != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }

    private void initializeCheckPointIndexSession(String checkPointLoc, String moduleName) {
        if (checkPointLoc != null && moduleName != null) {
            cpis = OicsCheckPointFactory.getIndexSession((String)checkPointLoc, (String)moduleName);
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicdetachhome.");
            OiiolTextLogger.appendText("Checkpoint:Location is- " + checkPointLoc);
        }
    }
}

