/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

public final class OiicExitCode {
    public static final int S_EXIT_SUCCESS = 0;
    public static final int S_EXIT_SUCCESS_MINUS_OPTTOOLS = 1;
    public static final int S_EXIT_LOCAL_SUCCESS_REMOTE_FAILURE = 2;
    public static final int S_EXIT_SUCCESS_MINUS_RECTOOLS = 3;
    public static final int S_EXIT_USER_CANCEL_INSTALL = 4;
    public static final int S_EXIT_FAILURE = -1;
    public static final int S_EXIT_VAR_VALIDATION_FAILURE = -2;
    public static final int S_EXIT_PREREQ_FAILURE = -3;
    public static final int S_SUCCESS_WITH_WARNINGS = 6;
    public static final int S_EXIT_STOP_INSTALL = -4;
    public static final int S_EXIT_BACK_BTN = -5;
    private static int[] m_exitCodes = new int[]{0, 1, 3, -1, -2, -3, -4, 2, -5, 6};
    private static int m_exitCode = -1;
    private static boolean m_bExitCodeDefaulted = true;

    public static int getExitCode() {
        return m_exitCode;
    }

    public static boolean isDefaultExitCode() {
        return m_bExitCodeDefaulted;
    }

    public static void setExitCode(int exitCode) {
        if (Boolean.getBoolean("oracle.installer.ignoreExitCode")) {
            return;
        }
        if (m_exitCode == -1 && !m_bExitCodeDefaulted) {
            return;
        }
        if (!OiicExitCode.isValid(exitCode)) {
            throw new IllegalArgumentException("Illegal exit code: " + exitCode);
        }
        m_exitCode = exitCode;
        m_bExitCodeDefaulted = false;
    }

    private static boolean isValid(int exitCode) {
        for (int i = 0; i < m_exitCodes.length; ++i) {
            if (exitCode != m_exitCodes[i]) continue;
            return true;
        }
        return false;
    }

    public static void setExitCodeToSuccess() {
        m_exitCode = 0;
    }
}

