/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class OiicExitOps {
    private Vector m_vCommands = new Vector();
    private Vector m_vDelDirs = new Vector();
    private static OiicExitOps _exitOpsObj;
    private OicsICheckPointIndexSession indexSession = null;

    private OiicExitOps() {
    }

    public static OiicExitOps getExitOps() {
        if (_exitOpsObj == null) {
            _exitOpsObj = new OiicExitOps();
        }
        return _exitOpsObj;
    }

    public void exit() {
        System.exit(this.doExitOperations());
    }

    public int doExitOperations() {
        OiiolTextLogger.closeLog();
        try {
            OiixTeePrintStream.restoreSystemOut();
            OiixTeePrintStream.restoreSystemErr();
        }
        catch (IOException e) {
            // empty catch block
        }
        OiiolTextLogger.copyLogs();
        try {
            this.runExitCommands();
            this.delDirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.indexSession != null) {
            try {
                this.indexSession.closeCheckPointIndexSession();
                OiiolTextLogger.appendText("Checkpoint:Index session closed from OiicExitOps. .");
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
        return OiicExitCode.getExitCode();
    }

    public void addExitCommand(String sCmd) {
        this.m_vCommands.addElement(sCmd);
    }

    public void addDelDir(String sDelDir) {
        this.m_vDelDirs.addElement(sDelDir);
    }

    private void runExitCommands() {
        int nSize = this.m_vCommands.size();
        if (nSize > 0) {
            OiixSpawner spawner = new OiixSpawner();
            for (int i = 0; i < nSize; ++i) {
                try {
                    spawner.asyncExec((String)this.m_vCommands.elementAt(i));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void delDirs() {
        int nSize = this.m_vDelDirs.size();
        for (int i = 0; i < nSize; ++i) {
            File fDelDir = new File((String)this.m_vDelDirs.elementAt(i));
            OiixFileOps.cleanupdelete(fDelDir);
        }
    }

    public void addIndexSessionObj(OicsICheckPointIndexSession oicsIndexSession) {
        if (oicsIndexSession != null) {
            OiiolTextLogger.appendText("Checkpoint:Index session object added to oiicexitops.");
            this.indexSession = oicsIndexSession;
        }
    }
}

