/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicGlobalContextReaderWriter;
import oracle.sysman.oii.oiic.OiicGlobalVarsReader;
import oracle.sysman.oii.oiic.OiicLWSessionContext;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionVarsReader;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisLWVariableOwner;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiicGlobalContextXMLReaderWriter
extends OiicGlobalContextReaderWriter {
    private static final String s_sExt = ".xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readGlobalContextFile(OiicGlobalContext oGlobalContext, String sGlobalContextXMLFilePath) {
        FileInputStream fInputStream;
        Document oDoc;
        block24: {
            if (oGlobalContext == null) {
                return;
            }
            if (sGlobalContextXMLFilePath == null) return;
            if (sGlobalContextXMLFilePath.length() <= 0) {
                return;
            }
            File fGlobalContext = new File(sGlobalContextXMLFilePath);
            if (!fGlobalContext.exists()) return;
            if (!fGlobalContext.isFile()) return;
            oDoc = null;
            String sMsg = null;
            fInputStream = null;
            try {
                Object var9_7;
                try {
                    fInputStream = new FileInputStream(fGlobalContext);
                    oDoc = OixdDOMReader.getDocument(fInputStream);
                }
                catch (ParserConfigurationException e0) {
                    sMsg = e0.getMessage();
                    var9_7 = null;
                    if (sMsg != null) {
                        OiiolTextLogger.writeMessageToConsole(sMsg);
                        OiiolTextLogger.appendText(sMsg);
                    }
                    break block24;
                }
                catch (SAXException e1) {
                    sMsg = e1.getMessage();
                    var9_7 = null;
                    if (sMsg != null) {
                        OiiolTextLogger.writeMessageToConsole(sMsg);
                        OiiolTextLogger.appendText(sMsg);
                    }
                    break block24;
                }
                catch (FileNotFoundException e2) {
                    sMsg = e2.getMessage();
                    var9_7 = null;
                    if (sMsg != null) {
                        OiiolTextLogger.writeMessageToConsole(sMsg);
                        OiiolTextLogger.appendText(sMsg);
                    }
                    break block24;
                }
                catch (IOException e3) {
                    sMsg = e3.getMessage();
                    var9_7 = null;
                    if (sMsg != null) {
                        OiiolTextLogger.writeMessageToConsole(sMsg);
                        OiiolTextLogger.appendText(sMsg);
                    }
                    break block24;
                }
                var9_7 = null;
                if (sMsg == null) break block24;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (sMsg == null) throw throwable;
                OiiolTextLogger.writeMessageToConsole(sMsg);
                OiiolTextLogger.appendText(sMsg);
                throw throwable;
            }
            OiiolTextLogger.writeMessageToConsole(sMsg);
            OiiolTextLogger.appendText(sMsg);
        }
        XMLElement oGlobalContextRoot = (XMLElement)oDoc.getDocumentElement();
        NodeList oSessionContextNodes = oGlobalContextRoot.getElementsByTagName("SESSIONVARS");
        int iSize = oSessionContextNodes != null ? oSessionContextNodes.getLength() : 0;
        HashMap varsOfUnknownType = new HashMap();
        for (int i = 0; i < iSize; ++i) {
            NodeList oEnvNodeList;
            int iEnvVarListSize;
            XMLElement oSessionVar = (XMLElement)oSessionContextNodes.item(i);
            OiicSessionVarsReader oSessionVarsReader = new OiicSessionVarsReader(oSessionVar);
            OiicLWSessionContext oSessionContext = new OiicLWSessionContext();
            List oLinkedList = oSessionVarsReader.getAllSessionVariables(null, false, varsOfUnknownType);
            int iListSize = oLinkedList != null ? oLinkedList.size() : 0;
            for (int j = 0; j < iListSize; ++j) {
                OiisVariable oVar = (OiisVariable)oLinkedList.get(j);
                if (oVar == null) continue;
                oSessionContext.addVariable(oVar);
            }
            String sTLComp = (String)varsOfUnknownType.get("ToplevelComp");
            if (sTLComp != null) {
                try {
                    String[] params = OiisDataTypes.getStringListObject(sTLComp);
                    if (params.length == 4) {
                        StringTokenizer st = new StringTokenizer(params[3], "[,]");
                        int nPlatform = Integer.parseInt(st.nextToken().trim());
                        Vector<Integer> vPlatforms = new Vector<Integer>(1);
                        vPlatforms.addElement(new Integer(nPlatform));
                        params[3] = st.nextToken();
                        st = new StringTokenizer(params[3], ":");
                        params[3] = st.nextToken();
                        int ohType = Integer.parseInt(st.nextToken());
                        OiiiCompInstallID cid = new OiiiCompInstallID(params[0], new OiiiVersion(params[1]), vPlatforms, new OiiiVersion(params[2].substring(1)), 1, ohType, 0);
                        OiisVariable oTLCompVar = oSessionContext.getVariable("ToplevelComp");
                        oTLCompVar.setValueWithoutValidation(cid);
                    }
                }
                catch (Exception err) {
                    OiiolTextLogger.appendText(err.toString(), OiiolTextLogger.LOG_DETAILED);
                }
            }
            int n = iEnvVarListSize = (oEnvNodeList = oSessionVar.getElementsByTagName("ENVVARS")) != null ? oEnvNodeList.getLength() : 0;
            if (iEnvVarListSize > 0) {
                for (int k = 0; k < iEnvVarListSize; ++k) {
                    int iEnvVarSize;
                    XMLElement oEnvVarRoot = (XMLElement)oEnvNodeList.item(k);
                    NodeList oEnvVarList = oEnvVarRoot.getElementsByTagName("VAR");
                    int n2 = iEnvVarSize = oEnvVarList != null ? oEnvVarList.getLength() : 0;
                    if (iEnvVarSize <= 0) continue;
                    for (int j = 0; j < iEnvVarSize; ++j) {
                        XMLElement oEnvVar = (XMLElement)oEnvVarList.item(j);
                        oSessionContext.setEnvironmentVariablesSet(oEnvVar.getAttribute("NAME"), oEnvVar.getAttribute("VALUE"));
                    }
                }
            }
            String sOHName = oSessionVar.getAttribute("ORACLE_HOME_NAME");
            String sTLCompName = oSessionVar.getAttribute("TOPLEVEL_COMPONENT");
            oGlobalContext.addLWVariableOwner(sOHName, sTLCompName, oSessionContext);
            this.loadGlobalVars(oSessionContext);
        }
        try {
            fInputStream.close();
            return;
        }
        catch (IOException e3) {
            // empty catch block
        }
    }

    private void loadGlobalVars(OiisLWVariableOwner oOwner) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        String sOHName = (String)oOwner.getVariable("ORACLE_HOME_NAME").getValue();
        OiiiCompInstallID cid = (OiiiCompInstallID)oOwner.getVariable("ToplevelComp").getValue();
        String sTopLvlName = cid.getName();
        if (null == instInv) {
            return;
        }
        String sInvLoc = OiixPathOps.concatPath(instInv.getHomeWithName(sOHName).getLocation(), "inventory");
        String sGlobalVarsDirInv = OiixPathOps.concatPath(sInvLoc, "globalvariables");
        String sCompGlobalVarsDir = OiixPathOps.concatPath(sGlobalVarsDirInv, sTopLvlName);
        String sGlobalVarsFileInv = OiixPathOps.concatPath(sCompGlobalVarsDir, "globalvariables.xml");
        OiicGlobalVarsReader oReader = null;
        try {
            oReader = new OiicGlobalVarsReader(null);
        }
        catch (OiixException e) {
            // empty catch block
        }
        List vars = OiicGlobalVarsReader.readVarValuesFromInventory(sGlobalVarsFileInv, null);
        for (int i = 0; i < vars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)vars.get(i);
            oOwner.addVariable(oVar);
        }
    }

    public void writeGlobalContextFile(OiicGlobalContext oGlobalContext, String sPathToFirstOH) {
        if (oGlobalContext == null) {
            return;
        }
        if (sPathToFirstOH != null && sPathToFirstOH.length() <= 0) {
            return;
        }
        Iterator iterKeys = oGlobalContext.getKeys();
        String sGlobalContextXMLFilePath = this.getGlobalContextXMLFilePath(sPathToFirstOH) + s_sExt;
        File fGlobalContext = new File(sGlobalContextXMLFilePath);
        if (fGlobalContext.exists()) {
            fGlobalContext.delete();
        }
        try {
            File fParent = fGlobalContext.getParentFile();
            if (!fParent.exists()) {
                fParent.mkdirs();
            }
            fGlobalContext.createNewFile();
            FileWriter fWriter = new FileWriter(fGlobalContext, true);
            BufferedWriter bWriter = new BufferedWriter(fWriter);
            PrintWriter pWriter = new PrintWriter((Writer)bWriter, true);
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            XMLElement oGlobalContextRoot = new XMLElement("GLOBALCONTEXT");
            pWriter.println(OixsXMLOps.getStartTag(oGlobalContextRoot));
            int i = 0;
            while (iterKeys.hasNext()) {
                String sKey = (String)iterKeys.next();
                OiisLWVariableOwner oVarOwner = oGlobalContext.getLWVariableOwner(sKey);
                if (oVarOwner != null) {
                    Vector<String[]> attributes = new Vector<String[]>();
                    String[] ohname = new String[]{"ORACLE_HOME_NAME", oGlobalContext.getOracleHome(i)};
                    String[] tlcomp = new String[]{"TOPLEVEL_COMPONENT", oGlobalContext.getToplevelCompName(i)};
                    attributes.add(ohname);
                    attributes.add(tlcomp);
                    OiicSessionContext.writeToXML(pWriter, oVarOwner, "INSTALLSESSIONVARS", oGlobalContextRoot, attributes);
                }
                ++i;
            }
            pWriter.println(OixsXMLOps.getEndTag(oGlobalContextRoot));
            pWriter.close();
            bWriter.close();
            fWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg);
            OiiolTextLogger.writeMessageToConsole(sMsg);
        }
    }
}

