/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionContextConstants;
import oracle.sysman.oii.oiic.OiicSessionVarsReader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OiicGlobalVarsReader
implements OiicSessionContextConstants {
    private Document m_oGlobalVarsDoc = null;
    private XMLElement m_oVarListNode = null;
    private OiicSessionVarsReader m_oSessionVarsReader = null;
    public static final String VARIABLES_XMLS = "variables_xmls";
    public static final String GLOBAL_VARS_TAG = "GLOBALVARS";
    public static final String VARS_PROPS_FILE = "variable.properties";
    public static final String GLOBAL_VARS_DIR = "globalvariables";
    public static final String GLOBAL_VARS_FILE = "globalvariables.xml";
    public static final String SCHEMA_SRC = "globalvars.xsd";
    public static final String IGNORE_DUPLICATE_VAR = "ignore_duplicate_variables";
    private static String sSchemaLoc = "globalvars.xsd";

    public OiicGlobalVarsReader(String sVarPropsLoc) throws OiixException {
        String sFile = System.getProperty("oracle.installer.globalvarxml");
        if (null != sFile && sFile.trim().length() > 0) {
            sFile = OiixPathOps.getAbsolutePath(sFile);
            OiiolTextLogger.appendText("Reading global variables from file " + sFile);
            if (sFile.trim().endsWith(".xml")) {
                this.init(sFile);
                return;
            }
            if (sFile.trim().endsWith(".properties")) {
                sVarPropsLoc = sFile;
            }
        }
        if (null == sVarPropsLoc || sVarPropsLoc.trim().equals("")) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(sVarPropsLoc);
            String path = OiixPathOps.getParentDir(sVarPropsLoc);
            if (null == path) {
                path = "";
            }
            this.init(fis, path);
            fis.close();
        }
        catch (IOException ioe) {
            throw new OiixException(ioe);
        }
    }

    public OiicGlobalVarsReader(InputStream in, String path) throws OiixException {
        this.init(in, path);
    }

    private void init(InputStream in, String path) throws OiixException {
        Properties props = new Properties();
        try {
            props.load(in);
            String sXmlfiles = props.getProperty(VARIABLES_XMLS);
            boolean bIgnoreDuplicates = false;
            if (props.getProperty(IGNORE_DUPLICATE_VAR) != null) {
                bIgnoreDuplicates = new Boolean(props.getProperty(IGNORE_DUPLICATE_VAR));
            }
            if (null == sXmlfiles) {
                throw new OiixException("message: OiicGlobalVarsReader.init");
            }
            String[] sFilesArr = OiixVectorOps.parseStringArrFromString(sXmlfiles, ",");
            Document oDoc = null;
            for (int i = 0; i < sFilesArr.length; ++i) {
                String sFilename = sFilesArr[i].trim();
                if (!(sFilename.startsWith("/") || sFilename.length() > 2 && (sFilename.charAt(1) == ':' && sFilename.charAt(2) == '/' || sFilename.charAt(2) == '\\') || path == null || path.trim().equals(""))) {
                    sFilename = OiixPathOps.concatPath(path, sFilesArr[i]);
                }
                if (!new File(sFilename).exists()) {
                    String msg = "Global variables file not found: " + sFilename;
                    String[] msgArgs = new String[]{msg};
                    String sInitError = this.formatErrorMessage("OUI-25041", msgArgs);
                    throw new OiixException(msg);
                }
                try {
                    this.validate(sFilename);
                }
                catch (Exception e) {
                    String msg = "Validation failed for file: " + sFilename;
                    String[] msgArgs = new String[]{msg};
                    String sInitError = this.formatErrorMessage("OUI-25041", msgArgs);
                    throw new OiixException(msg, e);
                }
                oDoc = OixdDOMReader.getDocument(sFilename);
                if (null == this.m_oGlobalVarsDoc) {
                    this.m_oGlobalVarsDoc = oDoc;
                    continue;
                }
                NodeList list = oDoc.getDocumentElement().getElementsByTagName("VAR");
                for (int j = 0; j < list.getLength(); ++j) {
                    Node node = this.m_oGlobalVarsDoc.importNode(list.item(j), true);
                    this.m_oGlobalVarsDoc.getDocumentElement().appendChild(node);
                }
            }
            this.m_oSessionVarsReader = new OiicSessionVarsReader((XMLElement)this.m_oGlobalVarsDoc);
            this.checkForDuplicates((XMLElement)this.m_oGlobalVarsDoc.getDocumentElement(), bIgnoreDuplicates);
        }
        catch (Exception e) {
            String[] msgArgs = new String[]{e.getMessage()};
            String sInitError = this.formatErrorMessage("OUI-25041", msgArgs);
            throw new OiixException(sInitError, e);
        }
    }

    private void init(String sVarFileName) throws OiixException {
        try {
            Object oDoc = null;
            try {
                this.validate(sVarFileName);
            }
            catch (Exception e) {
                String msg = "Validation failed for file: " + sVarFileName;
                String[] msgArgs = new String[]{msg};
                String sInitError = this.formatErrorMessage("OUI-25041", msgArgs);
                throw new OiixException(msg, e);
            }
            this.m_oGlobalVarsDoc = OixdDOMReader.getDocument(sVarFileName);
            this.m_oSessionVarsReader = new OiicSessionVarsReader((XMLElement)this.m_oGlobalVarsDoc);
            this.checkForDuplicates((XMLElement)this.m_oGlobalVarsDoc.getDocumentElement());
        }
        catch (Exception e) {
            String[] msgArgs = new String[]{e.getMessage()};
            String sInitError = this.formatErrorMessage("OUI-25041", msgArgs);
            throw new OiixException(sInitError, e);
        }
    }

    private void checkForDuplicates(XMLElement oVarRoot) throws OiixException {
        this.checkForDuplicates(oVarRoot, false);
    }

    private void checkForDuplicates(XMLElement oVarRoot, boolean bIgnore) throws OiixException {
        NodeList oVarNodeParent = oVarRoot.getElementsByTagName("VAR");
        int nSizeVar = oVarNodeParent.getLength();
        for (int i = 0; i < nSizeVar; ++i) {
            Element oVarNode1 = (Element)oVarNodeParent.item(i);
            if (oVarNode1 == null) continue;
            String sVarName = oVarNode1.getAttribute("NAME");
            for (int j = i + 1; j < nSizeVar; ++j) {
                Element oVarNode2 = (Element)oVarNodeParent.item(j);
                String sVarName2 = oVarNode2.getAttribute("NAME");
                if (sVarName == null || !sVarName.equals(sVarName2)) continue;
                if (bIgnore) {
                    String type1 = oVarNode1.getAttribute("TYPE");
                    String type2 = oVarNode2.getAttribute("TYPE");
                    if (type1 == null) {
                        type1 = "";
                    }
                    if (type2 == null) {
                        type2 = "";
                    }
                    if (type1.trim().equalsIgnoreCase(type2.trim())) {
                        System.out.println("Duplicate variable ignored:" + sVarName2);
                        oVarRoot.removeChild((Node)oVarNode2);
                        continue;
                    }
                    String[] sInitError = new String[]{"Duplicate variable " + sVarName2 + " found with different type from existing variable"};
                    throw new OiixException(this.formatErrorMessage("OUI-25041", sInitError));
                }
                String[] sInitError = new String[]{"Duplicate variable found. A variable with name" + sVarName2 + "already exists"};
                throw new OiixException(this.formatErrorMessage("OUI-25041", sInitError));
            }
        }
    }

    private static URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return url;
    }

    private void validate(String sFilename) throws XSDException, XMLParseException, SAXException, IOException {
        File fSchema = new File(sSchemaLoc);
        if (!fSchema.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(sFilename);
        SAXParser saxParser = new SAXParser();
        saxParser.setValidationMode(3);
        XSDBuilder builder = new XSDBuilder();
        XMLSchema schemadoc = builder.build(OiicGlobalVarsReader.createURL(sSchemaLoc));
        saxParser.setXMLSchema((Object)schemadoc);
        OiicGlobalVarsValidator handler = new OiicGlobalVarsValidator();
        saxParser.setErrorHandler((ErrorHandler)handler);
        saxParser.parse((InputStream)fis);
        fis.close();
    }

    public static void setSchemaLoc(String sLoc) {
        sSchemaLoc = sLoc;
    }

    public Map getGlobalVariablesOSP() {
        Hashtable vars;
        if (null != this.m_oSessionVarsReader && null != (vars = this.m_oSessionVarsReader.getVarsFromXML(GLOBAL_VARS_TAG, true))) {
            return vars;
        }
        return new Hashtable();
    }

    public List getGlobalVariables(OiicSessionContext oSession) {
        return this.getGlobalVariables(oSession, false);
    }

    public List getGlobalVariablesRSP(OiicSessionContext oSession) {
        return this.getGlobalVariables(oSession, true);
    }

    private List getGlobalVariables(OiicSessionContext oSession, boolean bResp) {
        if (null == this.m_oSessionVarsReader) {
            return new LinkedList();
        }
        List vars = this.m_oSessionVarsReader.readSessionVariablesFromXML(oSession, GLOBAL_VARS_TAG, bResp, null);
        if (null == vars) {
            return new LinkedList();
        }
        for (int i = 0; i < vars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)vars.get(i);
            OiicGlobalVarsReader.processVar(oVar, oSession);
        }
        return vars;
    }

    private static void processVar(OiisVariable oVar, OiicSessionContext oSession) {
        oVar.setGlobal(true);
        oVar.setShowInOSP(true);
        oVar.setPublish(true);
        if (oSession != null && oSession.getSession() != null && oSession.getSession().isCloneMode() && oVar.isComputeAtClone()) {
            oVar.setAdvice(false);
            if (oVar.isCalcMethodPresent()) {
                try {
                    oVar.setValueWithoutValidation(oVar.getCalculatedValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static List readVarValuesFromInventory(String sInvFileLoc, OiicSessionContext oSession) {
        File file = new File(sInvFileLoc);
        if (!file.exists() || file.isDirectory()) {
            return new LinkedList();
        }
        try {
            Document oDoc = OixdDOMReader.getDocument(sInvFileLoc);
            OiicSessionVarsReader oReader = new OiicSessionVarsReader((XMLElement)oDoc);
            List vars = oReader.readSessionVariablesFromXML(oSession, GLOBAL_VARS_TAG, false, null);
            if (null == vars) {
                return new LinkedList();
            }
            for (int i = 0; i < vars.size(); ++i) {
                OiisVariable oVar = (OiisVariable)vars.get(i);
                OiicGlobalVarsReader.processVar(oVar, oSession);
            }
            return vars;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new LinkedList();
        }
    }

    public static Map readGlobalVariables(String sVarFile) throws IOException {
        if (null == sVarFile) {
            throw new IOException("Filename cannot be null");
        }
        File file = new File(sVarFile);
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("Either the file doesn't exist or is a directory");
        }
        OiiolTextLogger.appendText("Reading global variables from file " + sVarFile);
        try {
            Document oDoc = OixdDOMReader.getDocument(sVarFile);
            OiicSessionVarsReader oReader = new OiicSessionVarsReader((XMLElement)oDoc);
            List varList = oReader.readSessionVariablesFromXML(null, GLOBAL_VARS_TAG, false, null);
            HashMap<String, OiisVariable> varMap = new HashMap<String, OiisVariable>();
            for (int i = 0; i < varList.size(); ++i) {
                OiisVariable oVar = (OiisVariable)varList.get(i);
                if (null == oVar) continue;
                OiicGlobalVarsReader.processVar(oVar, null);
                String name = oVar.getName();
                varMap.put(name, oVar);
            }
            return varMap;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void writeGlobalVarsToXML(String sFile, Map varsMap) throws IOException {
        FileWriter fWriter = new FileWriter(sFile, false);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter((Writer)bWriter, true);
        OiiolTextLogger.appendText("Writing global variables to file " + sFile);
        OiicGlobalVarsReader.writeGlobalVarsToXML(pWriter, varsMap.values().iterator());
        pWriter.close();
        bWriter.close();
        fWriter.close();
    }

    public static void writeGlobalVarsToXML(PrintWriter pWriter, Iterator listVars) throws IOException {
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement rootElement = new XMLElement(GLOBAL_VARS_TAG);
        pWriter.println(OixsXMLOps.getStartTag(rootElement));
        while (listVars.hasNext()) {
            XMLElement element = new XMLElement("VAR");
            OiisVariable oVar = (OiisVariable)listVars.next();
            if (element == null || null == oVar || !oVar.isGlobalVar()) continue;
            element.setAttribute("NAME", oVar.getName());
            int type = oVar.getType();
            String val = OiicSessionVarsReader.getTypeStringValue(type);
            element.setAttribute("TYPE", val);
            val = oVar.getValueAsString();
            if (type == 3) {
                Boolean valueObj = (Boolean)oVar.getValue();
                boolean bValue = valueObj == null ? false : valueObj;
                val = OiicSessionVarsReader.setBooleanValue(bValue);
            }
            boolean flag = false;
            if (!oVar.isSecure()) {
                element.setAttribute("VALUE", val);
            }
            if (!oVar.isSecure()) {
                flag = oVar.getAdvice();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("ADVISE", val);
            }
            flag = oVar.isComputeAtClone();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("COMPUTE_AT_CLONE", val);
            flag = oVar.isCalcMethodPresent();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("CALC_REQD", val);
            element.setAttribute("CLASS", oVar.getClass().getName());
            val = oVar.getExtendsFrom();
            element.setAttribute("EXTENDS_FROM", val);
            flag = oVar.isAllowAssignment();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("ALLOW_ASSIGNMENT", val);
            flag = oVar.isHandleErrors();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("HANDLE_ERRORS", val);
            flag = oVar.isValueReqd();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("VAL_REQD", val);
            flag = oVar.isSecure();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("SECURE", val);
            flag = oVar.isSuppressedOnSilent();
            val = OiicSessionVarsReader.setBooleanValue(flag);
            element.setAttribute("SUPPRESS_ON_SILENT", val);
            val = oVar.getDescriptionID();
            if (val != null) {
                element.setAttribute("DESC_ID", val);
            }
            rootElement.appendChild((Node)element);
            element.print(pWriter);
        }
        pWriter.println(OixsXMLOps.getEndTag(rootElement));
    }

    public void writeGlobalVarsToXML(String filename) {
        try {
            DOMSource source = new DOMSource(this.m_oGlobalVarsDoc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatErrorMessage(String resourceId, String[] args) {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resourceId, args);
    }

    private class OiicGlobalVarsValidator
    extends DefaultHandler {
        public boolean validationError = false;
        public SAXParseException saxParseException = null;

        private OiicGlobalVarsValidator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

