/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiicInstAccessSetupWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo;
    private boolean m_errorOcc = false;
    private String m_errmsg;
    private int m_nextInd;

    public OiicInstAccessSetupWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    public void dispose() {
    }

    public void initialize() {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTACCESSSETUPWCCE_INITIALIZE"));
        this.m_errorOcc = false;
        try {
            OiicPullSession pSession = this.m_vo.getSession();
            if (pSession.getProgressListener() == null) {
                return;
            }
            this.updateFromLocation();
            OiisVariable cdLabelVar = this.m_vo.getVariable("FROM_LOCATION_CD_LABEL");
            if (cdLabelVar != null && cdLabelVar.getValue() != null) {
                String sNewFromLocation = null;
                OiicInstallSession instSession = null;
                if (pSession instanceof OiicInstallSession && (instSession = (OiicInstallSession)pSession) != null) {
                    sNewFromLocation = instSession.ensureValidDisk((String)cdLabelVar.getValue(), 1);
                }
                if (sNewFromLocation != null) {
                    sNewFromLocation = sNewFromLocation + "products.xml";
                    sNewFromLocation = OiixPathOps.getNativeForm(sNewFromLocation);
                    OiisVariable fromLocationVar = this.m_vo.getVariable("FROM_LOCATION");
                    String sFromLocation = (String)fromLocationVar.getValue();
                    if (!(sFromLocation = OiixPathOps.getNativeForm(sFromLocation)).equals(sNewFromLocation)) {
                        fromLocationVar.setValue(sNewFromLocation);
                        this.m_vo.addVariable(fromLocationVar);
                    }
                }
            }
            pSession.setupAccessObjects();
        }
        catch (Exception ex) {
            if (ex instanceof IOException || ex instanceof OiitTargetLockNotAvailableException || ex instanceof OiiiDiskNotFoundException) {
                this.m_errmsg = ex.getMessage();
            } else {
                ex.printStackTrace(System.err);
                this.m_errmsg = OiixResourceBundle.getString("S_ERROR_IN_FROM_TO");
            }
            if (!(ex instanceof SSLHandshakeException)) {
                OiifmAlert.displayError(this.m_errmsg);
            }
            this.m_errorOcc = true;
            this.m_vo.getVariable("FROM_LOCATION").setAdvice(false);
        }
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTACCESSSETUPWCCE_DOOPERATION"));
        OiicPullSession pSession = this.m_vo.getSession();
        if (isBack) {
            return 1;
        }
        if (!this.m_errorOcc && OiicPullSession.isLangAddonMode() && !this.isTLCIntersectionNonEmpty()) {
            OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25038"));
            this.m_errorOcc = true;
        }
        if (this.m_errorOcc) {
            if (pSession.isSilentMode() || pSession.isSuppressedSource()) {
                throw new OiifbEndIterateException(this.m_errmsg);
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException());
            }
        }
        return this.m_errorOcc ? 1 : 0;
    }

    private boolean isTLCIntersectionNonEmpty() {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiSourceAccess srcAccess = pSession.getSourceAccess();
        OiiiStageInventory osi = srcAccess.getStageInventory();
        Vector stageTLCVector = osi.getTopLevelComps(0);
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Vector oHTLCVector = oInventory.getTopLevelComps(this.getHomeIndex());
        Vector tlcIntersectionVector = stageTLCVector;
        tlcIntersectionVector.retainAll(oHTLCVector);
        return tlcIntersectionVector.size() > 0;
    }

    private int getHomeIndex() {
        int homeIndex = -1;
        OiisVariable oHomeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeName = oInfo.getName();
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                if (!bSameHomeName) continue;
                homeIndex = oInfo.getIndex();
                break;
            }
        }
        return homeIndex;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private void updateFromLocation() {
        OiisVariable fromLocationVar = this.m_vo.getVariable("FROM_LOCATION");
        String sFromLocation = (String)fromLocationVar.getValue();
        if (OiixPathOps.isHttpLocation(sFromLocation)) {
            return;
        }
        File f = new File(sFromLocation);
        if (f.exists()) {
            return;
        }
        String sStartupLocation = System.getProperty("oracle.installer.startup_location");
        if (!sStartupLocation.endsWith(File.separator)) {
            sStartupLocation = sStartupLocation + File.separator;
        }
        sStartupLocation = OiixPathOps.getStandardForm(sStartupLocation);
        sFromLocation = (sStartupLocation = OiixPathOps.getNativeForm(sStartupLocation)) + sFromLocation;
        f = new File(sFromLocation);
        if (f.exists() && !f.isDirectory()) {
            try {
                fromLocationVar.setValue(OiixPathOps.getFileCanonicalPath(sFromLocation));
            }
            catch (OiisVarSettingException e) {
            }
            catch (OiifbCancelException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

