/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.net.ssl.SSLHandshakeException;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiicInstSHSetupWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo = null;
    private Exception m_errorOcc = null;
    private String m_errmsg = null;
    private int m_nextInd = -1;

    public OiicInstSHSetupWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    public void dispose() {
    }

    public void initialize() {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_INSTACCESSSETUPWCCE_SH_INITIALIZE"));
        this.m_errorOcc = null;
        this.m_errmsg = null;
        String sErrorCode = null;
        OiicPullSession pSession = this.m_vo.getSession();
        try {
            if (!pSession.hasSourceChanged()) {
                return;
            }
            this.updateFromLocation();
            OiisVariable cdLabelVar = this.m_vo.getVariable("FROM_LOCATION_CD_LABEL");
            if (cdLabelVar != null && cdLabelVar.getValue() != null) {
                String sNewFromLocation = null;
                OiicInstallSession instSession = null;
                if (pSession instanceof OiicInstallSession && (instSession = (OiicInstallSession)pSession) != null) {
                    sNewFromLocation = instSession.ensureValidDisk((String)cdLabelVar.getValue(), 1);
                }
                if (sNewFromLocation != null) {
                    sNewFromLocation = sNewFromLocation + "products.xml";
                    sNewFromLocation = OiixPathOps.getNativeForm(sNewFromLocation);
                    OiisVariable fromLocationVar = this.m_vo.getVariable("FROM_LOCATION");
                    String sFromLocation = (String)fromLocationVar.getValue();
                    if (!(sFromLocation = OiixPathOps.getNativeForm(sFromLocation)).equals(sNewFromLocation)) {
                        fromLocationVar.setValue(sNewFromLocation);
                        this.m_vo.addVariable(fromLocationVar);
                    }
                }
            }
            pSession.setupSHAccessObjects();
            pSession.updateSourceConfigs();
        }
        catch (SSLHandshakeException e0) {
            this.m_errmsg = null;
            this.m_errorOcc = e0;
        }
        catch (IOException e1) {
            this.m_errmsg = e1.getMessage();
            this.m_errorOcc = e1;
        }
        catch (ClassNotFoundException e2) {
            this.m_errmsg = e2.getMessage();
            this.m_errorOcc = e2;
            sErrorCode = "OUI-22002";
        }
        catch (OiifbCancelException e3) {
            this.m_errmsg = e3.getMessage();
            this.m_errorOcc = e3;
            sErrorCode = "OUI-22002";
        }
        catch (OiiiDiskNotFoundException e4) {
            this.m_errmsg = e4.getMessage();
            this.m_errorOcc = e4;
        }
        catch (OiisCompLoadingException e5) {
            this.m_errmsg = e5.getMessage();
            this.m_errorOcc = e5;
            sErrorCode = "OUI-22002";
        }
        catch (OiisVarSettingException e6) {
            this.m_errmsg = e6.getMessage();
            this.m_errorOcc = e6;
            sErrorCode = "OUI-22002";
        }
        catch (OiitTargetLockNotAvailableException e7) {
            this.m_errmsg = e7.getMessage();
            this.m_errorOcc = e7;
        }
        catch (Exception e) {
            this.m_errmsg = e.getMessage();
            this.m_errorOcc = e;
            sErrorCode = "OUI-22002";
        }
        if (this.m_errorOcc != null) {
            if (sErrorCode != null) {
                if (OiicPullSession.isDebugMode()) {
                    OiiolTextLogger.appendException(this.m_errorOcc);
                }
                String sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErrorCode);
                this.m_errmsg = this.m_errmsg != null && this.m_errmsg.length() > 0 ? sErrMsg + " (" + this.m_errmsg + ")" : sErrMsg;
            }
            if (this.m_errmsg != null && this.m_errmsg.length() > 0) {
                OiifmAlert.displayError(this.m_errmsg);
            }
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            oFromLoc.setAdvice(false);
        } else {
            pSession.resetSourceChangeStatus();
        }
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTACCESSSETUPWCCE_SH_DOOPERATION"));
        if (isBack) {
            return 1;
        }
        if (this.m_errorOcc != null) {
            OiicPullSession pSession = this.m_vo.getSession();
            if (pSession.isSilentMode() || pSession.isSuppressedSource()) {
                throw new OiifbEndIterateException(OiixResourceBundle.getString("S_LOG_ALERT_ERROR") + this.m_errmsg);
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException(this.m_errmsg));
            }
        }
        return this.m_errorOcc != null ? 1 : 0;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private void updateFromLocation() throws IOException {
        OiisVariable fromLocationVar = this.m_vo.getVariable("FROM_LOCATION");
        String sFromLocation = (String)fromLocationVar.getValue();
        if (OiixPathOps.isHttpLocation(sFromLocation)) {
            return;
        }
        File f = new File(sFromLocation);
        if (f.exists()) {
            return;
        }
        String sStartupLocation = System.getProperty("oracle.installer.startup_location");
        if (!sStartupLocation.endsWith(File.separator)) {
            sStartupLocation = sStartupLocation + File.separator;
        }
        sStartupLocation = OiixPathOps.getStandardForm(sStartupLocation);
        sFromLocation = (sStartupLocation = OiixPathOps.getNativeForm(sStartupLocation)) + sFromLocation;
        f = new File(sFromLocation);
        if (f.exists() && !f.isDirectory()) {
            try {
                String sCanonicalFromLocationPath = OiixPathOps.getFileCanonicalPath(sFromLocation);
                fromLocationVar.setValue(sCanonicalFromLocationPath);
            }
            catch (OiisVarSettingException e1) {
            }
            catch (OiifbCancelException e2) {
            }
            catch (IOException e3) {
                String sMsg = e3.getMessage();
                sMsg = sMsg != null && sMsg.length() > 0 ? " (" + sMsg + ")" : "";
                Object[] msgArr = new String[]{sFromLocation, sMsg};
                String errString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-22001");
                errString = MessageFormat.format(errString, msgArr);
                OiiolTextLogger.appendText(errString);
                throw new IOException(errString);
            }
        }
    }
}

