/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicInstallReboot {
    public static final int NO_LAUNCH = 1;
    public static final int LAUNCH_OUI = 2;
    public static final int LAUNCH_APP = 4;
    private static final String RUNONCE_REG_MAINKEY = "HKEY_LOCAL_MACHINE";
    private static final String RUNONCE_REG_SUBKEY = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce";
    private static final String RUNONCE_APPCOMMAND_DATAKEY = "OUIApp";
    private static final String RUNONCE_OUICOMMAND_DATAKEY = "OUICommand";
    private static final String RUNONCE_OUIEXITCONFIG_DATAKEY = "OUIExitConfig";
    private static final String EXIT_CONFIG_LOC = " -exit_config_loc ";
    private static final String EXITTOOLS_FILE = "../exittools.bat";
    private static final String COMMAND_PREFIX = "cmd /c START ";
    private String m_sOUICommandLineArgs;
    private int m_nLaunch;
    private String m_sMessage;
    private Hashtable m_hCommands;
    private static int m_nCount = 1;
    private OiicPullSession m_pullSession;

    public OiicInstallReboot(String sMessage, String sCompDisplayName) {
        this(sMessage, null, sCompDisplayName, 1);
    }

    public OiicInstallReboot(String sMessage, String sCommandLine, String sCompDisplayName, int nLaunch) {
        this.m_sMessage = sMessage;
        this.m_hCommands = new Hashtable();
        if (nLaunch == 4 || nLaunch == 2) {
            this.addRebootInformation(sCommandLine, sCompDisplayName, nLaunch);
        } else {
            this.m_nLaunch |= nLaunch;
        }
    }

    void setInstallSession(OiicPullSession pullSession) {
        this.m_pullSession = pullSession;
    }

    void addRebootInformation(String sCommandLine, String sCompDisplayName, int nLaunch) {
        if (nLaunch == 1) {
            return;
        }
        if (nLaunch == 2) {
            if ((this.m_nLaunch & 2) > 0) {
                Object[] args = new Object[]{sCompDisplayName, sCommandLine};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_REBOOT_OUILAUNCH_INFO_ALREADY_SET", args));
            } else {
                this.m_sOUICommandLineArgs = sCommandLine == null ? "" : sCommandLine;
            }
            this.m_nLaunch |= nLaunch;
            return;
        }
        String sKey = sCompDisplayName + m_nCount++;
        this.m_hCommands.put(sKey, sCommandLine);
        this.m_nLaunch |= nLaunch;
    }

    public void reboot(boolean bReboot, boolean bNextSession) throws OiifbCancelException {
        if (this.m_nLaunch == 1 && !bReboot) {
            return;
        }
        try {
            boolean bSetExitLaunch = false;
            Vector vExitTools = this.m_pullSession.getOnRebootExitTools();
            if (this.m_nLaunch != 1) {
                if (!bNextSession) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_REBOOT_COMMAND_LINE_LOG"));
                } else {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_REBOOT_COMMAND_LINE_LOGONLY"));
                }
                if ((this.m_nLaunch & 2) > 0) {
                    String sOUICommand = System.getProperty("oracle.installer.exec_location") + " " + this.m_sOUICommandLineArgs + " ";
                    if (vExitTools != null && vExitTools.size() > 0) {
                        String sExitConfigLoc = null;
                        try {
                            sExitConfigLoc = this.writeRebootExitTools(vExitTools);
                            sOUICommand = sOUICommand + " -exit_config_loc \"" + sExitConfigLoc + "\"";
                            bSetExitLaunch = true;
                        }
                        catch (Exception e) {
                            Object[] args = new Object[]{sExitConfigLoc, e.getMessage()};
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_REBOOT_LOG_MESSAGE_EXITTOOLS_ERROR", args));
                        }
                    }
                    this.setRunOnceRegistryKey(RUNONCE_OUICOMMAND_DATAKEY, sOUICommand, bNextSession);
                }
                if ((this.m_nLaunch & 4) > 0) {
                    Enumeration eKeys = this.m_hCommands.keys();
                    while (eKeys.hasMoreElements()) {
                        String sKey = (String)eKeys.nextElement();
                        String sCommand = (String)this.m_hCommands.get(sKey);
                        this.setRunOnceRegistryKey(RUNONCE_APPCOMMAND_DATAKEY + sKey, sCommand, bNextSession);
                    }
                }
            }
            if (vExitTools != null && vExitTools.size() > 0 && !bSetExitLaunch) {
                String sTopLevelComp = this.m_pullSession.getSelTopLevelCompID().getName();
                int iSize = vExitTools.size();
                for (int i = 0; i < iSize; ++i) {
                    String sCommand = (String)vExitTools.elementAt(i);
                    this.setRunOnceRegistryKey(RUNONCE_OUIEXITCONFIG_DATAKEY + sTopLevelComp + i, sCommand, bNextSession);
                }
            }
            if (this.m_pullSession != null && this.m_pullSession.isInstallMode()) {
                ((OiicInstallSession)this.m_pullSession).runOuica(true);
            }
            if (bReboot && !bNextSession) {
                int ret = OiipwWin32NativeCalls.rebootWindows();
                OiiolTextLogger.appendText("Reboot Windows returned :" + ret);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            String sFailureMsg = OiixResourceBundle.getString("S_REBOOT_FAILURE", args);
            OiiolTextLogger.appendText(sFailureMsg);
            throw new OiifbCancelException(sFailureMsg, true);
        }
    }

    private void setRunOnceRegistryKey(String sKey, String sCommand, boolean bNextSession) {
        try {
            OiiolTextLogger.appendText(sCommand);
            if (!bNextSession) {
                OiipwWin32NativeCalls.RegSetValue(RUNONCE_REG_MAINKEY, RUNONCE_REG_SUBKEY, sKey, COMMAND_PREFIX + sCommand);
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{sKey, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_REBOOT_LOG_MESSAGE_REG_ERROR", args));
        }
    }

    public String getMessage() {
        return this.m_sMessage;
    }

    public boolean isLaunchOUI() {
        return (this.m_nLaunch & 2) > 0;
    }

    private String writeRebootExitTools(Vector vExitTools) throws IOException {
        String sTempDir = OiipgFileSystem.getTempLoc();
        String sExitFileLoc = OiixPathOps.concatPath(sTempDir, EXITTOOLS_FILE);
        sExitFileLoc = OiixPathOps.getStandardCanonicalPath(sExitFileLoc);
        FileWriter fw = new FileWriter(sExitFileLoc, true);
        int iSize = vExitTools.size();
        String NEW_LINE = System.getProperty("line.separator");
        for (int i = 0; i < iSize; ++i) {
            String sCommand = COMMAND_PREFIX + (String)vExitTools.elementAt(i);
            fw.write(sCommand);
            fw.write(NEW_LINE);
        }
        if (fw != null) {
            fw.close();
        }
        return sExitFileLoc;
    }
}

