/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class OiicPreCloneSetup
extends OiicBaseApp {
    private static final String S_PRECLONE_CHECK = "PRECLONE_CHECK";
    private static final String S_COMPONENTS = "COMPONENTS";
    private static final String S_APPLICATION_ID = "preCloneOperations";
    private String[] m_args;
    private String m_sOracleHome = null;
    private boolean m_bNewHome = true;
    private boolean m_bNewHomeDir = true;
    private static OiicPreCloneSetup s_oiicPreCloneSetup = null;
    private static final String appName = "oui";

    private OiicPreCloneSetup(String[] args) {
        super(appName);
        this.m_args = args;
    }

    private OiicPreCloneSetup(String[] args, String app) {
        super(app);
        this.m_args = args;
    }

    public static OiicPreCloneSetup getOiicPreCloneSetupInstance(String[] args) {
        if (s_oiicPreCloneSetup == null) {
            s_oiicPreCloneSetup = new OiicPreCloneSetup(args);
        }
        return s_oiicPreCloneSetup;
    }

    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    private int performPreCloneOperations() {
        int iExitCode;
        block4: {
            iExitCode = 0;
            try {
                ArrayList alCompIds = this.getPreCloneCompsList();
                ArrayList alCompsToInstall = this.getCompsToInstall(alCompIds);
                if (alCompsToInstall.size() > 0) {
                    iExitCode = this.installComponents(alCompsToInstall);
                    if (this.m_bNewHome) {
                        this.removeHome(this.getOracleHome());
                    }
                    break block4;
                }
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_PRECLONE_NO_COMPS_TO_INSTALL"));
                return 0;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        OiiolTextLogger.closeLog();
        return iExitCode;
    }

    private ArrayList getPreCloneCompsList() throws IOException {
        String[] sDefValue = new String[]{};
        String[] asCompsList = OiixOraparam.getOraparamProfileStringList(S_PRECLONE_CHECK, S_COMPONENTS, sDefValue);
        ArrayList<OiiiCompInstallID> alCompIds = null;
        if (asCompsList != null && asCompsList.length > 0) {
            alCompIds = new ArrayList<OiiiCompInstallID>(asCompsList.length / 2);
            for (int i = 0; i < asCompsList.length; i += 2) {
                if (i + 1 >= asCompsList.length) {
                    String[] args = new String[]{S_PRECLONE_CHECK, S_COMPONENTS};
                    throw new IOException(OiixResourceBundle.getString("S_PRECLONE_INCORRECT_COMP_LIST"));
                }
                OiiiCompInstallID cid = null;
                String sIntName = asCompsList[i].trim();
                String sVersion = asCompsList[i + 1].trim();
                cid = new OiiiCompInstallID(sIntName, new OiiiVersion(sVersion), OiixPlatform.getCurrentPlatformVector());
                alCompIds.add(cid);
            }
        }
        return alCompIds;
    }

    private ArrayList getCompsToInstall(ArrayList alCompsList) {
        ArrayList alCompsToInstall = new ArrayList();
        String sOracleHome = this.getOracleHome();
        OiicStandardInventorySession session = new OiicStandardInventorySession(S_APPLICATION_ID, OiicInstVersion.getInstallerVersion().getVerString());
        try {
            session.initSession(0, 1, 1);
            OiiiInstallAreaControl iac = session.getInstallAreaControl();
            OiiiInstallInventory inventory = iac.getInstallInventory();
            if (inventory.getHomeWithLocation(sOracleHome) != null) {
                this.m_bNewHome = false;
            } else if (inventory.getHomeWithLocation(sOracleHome, 3) != null) {
                throw new IOException(OiixResourceBundle.getString("S_PRECLONE_ORCA_HOME_SPECIFIED", new Object[]{sOracleHome}));
            }
            for (int i = 0; i < alCompsList.size(); ++i) {
                Object[] args;
                OiiiCompInstallID cid = (OiiiCompInstallID)alCompsList.get(i);
                OiiiCompInvEntry cie = inventory.getCompatCompEntry(cid, 0);
                if (cie == null) {
                    args = new String[]{cid.getName(), cid.getVersion().getVerString()};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_PRECLONE_COMP_NOT_FOUND", args));
                    alCompsToInstall.add(cid);
                    continue;
                }
                args = new String[]{cie.getFullDisplayName()};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_PRECLONE_COMPATIBLE_COMP_FOUND", args));
            }
        }
        catch (OiiiInventoryDoesNotExistException e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
            alCompsToInstall = (ArrayList)alCompsList.clone();
            this.m_bNewHome = true;
        }
        catch (OiitTargetLockNotAvailableException e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
        }
        catch (IOException e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Unknown error obtaining inventory lock:: " + e.getMessage());
            e.printStackTrace();
        }
        this.m_bNewHomeDir = !new File(sOracleHome).exists();
        session.endSession();
        return alCompsToInstall;
    }

    private int installComponents(ArrayList alCompsToInstall) {
        int iExitCode = 0;
        for (int i = 0; i < alCompsToInstall.size(); ++i) {
            Object[] args;
            OiiiCompInstallID cid = (OiiiCompInstallID)alCompsToInstall.get(i);
            String sResponseFileLoc = this.getResponseFileLoc(cid);
            if (sResponseFileLoc.trim().equals("")) {
                args = new String[]{cid.getName(), cid.getVersion().getVerString()};
                OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("S_PRECLONE_CANNOT_INSTALL_COMP", args));
            } else {
                args = new String[]{cid.getName(), cid.getVersion().getVerString(), sResponseFileLoc};
                OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("S_PRECLONE_INSTALLING_COMP", args));
                int iAddedArgs = 2;
                String[] sArgs = new String[this.m_args.length + iAddedArgs];
                System.arraycopy(this.m_args, 0, sArgs, 0, this.m_args.length);
                sArgs[this.m_args.length] = "-responseFile";
                sArgs[this.m_args.length + 1] = sResponseFileLoc;
                String sLogDir = OiiolTextLogger.getLogDir();
                OiiolTextLogger.closeLog();
                iExitCode = OiicInstaller.getOiicInstallerInstance().runInstaller(sArgs);
                try {
                    OiiolTextLogger.setLogLoc(sLogDir, S_APPLICATION_ID);
                }
                catch (IOException e) {
                    OiiolTextLogger.writeMessageToConsole("S_PRECLONE_UNABLE_TO_SETUP_LOG", new Object[]{sLogDir, e.getMessage()});
                }
            }
            if (iExitCode != -1) continue;
            return -1;
        }
        return iExitCode;
    }

    private void removeHome(String sOracleHome) {
        boolean bHomeRemoved = false;
        OiicStandardInventorySession session = new OiicStandardInventorySession(S_APPLICATION_ID, OiicInstVersion.getInstallerVersion().getVerString());
        try {
            session.initSession(1);
            OiiiInstallAreaControl iac = session.getInstallAreaControl();
            OiiiInstallInventory inventory = iac.getInstallInventory();
            OiiiOracleHomeInfo ohi = inventory.getHomeWithLocation(sOracleHome);
            if (ohi != null) {
                if (inventory.getAllCompsVect(ohi.getIndex()).size() == 0) {
                    inventory.removeHome(ohi);
                    bHomeRemoved = this.m_bNewHomeDir;
                } else {
                    bHomeRemoved = false;
                }
            } else {
                bHomeRemoved = this.m_bNewHomeDir;
            }
            iac.saveInstallInventory();
            session.endSession();
            if (bHomeRemoved) {
                OiixFileOps.recdelete(new File(sOracleHome));
            }
        }
        catch (OiitTargetLockNotAvailableException e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
        }
        catch (IOException e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
        }
        catch (Exception e) {
            OiiolTextLogger.writeToLogAndConsole(e.getMessage());
        }
    }

    private String getOracleHome() {
        if (this.m_sOracleHome == null) {
            String sOracleHomeLhs = "ORACLE_HOME=";
            for (int j = 0; j < this.m_args.length; ++j) {
                if (!this.m_args[j].startsWith(sOracleHomeLhs)) continue;
                this.m_sOracleHome = this.m_args[j].substring(sOracleHomeLhs.length());
                break;
            }
        }
        return this.m_sOracleHome;
    }

    private String getResponseFileLoc(OiiiCompInstallID cid) {
        String sSection = cid.getName() + "_" + cid.getVersion().getVerString();
        String sEntry = "RESPONSE_FILE";
        String sResponseFile = OiixOraparam.getOraparamProfileString(sSection, sEntry, "");
        return sResponseFile;
    }

    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
    }

    public static void main(String[] args) {
        OiicPreCloneSetup oPreCloneSetup = OiicPreCloneSetup.getOiicPreCloneSetupInstance(args);
        int iExitCode = 0;
        try {
            oPreCloneSetup.processCommandLine(args);
            oPreCloneSetup.displayBanner();
            if (oPreCloneSetup.isHelpOptionSpecified()) {
                oPreCloneSetup.displayHelp();
                iExitCode = OiicExitCode.getExitCode();
            } else {
                iExitCode = oPreCloneSetup.performPreCloneOperations();
            }
        }
        catch (Throwable e) {
            System.err.println("Exception " + e + " occurred..");
            e.printStackTrace();
            OiicExitCode.setExitCode(-1);
            String sMsg = "";
            String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
            String sLogLoc = OiiolTextLogger.getCurLogFileName();
            sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
            String sErrLoc = OiixTeePrintStream.getErrFileLoc();
            sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
            String sOutLoc = OiixTeePrintStream.getOutFileLoc();
            sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
            sMsg = OiixResourceBundle.getString("S_CALL_SUPPORT", new Object[]{sLogLoc, sErrLoc, sOutLoc});
            sMsg = OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_MSG") + " " + sMsg;
            OiifmAlert.displayError(sMsg, OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_TITLE"));
            iExitCode = OiicExitCode.getExitCode();
        }
        System.exit(iExitCode);
    }
}

