/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicClusterNodeList;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallPlan;
import oracle.sysman.oii.oiic.OiicInstallReboot;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicNotifChecker;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiig.OiigAuthDetails;
import oracle.sysman.oii.oiig.OiigLoginFailedException;
import oracle.sysman.oii.oiig.OiigPubClient;
import oracle.sysman.oii.oiig.OiigRemoteException;
import oracle.sysman.oii.oiig.OiigServerConfig;
import oracle.sysman.oii.oiig.OiigSourceConfigs;
import oracle.sysman.oii.oiig.OiigStgAreaInfo;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibType;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiLibraryIDPool;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSessionCloneVars;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolCopyLogInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgActionsPhase;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDialogLibLoader;
import oracle.sysman.oii.oiis.OiisLibraryLoader;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisQueryLibLoader;
import oracle.sysman.oii.oiis.OiisStagedCompHelper;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiicPullSession
implements OiifbWizOperation,
OiicInstallTimeSession,
OiicClusterNodeList,
OiicISession {
    public static final int INSTALL_SESSION = 1;
    public static final int DEINSTALL_SESSION = 2;
    private static final int DIR_LEVEL_TO_BE_DELETED = 4;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private static Boolean m_silentMode = null;
    private static Boolean m_bLangAddonMode = null;
    private static Boolean m_bRecordMode = null;
    private static String m_sRecordModeFileName = null;
    private static String m_sRegistrationKey = null;
    private static Boolean s_bCloneMode = null;
    private static Boolean s_bInstallMode = null;
    private static Boolean s_bAddNodeMode = null;
    private static char s_cInstallFromCDStatus = (char)78;
    private static OiiiLibraryID m_fileActionID = null;
    private static OiiiLibraryID m_unixActionID = null;
    private static Boolean m_bDebugMode = null;
    protected OiiiSourceAccess m_sourceAccess = null;
    private OiiiTargetAreaControl m_targetAreaControl = null;
    protected OiiiInstallInventory m_installInv = null;
    private String m_sInvLoc = null;
    protected OiiodDepEngine m_depEngine = null;
    private Vector m_availTopLevelIDs = null;
    protected OiifbCondIterator m_iter = null;
    protected OiicSessionPlan m_sessionPlan = null;
    private boolean m_bSuppressedSource = false;
    private OiigSourceConfigs m_srcCfgs = new OiigSourceConfigs();
    protected Hashtable m_namespaceTable = null;
    protected OiicSessionContext m_sessionContext = null;
    private Vector m_vVolumes = null;
    static OiiiCompInstallID sessionContextID = null;
    private int m_ohIndex = 0;
    private int m_appltopIndex = 0;
    private OiipgActionsPhase m_pgActions = null;
    private Vector m_endMsgs = null;
    private boolean m_bInstallReadmeSaved = false;
    private OiifwActionsPhaseWCDE m_actionsPhase = null;
    private OiicInstPostActionsPhase m_instPostActionsPhase = null;
    private Vector m_IDsToComps = null;
    private Hashtable m_IDsToPSets = null;
    protected Hashtable[] m_IDsToLibLoaders = null;
    public static final String s_logLocRelToOH = "cfgtoollogs/oui/";
    public static final String s_invLogLoc = "logs/";
    private OiigPubClient m_pubClient = null;
    private Vector m_authCats = null;
    private OiigServerConfig m_svrCfg = null;
    private boolean m_publisherSession = false;
    private boolean m_bSuccessfulInstallation = false;
    private boolean m_bSuccessDefault = false;
    private boolean m_bSuccessfulOptionalTools = false;
    private boolean m_bSuccessfulRecommendedTools = false;
    private boolean m_bSuccessfulRemoteInstallation = true;
    private OiicInstallReboot m_reboot = null;
    private Vector m_vOnRebootExitTools = null;
    private boolean m_bLockGrabbed = false;
    private boolean m_bInstRootSHNeeded = false;
    private static final String INSTALL_README_LOC = "install/readme.txt";
    private boolean m_bAutoOUI = false;
    private boolean m_isAddComps = false;
    private boolean m_bDirtyPanelStatus = false;
    private char m_cHasSourceChanged = (char)78;
    private String m_sSourceLocationOld = null;
    private HashMap m_hmBackedupTemplates;
    private boolean m_bDeleteLibsCopied;
    private ArrayList m_vInstantiates = null;
    protected boolean m_bNewOraclHome;
    private boolean m_bFailedForStgVersionChk = true;
    private OicsICheckPointIndexSession checkPointSessionObj = null;
    private String DEFAULT_RECORD_FILE_DIR = "inventory" + File.separator + "response";
    private String RESP_FILE_EXTN = ".rsp";
    private String m_sDefaultRecordFileName = null;
    private static boolean m_bRemoteOperationSuccess = true;
    protected Hashtable m_oOhLocName;
    protected Hashtable m_oCopiedLibs;
    private boolean m_bInstallInProgress;
    static final int WAIT_TIME = 10;

    public void setNewOraclHome(boolean val) {
        this.m_bNewOraclHome = val;
    }

    public boolean isNewOraclHome() {
        return this.m_bNewOraclHome;
    }

    public Hashtable getOhLocName() {
        return this.m_oOhLocName;
    }

    public Hashtable getCopiedLibs() {
        return this.m_oCopiedLibs;
    }

    public boolean isInstallInProgress() {
        return this.m_bInstallInProgress;
    }

    protected OiicPullSession(OiicInstaller installer, boolean silentMode) {
        m_silentMode = OiixUtilityOps.booleanValueOf(silentMode);
        this.m_availTopLevelIDs = new Vector();
        this.m_bSuppressedSource = Boolean.getBoolean("oracle.installer.suppressedSource");
        this.m_pgActions = new OiipgActionsPhase(this);
        this.m_endMsgs = new Vector(1, 1);
        this.m_bDeleteLibsCopied = false;
        this.m_oOhLocName = new Hashtable();
        this.m_oCopiedLibs = new Hashtable();
        this.m_bInstallInProgress = false;
        this.m_IDsToComps = new Vector();
        this.m_IDsToPSets = new Hashtable();
        this.m_IDsToLibLoaders = new Hashtable[3];
        for (int i = 0; i < 3; ++i) {
            this.m_IDsToLibLoaders[i] = new Hashtable();
        }
        OiiiCompInstallID.setShouldOptimize(true);
        OiiiLibraryID.setShouldOptimize(true);
        this.setSessionPlan(new OiicInstallPlan());
        this.m_bSuccessfulInstallation = false;
        this.m_bSuccessfulOptionalTools = true;
        this.m_bSuccessfulRecommendedTools = true;
        this.m_bSuccessDefault = true;
        this.readOnRebootExitConfigTools();
    }

    public static boolean isLangAddonMode() {
        if (m_bLangAddonMode == null) {
            m_bLangAddonMode = new Boolean(Boolean.getBoolean("oracle.installer.addLangs"));
        }
        return m_bLangAddonMode;
    }

    public static void resetLangAddonMode() {
        m_bLangAddonMode = null;
        s_bInstallMode = null;
    }

    public void createComponentNamespaces(Vector voArr) {
        int numNamespaces = voArr.size();
        Hashtable sessionVars = (Hashtable)this.m_namespaceTable.get(this.m_sessionContext);
        this.m_namespaceTable = new Hashtable(numNamespaces + 1);
        this.m_namespaceTable.put(this.m_sessionContext, sessionVars);
        Enumeration e = voArr.elements();
        while (e.hasMoreElements()) {
            OiisVariableOwner vo = (OiisVariableOwner)e.nextElement();
            this.m_namespaceTable.put(vo, new Hashtable());
        }
    }

    public void bindSessionVariable(String varName, OiisAdvisedValue val) throws OiisVarSettingException {
        OiisVariable v = this.m_sessionContext.getVariable(varName);
        try {
            v.validate(val.getValue());
        }
        catch (OiifbCancelException ce) {
            ce.printStackTrace();
        }
        Hashtable ns = (Hashtable)this.m_namespaceTable.get(this.m_sessionContext);
        ns.put(v, val);
    }

    public void unbindSessionVariable(String varName) {
        OiisVariable v = this.m_sessionContext.getVariable(varName);
        Hashtable ns = (Hashtable)this.m_namespaceTable.get(this.m_sessionContext);
        ns.remove(v);
    }

    public OiisAdvisedValue getVariableBinding(OiisVariableOwner vo, OiisVariable v) {
        if (vo == null || v == null || !this.m_namespaceTable.containsKey(vo)) {
            return null;
        }
        Hashtable ns = (Hashtable)this.m_namespaceTable.get(vo);
        return (OiisAdvisedValue)ns.get(v);
    }

    protected void finalize() {
    }

    public void disposeAccessLocks() {
        if (this.m_sourceAccess != null) {
            this.m_sourceAccess.dispose();
            this.m_sourceAccess = null;
        }
    }

    public void dispose() {
        this.disposeAccessLocks();
        if (null != this.m_pgActions) {
            this.m_pgActions.dispose();
            this.m_pgActions = null;
        }
        this.m_actionsPhase = null;
        m_fileActionID = null;
        m_unixActionID = null;
        if (this.m_iter != null) {
            this.m_iter.dispose();
            this.m_iter = null;
        }
        this.m_sessionContext = null;
        this.m_depEngine = null;
        this.m_installInv = null;
        this.m_endMsgs = null;
        if (this.m_sessionPlan != null) {
            this.m_sessionPlan.dispose();
            this.m_sessionPlan = null;
        }
        this.m_IDsToComps.removeAllElements();
        this.m_IDsToPSets.clear();
        try {
            this.clearAllLibLoaders();
            for (int i = 0; i < this.m_IDsToLibLoaders.length; ++i) {
                this.m_IDsToLibLoaders[i].clear();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_IDsToComps = null;
        this.m_IDsToPSets = null;
        this.m_IDsToLibLoaders = null;
        this.m_reboot = null;
        OiiiCompIDPool.getInstance().clearPool();
        OiiiLibraryIDPool.getInstance().clearPool();
        OiixPathOps.dispose();
        OiicClusterInstallInfo.dispose();
        String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
        if (!val.equalsIgnoreCase("true")) {
            OiipgCFSDriveCheck.dispose();
        }
        if (this.m_hmBackedupTemplates != null) {
            this.m_hmBackedupTemplates.clear();
            this.m_hmBackedupTemplates = null;
        }
    }

    public void clearLibLoaders(int libType) {
        if (OiiiLibType.validType(libType)) {
            this.m_IDsToLibLoaders[libType].clear();
        }
    }

    public void clearAllLibLoaders() {
        for (int i = 0; i < this.m_IDsToLibLoaders.length; ++i) {
            int size = this.m_IDsToLibLoaders[i].size();
            Enumeration em = this.m_IDsToLibLoaders[i].keys();
            for (int j = 0; j < size; ++j) {
                OiisLibraryLoader l = (OiisLibraryLoader)this.m_IDsToLibLoaders[i].remove(em.nextElement());
                l.unload();
                l = null;
            }
        }
        System.gc();
    }

    public void setDeleteLibsCopied(boolean val) {
        this.m_bDeleteLibsCopied = val;
    }

    public void resetParams() {
        this.m_oOhLocName.clear();
        this.m_oCopiedLibs.clear();
        this.m_bInstallInProgress = true;
    }

    public void setListInstantiates(ArrayList list) {
        this.m_vInstantiates = list;
    }

    public ArrayList getListInstantiates() {
        return this.m_vInstantiates;
    }

    public void deleteUnusedOHData(String oracleHomeString) {
        Hashtable homes = this.getOhLocName();
        int nHomeCount = homes.size();
        Enumeration locs = homes.keys();
        boolean excludeHome = false;
        File[] excludeDirs = new File[2];
        if (oracleHomeString != null && oracleHomeString.length() != 0) {
            excludeDirs[0] = new File(oracleHomeString);
            String homeInv = OiixPathOps.getNativeCanonicalPath(OiixPathOps.concatPath(oracleHomeString, "inventory"));
            excludeDirs[1] = new File(homeInv);
            excludeHome = true;
        }
        for (int i = 0; i < nHomeCount; ++i) {
            String delDir;
            String[] ohInfo = (String[])homes.get(locs.nextElement());
            String OHLoc = ohInfo[0];
            if (OHLoc.equals("")) continue;
            OHLoc = OiixPathOps.getNativeForm(OHLoc);
            File dir = new File(OHLoc);
            String scratch = System.getProperty("oracle.installer.scratchPath");
            scratch = OiixPathOps.getStandardForm(scratch);
            if (excludeHome) {
                delDir = OiixPathOps.getStandardForm(OHLoc);
                if (delDir.startsWith(scratch)) continue;
                OiiolTextLogger.appendText("recdelete: " + OHLoc + " excluding: " + excludeDirs[0].getAbsolutePath() + " " + excludeDirs[1].getAbsolutePath());
                OiixFileOps.recdeleteExcludeFiles(dir, excludeDirs);
                continue;
            }
            delDir = OiixPathOps.getStandardForm(OHLoc);
            if (delDir.startsWith(scratch)) continue;
            OiiolTextLogger.appendText("recdelete: " + OHLoc);
            OiixFileOps.recdelete(dir);
        }
    }

    public void deleteUnusedLibs() {
        Hashtable entries = this.getCopiedLibs();
        int num = entries.size();
        Enumeration indices = entries.elements();
        for (int i = 0; i < num; ++i) {
            Vector libsCopied = (Vector)indices.nextElement();
            int numLibs = libsCopied.size();
            for (int j = 0; j < numLibs; ++j) {
                String libPath = (String)libsCopied.elementAt(j);
                libPath = OiixPathOps.getNativeForm(libPath);
                String scratch = System.getProperty("oracle.installer.scratchPath");
                scratch = OiixPathOps.getStandardForm(scratch);
                String delFile = OiixPathOps.getStandardForm(libPath);
                if (delFile.startsWith(scratch)) continue;
                OiiolTextLogger.appendText("deleting the library: " + libPath);
                File libToBeDel = new File(libPath);
                libToBeDel.delete();
                OiiolTextLogger.appendText("deleteParentDirs: " + libPath + "upto level" + 4);
                OiixFileOps.deleteParentDirs(libPath, 4);
            }
        }
    }

    public OiicSessionPlan getSessionPlan() {
        return this.m_sessionPlan;
    }

    public void setSessionPlan(OiicSessionPlan sessionPlan) {
        this.m_sessionPlan = sessionPlan;
    }

    public OiifmMainFrame getMainFrame() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            OiifmGraphicInterfaceManager graphicInterfaceManager = (OiifmGraphicInterfaceManager)interfaceManager;
            return graphicInterfaceManager.getMainFrame();
        }
        return null;
    }

    public OiifwWizDialog getWizardDialog() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            OiifmGraphicInterfaceManager graphicInterfaceManager = (OiifmGraphicInterfaceManager)interfaceManager;
            return graphicInterfaceManager.getWizardDialog();
        }
        return null;
    }

    public OiicNotifChecker getNotifChecker() {
        return null;
    }

    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (back) {
            return 0;
        }
        return this.m_iter.iterate(back);
    }

    public void initialize() throws OiifbEndIterateException {
        this.initialize(false);
    }

    public void initialize(boolean noBack) throws OiifbEndIterateException {
        this.initSession();
        this.loadSourceConfigs();
        Vector iterElems = this.getIterElements();
        if (this.m_availTopLevelIDs != null) {
            this.m_availTopLevelIDs.clear();
        }
        this.m_iter = new OiifbCondIterator(iterElems, noBack);
        s_cInstallFromCDStatus = (char)78;
        OiisVariable oFromLoc = this.m_sessionContext.getVariable("FROM_LOCATION");
        String sFromLoc = oFromLoc != null ? (String)oFromLoc.getValue() : null;
        this.setOldSourceLocation(sFromLoc);
    }

    public static char getInstallFromCDStatus() {
        return s_cInstallFromCDStatus;
    }

    public static void setInstallFromCDStatus(char cInstallFromCDStatus) {
        s_cInstallFromCDStatus = cInstallFromCDStatus;
    }

    public OiiiSourceAccess getSourceAccess() {
        return this.m_sourceAccess;
    }

    public OiiiTargetAreaControl getTargetAreaControl() {
        return this.m_targetAreaControl;
    }

    public OiiodDepEngine getDepEngine() {
        return this.m_depEngine;
    }

    protected void setDepEngine(OiiodDepEngine depEngine) {
        this.m_depEngine = depEngine;
    }

    public OiicSessionContext getSessionContext() {
        return this.m_sessionContext;
    }

    public Vector getAvailTopLevelCompIDs() {
        return this.m_availTopLevelIDs;
    }

    public final int getNumberOfTopLevelComps() throws NullPointerException {
        if (this.m_availTopLevelIDs == null) {
            throw new NullPointerException();
        }
        return this.m_availTopLevelIDs != null ? this.m_availTopLevelIDs.size() : 0;
    }

    public Object getSessionVarValue(String sVar) {
        if (sVar == null) {
            return null;
        }
        OiisVariable var = this.m_sessionContext.getVariable(sVar);
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public OiiiCompInstallID getSelTopLevelCompID() {
        OiisVariable var = this.m_sessionContext.getVariable("ToplevelComp");
        return (OiiiCompInstallID)var.getValue();
    }

    public void setSelTopLevelCompID(OiiiCompInstallID cid, boolean advice) {
        OiisVariable var = this.m_sessionContext.getVariable("ToplevelComp");
        try {
            var.setValue(cid, false);
            var.setAdvice(advice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OiiiCompInstallID[] getSelTopLevelCompIDs() {
        OiisVariable var = this.m_sessionContext.getVariable("ToplevelComps");
        OiiiCompInstallID[] retVal = (OiiiCompInstallID[])var.getValue();
        if (retVal == null) {
            retVal = new OiiiCompInstallID[]{this.getSelTopLevelCompID()};
        }
        return retVal;
    }

    public String getStgCompName(OiiiCompInstallID cid) {
        return this.getStgCompName(cid, true);
    }

    public String getStgCompName(OiiiCompInstallID cid, boolean platSpecific) {
        String retName = null;
        Vector plats = this.getSearchPlats(platSpecific);
        OiiiCompInvEntry scie = null;
        OiiiStageInventory stageInv = this.getStageInventory();
        if (stageInv != null) {
            scie = stageInv.getStageCompInvEntry(cid, plats);
        }
        if (scie != null) {
            retName = scie.getName();
        }
        return retName;
    }

    public String getStgCompDisplayName(OiiiCompInstallID cid) {
        return this.getStgCompDisplayName(cid, true);
    }

    public String getStgCompDisplayName(OiiiCompInstallID cid, boolean platSpecific) {
        String retName = null;
        Vector plats = this.getSearchPlats(platSpecific);
        OiiiStageCompInvEntry scie = null;
        OiiiStageInventory stageInv = this.getStageInventory();
        if (stageInv != null && (scie = stageInv.getStageCompInvEntry(cid, plats)) != null) {
            retName = scie.getFullDisplayName();
        }
        return retName;
    }

    public Vector getStgCompLangs(OiiiCompInstallID cid) {
        return this.getStgCompLangs(cid, true);
    }

    public Vector getStgCompLangs(OiiiCompInstallID cid, boolean platSpecific) {
        Vector plats = this.getSearchPlats(platSpecific);
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
        return null != scie ? scie.getLanguages() : null;
    }

    public Vector getStgCompPlats(OiiiCompInstallID cid) {
        return this.getStgCompPlats(cid, true);
    }

    public Vector getStgCompPlats(OiiiCompInstallID cid, boolean platSpecific) {
        Vector retPlats = new Vector();
        OiiiStageInventory stageInv = this.getStageInventory();
        if (platSpecific) {
            OiiiStageCompInvEntry scie = stageInv.getStageCompInvEntry(cid);
            if (scie != null) {
                OiixVectorOps.unionInPlace(retPlats, scie.getPlatforms());
            }
        } else {
            Vector scies = stageInv.getCompInvEntries(cid);
            int numEntries = null != scies ? scies.size() : 0;
            for (int i = 0; i < numEntries; ++i) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)scies.elementAt(i);
                OiixVectorOps.unionInPlace(retPlats, scie.getPlatforms());
            }
        }
        return retPlats;
    }

    private Vector getSearchPlats(boolean platSpecific) {
        return platSpecific ? OiiiAreaInventory.getCurPlatVect() : new Vector();
    }

    protected void initSessionCloneVars() {
        OiiiSessionCloneVars sessionCloneVars = this.getSessionCloneVars();
        if (null == sessionCloneVars) {
            return;
        }
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("ORACLE_HOME"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("ORACLE_HOME_NAME"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("ORACLE_HOSTNAME"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("OUI_HOSTNAME"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("UNIX_GROUP_NAME"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("CLUSTER_NODES"));
        sessionCloneVars.addVariable(this.m_sessionContext.getVariable("ORACLE_BASE"));
    }

    public String getCompDisplayName(OiiiCompInstallID cid) {
        return this.getStgCompName(cid);
    }

    public String getInstCompName(OiiiCompInstallID cid, int ohind) {
        String retName = null;
        OiiiInstallAreaControl iac = (OiiiInstallAreaControl)this.getTargetAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        OiiiInstallCompInvEntry icie = instInv.getInstallCompInvEntry(cid, ohind);
        if (icie != null) {
            retName = icie.getName();
        }
        return retName;
    }

    public String getInstCompDisplayName(OiiiCompInstallID cid) {
        String retName = null;
        OiiiCompInvEntry cie = this.m_targetAreaControl.getAreaInventory().getCompInvEntry(cid, 0);
        if (cie != null) {
            retName = cie.getFullDisplayName();
        }
        return retName;
    }

    protected String checkForPublisherConn() throws IOException {
        OiisVariable srcLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
        String stageSource = (String)srcLocVar.getValue();
        stageSource = OiixPathOps.getStandardForm(stageSource);
        if (this.isPublisherSession()) {
            this.m_pubClient = new OiigPubClient(stageSource);
            OiisVariable loginTypeVar = this.m_sessionContext.getVariable("ANONYMOUS_LOGIN");
            OiisVariable loginNameVar = this.m_sessionContext.getVariable("LOGIN_NAME");
            OiisVariable loginPwdVar = this.m_sessionContext.getVariable("PASSWORD");
            OiisVariable loginCatVar = this.m_sessionContext.getVariable("LOGIN_CATEGORY");
            try {
                String userName = "anonymous";
                String password = "";
                String category = "internal";
                boolean anonLogin = (Boolean)loginTypeVar.getValue();
                if (!anonLogin) {
                    category = (String)loginCatVar.getValue();
                    userName = (String)loginNameVar.getValue();
                    password = (String)loginPwdVar.getValue();
                }
                this.m_pubClient.logon(category, userName, password);
                stageSource = this.m_pubClient.getSubsetStgURL();
                stageSource = OiixPathOps.getStandardForm(stageSource);
                OiigAuthDetails authDets = this.m_svrCfg.getAuthDets();
                authDets.setAnonLogin(anonLogin);
                authDets.setUsername(userName);
                authDets.setPassword(password);
                authDets.setCategory(category);
            }
            catch (OiigLoginFailedException lfe) {
                lfe.printStackTrace();
                loginCatVar.setAdvice(false);
                throw new IOException("Login to publisher failed..");
            }
            catch (OiigRemoteException re) {
                re.printStackTrace();
                loginCatVar.setAdvice(false);
                throw new IOException("Login to publisher failed..");
            }
        }
        return stageSource;
    }

    public void setPublisherSession(boolean publisherSession) {
        this.m_publisherSession = publisherSession;
    }

    public boolean isPublisherSession() {
        return this.m_publisherSession;
    }

    public void setPubClient(OiigPubClient pubClient) {
        this.m_pubClient = pubClient;
    }

    public OiigPubClient getPubClient() {
        return this.m_pubClient;
    }

    public void setCurAuthCategories(Vector authCats) {
        this.m_authCats = authCats;
    }

    public Vector getCurAuthCategories() {
        return this.m_authCats;
    }

    public void setCurServerConfig(OiigServerConfig svrCfg) {
        this.m_svrCfg = svrCfg;
    }

    public OiigServerConfig getCurServerConfig() {
        return this.m_svrCfg;
    }

    public OiigSourceConfigs getSourceConfigs() {
        return this.m_srcCfgs;
    }

    public void setupSHAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException, RuntimeException {
        OiiolTextLogger.appendText("Method 'setupSHAccessObjects()' Not implemented in class '" + this.getClass().getName() + "'");
    }

    public void setupOHAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException, RuntimeException {
        OiiolTextLogger.appendText("Method 'setupOHAccessObjects()' Not implemented in class '" + this.getClass().getName() + "'");
    }

    public void setupAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        OiisVariable srcLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
        String stageSource = (String)srcLocVar.getValue();
        stageSource = OiixPathOps.getStandardForm(stageSource);
        OiixJarClassLoader.clearLoaderList();
        String tempLoc = System.getProperty("oracle.installer.scratchPath");
        OiiiSourceAccess oSourceAccess = null;
        try {
            oSourceAccess = new OiiiSourceAccess(stageSource, tempLoc, true, this.getProgressListener(), true, false, true);
            boolean bHomeStageMode = this.isCloneMode() || this.isAddNodeMode();
            oSourceAccess.setHomeStageMode(bHomeStageMode);
        }
        catch (IOException ioe) {
            String errString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_FROMLOC");
            throw new IOException(errString);
        }
        if (oSourceAccess == null) {
            String errString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_FROMLOC");
            IOException e = new IOException(errString);
            if (OiicPullSession.isDebugMode()) {
                e.printStackTrace();
            }
            throw e;
        }
        this.setSourceAccess(oSourceAccess);
        this.getSessionContext().setupGlobalVars();
    }

    protected void releaseLocks() {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        if (iac != null) {
            iac.releaseWriterLock();
            iac.releaseReaderLock();
        }
    }

    public void updateSourceConfigs() {
        OiisVariable invLocVar;
        String invLoc;
        if (this.isCloneMode()) {
            return;
        }
        if (!this.isSuppressedSource()) {
            if (this.isPublisherSession()) {
                this.m_srcCfgs.insertSvrConfig(this.m_svrCfg);
            } else {
                OiisVariable srcLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
                String stageSource = (String)srcLocVar.getValue();
                this.m_srcCfgs.insertStgArea(new OiigStgAreaInfo(stageSource));
            }
        }
        if (this.m_srcCfgs.getPersistLoc() == null && (invLoc = (String)(invLocVar = this.m_sessionContext.getVariable("INVENTORY_LOCATION")).getValue()) != null) {
            this.m_srcCfgs.setPersistLoc(this.m_srcCfgs.calcFileLoc(invLoc));
        }
        if (this.m_srcCfgs.getPersistLoc() != null) {
            try {
                this.m_srcCfgs.saveToFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void loadLibrary(String libPath) {
        System.load(libPath);
    }

    private void loadSourceConfigs() {
        block3: {
            OiisVariable invLocVar = this.m_sessionContext.getVariable("INVENTORY_LOCATION");
            String invLoc = (String)invLocVar.getValue();
            if (invLoc != null) {
                this.m_srcCfgs.setPersistLoc(this.m_srcCfgs.calcFileLoc(invLoc));
                try {
                    this.m_srcCfgs.loadFromFile();
                }
                catch (IOException ioe) {
                    if (ioe instanceof FileNotFoundException) break block3;
                    ioe.printStackTrace();
                }
            }
        }
    }

    public void setSourceTargetObjs(OiiiSourceAccess sourceAccess, OiiiTargetAreaControl targetAreaControl) throws IOException {
        this.setSourceAccess(sourceAccess);
        this.setTargetAreaControl(targetAreaControl);
    }

    public void setChosenTLComps(Vector comps) throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext sCntxt = this.getSessionContext();
        int numComps = null != comps ? comps.size() : 0;
        Object[] compIDs = new OiiiCompInstallID[numComps];
        comps.copyInto(compIDs);
        OiisVariable tlSels = sCntxt.getVariable("ToplevelComps");
        tlSels.setValue(compIDs, false);
    }

    protected void setSourceAccess(OiiiSourceAccess sourceAccess) throws IOException {
        this.m_sourceAccess = sourceAccess;
        OiiiStageInventory stageInv = this.m_sourceAccess.getStageInventory(true);
    }

    protected void setTargetAreaControl(OiiiTargetAreaControl targetAreaControl) {
        this.m_targetAreaControl = targetAreaControl;
        OiiiInstallAreaControl.setInventoryAreaControl(this.m_targetAreaControl);
    }

    public void setupTopLevelList(boolean platSpecific) throws IOException {
        OiiiStageInventory stageInv = this.getStageInventory();
        this.m_availTopLevelIDs = platSpecific ? stageInv.getTopLevelComps(0, OiixPlatform.getCurrentPlatform()) : stageInv.getTopLevelComps(0);
        int numTLComps = this.getNumberOfTopLevelComps();
        if (numTLComps == 0) {
            Object[] msgArr = new String[]{OiixPlatform.getPlatformName(OiixPlatform.getCurrentPlatform())};
            String errString = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_STAGE"), msgArr);
            throw new IOException(errString);
        }
        int i = 0;
        OiiiVersion oVersion = null;
        while (i < numTLComps) {
            OiiiVersion oInstVer;
            OiiiCompInstallID cid = (OiiiCompInstallID)this.m_availTopLevelIDs.elementAt(i);
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)stageInv.getCompInvEntry(cid, 0);
            if (scie.isStageVersionPostX((oInstVer = OiicInstaller.getInstallerVersion()).getVerString())) {
                this.m_availTopLevelIDs.removeElementAt(i);
                OiiiVersion oVer = scie.getInstallerVersion(OiixPlatform.getCurrentPlatform(), oInstVer);
                OiiiVersion oStgVer = scie.getStageVersion();
                OiiiVersion oiiiVersion = oVer = oStgVer.laterThan(oVer) ? oStgVer : oVer;
                if (null != oVersion && !oVersion.laterThan(oVer)) continue;
                oVersion = oVer;
                continue;
            }
            ++i;
        }
        Enumeration stagedcomps = null;
        this.m_bFailedForStgVersionChk = true;
        stagedcomps = platSpecific ? stageInv.getAllComps(0, OiixPlatform.getCurrentPlatform()) : stageInv.getAllComps(0);
        if (null != stagedcomps) {
            int j = 0;
            while (stagedcomps.hasMoreElements()) {
                OiiiVersion oInstVer_forStagedComps;
                OiiiStageCompInvEntry scie_forStagedComps = (OiiiStageCompInvEntry)stagedcomps.nextElement();
                if (scie_forStagedComps.isStageVersionPreX((oInstVer_forStagedComps = OiicInstVersion.getCompatibleInstallerVersion()).getVerString())) {
                    Object[] msgArr = new String[]{oInstVer_forStagedComps.getVerString()};
                    String errString = MessageFormat.format(OiixResourceBundle.getString("OUI-5005"), msgArr);
                    this.m_bFailedForStgVersionChk = false;
                    throw new IOException(errString);
                }
                ++j;
            }
        }
        OiisVariable topLevel = this.m_sessionContext.getVariable("ToplevelComp");
        OiisVariable topLevelIDs = this.m_sessionContext.getVariable("ToplevelComps");
        OiisVariable topLevelRespVar = this.m_sessionContext.getVariable("TOPLEVEL_COMPONENT");
        OiiiCompInstallID[] chosenIDs = this.getCompIDValueForToplevel(topLevelRespVar.getValue());
        OiiiCompInstallID chosenID = null;
        if (chosenIDs != null && chosenIDs.length > 0) {
            chosenID = chosenIDs[0];
        }
        boolean bForce = topLevelRespVar.getAdvice();
        OiisVariable oLang = this.m_sessionContext.getVariable("SELECTED_LANGUAGES");
        OiisVariable oLangResp = this.m_sessionContext.getVariable("COMPONENT_LANGUAGES");
        Object vLangs = null;
        String[] strList = null;
        try {
            topLevel.setValue(chosenID, true);
            topLevel.setAdvice(bForce);
            topLevelIDs.setValue(chosenIDs, true);
            topLevelIDs.setAdvice(bForce);
            if (!oLangResp.getAdvice()) {
                oLangResp.setVariable(chosenID);
            }
            if (oLangResp.getValue() != null && oLangResp.getValue() instanceof String[]) {
                boolean bEng = false;
                String[] strArr = (String[])oLangResp.getValue();
                for (int j = 0; j < strArr.length; ++j) {
                    if (!strArr[j].equals(OiixLanguage.ENGLISH.toString())) continue;
                    bEng = true;
                    break;
                }
                if (!bEng) {
                    if (!OiicPullSession.isLangAddonMode()) {
                        String[] strArrCp = new String[strArr.length + 1];
                        System.arraycopy(strArr, 0, strArrCp, 0, strArr.length);
                        strArrCp[strArr.length] = OiixLanguage.ENGLISH.toString();
                        oLang.setValue(strArrCp, true);
                    }
                } else if (!OiicPullSession.isLangAddonMode()) {
                    oLang.setValue(oLangResp.getValue(), true);
                }
            }
            if (!OiicPullSession.isLangAddonMode()) {
                oLang.setAdvice(oLangResp.getAdvice());
            }
        }
        catch (OiisVarSettingException e) {
        }
        catch (OiifbCancelException ce) {
        }
        catch (OiifbEndIterateException ce) {
            // empty catch block
        }
        if (!topLevel.getAdvice() && numTLComps == 1) {
            chosenID = (OiiiCompInstallID)this.m_availTopLevelIDs.elementAt(0);
            try {
                topLevel.setValue(chosenID, true);
                topLevel.setAdvice(true);
            }
            catch (OiisVarSettingException e) {
            }
            catch (OiifbCancelException ce) {
                // empty catch block
            }
        }
        if (chosenID == null) {
            if (topLevel.getAdvice()) {
                chosenID = (OiiiCompInstallID)topLevel.getValue();
            }
            if (chosenID == null) {
                chosenID = (OiiiCompInstallID)this.m_availTopLevelIDs.firstElement();
                try {
                    topLevel.setValue(new OiisAdvisedValue(chosenID, false), true);
                }
                catch (OiisVarSettingException vse) {
                    vse.printStackTrace();
                }
                catch (OiifbCancelException ce) {
                    ce.printStackTrace();
                }
            }
        }
        if (!oLang.getAdvice()) {
            try {
                strList = this.getDefaultLanguageSelection(chosenID);
                oLang.setValue(strList, true);
                oLang.setAdvice((this.isAPIMode() || OiicPullSession.isSilentMode()) && !OiicPullSession.isLangAddonMode());
            }
            catch (OiisVarSettingException e) {
            }
            catch (OiifbCancelException ce) {
                // empty catch block
            }
        }
        if (!OiicPullSession.isLangAddonMode() && topLevel.getAdvice()) {
            boolean bAddDefLocale = Boolean.getBoolean("oracle.installer.defaultifyLanguages");
            OiiolTextLogger.appendText("DefaultifyLangiages : Value of oracle.installer.defaultifyLanguages : " + bAddDefLocale);
            if (bAddDefLocale) {
                this.setDefaultLocale(oLang, chosenID);
            }
        }
    }

    private void setDefaultLocale(OiisVariable selLangs, OiiiCompInstallID selectedCompId) {
        Vector langs = this.getStgCompLangs(selectedCompId);
        Locale l = Locale.getDefault();
        if (langs != null && selLangs.getValue() != null && selLangs.getValue() instanceof String[]) {
            int nIndex;
            String[] strArr = (String[])selLangs.getValue();
            boolean bDef = false;
            for (int j = 0; j < strArr.length; ++j) {
                if (!strArr[j].equals(l.toString())) continue;
                bDef = true;
            }
            if (!bDef && (nIndex = OiixVectorOps.vectIndexOf(langs, (Object)l)) != -1) {
                String[] strArrCp = new String[strArr.length + 1];
                System.arraycopy(strArr, 0, strArrCp, 0, strArr.length);
                strArrCp[strArr.length] = l.toString();
                try {
                    OiiolTextLogger.appendText("DefaultifyLocale : Adding def local :" + l.toString());
                    selLangs.setValue(OiixLanguage.getUpdatedLangs23(strArrCp), true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            selLangs.setAdvice(true);
        }
    }

    public String[] getDefaultLanguageSelection(OiiiCompInstallID selectedCompId) {
        Vector langs = this.getStgCompLangs(selectedCompId);
        Locale l = Locale.getDefault();
        Vector vLangs = new Vector();
        if (langs != null) {
            boolean bIsLangAddon = OiicPullSession.isLangAddonMode();
            int nIndex = OiixVectorOps.vectIndexOf(langs, (Object)l);
            if (nIndex != -1 && !bIsLangAddon) {
                vLangs.addElement(langs.elementAt(nIndex));
            }
            if ((nIndex = OiixVectorOps.vectIndexOf(vLangs, (Object)OiixLanguage.ENGLISH)) == -1 && !bIsLangAddon) {
                vLangs.addElement(OiixLanguage.ENGLISH);
            }
        }
        String[] strList = OiixLanguage.getStringArray(vLangs);
        return strList;
    }

    public OiiiCompInstallID[] getCompIDValueForToplevel(Object oValue) {
        String[] sArray = null;
        if (!(oValue instanceof String[])) {
            return null;
        }
        sArray = (String[])oValue;
        Vector<OiiiCompInstallID> vSelComps = new Vector<OiiiCompInstallID>();
        for (int i = 0; i < sArray.length; i += 2) {
            String[] arr;
            OiiiCompInstallID id;
            Vector allComps = this.m_availTopLevelIDs;
            int nSize = allComps.size();
            int j = 0;
            for (j = 0; j < nSize; ++j) {
                OiiiCompInstallID id2 = (OiiiCompInstallID)allComps.elementAt(j);
                OiiiVersion oVersion = new OiiiVersion(sArray[i + 1]);
                if (!sArray[i].equalsIgnoreCase(id2.getName()) || !oVersion.equals(id2.getVersion())) continue;
                vSelComps.addElement(id2);
                break;
            }
            if (j != nSize || (id = this.getCompIDValue(arr = new String[]{sArray[i], sArray[i + 1]})) == null || id.getCompType() != 2) continue;
            vSelComps.addElement(id);
        }
        if (vSelComps.size() > 0) {
            int nSize = vSelComps.size();
            Object[] ids = new OiiiCompInstallID[nSize];
            vSelComps.copyInto(ids);
            return ids;
        }
        return null;
    }

    public OiiiCompInstallID getCompIDValue(Object oValue) {
        String[] sArray = null;
        if (!(oValue instanceof String[])) {
            return null;
        }
        sArray = (String[])oValue;
        Enumeration e = this.getStageInventory().getAllComps(0);
        while (e.hasMoreElements()) {
            OiiiCompInvEntry invEntry = (OiiiCompInvEntry)e.nextElement();
            OiiiCompInstallID id = invEntry.getCompInstallID();
            OiiiVersion oVersion = new OiiiVersion(sArray[1]);
            if (!sArray[0].equalsIgnoreCase(id.getName()) || !oVersion.equals(id.getVersion())) continue;
            return id;
        }
        return null;
    }

    private Vector getLangsSelValue(Object oValue) {
        String[] origVal = null;
        Vector<Locale> v = null;
        if (!(oValue instanceof String[])) {
            return v;
        }
        origVal = (String[])oValue;
        v = new Vector<Locale>();
        for (int i = 0; i < origVal.length; ++i) {
            int nIndex = origVal[i].indexOf(95);
            Locale l = null;
            if (nIndex != -1) {
                String sLang = origVal[i].substring(0, nIndex);
                String sCountry = origVal[i].substring(nIndex + 1, origVal[i].length());
                l = new Locale(sLang, sCountry);
            } else {
                l = new Locale(origVal[i], "");
            }
            v.addElement(l);
        }
        return v;
    }

    public void setInventoryLocation(String locationFileLoc) {
        if (locationFileLoc != null) {
            OiisVariable invLoc = this.m_sessionContext.getVariable("INVENTORY_LOCATION");
            OiisVariable grpName = this.m_sessionContext.getVariable("UNIX_GROUP_NAME");
            try {
                invLoc.setValue(locationFileLoc, true);
                grpName.setValue(" ", false);
                invLoc.setAdvice(true);
                grpName.setAdvice(true);
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
            }
        }
    }

    public void setSessionMode(String mode) {
        if (mode != null && (mode.equals("Install") || mode.equals("Clone") || mode.equals("AddNode"))) {
            OiisVariable sm = this.m_sessionContext.getVariable("SESSION_MODE");
            try {
                sm.setValue(mode, true);
                sm.setAdvice(true);
                if (mode.equals("Clone")) {
                    s_bCloneMode = OiixUtilityOps.booleanValueOf(true);
                    s_bInstallMode = OiixUtilityOps.booleanValueOf(false);
                    s_bAddNodeMode = OiixUtilityOps.booleanValueOf(false);
                } else if (mode.equals("AddNode")) {
                    s_bCloneMode = OiixUtilityOps.booleanValueOf(false);
                    s_bInstallMode = OiixUtilityOps.booleanValueOf(false);
                    s_bAddNodeMode = OiixUtilityOps.booleanValueOf(true);
                } else {
                    s_bCloneMode = OiixUtilityOps.booleanValueOf(false);
                    s_bInstallMode = OiixUtilityOps.booleanValueOf(true);
                    s_bAddNodeMode = OiixUtilityOps.booleanValueOf(false);
                }
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
            }
        }
    }

    public boolean isCloneMode() {
        if (s_bCloneMode == null) {
            String sm = (String)this.getSessionVarValue("SESSION_MODE");
            boolean v_bCloneMode = null != sm && sm.equals("Clone");
            s_bCloneMode = OiixUtilityOps.booleanValueOf(v_bCloneMode);
        }
        return s_bCloneMode;
    }

    public boolean isAPIMode() {
        return System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
    }

    public boolean isInstallMode() {
        if (s_bInstallMode == null) {
            String sm = (String)this.getSessionVarValue("SESSION_MODE");
            boolean v_bInstallMode = null != sm && sm.equals("Install");
            s_bInstallMode = OiixUtilityOps.booleanValueOf(v_bInstallMode);
        }
        return s_bInstallMode;
    }

    public String getFromLocation() {
        String sm = (String)this.getSessionVarValue("FROM_LOCATION");
        return sm;
    }

    public boolean isAddNodeMode() {
        if (s_bAddNodeMode == null) {
            String sm = (String)this.getSessionVarValue("SESSION_MODE");
            s_bAddNodeMode = null != sm && sm.equals("AddNode") ? OiixUtilityOps.booleanValueOf(true) : OiixUtilityOps.booleanValueOf(false);
        }
        return s_bAddNodeMode;
    }

    public boolean isDeinstallMode() {
        return false;
    }

    public boolean isInstRootSHNeeded() {
        return this.m_bInstRootSHNeeded;
    }

    public void setInstRootSHNeeded(boolean bInstRootSHNeeded) {
        this.m_bInstRootSHNeeded = bInstRootSHNeeded;
    }

    public OiixProgressListener getProgressListener() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        return interfaceManager.getProgressListener();
    }

    public abstract void initSession() throws OiifbEndIterateException;

    public abstract Vector getIterElements();

    public static void setRecordModeFileName(String sFile) {
        m_sRecordModeFileName = sFile;
    }

    public static String getRecordModeFileName() {
        return m_sRecordModeFileName;
    }

    public static String getRecordModeResponseFileLocation() {
        return OiixPathOps.getParentDir(OiixPathOps.getStandardForm(m_sRecordModeFileName));
    }

    public static boolean isRecordMode() {
        String fileName = System.getProperty("oracle.installer.destinationFile");
        m_bRecordMode = OiixUtilityOps.booleanValueOf(true);
        if (fileName != null && fileName.length() > 0) {
            try {
                fileName = OiixPathOps.getCanonicalPath(fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            OiicPullSession.setRecordModeFileName(fileName);
            OiiolTextLogger.appendText("User provided destination file name is " + fileName);
        }
        return m_bRecordMode;
    }

    public String getDefaultRecordRespFile() {
        String sDefaultRecordFileName = null;
        OiicSessionContext oContext = this.getSessionContext();
        String oHome = (String)this.getSessionVarValue("ORACLE_HOME");
        String installType = (String)this.getSessionVarValue("INSTALL_TYPE");
        String topLevelComp = this.getSelTopLevelCompID().getName();
        if (null != oHome && null != installType && null != topLevelComp) {
            sDefaultRecordFileName = OiixPathOps.concatPath(oHome, this.DEFAULT_RECORD_FILE_DIR);
            sDefaultRecordFileName = sDefaultRecordFileName + File.separator + topLevelComp + "_" + installType + this.RESP_FILE_EXTN;
            OiiolTextLogger.appendText("The default response file generated with recorded values is " + sDefaultRecordFileName, OiiolTextLogger.LOG_TRACE);
        }
        return sDefaultRecordFileName;
    }

    public static void setRecordMode(boolean record) {
        m_bRecordMode = OiixUtilityOps.booleanValueOf(record);
    }

    public static boolean isSilentMode() {
        if (m_silentMode == null) {
            String silentMode = System.getProperty("oracle.installer.silent", "false");
            boolean v_bSilentMode = silentMode.equals("true");
            m_silentMode = OiixUtilityOps.booleanValueOf(v_bSilentMode);
        }
        return m_silentMode;
    }

    public static int getSessionType() {
        String sesTypeStr = System.getProperty("oracle.installer.sessionType");
        return sesTypeStr.equalsIgnoreCase("DeInstall") ? 2 : 1;
    }

    public void onBackIntoLocations() {
        this.m_bLockGrabbed = false;
        if (this.m_targetAreaControl != null) {
            this.m_targetAreaControl.releaseWriterLock();
        }
        this.disposeAccessLocks();
        OiiiStageInventory stageInv = this.getStageInventory();
        if (stageInv != null) {
            stageInv.dispose();
        }
        this.setPublisherSession(false);
        OiicClusterInstallInfo.dispose();
        this.clearCompTable();
        this.clearPSetsTable();
        for (int i = 0; i < this.m_IDsToLibLoaders.length; ++i) {
            this.m_IDsToLibLoaders[i].clear();
        }
        OiixPathOps.dispose();
        String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
        if (!val.equalsIgnoreCase("true")) {
            OiipgCFSDriveCheck.dispose();
        }
    }

    public void refreshOHFiles() {
        this.clearAllLibLoaders();
        this.deleteUnusedLibs();
        this.m_oCopiedLibs.clear();
    }

    public boolean isSuppressedSource() {
        return this.m_bSuppressedSource;
    }

    public void setSelectedLanguages(Vector vLangs) {
        Vector vComps = this.getStageInventory().getAllCompsVect(0);
        int nComps = null != vComps ? vComps.size() : 0;
        for (int i = 0; i < nComps; ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)vComps.elementAt(i);
            cie.setSelectedLanguages(vLangs);
        }
    }

    public static void setRegistrationKey(String sRegistrationKey) {
        m_sRegistrationKey = sRegistrationKey;
    }

    public static String getRegistrationKey() {
        return m_sRegistrationKey;
    }

    public void setVolumeInfo(Vector vVolumes) {
        this.m_vVolumes = vVolumes;
    }

    public Vector getVolumeInfo() {
        return this.m_vVolumes;
    }

    public static boolean isDebugMode() {
        if (m_bDebugMode == null) {
            m_bDebugMode = new Boolean(Boolean.getBoolean("oracle.installer.debug"));
        }
        return m_bDebugMode;
    }

    public void registerFile(String sFilePath, OiiiCompInstallID cid) {
    }

    public void deregisterFile(String sFilePath, OiiiCompInstallID cid) {
    }

    public void setOHIndex(int ohIndex) {
        this.m_ohIndex = ohIndex;
    }

    public int getOHIndex() {
        return this.m_ohIndex;
    }

    public void setAppltopIndex(int appltopIndex) {
        this.m_appltopIndex = appltopIndex;
    }

    public int getAppltopIndex() {
        return this.m_appltopIndex;
    }

    public int getHomeIndex(OiiiCompInstallID oCompId) {
        int nHomeIndex = this.getOHIndex();
        int nHomeType = oCompId.getHomeType();
        switch (nHomeType) {
            case 1: 
            case 2: {
                nHomeIndex = this.getOHIndex();
                break;
            }
            case 0: {
                nHomeIndex = 0;
                break;
            }
            case 3: {
                nHomeIndex = this.getAppltopIndex();
            }
        }
        return nHomeIndex;
    }

    private String getHomePathFor(OiiiCompInstallID cid) {
        String sHomePath = null;
        OiiiInstallAreaControl iac = (OiiiInstallAreaControl)this.getTargetAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        if (cid.isOracleHomeComp()) {
            sHomePath = instInv.getHomeLocation(this.getOHIndex());
        } else if (cid.isAppltopComponent()) {
            sHomePath = instInv.getHomeLocation(this.getAppltopIndex());
        } else if (cid.isNOHComp()) {
            sHomePath = iac.getAreaRoot();
        }
        return sHomePath;
    }

    public OiipgActionsPhase getPgActionsPhase() {
        return this.m_pgActions;
    }

    public Vector getEndMsgs() {
        return this.m_endMsgs;
    }

    protected String getEndMsgsText() {
        Vector v = this.getEndMsgs();
        StringBuffer msg = new StringBuffer();
        String sLineSep = System.getProperty("line.separator");
        int nMsgCnt = v.size();
        for (int i = 0; i < nMsgCnt; ++i) {
            String nextStr = (String)v.elementAt(i);
            if (nextStr == null || nextStr.length() <= 0) continue;
            msg.append(nextStr);
            msg.append(sLineSep);
        }
        return msg.toString();
    }

    protected String getReadmeLoc() {
        String sOracleHome = (String)this.getSessionVarValue("ORACLE_HOME");
        return OiixPathOps.concatPath(sOracleHome, INSTALL_README_LOC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveEndOfInstallMessages() {
        String sInstallReadmeLoc = this.getReadmeLoc();
        String sEndMsgs = this.getEndMsgsText();
        if (null != sEndMsgs && sEndMsgs.length() > 0) {
            BufferedWriter bw = null;
            try {
                OiixFileOps.mkdirs(new File(sInstallReadmeLoc).getParentFile());
                bw = new BufferedWriter(new FileWriter(sInstallReadmeLoc));
                bw.write(sEndMsgs);
                this.m_bInstallReadmeSaved = true;
            }
            catch (IOException e) {
                this.m_bInstallReadmeSaved = false;
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEndOfInstallMessages() throws IOException {
        String sInstallReadmeLoc = this.getReadmeLoc();
        StringBuffer sEndMsgs = new StringBuffer();
        String sLineSep = System.getProperty("line.separator");
        BufferedReader br = null;
        IOException ex = null;
        try {
            br = new BufferedReader(new FileReader(sInstallReadmeLoc));
            String sMsg = null;
            while ((sMsg = br.readLine()) != null) {
                sEndMsgs.append(sMsg);
                sEndMsgs.append(sLineSep);
            }
        }
        catch (IOException e) {
            ex = e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        if (ex != null) {
            throw ex;
        }
        return sEndMsgs.toString();
    }

    public boolean allPatchSets() {
        boolean bAllPatchsets = true;
        Vector compIDs = this.getAvailTopLevelCompIDs();
        int size = compIDs != null ? compIDs.size() : 0;
        for (int i = 0; i < size; ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)compIDs.elementAt(i);
            if (id.getCompType() == 4) continue;
            bAllPatchsets = false;
            break;
        }
        return size > 0 ? bAllPatchsets : false;
    }

    public String getEndOfInstallMessages() {
        String sEndMsgs = null;
        this.m_bInstallReadmeSaved = true;
        if (true) {
            try {
                sEndMsgs = this.readEndOfInstallMessages();
            }
            catch (IOException e) {
                sEndMsgs = null;
            }
        }
        if (sEndMsgs == null) {
            sEndMsgs = this.getEndMsgsText();
        }
        return sEndMsgs;
    }

    public OiifwActionsPhaseWCDE getActionsPhaseWCDE() {
        return this.m_actionsPhase;
    }

    public void setActionsPhaseWCDE(OiifwActionsPhaseWCDE iap) {
        this.m_actionsPhase = iap;
    }

    public OiicInstPostActionsPhase getInstPostActionsPhase() {
        return this.m_instPostActionsPhase;
    }

    public void setInstPostActionsPhase(OiicInstPostActionsPhase instPostActionsPhase) {
        this.m_instPostActionsPhase = instPostActionsPhase;
    }

    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
    }

    public OiiiInstallAreaControl getInstallAreaControl() {
        return (OiiiInstallAreaControl)this.getTargetAreaControl();
    }

    protected OiiiStageInventory getStageInventory() {
        OiiiStageInventory stageInv = null;
        if (this.m_sourceAccess != null) {
            stageInv = this.m_sourceAccess.getStageInventory();
        }
        return stageInv;
    }

    public void prefetchComponentJars() throws IOException {
        OiiiStageInventory stageInv = this.m_sourceAccess.getStageInventory();
        Vector compsInfo = stageInv.getAllCompsVect(0);
        int vectSize = compsInfo.size();
        int iToPreLoad = 0;
        Hashtable<OiisCompInstallation, OiisCompInstallation> compsToLoad = new Hashtable<OiisCompInstallation, OiisCompInstallation>(vectSize);
        long lStartPrefetch = System.currentTimeMillis();
        int nTotalProgSize = vectSize * 5;
        OiixProgressListener progListener = this.getProgressListener();
        if (progListener != null) {
            progListener.setTotalBytes(nTotalProgSize);
            progListener.setTitle(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STGINV_PROG_TITLE"));
            progListener.addBytes(vectSize * 2);
            progListener.setStatus(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STGINV_PROD_PROG_MSG"));
        }
        int i = 0;
        while (i < vectSize) {
            OiiiCompInstallID id;
            int iCompType;
            OiisCompJarInfo oJarInfo;
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)compsInfo.elementAt(i);
            OiisCompProperties oProp = scie.getCompProperties();
            if (oProp != null && (oJarInfo = oProp.getCompJarInfo()) != null) {
                oJarInfo.disposeForInstall();
            }
            if ((iCompType = (id = scie.getCompInstallID()).getCompType()) != 4) {
                OiisCompInstallation compInstall = this.getCompInstall(scie);
                if (compInstall != null) {
                    if (null != progListener) {
                        progListener.addBytes(1);
                    }
                    if (iCompType == 1 && !compsToLoad.containsKey(compInstall)) {
                        compsToLoad.put(compInstall, compInstall);
                    }
                    compInstall.setDiskNumber(scie.getDiskNumber());
                    compInstall.setStageCompInvEntry(scie);
                    ++i;
                    continue;
                }
                compsInfo.removeElement(scie);
                --vectSize;
                continue;
            }
            ++i;
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("Time for Prefetching jars ", System.currentTimeMillis() - lStartPrefetch);
        }
        iToPreLoad = compsToLoad.size();
        CompInit cInit = new CompInit(iToPreLoad, null);
        CompLoader cLdr = new CompLoader(iToPreLoad, cInit);
        int nComps = this.m_IDsToComps.size();
        for (i = 0; i < nComps; ++i) {
            OiisCompInstallation ci = (OiisCompInstallation)this.m_IDsToComps.elementAt(i);
            if (ci.getCompInstallID().getCompType() != 1) continue;
            cLdr.addCompToLoad(ci);
        }
        Thread ldrThread = new Thread(cLdr);
        Thread initThread = new Thread(cInit);
        ldrThread.start();
        initThread.start();
        try {
            initThread.join();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public synchronized OiisCompInstallation getCompInstall(OiiiStageCompInvEntry scie, boolean bThrow) throws OiifbCancelException {
        OiisCompInstallation os = null;
        if (scie != null) {
            OiiiCompInstallID cid = scie.getCompInstallID();
            Vector plats = scie.getPlatforms();
            if (plats.indexOf(new Integer(OiixPlatform.getCurrentPlatform())) == -1) {
                return null;
            }
            if (scie.isStageVersionPostX(OiicBaseApp.getInstallerVersion().toString())) {
                return null;
            }
            os = this.getCompInstallEntry(cid);
            if (os == null) {
                try {
                    os = OiisStagedCompHelper.createCompInstall(scie, this.m_sourceAccess, this.m_sessionContext);
                    os.setSession(this);
                    this.m_IDsToComps.addElement(os);
                }
                catch (Exception e) {
                    if (e instanceof OiifbCancelException) {
                        throw (OiifbCancelException)e;
                    }
                    System.err.println("Error in loading component installation for: " + scie);
                }
            }
        }
        return os;
    }

    public synchronized OiisCompInstallation getCompInstall(OiiiCompInstallID cid) {
        OiiiStageInventory stageInv = this.getStageInventory();
        if (stageInv == null) {
            return null;
        }
        OiiiStageCompInvEntry scie = stageInv.getStageCompInvEntry(cid);
        return this.getCompInstall(scie);
    }

    public synchronized OiisCompInstallation getCompInstall(OiiiStageCompInvEntry scie) {
        try {
            return this.getCompInstall(scie, true);
        }
        catch (OiifbCancelException ex) {
            return null;
        }
    }

    public void disposeUnusedCompInstalls() {
        Vector vCompsToInstall = this.m_depEngine.getCompsToInstall();
        int nSize = vCompsToInstall.size();
        Vector finalCompList = new Vector(nSize);
        int prevSize = this.m_IDsToComps.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)vCompsToInstall.elementAt(i);
            int idx = OiixVectorOps.vectIndexOf(this.m_IDsToComps, (Object)id);
            if (idx == -1) continue;
            finalCompList.addElement(this.m_IDsToComps.elementAt(idx));
            this.m_IDsToComps.removeElementAt(idx);
        }
        nSize = this.m_IDsToComps.size();
        Object[] compArray = new OiisCompInstallation[nSize];
        this.m_IDsToComps.copyInto(compArray);
        this.m_IDsToComps.removeAllElements();
        for (int i = 0; i < nSize; ++i) {
            if (compArray[i] != null) {
                ((OiisCompInstallation)compArray[i]).dispose();
            }
            compArray[i] = null;
        }
        this.m_IDsToComps = finalCompList;
    }

    private OiisCompInstallation getCompInstallEntry(OiiiCompInstallID cid) {
        int size = this.m_IDsToComps.size();
        int curPlat = OiixPlatform.getCurrentPlatform();
        if (cid != null) {
            for (int i = 0; i < size; ++i) {
                OiisCompInstallation os = (OiisCompInstallation)this.m_IDsToComps.elementAt(i);
                if (!os.getCompInstallID().equalsNoPlat(cid, curPlat)) continue;
                return os;
            }
        }
        return null;
    }

    public synchronized OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid, boolean bThrow) throws OiifbCancelException {
        if (!this.m_IDsToPSets.containsKey(psid)) {
            OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(psid);
            if (scie != null) {
                try {
                    OiisPatchSetInstallation psi = OiisStagedCompHelper.createPatchSetInstall(scie, this.m_sourceAccess);
                    psi.setSession(this);
                    this.m_IDsToPSets.put(psid, psi);
                }
                catch (Exception e) {
                    System.err.println("Error in loading patch set installation..");
                    return null;
                }
            } else {
                return null;
            }
        }
        return (OiisPatchSetInstallation)this.m_IDsToPSets.get(psid);
    }

    public synchronized OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid) {
        if (!this.m_IDsToPSets.containsKey(psid)) {
            try {
                return this.getPSetInstall(psid, true);
            }
            catch (OiifbCancelException ex) {
                return null;
            }
        }
        return (OiisPatchSetInstallation)this.m_IDsToPSets.get(psid);
    }

    public void clearCompTable() {
        Enumeration enum_1 = this.m_IDsToComps.elements();
        while (enum_1.hasMoreElements()) {
            OiisCompInstallation oCompInstall = (OiisCompInstallation)enum_1.nextElement();
            OiisCompJarLoader loader = oCompInstall.getCompJarLoader();
            if (loader == null) continue;
            OiixJarClassLoader.forgetLoader(loader.getJarLoc());
        }
        this.m_IDsToComps = new Vector();
    }

    public Vector getCompInstallVector() {
        return this.m_IDsToComps;
    }

    public void clearPSetsTable() {
        Enumeration enum_1 = this.m_IDsToPSets.elements();
        while (enum_1.hasMoreElements()) {
            OiisPatchSetInstallation oPSetInstall = (OiisPatchSetInstallation)enum_1.nextElement();
            OiisCompJarLoader loader = oPSetInstall.getCompJarLoader();
            if (loader == null) continue;
            OiixJarClassLoader.forgetLoader(loader.getJarLoc());
        }
        this.m_IDsToPSets = new Hashtable();
    }

    public OiisLibraryLoader getLibLoader(OiiiLibraryID lid, int libType, int homeIndex) throws IOException, OiifbCancelException {
        OiiiLibInvEntry localLib;
        OiiiInstallAreaControl installAreaControl = this.getInstallAreaControl();
        lid.optimizePlatList();
        OiisLibraryLoader lLoader = null;
        if (this.m_installInv != null && (localLib = this.m_installInv.getCompatLibInvEntry(lid, libType, homeIndex)) != null) {
            OiiiLibraryID newLID = localLib.getLibraryID();
            if (this.m_IDsToLibLoaders[libType].containsKey(newLID)) {
                OiisLibraryLoader loader = (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(newLID);
                return loader;
            }
            String relativeFileLoc = localLib.getLocation();
            String sInvDir = installAreaControl.getInventoryLocForHome(homeIndex);
            String localFileLoc = OiixPathOps.concatPath(sInvDir, relativeFileLoc);
            try {
                switch (libType) {
                    case 0: {
                        lLoader = new OiisActionLibLoader(localFileLoc);
                        break;
                    }
                    case 1: {
                        lLoader = new OiisQueryLibLoader(localFileLoc);
                        break;
                    }
                    case 2: {
                        lLoader = new OiisDialogLibLoader(localFileLoc);
                    }
                }
            }
            catch (IOException ioe) {
                lLoader = null;
            }
            if (lLoader != null) {
                this.m_IDsToLibLoaders[libType].put(newLID, lLoader);
            }
        }
        return lLoader;
    }

    public OiisActionLibLoader getActionLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException, OiifbCancelException {
        return (OiisActionLibLoader)this.getLibLoader(lid, 0, homeIndex);
    }

    public OiisQueryLibLoader getQueryLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException, OiifbCancelException {
        return (OiisQueryLibLoader)this.getLibLoader(lid, 1, homeIndex);
    }

    public OiisDialogLibLoader getDialogLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException, OiifbCancelException {
        return (OiisDialogLibLoader)this.getLibLoader(lid, 2, homeIndex);
    }

    public boolean inRollbackMode() {
        return false;
    }

    public void setSuccessfullInstallation(boolean bSucess) {
        this.m_bSuccessDefault = false;
        this.m_bSuccessfulInstallation = bSucess;
        this.updateExitCode();
    }

    public boolean isSuccessfullInstallation() {
        return this.m_bSuccessfulInstallation;
    }

    public boolean isSuccessfullRemoteInstallation() {
        return this.isRemoteOperationSuccessful();
    }

    public void setSuccessfulOptionalTools(boolean bSuccess) {
        this.m_bSuccessfulOptionalTools = bSuccess;
        this.updateExitCode();
    }

    public void setSuccessfulRecommendedTools(boolean bSuccess) {
        this.m_bSuccessfulRecommendedTools = bSuccess;
        this.updateExitCode();
    }

    public boolean isSuccessDefaulted() {
        return this.m_bSuccessDefault;
    }

    private void updateExitCode() {
        if (this.m_bSuccessfulInstallation && this.m_bSuccessfulOptionalTools && m_bRemoteOperationSuccess && this.m_bSuccessfulRecommendedTools) {
            OiicExitCode.setExitCode(0);
        } else if (this.m_bSuccessfulInstallation && !this.m_bSuccessfulOptionalTools) {
            OiicExitCode.setExitCode(1);
        } else if (this.m_bSuccessfulInstallation && !this.m_bSuccessfulRecommendedTools) {
            OiicExitCode.setExitCode(3);
        } else if (this.m_bSuccessfulInstallation && !m_bRemoteOperationSuccess) {
            OiicExitCode.setExitCode(2);
        } else {
            OiicExitCode.setExitCode(-1);
        }
    }

    public boolean isSuccessfulOptionalTools() {
        return this.m_bSuccessfulOptionalTools;
    }

    public boolean isSuccessfulRecommendedTools() {
        return this.m_bSuccessfulRecommendedTools;
    }

    public boolean isRebootInfoSet() {
        return this.m_reboot != null;
    }

    public void addRebootInfo(String sMessage, String sCommandLine, OiiiCompInstallID compID, int nLaunch) {
        if (this.m_reboot == null) {
            this.m_reboot = new OiicInstallReboot(sMessage, sCommandLine, compID.getName(), nLaunch);
            this.m_reboot.setInstallSession(this);
        } else {
            this.m_reboot.addRebootInformation(sCommandLine, compID.getName(), nLaunch);
        }
    }

    public OiicInstallReboot getRebootInfo() {
        return this.m_reboot;
    }

    public Vector getOnRebootExitTools() {
        return this.m_vOnRebootExitTools;
    }

    public void setOnRebootExitTools(Vector vExitTools) {
        this.m_vOnRebootExitTools = vExitTools;
    }

    private void readOnRebootExitConfigTools() {
        String sExitToolsLoc = System.getProperty("oracle.installer.exit_config_loc");
        if (sExitToolsLoc != null && sExitToolsLoc.length() > 0) {
            File f = new File(sExitToolsLoc);
            try {
                this.m_vOnRebootExitTools = new Vector();
                FileReader fr = new FileReader(f);
                LineNumberReader lnr = new LineNumberReader(fr);
                String sCommand = null;
                Object[] args = new Object[]{sExitToolsLoc};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REBOOT_LOG_MESSAGE_READ_EXITTOOLS", args));
                while ((sCommand = lnr.readLine()) != null) {
                    OiiolTextLogger.appendText(sCommand);
                    this.m_vOnRebootExitTools.addElement(sCommand);
                }
                lnr.close();
                fr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.delete();
        }
    }

    public void grabLocks() throws IOException, OiitTargetLockNotAvailableException {
        if (!this.m_bLockGrabbed) {
            OiiiTargetAreaControl targetAreaControl = this.getTargetAreaControl();
            targetAreaControl.grabWriterLock(false);
            this.m_bLockGrabbed = true;
            this.m_installInv = ((OiiiInstallAreaControl)targetAreaControl).getInstallInventory();
        }
    }

    public boolean isLockGrabbed() {
        return this.m_bLockGrabbed;
    }

    public boolean isClusterMode() {
        boolean bCluster = false;
        String[] clusterList = this.getAllClusterNodes();
        if (clusterList != null && clusterList.length >= 1) {
            bCluster = true;
        }
        return bCluster;
    }

    public String[] getAllClusterNodes() {
        String[] clusterList = (String[])this.getSessionVarValue("CLUSTER_NODES");
        return clusterList;
    }

    public String[] getAllRemoteNodes() {
        String[] clusterList = (String[])this.getSessionVarValue("CLUSTER_NODES");
        String[] remoteNodes = new String[clusterList.length - 1];
        System.arraycopy(clusterList, 1, remoteNodes, 0, clusterList.length - 1);
        return remoteNodes;
    }

    public String[] getNewNodes() {
        String[] newNodes = (String[])this.getSessionVarValue("CLUSTER_NEW_NODES");
        return newNodes;
    }

    public void setupDuplicateStreams() throws OiifbEndIterateException {
        OiicPullSession.createDuplicateStreams(this.m_sInvLoc);
    }

    public void setupDuplicateStreamsForLog(String sLogLoc) throws OiifbEndIterateException {
        OiicPullSession.createDuplicateStreamsForLog(sLogLoc);
    }

    static void createDuplicateStreamsForLog(String logsDir) throws OiifbEndIterateException {
        try {
            String fileName = OiicPullSession.getOutStreamFileName() + OiixUtilityOps.getSessionTimeStamp();
            File dupOut = new File(logsDir, fileName + ".out");
            File dupErr = new File(logsDir, fileName + ".err");
            String sPath = System.getProperty("oracle.installer.scratchPath");
            String sOutLoc = OiixPathOps.concatPath(sPath, OiicPullSession.getOutStreamFileName() + OiixUtilityOps.getSessionTimeStamp() + ".out");
            String sErrLoc = OiixPathOps.concatPath(sPath, OiicPullSession.getOutStreamFileName() + OiixUtilityOps.getSessionTimeStamp() + ".err");
            OiixTeePrintStream.resetOutputTee();
            OiixTeePrintStream.resetErrorTee();
            OiixTeePrintStream.setOutputTee(dupOut.getPath());
            OiixTeePrintStream.setErrorTee(dupErr.getPath());
            if (System.getProperty("oracle.installer.skipLogCopyFromScratch", "false").compareToIgnoreCase("false") == 0) {
                try {
                    OiixFileOps.copyFile(sOutLoc, OiixPathOps.concatPath(logsDir, fileName + ".out"), false);
                    OiixFileOps.copyFile(sErrLoc, OiixPathOps.concatPath(logsDir, fileName + ".err"), false);
                }
                catch (OiifbCancelException oce) {
                    oce.printStackTrace();
                }
            }
            if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
                try {
                    OiipuUnixOps.changePermission(OiixTeePrintStream.getErrFileLoc(), 384);
                    OiipuUnixOps.changePermission(OiixTeePrintStream.getOutFileLoc(), 384);
                }
                catch (OiilNativeException natEx) {
                    natEx.printStackTrace();
                }
            }
            OiicPullSession.writeToMonitorFile("outlog=" + dupOut.getPath());
            OiicPullSession.writeToMonitorFile("errlog=" + dupErr.getPath());
        }
        catch (IOException ioe) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SCRATCHPATH_ERROR");
            Object[] objs = new String[]{logsDir};
            sMsg = MessageFormat.format(ioe.getMessage(), objs);
            throw new OiifbEndIterateException(sMsg);
        }
    }

    static void createDuplicateStreams(String sInvLoc) throws OiifbEndIterateException {
        String logsDir = "";
        try {
            try {
                if (sInvLoc == null) {
                    throw new IOException("");
                }
                File invDir = new File(sInvLoc);
                if (!invDir.exists()) {
                    throw new IOException("");
                }
                logsDir = OiixPathOps.getNativeForm(sInvLoc) + File.separatorChar + "logs";
                if (!new File(logsDir).exists()) {
                    throw new IOException("Logs Dir has changed");
                }
            }
            catch (IOException ie) {
                String initLoc = System.getProperty("oracle.installer.scratchPath");
                OiipgFileSystem pfs = new OiipgFileSystem();
                OiipgFileSystem.checkWritablePath(initLoc);
                String tmpDirLoc = OiixPathOps.getNativeForm(initLoc);
                File tmpDirFile = new File(tmpDirLoc);
                if (!tmpDirFile.exists()) {
                    tmpDirFile.mkdirs();
                }
                logsDir = tmpDirLoc;
            }
        }
        catch (OiipgPathException exp) {
            exp.printStackTrace(System.out);
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SCRATCHPATH_ERROR");
            Object[] objs = new String[]{logsDir};
            sMsg = MessageFormat.format(exp.getMessage(), objs);
            throw new OiifbEndIterateException(sMsg);
        }
        OiicPullSession.createDuplicateStreamsForLog(logsDir);
    }

    static void writeToMonitorFile(String sWrite) {
        String sMonitorFile = System.getProperties().getProperty("oracle.installer.monitorFile");
        if (sMonitorFile != null && sMonitorFile.length() > 0) {
            try {
                FileWriter fw = new FileWriter(sMonitorFile, true);
                PrintWriter pw = new PrintWriter(fw);
                pw.println(sWrite);
                pw.close();
                fw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static OiiiLibraryID getCurrentPlatformFileLibraryID() {
        if (m_fileActionID == null) {
            Vector<Integer> plats = new Vector<Integer>(1);
            plats.addElement(new Integer(OiixPlatform.getCurrentPlatform()));
            m_fileActionID = new OiiiLibraryID("fileActions", new OiiiVersion("1.0"), plats, new OiiiVersion("0.0"));
        }
        return m_fileActionID;
    }

    public static OiiiLibraryID getCurrentPlatformLinkLibraryID() {
        if (m_unixActionID == null) {
            Vector<Integer> plats = new Vector<Integer>();
            plats.addElement(new Integer(OiixPlatform.getCurrentPlatform()));
            m_unixActionID = new OiiiLibraryID("unixActions", new OiiiVersion("1.0"), plats, new OiiiVersion("0.0"));
        }
        return m_unixActionID;
    }

    public void saveInventoryWithUpdate() throws IOException, OiifbCancelException {
    }

    protected String getInvLoc() {
        return this.m_sInvLoc;
    }

    protected void setInvLoc(String sInvLoc) {
        this.m_sInvLoc = sInvLoc;
    }

    public final boolean hasSourceChanged() {
        if (this.m_cHasSourceChanged == 'N') {
            this.m_cHasSourceChanged = (char)84;
            OiisVariable oFromLoc = this.m_sessionContext.getVariable("FROM_LOCATION");
            String sNewSourceLocation = oFromLoc != null ? (String)oFromLoc.getValue() : "";
            String sOldSourceLocation = this.getOldSourceLocation();
            if (null != sNewSourceLocation && null != sOldSourceLocation) {
                this.m_cHasSourceChanged = (char)(sNewSourceLocation.equals(sOldSourceLocation) && this.m_bFailedForStgVersionChk ? 70 : 84);
                if (this.m_cHasSourceChanged == 'F') {
                    this.m_cHasSourceChanged = (char)(this.getNumberOfTopLevelComps() <= 0 ? 84 : 70);
                } else {
                    this.m_availTopLevelIDs.clear();
                }
            }
        }
        return this.m_cHasSourceChanged == 'T';
    }

    public void bindVariable(OiiiCompInstallID child, String varName, OiisAdvisedValue val) throws OiisVarSettingException, OiifbCancelException {
        this.bindVariable(child, varName, val, true);
    }

    public void bindVariable(OiiiCompInstallID child, String varName, OiisAdvisedValue val, boolean bValidate) throws OiisVarSettingException, OiifbCancelException {
        OiisCompContext vo = this.getCompInstall(child).getContext();
        if (vo == null || !this.m_namespaceTable.containsKey(vo)) {
            return;
        }
        OiisVariable v = vo.getVariable(varName);
        if (v != null) {
            if (bValidate) {
                v.validate(val.getValue());
            }
            Hashtable ns = (Hashtable)this.m_namespaceTable.get(vo);
            ns.put(v, val);
        }
    }

    public Map getBackedupTemplates() {
        if (this.m_hmBackedupTemplates == null) {
            this.m_hmBackedupTemplates = new HashMap();
        }
        return this.m_hmBackedupTemplates;
    }

    public void unbindVariable(OiiiCompInstallID child, String varName) {
        OiisCompContext vo = this.getCompInstall(child).getContext();
        if (vo == null || !this.m_namespaceTable.containsKey(vo)) {
            return;
        }
        OiisVariable v = vo.getVariable(varName);
        if (v != null) {
            Hashtable ns = (Hashtable)this.m_namespaceTable.get(vo);
            ns.remove(v);
        }
    }

    public OiiiSessionCloneVars getSessionCloneVars() {
        if (this.m_installInv != null) {
            return this.m_installInv.getCurSessionCloneVars();
        }
        return null;
    }

    public String getHostNameForCurrentOH() {
        if (this.m_installInv != null) {
            return this.m_installInv.getFullHostName(this.getOHIndex());
        }
        return null;
    }

    protected static String getOutStreamFileName() {
        return "oraInstall";
    }

    public OiisVariableOwner getContext() {
        return this.getSessionContext();
    }

    public OiiiInstallInventory getInstallInventory() {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        return iac != null ? iac.getInstallInventory() : null;
    }

    public void setAdditionalComps(boolean baddComps) {
        this.m_isAddComps = baddComps;
    }

    public boolean isAdditionalComps() {
        return this.m_isAddComps;
    }

    public void setAutoOUI(boolean bAutoOUI) {
        this.m_bAutoOUI = bAutoOUI;
    }

    public boolean isAutoOUI() {
        return this.m_bAutoOUI;
    }

    public void setDirtyPanelStatus(boolean bDirtyPanelStatus) {
        this.m_bDirtyPanelStatus = bDirtyPanelStatus;
    }

    public boolean getDirtyPanelStatus() {
        return this.m_bDirtyPanelStatus;
    }

    public void setOldSourceLocation(String sOldSourceLocation) {
        this.m_cHasSourceChanged = (char)78;
        this.m_sSourceLocationOld = sOldSourceLocation;
    }

    public final String getOldSourceLocation() {
        return this.m_sSourceLocationOld;
    }

    public void resetSourceChangeStatus() {
        this.m_cHasSourceChanged = (char)78;
    }

    public String setLocalNode(OiiiOracleHomeInfo homeInfo) throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext oContext = this.getSessionContext();
        return oContext.setLocalNodeName(homeInfo);
    }

    public void setUnixGroupName(OiicSessionContext sessionContext) {
        Hashtable argsTable = sessionContext.getCommandLineArgsTable();
        String sUnixGrpNameByUser = (String)argsTable.get("UNIX_GROUP_NAME");
        if (sUnixGrpNameByUser != null && sUnixGrpNameByUser.trim().length() > 0) {
            OiisVariable oUnixGroup = sessionContext.getVariable("UNIX_GROUP_NAME");
            try {
                oUnixGroup.setValue(sUnixGrpNameByUser, false);
                oUnixGroup.setAdvice(true);
            }
            catch (Exception e) {}
        } else {
            String sUnixGroup = new OiipgPropertyLoader().getUnixGroup();
            if (sUnixGroup != null && sUnixGroup.trim().length() > 0) {
                OiisVariable oUnixGroup = sessionContext.getVariable("UNIX_GROUP_NAME");
                try {
                    oUnixGroup.setValue(sUnixGroup, false);
                    oUnixGroup.setAdvice(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isHomeVersionCompatibleForClone() {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        if (null != iac) {
            OiiiInstallInventory instInv = iac.getInstallInventory();
            if (null != iac) {
                Vector installIEs = instInv.getAllCompsVect(this.getOHIndex(), OiixPlatform.getCurrentPlatform());
                int nComps = installIEs.size();
                OiiiVersion[] stgVersions = new OiiiVersion[]{OiicInstVersion.getCompatibleInstallerVersion()};
                for (int i = 0; i < nComps; ++i) {
                    OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
                    if (!OiiiVersion.isInstVersionPostX(ie.getInstallerVersion(), stgVersions)) continue;
                    Object[] msgArr = new String[]{OiicInstVersion.getCompatibleInstallerVersion().getVerString()};
                    String errString = MessageFormat.format(OiixResourceBundle.getString("OUI-25037"), msgArr);
                    OiiolTextLogger.appendText(errString, OiiolTextLogger.LOG_WARNING);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void registerCopyLogInfo() {
        String sInvLoc;
        String sHomeLoc;
        OiicSessionContext oContext = this.getSessionContext();
        if (oContext != null && (sHomeLoc = (String)oContext.getVarValue("ORACLE_HOME")) != null && (sInvLoc = (String)oContext.getVarValue("INVENTORY_LOCATION")) != null) {
            String timestamp = OiixUtilityOps.getSessionTimeStamp();
            OiiolCopyLogInfo logCopyInfo = new OiiolCopyLogInfo(sInvLoc, sHomeLoc, timestamp);
            OiiolTextLogger.registerCopyLogInfo(logCopyInfo);
        }
    }

    public void setChainInstallProgress(Boolean bShow, String sTitle, String sText) {
        try {
            OiicSessionContext sCntxt = this.getSessionContext();
            OiisVariable showProgress = sCntxt.getVariable("SHOW_NEXT_SESSION_PROGRESS");
            showProgress.setValue(bShow);
            OiisVariable title = sCntxt.getVariable("NEXT_SESSION_PROGRESS_TITLE");
            title.setValue(sTitle);
            OiisVariable text = sCntxt.getVariable("NEXT_SESSION_PROGRESS_TEXT");
            text.setValue(sText);
        }
        catch (OiisVarSettingException ovse) {
        }
        catch (OiifbCancelException oce) {
            // empty catch block
        }
    }

    public void setCustomRootShMessage(String sMessage) {
        try {
            OiicSessionContext sCntxt = this.getSessionContext();
            OiisVariable text = sCntxt.getVariable("SHOW_CUSTOM_ROOTSH_MESSAGE");
            text.setValue(sMessage);
        }
        catch (OiisVarSettingException ovse) {
        }
        catch (OiifbCancelException oiifbCancelException) {
            // empty catch block
        }
    }

    public void setCheckPointIndexSessionObj(OicsICheckPointIndexSession sessObj) {
        if (sessObj != null) {
            OiiolTextLogger.appendText("Setting checkpoint object");
            this.checkPointSessionObj = sessObj;
        }
    }

    public OicsICheckPointIndexSession getCheckPointIndexSessionObj() {
        if (this.checkPointSessionObj != null) {
            return this.checkPointSessionObj;
        }
        return null;
    }

    public static void setRemoteOperationSuccess(boolean bSucess) {
        m_bRemoteOperationSuccess = bSucess;
    }

    public boolean isRemoteOperationSuccessful() {
        return m_bRemoteOperationSuccess;
    }

    static {
        OiiiVersion ver = new OiiiVersion("0.0.0.0.0");
        OiiiVersion replver = new OiiiVersion("0.0.0.0.0");
        sessionContextID = new OiiiCompInstallID("oracle.sysman.installer.session", ver, new Vector(), replver, 1, 0, 0, false);
    }

    public class CompInit
    implements Runnable,
    Loadable {
        Vector m_oCompsToLoad;
        int iCompsToLoad;
        int iNextComp = 0;
        Loadable m_ldr;
        boolean bMore = true;

        public CompInit(int iComps, Loadable ldr) {
            this.m_oCompsToLoad = new Vector(iComps);
            this.iCompsToLoad = iComps;
            this.m_ldr = ldr;
        }

        public void run() {
            long lStartInitContext = System.currentTimeMillis();
            while (this.iCompsToLoad != 0) {
                if (this.m_oCompsToLoad.isEmpty()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                OiisCompInstallation ci = this.getNextComp();
                if (ci == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                OiixProgressListener progListener = OiicPullSession.this.getProgressListener();
                if (progListener != null) {
                    progListener.addBytes(1);
                }
                this.initComp(ci);
            }
            this.m_oCompsToLoad = null;
            if (OiixDebug.PRINT_TIME) {
                OiixDebug.printTimeMsg("OiicInstallSession, initContext ", System.currentTimeMillis() - lStartInitContext);
            }
        }

        private synchronized OiisCompInstallation getNextComp() {
            int iComps = this.m_oCompsToLoad.size();
            OiisCompInstallation ci = null;
            if (iComps > 0 && this.iNextComp < iComps) {
                ci = (OiisCompInstallation)this.m_oCompsToLoad.elementAt(this.iNextComp);
                ++this.iNextComp;
            } else {
                ci = null;
            }
            return ci;
        }

        public synchronized void addCompToLoad(OiisCompInstallation ci) {
            this.m_oCompsToLoad.addElement(ci);
        }

        private void initComp(OiisCompInstallation ci) {
            OiisCompJarLoader oCjl = ci.getCompJarLoader();
            long lStartLoad = System.currentTimeMillis();
            try {
                ci.initContext();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            if (this.m_ldr != null) {
                this.m_ldr.addCompToLoad(ci);
            }
            --this.iCompsToLoad;
        }
    }

    public class CompLoader
    implements Runnable,
    Loadable {
        Vector m_oCompsToLoad;
        int iCompsToLoad;
        int iNextComp = 0;
        Loadable m_ldr;

        public CompLoader(int iComps, Loadable ldr) {
            this.m_oCompsToLoad = new Vector(iComps);
            this.iCompsToLoad = iComps;
            this.m_ldr = ldr;
        }

        public void run() {
            long lstartLoad = System.currentTimeMillis();
            while (this.iCompsToLoad != 0) {
                if (this.m_oCompsToLoad.isEmpty()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                OiisCompInstallation ci = this.getNextComp();
                if (ci == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                OiixProgressListener progListener = OiicPullSession.this.getProgressListener();
                if (progListener != null) {
                    progListener.addBytes(1);
                }
                this.loadComp(ci);
            }
            this.m_oCompsToLoad = null;
            if (OiixDebug.PRINT_TIME) {
                OiixDebug.printTimeMsg("Time for loading comp Info ", System.currentTimeMillis() - lstartLoad);
            }
        }

        private synchronized OiisCompInstallation getNextComp() {
            int iComps = this.m_oCompsToLoad.size();
            OiisCompInstallation ci = null;
            if (iComps > 0 && this.iNextComp < iComps) {
                ci = (OiisCompInstallation)this.m_oCompsToLoad.elementAt(this.iNextComp);
                ++this.iNextComp;
            } else {
                ci = null;
            }
            return ci;
        }

        public synchronized void addCompToLoad(OiisCompInstallation ci) {
            this.m_oCompsToLoad.addElement(ci);
        }

        private void loadComp(OiisCompInstallation ci) {
            OiisCompJarLoader oCjl = ci.getCompJarLoader();
            try {
                oCjl.loadCompContext(false, ci.getProperties());
                if (!ci.getProperties().isNoPreReqAvailable()) {
                    oCjl.loadPreRequisite(ci.getCompJarInfo());
                }
                if (!ci.getProperties().isNoProdHomeAvailable()) {
                    oCjl.loadProdHome(ci.getCompJarInfo());
                }
                if (this.m_ldr != null) {
                    this.m_ldr.addCompToLoad(ci);
                }
                --this.iCompsToLoad;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
        }
    }

    public static interface Loadable {
        public void addCompToLoad(OiisCompInstallation var1);
    }
}

