/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiic.OiicSessionVarContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiicSessionContextBuilder {
    private Map m_oVariablesMap;
    private static final String S_SEPARATOR = ",";

    protected Map buildVariablesMap(OiicSessionVarContext oContext, InputStream in) throws OiixException {
        HashMap<String, OiisVariable> oVarMap = new HashMap<String, OiisVariable>();
        try {
            Document oSessionVarsDoc = OixdDOMReader.getDocument(in);
            Element oVarListNode = oSessionVarsDoc.getDocumentElement();
            NodeList oVarNodes = oVarListNode.getElementsByTagName("VAR");
            int nSize = oVarNodes.getLength();
            for (int i = 0; i < nSize; ++i) {
                Element oVarNode = (Element)oVarNodes.item(i);
                String sVarName = oVarNode.getAttribute("NAME");
                String sType = oVarNode.getAttribute("TYPE");
                String sDescID = oVarNode.getAttribute("DESC_ID");
                String sValue = oVarNode.getAttribute("VAL");
                String sAdvice = oVarNode.getAttribute("ADV");
                String sSecure = oVarNode.getAttribute("SEC");
                OiisVariable oVar = new OiisVariable(oContext, sVarName);
                oVar.setType(OiisDataTypes.getTypeID(sType));
                oVar.setDescriptionID(sDescID);
                try {
                    if (sValue != null && !sValue.equals("")) {
                        if (oVar.getType() == 1) {
                            oVar.setValue(sValue);
                        } else if (oVar.getType() == 2) {
                            try {
                                oVar.setValue(new Integer(sValue));
                            }
                            catch (NumberFormatException nfe) {
                                nfe.printStackTrace();
                            }
                        } else if (oVar.getType() == 3) {
                            oVar.setValue(new Boolean(sValue));
                        } else if (oVar.getType() == 4) {
                            oVar.setValue(OiixFunctionOps.explodeString(sValue, S_SEPARATOR));
                        }
                    }
                }
                catch (OiifbCancelException ce) {
                    ce.printStackTrace();
                }
                catch (OiisVarSettingException ce1) {
                    ce1.printStackTrace();
                }
                oVar.setAdvice(this.getBooleanValue(sAdvice));
                oVar.setSecure(this.getBooleanValue(sSecure));
                oVarMap.put(oVar.getName().toUpperCase(), oVar);
            }
        }
        catch (ParserConfigurationException pe) {
            String[] msgArgs = new String[]{pe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, pe);
        }
        catch (SAXException se) {
            String[] msgArgs = new String[]{se.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, se);
        }
        catch (IOException ioe) {
            String[] msgArgs = new String[]{ioe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, ioe);
        }
        return oVarMap;
    }

    private String formatErrorMessage(String resourceId, String[] args) {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resourceId, args);
    }

    private boolean getBooleanValue(String s) {
        boolean bRet = false;
        if (s != null && s.equalsIgnoreCase("T")) {
            bRet = true;
        }
        return bRet;
    }
}

