/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodePhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAutoConfigWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwPrereqWCDE;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqProgress;

public abstract class OiicSessionInterfaceManager {
    private static final int GRAPHIC_MODE = 1;
    private static final int SILENT_MODE = 2;
    private static final int API_MODE = 3;
    protected static final int NEXT = 0;
    protected static final int BACK = 1;
    private static Hashtable s_interfaceTable = null;
    private static OiicSessionInterfaceManager s_oSessionInterfaceManager = null;
    private OiicInstallTimeSession m_oSession = null;
    protected OiifwPrereqWCDE m_oPrereqWCDE;
    protected OiixProgressListener m_progressListener = null;

    public OiicInstallTimeSession getSession() {
        return this.m_oSession;
    }

    public void setSession(OiicInstallTimeSession oSession) {
        this.m_oSession = oSession;
    }

    private static void createInterfaceManager() {
        int operatingMode = 1;
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            operatingMode = 3;
        }
        String noGUI = System.getProperty("oracle.installer.noGUI");
        if ((Boolean.getBoolean("oracle.installer.silent") || noGUI != null && noGUI.toLowerCase().equals("yes")) && operatingMode != 3) {
            operatingMode = 2;
        }
        try {
            Class<?> interfaceManagerClass = Class.forName((String)s_interfaceTable.get(new Integer(operatingMode)));
            s_oSessionInterfaceManager = (OiicSessionInterfaceManager)interfaceManagerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (InstantiationException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (IllegalAccessException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public static OiicSessionInterfaceManager getInterfaceManager() {
        if (s_oSessionInterfaceManager == null) {
            OiicSessionInterfaceManager.createInterfaceManager();
        }
        return s_oSessionInterfaceManager;
    }

    public int doWizardPageOperation(OiifbWizChainDlgElem wizardElem, boolean isBack) throws OiifbEndIterateException {
        return 0;
    }

    public int displayAlert(String title, String msg, int iconType, int buttonType, int defaultButton, int alertType, boolean bSelectable) {
        return 1;
    }

    public int displayAlert(String title, String msg, int iconType, int buttonType, int defaultButton, int alertType) {
        return 1;
    }

    public void initialize() {
    }

    public OiixProgressListener getProgressListener() {
        return null;
    }

    public abstract void setProgressListener(OiixProgressListener var1);

    public void dispose() {
        s_oSessionInterfaceManager = null;
    }

    public void disposePreStateChangeElements() {
        if (this.m_oPrereqWCDE != null) {
            this.m_oPrereqWCDE.dispose();
        }
        this.m_oPrereqWCDE = null;
    }

    public abstract OiicInstallCancelHandler getInstallCancelHandler(int var1, String var2, int var3);

    public abstract OiifbIRetry getRetryHandler(String var1, int var2, int var3);

    public abstract OiifbIRetry getRetryHandler(String var1, String var2, int var3, int var4, boolean var5);

    public abstract boolean processLicenceDialog() throws OiifbEndIterateException;

    protected String getLicenceFileName() {
        String lic = null;
        String dir = System.getProperty("oracle.installer.startup_location");
        if (dir == null) {
            return lic;
        }
        lic = OiixOraparam.getOraparamProfileString("LICENSE_LOCATION", null);
        if (lic != null && lic.length() != 0) {
            File l = new File(lic = OiixPathOps.concatPath(dir, lic));
            if (!l.exists()) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_LICENSE_NOT_FOUND") + lic);
                return null;
            }
        } else {
            return null;
        }
        return lic;
    }

    public abstract String getRootSHMessage(Object[] var1, boolean var2);

    public abstract void logMessage(String var1);

    public abstract String getDiskLocation(String var1, String var2, int var3) throws OiiiDiskNotFoundException;

    public int doInvSetupOperations(String sInvLoc, String unixGroup) throws OiifbEndIterateException {
        OiipgBootstrap pgb = new OiipgBootstrap();
        try {
            OiicPullSession pullSession = (OiicPullSession)this.getSession();
            pgb.updateInventoryLoc(this, sInvLoc, unixGroup);
            pullSession.setAreaControls(sInvLoc);
            pullSession.grabLocks();
        }
        catch (Exception ex) {
            String errString = ex.getMessage();
            errString = errString == null || errString.length() == 0 ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_SETUP_ERR") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", errString);
            String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVENTORY_LOC");
            this.displayAlert(sTitle, errString, 50, 1, 1, 20);
            return 1;
        }
        return 0;
    }

    public abstract boolean performInvSetupRootOperations(String[] var1) throws IOException;

    public void showMessage(String sMessage) {
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVENTORY_LOC");
        this.displayAlert(sTitle, sMessage, 50, 1, 1, 20);
    }

    public abstract int processConfigTools(OiifwAutoConfigWCDE var1, boolean var2, OiicInstPostActionsPhase var3, Vector var4, Vector var5) throws OiifbEndIterateException;

    public abstract int processConfigTools(OiifwAutoConfigWCDE var1, boolean var2, OiicInstPostActionsPhase var3, Vector var4) throws OiifbEndIterateException;

    public int doRebootOperations() {
        return 1;
    }

    protected boolean isRestartVariableSet() {
        OiicInstallTimeSession oSession = this.getSession();
        OiisVariable oRestartVar = oSession.getSessionContext().getVariable("RESTART_SYSTEM");
        return oRestartVar.getAdvice();
    }

    protected boolean isRestartRemoteVariableSet() {
        OiicInstallTimeSession oSession = this.getSession();
        OiisVariable oRestartRemoteVar = oSession.getSessionContext().getVariable("RESTART_REMOTE_SYSTEM");
        return oRestartRemoteVar.getAdvice();
    }

    protected boolean getRestartVarValue() {
        OiicInstallTimeSession oSession = this.getSession();
        OiisVariable oRestartVar = oSession.getSessionContext().getVariable("RESTART_SYSTEM");
        return (Boolean)oRestartVar.getValue();
    }

    protected boolean getRestartRemoteVarValue() {
        OiicInstallTimeSession oSession = this.getSession();
        OiisVariable oRestartRemoteVar = oSession.getSessionContext().getVariable("RESTART_REMOTE_SYSTEM");
        return (Boolean)oRestartRemoteVar.getValue();
    }

    public abstract void setupInstallProgress(OiifwActionsPhaseWCDE var1, int var2, int var3);

    public boolean isNextSessionSet() {
        OiicInstallTimeSession oSession = this.getSession();
        OiisVariable oNextSessionVar = oSession.getSessionContext().getVariable("NEXT_SESSION");
        OiisVariable oEndSessionVar = oSession.getSessionContext().getVariable("SHOW_END_SESSION_PAGE");
        boolean bRet = false;
        if (oNextSessionVar.getAdvice() && ((Boolean)oNextSessionVar.getValue()).booleanValue() && oEndSessionVar.getAdvice() && !((Boolean)oEndSessionVar.getValue()).booleanValue()) {
            bRet = true;
        }
        return bRet;
    }

    public boolean validateHostName(String sHostName, boolean bVarSet) throws OiifbEndIterateException {
        boolean bMultipleNIC = OiinNetOps.getNetOps().hasMultipleNICs();
        int nShow = OiixOraparam.getShowHostNameValue();
        boolean bOraparam = nShow == 1 || this.canShowHostNameConditionally(sHostName);
        try {
            if (!bVarSet && (bMultipleNIC || bOraparam)) {
                throw new Exception(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOSTNAME_ERROR_MULTIPLE_NIC"));
            }
            if (bVarSet && (sHostName == null || sHostName.trim().equals(""))) {
                throw new Exception(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOSTNAME_ERROR_EMPTY"));
            }
            if (bVarSet && !OiinNetOps.isValidHostName((String)sHostName)) {
                throw new Exception(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOSTNAME_ERROR_INVALID"));
            }
            String sHostAddress = OiinNetOps.getNetOps().ping(sHostName);
            if (bVarSet && sHostAddress == null) {
                throw new Exception(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOSTNAME_ERROR_CANNOT_LOOKUP"));
            }
        }
        catch (Exception e) {
            this.showError(e.getMessage());
            return false;
        }
        String sWarnMsg = null;
        if (bVarSet && !OiinNetOps.isFQDN((String)sHostName)) {
            sWarnMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_HOSTNAME_WARNING_NON_FQDN");
        }
        if (sWarnMsg != null) {
            return this.showHostNameWarning(sHostName, sWarnMsg);
        }
        return true;
    }

    public abstract void showError(String var1) throws OiifbEndIterateException;

    public abstract boolean showWarning(String var1);

    public boolean showHostNameWarning(String sHostName, String sMsg) {
        return this.showWarning(sMsg);
    }

    protected boolean canShowHostNameConditionally(String sHostName) {
        int nShow = OiixOraparam.getShowHostNameValue();
        return nShow == 1 || nShow == 2 && (OiinNetOps.getNetOps().hasMultipleNICs() || !OiinNetOps.isFQDN((String)sHostName));
    }

    public abstract OipcpPrereqProgress getPrereqProgress(OiifwPrereqWCDE var1);

    public abstract void setupAddNodeProgress(OiifwAddNodePhaseWCDE var1, int var2, int var3);

    public abstract void setSkipAllConfigTools(boolean var1);

    public abstract void showNextSessionProgress();

    public void hideSplashScr() {
    }

    public boolean canNavigateBack() {
        return false;
    }

    static {
        s_interfaceTable = new Hashtable(5, 5.0f);
        s_interfaceTable.put(new Integer(1), "oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager");
        s_interfaceTable.put(new Integer(2), "oracle.sysman.oii.oiic.OiicSilentInterfaceManager");
        s_interfaceTable.put(new Integer(3), "oracle.sysman.oii.oiic.OiicAPISessionInterfaceManager");
    }
}

