/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicSessionPlan
implements Serializable {
    static final long serialVersionUID = -4612516814397642620L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    public static final int PHASE_START = 0;
    public static final int PHASE_PRE_INTERVIEW = 5;
    public static final int PHASE_INTERVIEW = 10;
    public static final int PHASE_STATE_CHANGE_1 = 20;
    public static final int PHASE_STATE_CHANGE_LINK = 30;
    public static final int PHASE_STATE_CHANGE_2 = 40;
    public static final int PHASE_CONFIG = 50;
    public static final int PHASE_INVENTORIED = 60;
    public static final int PHASE_COMPLETE = 10;
    private Vector m_removeOrder;
    private Vector m_addOrder;
    private Vector m_patchSets;
    private Vector m_removeOneoffOrder;
    private List m_homesToRemove;
    private OiiiCompInstallID m_selectedComp;
    private OiiiCompInstallID[] m_selectedComps;
    private Hashtable m_delRefs;
    private Hashtable m_delDeps;
    private Vector m_topComps;

    public OiicSessionPlan() {
        this.clearPlan();
    }

    public void dispose() {
        this.m_addOrder.removeAllElements();
        this.m_removeOrder.removeAllElements();
        this.m_patchSets.removeAllElements();
    }

    private static String genPlanLocation(OiicPullSession pullSession) {
        String retLoc = pullSession.getTargetAreaControl().genFileSysLoc("sessionPlan.ser");
        return retLoc;
    }

    public static void writePlan(OiicPullSession pullSession) throws IOException {
        String planLoc = OiicSessionPlan.genPlanLocation(pullSession);
        FileOutputStream fos = new FileOutputStream(planLoc);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(pullSession.getSessionPlan());
        oos.flush();
        oos.close();
        fos.close();
    }

    public static OiicSessionPlan readPlan(OiicPullSession pullSession) throws IOException, ClassNotFoundException {
        String planLoc = OiicSessionPlan.genPlanLocation(pullSession);
        FileInputStream fis = new FileInputStream(planLoc);
        ObjectInputStream ois = new ObjectInputStream(fis);
        OiicSessionPlan sessionPlan = (OiicSessionPlan)ois.readObject();
        ois.close();
        fis.close();
        pullSession.setSessionPlan(sessionPlan);
        return sessionPlan;
    }

    public void clearPlan() {
        this.m_removeOrder = new Vector();
        this.m_addOrder = new Vector();
        this.m_patchSets = new Vector();
        this.m_delRefs = new Hashtable();
        this.m_delDeps = new Hashtable();
        this.m_topComps = new Vector();
        this.m_selectedComp = null;
        this.m_removeOneoffOrder = new Vector();
    }

    public void addRemoval(OiiiCompIdOhPair cIdOh) {
        OiiiCompInstallID cid = cIdOh.getCompID();
        this.addRemoval(cid, (Object)cIdOh);
    }

    public void addRemoval(OiiiCompInstallID cid, Object planInfo) {
        if (OiixVectorOps.vectIndexOf(this.m_removeOrder, planInfo) == -1) {
            this.m_removeOrder.addElement(new OiListObj(cid, planInfo));
        }
    }

    public void deleteRemoval(OiiiCompInstallID id) {
        int nIndex = OiixVectorOps.vectIndexOf(this.m_removeOrder, (Object)id);
        if (nIndex != -1) {
            this.m_removeOrder.removeElementAt(nIndex);
        }
    }

    public void addRemoval(OiiiOneoffIdOhPair oidOh) {
        OiiiOneoffInstallID oid = oidOh.getOneoffID();
        this.addRemoval(oid, (Object)oidOh);
    }

    public void addRemoval(OiiiOneoffInstallID oid, Object planInfo) {
        if (OiixVectorOps.vectIndexOf(this.m_removeOneoffOrder, planInfo) == -1) {
            this.m_removeOneoffOrder.addElement(new OiListObj(oid, planInfo));
        }
    }

    public void deleteRemoval(OiiiOneoffInstallID id) {
        int nIndex = OiixVectorOps.vectIndexOf(this.m_removeOneoffOrder, (Object)id);
        if (nIndex != -1) {
            this.m_removeOneoffOrder.removeElementAt(nIndex);
        }
    }

    public void addRemoval(OiiiOracleHomeInfo homeInfo) {
        int nIndex;
        if (this.m_homesToRemove == null) {
            this.m_homesToRemove = new ArrayList();
        }
        if ((nIndex = OiixVectorOps.vectIndexOf(this.m_homesToRemove, (Object)homeInfo)) == -1) {
            this.m_homesToRemove.add(homeInfo);
        }
    }

    public List getHomesToRemove() {
        return this.m_homesToRemove;
    }

    public void addAddition(OiiiCompInstallID cid, Object planInfo) {
        this.addAddition(cid, planInfo, true);
    }

    public void addPatchSet(OiiiPatchSetInstallID cid, Object planInfo) {
        if (OiixVectorOps.vectIndexOf(this.m_patchSets, (Object)cid) == -1) {
            this.m_patchSets.addElement(new OiListObj(cid, planInfo));
        }
    }

    public void addAddition(OiiiCompInstallID cid, Object planInfo, boolean checkDupIDs) {
        if (!checkDupIDs || OiixVectorOps.vectIndexOf(this.m_addOrder, (Object)cid) == -1) {
            this.m_addOrder.addElement(new OiListObj(cid, planInfo));
        }
    }

    public void setRemovalPhase(OiiiCompIdOhPair cIdOh, int phase) {
        int pos = -1;
        pos = OiixVectorOps.vectIndexOf(this.m_removeOrder, (Object)cIdOh);
        if (pos != -1) {
            ((OiListObj)this.m_removeOrder.elementAt(pos)).setPhase(phase);
        }
    }

    public int getRemovalPhase(OiiiCompIdOhPair cIdOh) {
        int retval = 0;
        int pos = -1;
        pos = OiixVectorOps.vectIndexOf(this.m_removeOrder, (Object)cIdOh);
        if (pos != -1) {
            retval = ((OiListObj)this.m_removeOrder.elementAt(pos)).getPhase();
        }
        return retval;
    }

    public void setAdditionPhase(OiiiCompInstallID cid, int phase) {
        int pos = -1;
        pos = OiixVectorOps.vectIndexOf(this.m_addOrder, (Object)cid);
        if (pos != -1) {
            ((OiListObj)this.m_addOrder.elementAt(pos)).setPhase(phase);
        }
    }

    public int getAdditionPhase(OiiiCompInstallID cid) {
        int retval = 0;
        int pos = -1;
        pos = OiixVectorOps.vectIndexOf(this.m_addOrder, (Object)cid);
        if (pos != -1) {
            retval = ((OiListObj)this.m_addOrder.elementAt(pos)).getPhase();
        }
        return retval;
    }

    public Vector getRemoves(int phase) {
        Vector<Object> remRemoves = new Vector<Object>();
        Enumeration rems = this.m_removeOrder.elements();
        while (rems.hasMoreElements()) {
            OiListObj lobj = (OiListObj)rems.nextElement();
            if (lobj.getPhase() >= phase) continue;
            remRemoves.addElement(lobj.getPlanInfo());
        }
        return remRemoves;
    }

    public Vector getOneoffRemoves() {
        Vector<Object> remRemoves = new Vector<Object>();
        Enumeration rems = this.m_removeOneoffOrder.elements();
        while (rems.hasMoreElements()) {
            OiListObj lobj = (OiListObj)rems.nextElement();
            remRemoves.addElement(lobj.getPlanInfo());
        }
        return remRemoves;
    }

    public Vector getAdditions(int phase) {
        Vector<Object> remAdds = new Vector<Object>();
        Enumeration adds = this.m_addOrder.elements();
        while (adds.hasMoreElements()) {
            OiListObj lobj = (OiListObj)adds.nextElement();
            if (lobj.getPhase() >= phase) continue;
            remAdds.addElement(lobj.getPlanInfo());
        }
        return remAdds;
    }

    public Object getAdditionInfo(Object id) {
        Object plan = null;
        int nIndex = OiixVectorOps.vectIndexOf(this.m_addOrder, id);
        if (nIndex != -1) {
            OiListObj lobj = (OiListObj)this.m_addOrder.elementAt(nIndex);
            plan = lobj.getPlanInfo();
        }
        return plan;
    }

    public Vector getCompIdAdditions(int phase) {
        Vector<OiiiCompInstallID> remAdds = new Vector<OiiiCompInstallID>();
        Enumeration adds = this.m_addOrder.elements();
        while (adds.hasMoreElements()) {
            OiListObj lobj = (OiListObj)adds.nextElement();
            if (lobj.getPhase() >= phase) continue;
            remAdds.addElement(lobj.getCompID());
        }
        return remAdds;
    }

    public Vector getPatchSets() {
        Vector<Object> remAdds = new Vector<Object>();
        Enumeration adds = this.m_patchSets.elements();
        while (adds.hasMoreElements()) {
            OiListObj lobj = (OiListObj)adds.nextElement();
            remAdds.addElement(lobj.getPlanInfo());
        }
        return remAdds;
    }

    public Vector getSuccessfulAdditionsForAddNode() {
        Vector<Object> succAdds = new Vector<Object>();
        int numAdds = this.m_addOrder.size();
        for (int i = 0; i < numAdds; ++i) {
            OiListObj lobj = (OiListObj)this.m_addOrder.elementAt(i);
            succAdds.addElement(lobj.getPlanInfo());
        }
        return succAdds;
    }

    public Vector getSuccessfulAdditions() {
        Vector<OiiiCompInstallID> succAdds = new Vector<OiiiCompInstallID>();
        int numAdds = this.m_addOrder.size();
        for (int i = 0; i < numAdds; ++i) {
            OiListObj lobj = (OiListObj)this.m_addOrder.elementAt(i);
            if (lobj.getPhase() < 60) continue;
            succAdds.addElement(lobj.getCompID());
        }
        return succAdds;
    }

    public Vector getSuccessfulAdditions(int phase) {
        return this.getSuccessfulAdditions(phase, false);
    }

    public Vector getSuccessfulAdditions(int phase, boolean bCompatible) {
        Vector<Object> remAdds = new Vector<Object>();
        Enumeration adds = this.m_addOrder.elements();
        while (adds.hasMoreElements()) {
            OiListObj lobj = (OiListObj)adds.nextElement();
            if (bCompatible) {
                if (lobj.getPhase() < phase) continue;
                remAdds.addElement(lobj.getPlanInfo());
                continue;
            }
            if (lobj.getPhase() != phase) continue;
            remAdds.addElement(lobj.getPlanInfo());
        }
        return remAdds;
    }

    public Vector getSuccessfulAdditionsForContext(int phase) {
        Vector<Object> remAdds = new Vector<Object>();
        int nSize = this.m_addOrder.size();
        for (int i = 0; i < nSize; ++i) {
            OiListObj compObj;
            OiiiCompInstallID compId;
            OiListObj lobj = (OiListObj)this.m_addOrder.elementAt(i);
            if (lobj.getPhase() != phase) continue;
            OiiiCompInstallID id = lobj.getCompID();
            if (id.getCompType() == 2 && i + 1 < nSize && (compId = (compObj = (OiListObj)this.m_addOrder.elementAt(i + 1)).getCompID()).equalsWithPlatInt(((OiiiPatchInstallID)id).getCompInstallID())) {
                remAdds.addElement(compObj.getPlanInfo());
                ++i;
            }
            remAdds.addElement(lobj.getPlanInfo());
        }
        return remAdds;
    }

    public boolean isEmpty() {
        return this.m_addOrder.isEmpty() && this.m_removeOrder.isEmpty() && (this.m_homesToRemove == null || this.m_homesToRemove.isEmpty());
    }

    public int getNumChanges() {
        return this.m_addOrder.size() + this.m_removeOrder.size();
    }

    public void noteRefs(OiiiCompInstallID cid, Vector refs) {
        this.m_delRefs.put(cid, refs);
    }

    public Vector getRefs(OiiiCompInstallID cid) {
        Vector retRefs = new Vector();
        Enumeration hkeys = this.m_delRefs.keys();
        while (hkeys.hasMoreElements()) {
            OiiiCompInstallID keyID = (OiiiCompInstallID)hkeys.nextElement();
            if (!cid.isCompatible(keyID) && !keyID.isCompatible(cid)) continue;
            Vector vRefs = (Vector)this.m_delRefs.get(keyID);
            OiixVectorOps.unionInPlace(retRefs, vRefs);
        }
        return retRefs;
    }

    public void noteDeps(OiiiCompInstallID cid, Vector deps) {
        this.m_delDeps.put(cid, deps);
    }

    public Vector getDeps(OiiiCompInstallID cid) {
        Vector retDeps = new Vector();
        Enumeration hkeys = this.m_delDeps.keys();
        while (hkeys.hasMoreElements()) {
            OiiiCompInstallID keyID = (OiiiCompInstallID)hkeys.nextElement();
            if (!cid.isCompatible(keyID) && !keyID.isCompatible(cid)) continue;
            Vector vDeps = (Vector)this.m_delDeps.get(keyID);
            OiixVectorOps.unionInPlace(retDeps, vDeps);
        }
        return retDeps;
    }

    public void setSelectedComps(OiiiCompInstallID[] selComps) {
        this.m_selectedComps = selComps;
    }

    public OiiiCompInstallID[] getSelectedComps() {
        return this.m_selectedComps;
    }

    public void setSelectedComp(OiiiCompInstallID selComp) {
        this.m_selectedComp = selComp;
    }

    public OiiiCompInstallID getSelectedComp() {
        return this.m_selectedComp;
    }

    public void addToTopLevelList(OiiiCompInstallID id) {
        if (OiixVectorOps.vectIndexOf(this.m_topComps, (Object)id) == -1) {
            this.m_topComps.addElement(id);
        }
    }

    public boolean isTopLevelComp(OiiiCompInstallID id) {
        boolean bRet = false;
        int nSize = this.m_topComps.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInstallID topId = (OiiiCompInstallID)this.m_topComps.elementAt(i);
            if (!topId.isCompatible(id) && !id.isCompatible(topId)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private class OiListObj
    implements Serializable {
        private OiiiCompInstallID m_cid;
        private int m_curPhase;
        private Object m_planInfo;
        private OiiiOneoffInstallID m_oid;

        OiListObj(OiiiCompInstallID cid, Object planInfo) {
            this.m_cid = cid;
            this.m_curPhase = 0;
            this.m_planInfo = planInfo;
        }

        OiListObj(OiiiCompInstallID cid) {
            this(cid, null);
        }

        OiListObj(OiiiOneoffInstallID oid, Object planInfo) {
            this.m_oid = oid;
            this.m_curPhase = 0;
            this.m_planInfo = planInfo;
        }

        OiListObj(OiiiOneoffInstallID oid) {
            this(oid, null);
        }

        OiiiCompInstallID getCompID() {
            return this.m_cid;
        }

        OiiiOneoffInstallID getOneoffID() {
            return this.m_oid;
        }

        Object getPlanInfo() {
            return this.m_planInfo;
        }

        public boolean equals(OiiiOneoffInstallID oid) {
            return this.m_oid.equals(oid);
        }

        public boolean equals(OiiiOneoffIdOhPair oidPair) {
            return this.m_planInfo.equals(oidPair);
        }

        public boolean equals(OiiiCompInstallID cid) {
            return this.m_cid.equalsWithPlatInt(cid);
        }

        public boolean equals(OiiiCompIdOhPair cIdOh) {
            return this.m_planInfo.equals(cIdOh);
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (obj instanceof OiiiCompInstallID) {
                    return this.equals((OiiiCompInstallID)obj);
                }
                if (obj instanceof OiiiCompIdOhPair) {
                    return this.equals((OiiiCompIdOhPair)obj);
                }
                if (obj instanceof OiiiOneoffInstallID) {
                    return this.equals((OiiiOneoffInstallID)obj);
                }
                if (obj instanceof OiiiOneoffIdOhPair) {
                    return this.equals((OiiiOneoffIdOhPair)obj);
                }
                return super.equals(obj);
            }
            return false;
        }

        void setPhase(int phase) {
            this.m_curPhase = phase;
        }

        int getPhase() {
            return this.m_curPhase;
        }
    }
}

