/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiic.OiicSessionContextConstants;
import oracle.sysman.oii.oiid.OiidVariableDef;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiicSessionVarsReader
implements OiicSessionContextConstants {
    private Document m_oSessionVarsDoc;
    private OiisVariableOwner m_oSessionContext = null;
    private XMLElement m_oVarListNode = null;
    private static String XML_JAR_FILE_NAME = "OraInstaller.jar";
    private static final String FIELD_SEPARATOR = "@";
    private static final String TRUE_VAL = "T";
    private static final String FALSE_VAL = "F";
    public static final String STRING_TYPE_NAME = OiisDataTypes.STRING.getName().toUpperCase(Locale.ENGLISH);
    public static final String BOOL_TYPE_NAME = OiisDataTypes.BOOL.getName().toUpperCase(Locale.ENGLISH).substring(0, 4);
    public static final String NUMBER_TYPE_NAME = OiisDataTypes.NUMBER.getName().toUpperCase(Locale.ENGLISH);
    public static final String STRINGLIST_TYPE_NAME = OiisDataTypes.STRINGLIST.getName().toUpperCase(Locale.ENGLISH);
    public static final String UNDEFINED_TYPE = "-1";

    public OiicSessionVarsReader(String pathToContextFile) throws OiixException {
        try {
            String sJarLoc = this.getSessionVarsJarLoc();
            OiixJarClassLoader oSessionVarJarLoader = OiixJarClassLoader.createLoader(sJarLoc);
            InputStream oInputStream = oSessionVarJarLoader.getLocalResourceAsStream(pathToContextFile);
            oSessionVarJarLoader.closeJarFile();
            this.m_oSessionVarsDoc = OixdDOMReader.getDocument(oInputStream);
            this.m_oVarListNode = (XMLElement)this.m_oSessionVarsDoc.getDocumentElement();
        }
        catch (SAXException se) {
            String[] msgArgs = new String[]{se.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, se);
        }
        catch (IOException ioe) {
            String[] msgArgs = new String[]{ioe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, ioe);
        }
        catch (ParserConfigurationException pe) {
            String[] msgArgs = new String[]{pe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, pe);
        }
    }

    public OiicSessionVarsReader(OiisVariableOwner sessionContext, String pathToContextFile) throws OiixException {
        try {
            String sJarLoc = this.getSessionVarsJarLoc();
            OiixJarClassLoader oSessionVarJarLoader = OiixJarClassLoader.createLoader(sJarLoc);
            InputStream oInputStream = oSessionVarJarLoader.getLocalResourceAsStream(pathToContextFile);
            oSessionVarJarLoader.closeJarFile();
            this.m_oSessionVarsDoc = OixdDOMReader.getDocument(oInputStream);
            this.m_oSessionContext = sessionContext;
            this.m_oVarListNode = (XMLElement)this.m_oSessionVarsDoc.getDocumentElement();
        }
        catch (SAXException se) {
            String[] msgArgs = new String[]{se.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, se);
        }
        catch (IOException ioe) {
            String[] msgArgs = new String[]{ioe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, ioe);
        }
        catch (ParserConfigurationException pe) {
            String[] msgArgs = new String[]{pe.getMessage()};
            String sContextInitError = this.formatErrorMessage("OUI-25000", msgArgs);
            throw new OiixException(sContextInitError, pe);
        }
    }

    public OiicSessionVarsReader(XMLElement oVarRoot) {
        this.m_oVarListNode = oVarRoot;
    }

    protected List getInstallSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar) {
        return this.readSessionVariablesFromXML(sessionContext, "INSTALLSESSIONVARS", ifResponseVar, null);
    }

    protected List getInstallSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar, Map varsOfUnknownType) {
        return this.readSessionVariablesFromXML(sessionContext, "INSTALLSESSIONVARS", ifResponseVar, varsOfUnknownType);
    }

    protected List getTopLevelSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar) {
        return this.readSessionVariablesFromXML(sessionContext, "TOPLEVELSESSIONVARS", ifResponseVar, null);
    }

    protected List getTopLevelSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar, Map varsOfUnknownType) {
        return this.readSessionVariablesFromXML(sessionContext, "TOPLEVELSESSIONVARS", ifResponseVar, varsOfUnknownType);
    }

    public List getComponentVariables(OiisVariableOwner sessionContext, boolean ifResponseVar) {
        return this.readSessionVariablesFromXML(sessionContext, "COMPONENTVARS", ifResponseVar, null);
    }

    public List getComponentVariables(OiisVariableOwner sessionContext, boolean ifResponseVar, Map varsOfUnknownType) {
        return this.readSessionVariablesFromXML(sessionContext, "COMPONENTVARS", ifResponseVar, varsOfUnknownType);
    }

    protected List getAllSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar) {
        return this.getAllSessionVariables(sessionContext, ifResponseVar, null);
    }

    protected List getAllSessionVariables(OiisVariableOwner sessionContext, boolean ifResponseVar, Map varsOfUnknownType) {
        List tempList = this.readSessionVariablesFromXML(sessionContext, "INSTALLSESSIONVARS", ifResponseVar, varsOfUnknownType);
        List tempList1 = this.readSessionVariablesFromXML(sessionContext, "TOPLEVELSESSIONVARS", ifResponseVar, varsOfUnknownType);
        tempList.addAll(tempList1);
        tempList1 = this.readSessionVariablesFromXML(sessionContext, "COMPONENTVARS", ifResponseVar, varsOfUnknownType);
        tempList.addAll(tempList1);
        return tempList;
    }

    public Hashtable getSessionVars() {
        Hashtable table = this.getVarsFromXML("INSTALLSESSIONVARS", false);
        return table;
    }

    protected Hashtable getVarsFromXML(String tagName, boolean bGlobalVar) {
        Hashtable<String, OiidVariableDef> hashtable = new Hashtable<String, OiidVariableDef>();
        NodeList oVarNodes = this.m_oVarListNode.getElementsByTagName(tagName);
        int nSize = oVarNodes.getLength();
        for (int i = 0; i < nSize; ++i) {
            Element oVarNode = (Element)oVarNodes.item(i);
            NodeList oVarNodeParent = oVarNode.getElementsByTagName("VAR");
            int nSizeVar = oVarNodeParent.getLength();
            for (int j = 0; j < nSizeVar; ++j) {
                Element oVarNode1 = (Element)oVarNodeParent.item(j);
                if (oVarNode1 == null) continue;
                String sVarName = oVarNode1.getAttribute("NAME");
                String sVarType = oVarNode1.getAttribute("TYPE");
                String sVarValue = oVarNode1.getAttribute("VALUE");
                boolean bVarAdvise = this.getBooleanValue(oVarNode1.getAttribute("ADVISE"));
                String sVarDescID = oVarNode1.getAttribute("DESC_ID");
                String sVarClass = oVarNode1.getAttribute("CLASS");
                if (sVarClass.equals("")) {
                    sVarClass = "oracle.sysman.oii.oiis.OiisVariable";
                }
                String sVarExtendsFrom = oVarNode1.getAttribute("EXTENDS_FROM");
                boolean bVarPublish = this.getBooleanValue(oVarNode1.getAttribute("PUBLISH"));
                boolean bVarAllowAssignment = this.getBooleanValue(oVarNode1.getAttribute("ALLOW_ASSIGNMENT"));
                boolean bVarComputeAtClone = this.getBooleanValue(oVarNode1.getAttribute("COMPUTE_AT_CLONE"));
                boolean bVarGenerate = this.getBooleanValue(oVarNode1.getAttribute("GENERATE"));
                boolean bVarValRequired = this.getBooleanValue(oVarNode1.getAttribute("VAL_REQD"));
                boolean bVarCalculationReqd = this.getBooleanValue(oVarNode1.getAttribute("CALC_REQD"));
                boolean bVarHandleErrors = this.getBooleanValue(oVarNode1.getAttribute("HANDLE_ERRORS"));
                boolean bShowInOsp = this.getBooleanValue(oVarNode1.getAttribute("SHOW_IN_OSP"));
                boolean bSecure = this.getBooleanValue(oVarNode1.getAttribute("SECURE"));
                int nType = 0;
                switch (this.getTypeValue(sVarType)) {
                    case 2: {
                        nType = 2;
                        break;
                    }
                    case 3: {
                        nType = 3;
                        break;
                    }
                    case 1: {
                        nType = 1;
                        break;
                    }
                    case 4: {
                        nType = 4;
                    }
                }
                if (!bGlobalVar && 0 == nType) {
                    nType = 1;
                }
                if (bGlobalVar) {
                    bShowInOsp = true;
                }
                OiidVariableDef def = new OiidVariableDef(sVarName, nType, bShowInOsp, bVarValRequired, bVarCalculationReqd, sVarExtendsFrom, sVarDescID, bVarHandleErrors, !bVarAllowAssignment, !bGlobalVar, bSecure);
                hashtable.put(sVarName, def);
            }
        }
        return hashtable;
    }

    private String formatErrorMessage(String resourceId, String[] args) {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resourceId, args);
    }

    private boolean getBooleanValue(String s) {
        boolean bRet = false;
        if (s != null && s.equalsIgnoreCase(TRUE_VAL)) {
            bRet = true;
        }
        return bRet;
    }

    private int getTypeValue(String s) {
        int type = 1;
        if (s.compareTo(STRING_TYPE_NAME) == 0) {
            type = 1;
        } else if (s.compareTo(BOOL_TYPE_NAME) == 0) {
            type = 3;
        } else if (s.compareTo(NUMBER_TYPE_NAME) == 0) {
            type = 2;
        } else if (s.compareTo(STRINGLIST_TYPE_NAME) == 0) {
            type = 4;
        } else if (s.compareTo(UNDEFINED_TYPE) == 0) {
            type = -1;
        }
        return type;
    }

    protected List readSessionVariablesFromXML(OiisVariableOwner sessionContext, String tagName, boolean ifResponseVar, Map varsOfUnknownType) {
        LinkedList<OiisVariable> tempList = new LinkedList<OiisVariable>();
        NodeList oVarNodes = this.m_oVarListNode.getElementsByTagName(tagName);
        int nSize = oVarNodes.getLength();
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        for (int i = 0; i < nSize; ++i) {
            Element oVarNode = (Element)oVarNodes.item(i);
            NodeList oVarNodeParent = oVarNode.getElementsByTagName("VAR");
            int nSizeVar = oVarNodeParent.getLength();
            for (int j = 0; j < nSizeVar; ++j) {
                Element oVarNode1 = (Element)oVarNodeParent.item(j);
                if (oVarNode1 == null) continue;
                String sVarName = oVarNode1.getAttribute("NAME");
                String sVarType = oVarNode1.getAttribute("TYPE");
                String sVarValue = oVarNode1.getAttribute("VALUE");
                boolean bIsValSpecified = oVarNode1.hasAttribute("VALUE");
                boolean bVarAdvise = this.getBooleanValue(oVarNode1.getAttribute("ADVISE"));
                String sVarDescID = oVarNode1.getAttribute("DESC_ID");
                String sVarClass = oVarNode1.getAttribute("CLASS");
                if (sVarClass.equals("")) {
                    sVarClass = "oracle.sysman.oii.oiis.OiisVariable";
                }
                String sVarExtendsFrom = oVarNode1.getAttribute("EXTENDS_FROM");
                boolean bVarPublish = this.getBooleanValue(oVarNode1.getAttribute("PUBLISH"));
                boolean bVarAllowAssignment = this.getBooleanValue(oVarNode1.getAttribute("ALLOW_ASSIGNMENT"));
                boolean bVarComputeAtClone = this.getBooleanValue(oVarNode1.getAttribute("COMPUTE_AT_CLONE"));
                boolean bVarGenerate = this.getBooleanValue(oVarNode1.getAttribute("GENERATE"));
                boolean bVarValueRequired = this.getBooleanValue(oVarNode1.getAttribute("VAL_REQD"));
                boolean bVarCalculationReqd = this.getBooleanValue(oVarNode1.getAttribute("CALC_REQD"));
                boolean bVarHandleErrors = this.getBooleanValue(oVarNode1.getAttribute("HANDLE_ERRORS"));
                boolean bShowInOsp = this.getBooleanValue(oVarNode1.getAttribute("SHOW_IN_OSP"));
                boolean bSecure = this.getBooleanValue(oVarNode1.getAttribute("SECURE"));
                OiisVariable oVar = null;
                Class<?> oVarOwnerClass = null;
                try {
                    oVarOwnerClass = Class.forName("oracle.sysman.oii.oiis.OiisVariableOwner");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                Object[] oConstrArgs = new Object[]{sessionContext, sVarName};
                Class[] oConstrArgTypes = new Class[]{oVarOwnerClass, sVarName.getClass()};
                Constructor<?> oConstr = null;
                try {
                    Class<?> oClass = Class.forName(sVarClass);
                    oConstr = oClass.getConstructor(oConstrArgTypes);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                try {
                    oVar = (OiisVariable)oConstr.newInstance(oConstrArgs);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                int loc = sVarDescID.indexOf(FIELD_SEPARATOR);
                if (loc != -1) {
                    String sBundleName = sVarDescID.substring(loc + 1, sVarDescID.length());
                    sVarDescID = sVarDescID.substring(0, loc);
                    jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle(sBundleName));
                }
                oVar.setDescriptionID(sVarDescID);
                oVar.setComputeAtClone(bVarComputeAtClone);
                if (this.getTypeValue(sVarType) == 2) {
                    if (sVarValue != null && sVarValue.length() > 0) {
                        Integer iValue = new Integer(sVarValue);
                        oVar.setValueWithoutValidation(iValue);
                    }
                } else if (this.getTypeValue(sVarType) == 3) {
                    if (sVarValue != null && sVarValue.length() > 0) {
                        Boolean bValue = new Boolean(this.getBooleanValue(sVarValue));
                        oVar.setValueWithoutValidation(bValue);
                    }
                } else if (this.getTypeValue(sVarType) == 1) {
                    if (sVarValue != null && sVarValue.length() > 0) {
                        oVar.setValueWithoutValidation(sVarValue);
                    } else if (bIsValSpecified && tagName.equalsIgnoreCase("GLOBALVARS")) {
                        oVar.setValueWithoutValidation("");
                    }
                } else if (this.getTypeValue(sVarType) == 4) {
                    if (sVarValue != null) {
                        String[] sStringList = OiisDataTypes.getStringListObject(sVarValue);
                        oVar.setValueWithoutValidation(sStringList);
                    }
                } else if (varsOfUnknownType != null) {
                    varsOfUnknownType.put(sVarName, sVarValue);
                }
                oVar.setAdvice(bVarAdvise);
                oVar.setType(this.getTypeValue(sVarType));
                if (sVarExtendsFrom.length() > 0) {
                    oVar.setExtendsFrom(sVarExtendsFrom);
                }
                oVar.setAllowAssignment(bVarAllowAssignment);
                oVar.setHandleErrors(bVarHandleErrors);
                oVar.setPublish(bVarPublish);
                oVar.setValueReqd(bVarValueRequired);
                oVar.setShowInOSP(bShowInOsp);
                oVar.setSecure(bSecure);
                oVar.setCalcMethodPresent(bVarCalculationReqd);
                boolean bSuppress = this.getBooleanValue(oVarNode1.getAttribute("SUPPRESS_ON_SILENT"));
                oVar.setSuppressedOnSilent(bSuppress);
                if (ifResponseVar) {
                    oVar.setGenerateRSP(bVarGenerate);
                    String sVarDefn = oVarNode1.getAttribute("VAR_DEF");
                    oVar.setExported(true);
                    String sVarRespValue = oVarNode1.getAttribute("RESP_VAR");
                    if (!sVarRespValue.equals("")) {
                        oVar.setInitialValue(new OiisAdvisedValue(sVarRespValue, false));
                    }
                    Object[] objs = new String[2];
                    String sDesc = null;
                    sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                    objs[0] = sVarName;
                    objs[1] = sVarDefn;
                    sDesc = MessageFormat.format(sDesc, objs);
                    oVar.setAllValueList(sDesc);
                }
                oVar.setResourceBundle(jrb);
                String description = jrb.getString(oVar.getDescriptionID());
                if (description != null && description.trim().length() > 0) {
                    oVar.setDescription(description);
                } else {
                    oVar.setDescription(oVar.getDescriptionID());
                }
                if (oVar == null) continue;
                tempList.add(oVar);
            }
        }
        return tempList;
    }

    public static String getTypeStringValue(int type) {
        String typeString = STRING_TYPE_NAME;
        if (type == 1) {
            typeString = OiisDataTypes.STRING.getName().toUpperCase();
        } else if (type == 3) {
            typeString = BOOL_TYPE_NAME;
        } else if (type == 2) {
            typeString = NUMBER_TYPE_NAME;
        } else if (type == 4) {
            typeString = STRINGLIST_TYPE_NAME;
        } else if (type == -1) {
            typeString = UNDEFINED_TYPE;
        }
        return typeString;
    }

    public static String setBooleanValue(boolean flag) {
        String boolVal = FALSE_VAL;
        if (flag) {
            boolVal = TRUE_VAL;
        }
        return boolVal;
    }

    protected String getSessionVarsJarLoc() {
        String sSessionVarsJarLoc = System.getProperty("oracle.installer.oui_loc");
        sSessionVarsJarLoc = OiixPathOps.concatPath(sSessionVarsJarLoc.trim(), "/jlib/" + XML_JAR_FILE_NAME);
        sSessionVarsJarLoc = OiixPathOps.getNativeForm(sSessionVarsJarLoc);
        return sSessionVarsJarLoc;
    }
}

