/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.text.DateFormat;
import java.util.Date;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicSilentInstallPhaseProgressListener
implements OiifrProgressActionListener {
    private static final String _sSpace = " ";
    private static final String _s2Space = "  ";
    private static final String _s3Space = "   ";
    private static final String _sStartBrace = "(";
    private static final String _sEndBrace = ")";
    private long m_totalBytes = 0L;
    private long m_currentBytes;
    private int m_progressDisplayed;
    private boolean m_bProgressCompleted;
    private int m_lineProgressDisplayed;
    private long m_carry;
    private boolean m_bDeinstall;
    private boolean m_bDoneProgress;
    private int m_iPhases = 0;
    private int m_iLastPhase = 0;
    private int m_iCurrentPhase = 0;
    private static final int PROG_PER_LINE = 63;
    private static final long MAX_FACTOR_PER_BIT = 0x500000L;
    private int FACTOR_PER_BIT = 0x500000;
    private int NUM_LINES = 1;
    private int m_nProgUnits = 63 * this.NUM_LINES;
    private int m_nCurrentRun = 1;
    private final String _sProgressChar = ".";
    private boolean m_bIvwPhase;

    public OiicSilentInstallPhaseProgressListener() {
        this(false, 0, 0);
    }

    public OiicSilentInstallPhaseProgressListener(boolean bShowLayout, int phases, int lastPhase) {
        if (bShowLayout) {
            this.showProgressLayout();
            this.m_iPhases = phases;
            this.m_iLastPhase = lastPhase;
        }
    }

    public void setIvwPhase(boolean bIvwPhase) {
        this.m_bIvwPhase = bIvwPhase;
    }

    private void reset() {
        this.m_currentBytes = 0L;
        this.m_progressDisplayed = 0;
        this.m_carry = 0L;
        this.m_lineProgressDisplayed = 0;
        this.m_nCurrentRun = 1;
        this.m_bProgressCompleted = false;
    }

    public void setTotalBytes(long bytes) {
        this.reset();
        this.m_totalBytes = bytes;
        this.FACTOR_PER_BIT = this.computeFactorPerBit(this.m_totalBytes);
        this.NUM_LINES = (int)(this.m_totalBytes / (long)(this.FACTOR_PER_BIT * 63));
        int rem = 0;
        if (this.NUM_LINES == 0) {
            this.NUM_LINES = 1;
            rem = 0;
        } else {
            rem = (int)(this.m_totalBytes % (long)(this.FACTOR_PER_BIT * 63) / (long)this.FACTOR_PER_BIT);
            rem %= 63;
        }
        this.m_nProgUnits = this.NUM_LINES * 63 + rem;
    }

    public void setStatus(String status) {
    }

    public void addBytes(int bytes) {
        if (bytes == 0 || this.m_bProgressCompleted) {
            return;
        }
        this.m_currentBytes += (long)bytes;
        if (this.m_totalBytes > 0L) {
            if (this.m_currentBytes > this.m_totalBytes) {
                return;
            }
            long goAhead = ((long)bytes + this.m_carry) * (long)this.m_nProgUnits / this.m_totalBytes;
            this.m_carry = goAhead > 0L ? ((long)bytes + this.m_carry) * (long)this.m_nProgUnits % this.m_totalBytes / this.m_currentBytes : (this.m_carry += (long)bytes);
            if ((long)this.m_progressDisplayed + goAhead <= (long)this.m_nProgUnits) {
                int tempGoAhead = (int)goAhead;
                int tempProg = this.m_progressDisplayed;
                while ((long)this.m_lineProgressDisplayed + goAhead >= 63L) {
                    this.displayProgress(63 - this.m_lineProgressDisplayed);
                    goAhead = (long)this.m_lineProgressDisplayed + goAhead - 63L;
                    int progAmount = 100 * (tempProg + 63 - this.m_lineProgressDisplayed) / this.m_nProgUnits;
                    tempProg += 63 - this.m_lineProgressDisplayed;
                    this.m_lineProgressDisplayed = 0;
                    if (progAmount < 100 && this.NUM_LINES > 1) {
                        System.out.print(this.getProgressAmtMessage(progAmount));
                        System.out.println();
                    }
                    if (goAhead >= 63L) continue;
                    break;
                }
                this.displayProgress(goAhead);
                this.m_lineProgressDisplayed += (int)goAhead;
                this.m_progressDisplayed += tempGoAhead;
            }
        } else {
            this.completeProgressDisplay();
        }
    }

    public void removeBytes(int bytes) {
    }

    private void displayProgress(long goAhead) {
        for (long i = 0L; i < goAhead; ++i) {
            System.out.print(".");
            System.out.flush();
        }
    }

    private void displayEmpty(long goAhead) {
        for (long i = 0L; i < goAhead; ++i) {
            System.out.print(_sSpace);
        }
    }

    private void showProgressLayout() {
        System.out.println();
    }

    private void setHeader(String lhs) {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, OiixLanguage.getDefaultLocale());
        System.out.println(lhs + _sSpace + _sStartBrace + df.format(new Date()) + _sEndBrace);
    }

    public void onDoneProgress() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, OiixLanguage.getDefaultLocale());
        if (!this.m_bIvwPhase && !this.m_bDoneProgress) {
            this.m_bDoneProgress = true;
            System.out.println();
            System.out.println(OiixResourceBundle.getString("S_END_INSTALL_PHASES") + _sStartBrace + df.format(new Date()) + _sEndBrace);
        } else if (this.m_bIvwPhase) {
            this.completeProgressDisplay();
        }
    }

    private void completeProgressDisplay() {
        block6: {
            int remaining = this.m_nProgUnits - this.m_progressDisplayed;
            if (remaining > 0) {
                while (this.m_lineProgressDisplayed + remaining >= 63) {
                    int disp = 63 - this.m_lineProgressDisplayed;
                    this.displayProgress(disp);
                    int progAmount = 100 * this.m_progressDisplayed / this.m_nProgUnits;
                    this.m_progressDisplayed += disp;
                    remaining -= disp;
                    this.m_lineProgressDisplayed = 0;
                    if (progAmount < 100 && this.NUM_LINES > 1) {
                        System.out.print(this.getProgressAmtMessage(progAmount));
                        System.out.println();
                    }
                    if (remaining >= 63) continue;
                    this.displayProgress(remaining);
                    if (remaining > 0 && this.NUM_LINES > 1) {
                        this.displayEmpty(63 - remaining);
                    }
                    break block6;
                }
                this.displayProgress(remaining);
                if (remaining > 0 && this.NUM_LINES > 1) {
                    this.displayEmpty(63 - remaining);
                }
            }
        }
        this.m_progressDisplayed = this.m_nProgUnits;
        if (!this.m_bProgressCompleted) {
            System.out.println(" 100" + OiixResourceBundle.getString("S_PERCENT_DONE"));
            System.out.println();
            this.m_bProgressCompleted = true;
        }
    }

    private void completePhaseDisplay(int phase) {
        if (!this.m_bProgressCompleted) {
            boolean bLastPhase = this.isLastPhase(phase);
            if (bLastPhase) {
                this.m_bProgressCompleted = true;
            }
            int progAmount = bLastPhase ? 100 : this.m_progressDisplayed * 100 / this.m_nProgUnits;
            int rem = 63 - this.m_lineProgressDisplayed;
            if (this.m_lineProgressDisplayed != 0) {
                this.displayEmpty(rem);
                System.out.println(this.getProgressAmtMessage(progAmount));
            }
        }
        System.out.println(OiifrProgressPhases.getPhaseDoneString(phase));
        this.m_lineProgressDisplayed = 0;
    }

    public void onCurrentComponent(String Comp) {
    }

    public void onStartDeinstall() {
        this.onStartPhase(1);
    }

    public void onSuspend() {
    }

    public void onResume() {
    }

    public void addPercentage(int percent) {
        this.addBytes((int)(this.m_totalBytes * (long)percent / 100L));
    }

    public boolean isNewProgressUsed() {
        return false;
    }

    public void setTitle(String title) {
        if (this.m_bIvwPhase) {
            System.out.println();
            System.out.println(title);
        }
    }

    public void onDoneDeinstall() {
        this.completeProgressDisplay();
        this.m_bProgressCompleted = true;
        this.reset();
    }

    private String getProgressAmtMessage(int progAmount) {
        return (progAmount < 10 ? _s3Space : (progAmount == 100 ? _sSpace : _s2Space)) + progAmount + OiixResourceBundle.getString("S_PERCENT_DONE");
    }

    public void onStartPhase(int phase) {
        if ((phase & this.m_iPhases) > 0 && this.m_iCurrentPhase != phase) {
            System.out.println();
            this.setHeader(OiifrProgressPhases.getPhaseInProgressString(phase));
            this.m_iCurrentPhase = phase;
        }
    }

    public void onDonePhase(int phase) {
        if ((phase & this.m_iPhases) > 0) {
            this.completePhaseDisplay(phase);
        }
    }

    public boolean isLastPhase(int phase) {
        return this.m_iLastPhase == phase;
    }

    private int computeFactorPerBit(long totalBytes) {
        long lFactor = Math.max(1L, totalBytes / 100L);
        return (int)Math.min(lFactor, 0x500000L);
    }
}

