/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallReboot;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSilentInstallPhaseProgressListener;
import oracle.sysman.oii.oiic.OiicSilentModeCancelHandler;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigController;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigLauncher;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfo;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfoPerSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbSilentRetryAdapter;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodePhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwAutoConfigWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwPrereqWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqProgress;
import oracle.sysman.oip.oipf.oipfc.OipfcSilentModeProgress;

public class OiicSilentInterfaceManager
extends OiicSessionInterfaceManager
implements OiixWorkNotifiable {
    private static final int NEXT = 0;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private static final String _sSpace = "    ";
    private static final String _sStartBrace = "(";
    private static final String _sEndBrace = ")";
    private static final String _sEquals = " = ";
    private static final int TOOL_CANCELED = -1;
    private static final int TOOL_FAILED = 1;
    private static final int TOOL_SUCCEEDED = 0;
    private Vector m_logVars;
    private OiifbSyncObject m_toolFinishSync;
    private Vector m_recToolNames;
    private Vector m_optToolNames;
    private OiifbConfigLauncher m_configLauncher;
    private OiicPullSession m_pullSession;
    private OiicInstPostActionsPhase m_phase;
    private boolean m_bSkipRemainingTools;
    private boolean m_bSkipAllConfigTools = !Boolean.getBoolean("oracle.installer.config");
    private boolean m_bNoConfigMsgPrinted = false;
    private StringBuffer m_sbLogBuffer = new StringBuffer();
    private Vector m_configTools = new Vector();
    private Vector m_pluginList = new Vector();
    private OiifbConfigController m_controller;
    private boolean noConfigSetForRootSh = false;

    public OiicSilentInterfaceManager() {
        this.m_logVars = new Vector();
    }

    public int doWizardPageOperation(OiifbWizChainDlgElem wizardElem, boolean isBack) throws OiifbEndIterateException {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        if (isBack) {
            throw new OiifbEndIterateException("");
        }
        OiisVariableOwner oVarOwner = wizardElem.getVarOwner();
        Vector vInOutElems = wizardElem.getInOutElems();
        Vector vUnInitializedElems = wizardElem.getAllUnInitializedElems();
        if (vUnInitializedElems != null && vUnInitializedElems.size() != 0) {
            String sErrorMsg = this.formatErrorMessage(vUnInitializedElems);
            OiiolTextLogger.writeMessageToConsole(sErrorMsg.toString());
            throw new OiifbEndIterateException(sErrorMsg.toString());
        }
        try {
            wizardElem.validate();
        }
        catch (OiifbCancelException e) {
            throw new OiifbEndIterateException(e);
        }
        if (Boolean.getBoolean("oracle.installer.showVariables")) {
            this.setVariablesToLog(oVarOwner, vInOutElems);
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg(wizardElem.getDisplayName(), System.currentTimeMillis() - lTime);
        }
        return 0;
    }

    private String formatErrorMessage(Vector vUnInitializedElems) {
        StringBuffer sVarsList = new StringBuffer();
        int size = vUnInitializedElems.size();
        for (int i = 0; i < size; ++i) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)vUnInitializedElems.elementAt(i);
            sVarsList.append(elem.getVarName());
            sVarsList.append(_sStartBrace + elem.getProperty() + _sEndBrace);
            if (i == size - 1) continue;
            sVarsList.append(",\n  ");
        }
        Object[] values = new String[]{sVarsList.toString()};
        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SILENT_VAR_NOT_SET");
        sMsg = MessageFormat.format(sMsg, values);
        StringBuffer sErrorMsg = new StringBuffer(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_ALERT_ERROR"));
        sErrorMsg.append(sMsg);
        return sErrorMsg.toString();
    }

    public void logVariablesToConsole(OiisVariableOwner oVarOwner, Vector vInOutElems) {
        int nSize = vInOutElems.size();
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < nSize; ++i) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)vInOutElems.elementAt(i);
            buf.append("   " + elem.getProperty());
            OiisVariable v = oVarOwner.getVariable(elem.getVarName());
            Object dispVal = v.getLogValue();
            buf.append(" (" + v.getName() + _sEndBrace);
            buf.append(_sEquals);
            dispVal = v.getLogValue();
            if (dispVal instanceof String[]) {
                dispVal = OiiolTextLogger.StringArrayToStringBuf((String[])dispVal);
            }
            buf.append(dispVal);
        }
        OiiolTextLogger.writeMessageToConsole(buf.toString());
    }

    public void setVariablesToLog(OiisVariableOwner oVarOwner, Vector vInOutElems) {
        int nSize = vInOutElems.size();
        for (int i = 0; i < nSize; ++i) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)vInOutElems.elementAt(i);
            OiisVariable v = oVarOwner.getVariable(elem.getVarName());
            String sProperty = elem.getProperty();
            Object dispVal = v.getLogValue();
            dispVal = v.getLogValue();
            if (dispVal instanceof String[]) {
                dispVal = OiiolTextLogger.StringArrayToStringBuf((String[])dispVal);
            }
            Object[] args = new Object[]{sProperty, v.getName(), dispVal, v.getValueTypeLogString()};
            this.m_logVars.addElement(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_SETTING_VAR_VALUE_CONSOLE", args));
        }
    }

    public void logVarDetails() {
        int iSize = this.m_logVars.size();
        if (iSize > 0) {
            OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_VAR_CONSOLE"));
        }
        for (int i = 0; i < iSize; ++i) {
            OiiolTextLogger.writeMessageToConsole(this.m_logVars.elementAt(i).toString());
        }
        if (iSize > 0) {
            OiiolTextLogger.writeMessageToConsole("-----------------------------------------------------------------------------");
        }
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity, boolean bSelectable) {
        return this.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity);
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity) {
        int result = defaultChoice;
        String sMsg = OiifmAlert.formatAlertMessageForLog(severity, msg);
        OiiolTextLogger.writeMessageToConsole(sMsg);
        OiiolTextLogger.appendErrorText(sMsg, false);
        if (severity == 20) {
            result = (userChoices & 4) == 4 ? 4 : ((userChoices & 2) == 2 ? 2 : 1);
        }
        return result;
    }

    public OiixProgressListener getProgressListener() {
        if (this.m_progressListener != null) {
            return this.m_progressListener;
        }
        OiicSilentInstallPhaseProgressListener l = new OiicSilentInstallPhaseProgressListener();
        l.setIvwPhase(true);
        this.m_progressListener = l;
        return this.m_progressListener;
    }

    public void setProgressListener(OiixProgressListener listener) {
        this.m_progressListener = listener;
    }

    public OiicInstallCancelHandler getInstallCancelHandler(int flags, String msg, int type) {
        return new OiicSilentModeCancelHandler(this, flags, msg, type);
    }

    public OiifbIRetry getRetryHandler(String msg, int flags, int type) {
        return new OiifbSilentRetryAdapter(msg, flags, type);
    }

    public OiifbIRetry getRetryHandler(String title, String msg, int flags, int type, boolean bCancel) {
        return this.getRetryHandler(msg, flags, type);
    }

    public boolean processLicenceDialog() throws OiifbEndIterateException {
        OiisVariable oVar;
        Boolean val;
        boolean bRetVal = true;
        String lic = this.getLicenceFileName();
        if (lic == null) {
            return bRetVal;
        }
        OiicPullSession oSession = null;
        if (this.getSession() instanceof OiicPullSession && (val = (Boolean)(oVar = (oSession = (OiicPullSession)this.getSession()).getSessionContext().getVariable("ACCEPT_LICENSE_AGREEMENT")).getValue()) != null) {
            Object[] args = new Object[]{lic};
            if (val.booleanValue()) {
                OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SILENT_LICENSE_TRUE", args));
            } else {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SILENT_LICENSE_FALSE", args);
                OiiolTextLogger.writeMessageToConsole(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
        }
        return bRetVal;
    }

    public String getRootSHMessage(Object[] args, boolean bCluster) {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", bCluster ? "S_RUN_ROOTSH_CLUSTER_SILENT" : "S_RUN_ROOTSH_PROMPT_SILENT", args);
    }

    public void logMessage(String sMessage) {
        OiiolTextLogger.writeMessageToConsole(sMessage);
        OiiolTextLogger.appendText(sMessage);
    }

    public int doInvSetupOperations(String sInvLoc, String unixGroup) throws OiifbEndIterateException {
        int retVal = super.doInvSetupOperations(sInvLoc, unixGroup);
        if (retVal == 0) {
            return retVal;
        }
        throw new OiifbEndIterateException("");
    }

    public boolean performInvSetupRootOperations(String[] nodeList) throws IOException {
        if (this.getSession() instanceof OiicPullSession) {
            OiicPullSession oSession = (OiicPullSession)this.getSession();
            oSession.setInstRootSHNeeded(true);
        }
        return true;
    }

    public void showMessage(String sMessage) {
        super.showMessage(sMessage);
        OiiolTextLogger.writeMessageToConsole(sMessage);
    }

    public String getDiskLocation(String sDefaultLoc, String label, int nDiskNumber) throws OiiiDiskNotFoundException {
        Object[] args = new Object[]{label};
        String sMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_USER_CANCEL_DISK_FIND", args);
        OiiolTextLogger.writeMessageToConsole("");
        OiiolTextLogger.writeMessageToConsole(sMessage);
        throw new OiiiDiskNotFoundException(sMessage);
    }

    public int getToolCount() {
        int iToolCount = 0;
        if (null != this.m_configTools) {
            int size = this.m_configTools.size();
            for (int i = 0; i < size; ++i) {
                OiifbConfigToolInfoPerSession configToolWrapper = (OiifbConfigToolInfoPerSession)this.m_configTools.elementAt(i);
                iToolCount += configToolWrapper.getRecPluginList().size();
                iToolCount += configToolWrapper.getOptPluginList().size();
            }
        }
        return iToolCount;
    }

    public void listPlugins() {
        if (null != this.m_configTools) {
            int size = this.m_configTools.size();
            int rowCount = 0;
            for (int i = 0; i < size; ++i) {
                Vector optTools;
                OiifbConfigToolInfoPerSession configToolWrapper = (OiifbConfigToolInfoPerSession)this.m_configTools.elementAt(i);
                Vector recTools = configToolWrapper.getRecPluginList();
                if (null != recTools) {
                    for (int k = 0; k < recTools.size(); ++k) {
                        this.m_pluginList.add(rowCount++, recTools.elementAt(k));
                    }
                }
                if (null == (optTools = configToolWrapper.getOptPluginList())) continue;
                for (int j = 0; j < optTools.size(); ++j) {
                    this.m_pluginList.add(rowCount++, optTools.elementAt(j));
                }
            }
        }
    }

    public int processConfigTools(OiifwAutoConfigWCDE wizElem, boolean isBack, OiicInstPostActionsPhase postActionsPhase, Vector pluginList) throws OiifbEndIterateException {
        boolean bAllOptSucceeded;
        this.m_configTools = pluginList;
        this.m_phase = postActionsPhase;
        this.m_pullSession = wizElem.getInstallSession();
        this.m_controller = new OiifbConfigController();
        this.m_toolFinishSync = new OiifbSyncObject();
        this.listPlugins();
        long lTime = 0L;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        Vector vVolumeInfo = null;
        int size = this.getToolCount();
        if (size > 0 && isDebugTMD) {
            lTime = System.currentTimeMillis();
            vVolumeInfo = this.m_pullSession.getVolumeInfo();
            OiixDebug.printConfigDebugTMDMesages("Start of launching config tools ", lTime, 0L, vVolumeInfo);
        }
        String sStartOfToolsMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_BEGIN_TOOLS");
        OiiolTextLogger.writeToLogAndConsole(sStartOfToolsMsg);
        boolean bToolExecutionResult = this.launchToolsForCfw();
        boolean bAllRecSucceeded = !this.m_controller.isRecommendedToolFailed();
        boolean bl = bAllOptSucceeded = !this.m_controller.isOptionalToolFailed();
        if (size > 0 && isDebugTMD) {
            long lElapsedTime = System.currentTimeMillis();
            OiixDebug.printConfigDebugTMDMesages("End of launching config tools ", lElapsedTime, lElapsedTime - lTime, vVolumeInfo);
        }
        if (!bAllRecSucceeded || !bAllOptSucceeded || this.m_bSkipAllConfigTools) {
            this.m_sbLogBuffer = new StringBuffer();
            this.logUnsuccessfulTools();
        } else {
            OiiolTextLogger.appendText(OiixCFOps.getConfigToolCommandsMessage(false));
            OiiolTextLogger.appendText("-----------------------------------------------------------------------------", OiiolTextLogger.LOG_WITHOUT_LEVEL);
        }
        this.m_sbLogBuffer = new StringBuffer();
        this.m_pullSession.setSuccessfulOptionalTools(bAllOptSucceeded);
        this.m_pullSession.setSuccessfulRecommendedTools(bAllRecSucceeded);
        return 0;
    }

    public int processConfigTools(OiifwAutoConfigWCDE wizElem, boolean isBack, OiicInstPostActionsPhase postActionsPhase, Vector recToolNames, Vector optToolNames) throws OiifbEndIterateException {
        this.m_recToolNames = recToolNames;
        this.m_optToolNames = optToolNames;
        this.m_phase = postActionsPhase;
        this.m_pullSession = wizElem.getInstallSession();
        this.m_configLauncher = new OiifbConfigLauncher(postActionsPhase);
        this.m_toolFinishSync = new OiifbSyncObject();
        long lTime = 0L;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        Vector vVolumeInfo = null;
        int size = this.m_optToolNames.size() + this.m_recToolNames.size();
        if (size > 0 && isDebugTMD) {
            lTime = System.currentTimeMillis();
            vVolumeInfo = this.m_pullSession.getVolumeInfo();
            OiixDebug.printConfigDebugTMDMesages("Start of launching config tools ", lTime, 0L, vVolumeInfo);
        }
        String sStartOfToolsMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_BEGIN_TOOLS");
        OiiolTextLogger.writeToLogAndConsole(sStartOfToolsMsg);
        boolean bAllRecSucceeded = this.launchTools(true);
        boolean bAllOptSucceeded = this.launchTools(false);
        if (size > 0 && isDebugTMD) {
            long lElapsedTime = System.currentTimeMillis();
            OiixDebug.printConfigDebugTMDMesages("End of launching config tools ", lElapsedTime, lElapsedTime - lTime, vVolumeInfo);
        }
        if (!bAllRecSucceeded || !bAllOptSucceeded || this.m_bSkipAllConfigTools) {
            this.logUnsuccessfulTools();
            this.logSkippedConfigTools();
        }
        this.m_sbLogBuffer = new StringBuffer();
        this.m_pullSession.setSuccessfulOptionalTools(bAllRecSucceeded && bAllOptSucceeded);
        return 0;
    }

    private void setPhase(OiiiCompInstallID cid, int pNum) {
        this.m_pullSession.getSessionPlan().setAdditionPhase(cid, pNum);
    }

    public OiifbConfigToolInfo getToolInfo(int index) {
        return (OiifbConfigToolInfo)this.m_pluginList.elementAt(index);
    }

    public void setAllToolStatus(int status) {
        for (int row = 0; row < this.m_pluginList.size(); ++row) {
            OiifbConfigToolInfo toolInfo = (OiifbConfigToolInfo)this.m_pluginList.elementAt(row);
            toolInfo.setToolStatus(status);
            this.m_pluginList.setElementAt(toolInfo, row);
            if (toolInfo.getToolType() == 0) {
                this.m_controller.setRecommendedToolsSkipped();
                continue;
            }
            if (toolInfo.getToolType() != 1) continue;
            this.m_controller.setOptionalToolsSkipped();
        }
    }

    public void setStatus(String toolname, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, int status, String sMsg) {
        for (int row = 0; row < this.m_pluginList.size(); ++row) {
            OiifbConfigToolInfo toolInfo = (OiifbConfigToolInfo)this.m_pluginList.elementAt(row);
            if (!toolname.equals(toolInfo.getToolName()) || !oraHomeName.equals(toolInfo.getOraHome()) || !compName.equals(toolInfo.getAggrName()) || !actionName.equals(toolInfo.getActionID()) || !stepIdx.equals(toolInfo.getStepIndex()) || !microStepIdx.equals(toolInfo.getMicroStepIndex())) continue;
            toolInfo.setToolStatus(status);
            toolInfo.setToolCommand(sMsg);
            this.m_pluginList.setElementAt(toolInfo, row);
            break;
        }
    }

    public OiifbConfigToolInfo getToolInfo(String toolname, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx) {
        OiifbConfigToolInfo oToolInfo = null;
        for (int row = 0; row < this.m_pluginList.size(); ++row) {
            OiifbConfigToolInfo toolInfo = (OiifbConfigToolInfo)this.m_pluginList.elementAt(row);
            if (!toolname.equals(toolInfo.getToolName()) || !oraHomeName.equals(toolInfo.getOraHome()) || !compName.equals(toolInfo.getAggrName()) || !actionName.equals(toolInfo.getActionID()) || !stepIdx.equals(toolInfo.getStepIndex()) || !microStepIdx.equals(toolInfo.getMicroStepIndex())) continue;
            oToolInfo = toolInfo;
            break;
        }
        return oToolInfo;
    }

    private boolean launchToolsForCfw() {
        boolean allSucceeded = true;
        boolean bRecommendedToolFailed = false;
        int size = this.getToolCount();
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        Vector vVolumeInfo = null;
        if (size > 0 && isDebugTMD) {
            vVolumeInfo = this.m_pullSession.getVolumeInfo();
        }
        this.m_controller.initialize(this, this.m_bSkipAllConfigTools, this.m_phase, this.m_pullSession);
        int nToolsSuccessStatus = this.m_controller.launchConfigToolsForSilent();
        allSucceeded = !this.m_controller.isRecommendedToolFailed() && !this.m_controller.isOptionalToolFailed();
        if (this.m_bSkipAllConfigTools) {
            allSucceeded = false;
        }
        if (!allSucceeded) {
            String rerunStr = "";
            if (this.m_controller.isRecommendedToolFailed()) {
                rerunStr = OiixResourceBundle.getString("S_WARNING_FAILED_RECOMMENDED_TOOLS");
            } else if (this.m_controller.isOptionalToolFailed()) {
                rerunStr = OiixResourceBundle.getString("S_WARNING_FAILED_OPTIONAL_TOOLS");
            }
            if (this.m_bSkipAllConfigTools && !this.m_bNoConfigMsgPrinted) {
                if (this.noConfigSetForRootSh) {
                    OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOCONFIG_OPTION_SELECTED"));
                } else {
                    OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOCONFIG_OPTION_SELECTED_WITHOUT_ROOTSH"));
                }
                this.m_bNoConfigMsgPrinted = true;
            } else if (!this.m_bSkipAllConfigTools) {
                OiifmAlert.displayError(rerunStr);
            }
        }
        return allSucceeded;
    }

    private boolean launchTools(boolean bRecommended) {
        boolean allSucceeded = true;
        boolean bRecommendedToolFailed = false;
        if (this.m_bSkipAllConfigTools) {
            allSucceeded = false;
        }
        OiisConfigToolDetails toolDetails = null;
        Vector toolNames = bRecommended ? this.m_recToolNames : this.m_optToolNames;
        int size = toolNames.size();
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        Vector vVolumeInfo = null;
        if (size > 0 && isDebugTMD) {
            vVolumeInfo = this.m_pullSession.getVolumeInfo();
        }
        for (int i = 0; i < size; ++i) {
            long lCurTime = System.currentTimeMillis();
            try {
                this.m_configLauncher.setWorkNotifiable(this);
            }
            catch (Exception e) {
                // empty catch block
            }
            OiifbConfigToolInfo ctInfo = (OiifbConfigToolInfo)toolNames.elementAt(i);
            String curToolName = ctInfo.getToolName();
            OiixBufferOutputStream outStream = new OiixBufferOutputStream();
            toolDetails = bRecommended ? this.m_phase.getReqConfigToolDetails(i) : this.m_phase.getOptALConfigToolDetails(i);
            int toolResult = 1;
            int nToolsType = 1;
            try {
                int n = nToolsType = ctInfo.getToolType() == 0 ? 1 : 2;
                if (this.m_bSkipRemainingTools || this.m_bSkipAllConfigTools) {
                    if (bRecommended) {
                        this.addToLogBuffer(toolDetails, nToolsType, i);
                        continue;
                    }
                    this.addToLogBuffer(toolDetails, nToolsType, i);
                    continue;
                }
                OiiolTextLogger.writeToLogAndConsole("-----------------------------------------------------------------------------");
                this.m_configLauncher.onSelectConfig(curToolName, i, nToolsType, outStream);
                if (!this.m_toolFinishSync.signalHappenedBeforeSync()) {
                    this.m_toolFinishSync.sync();
                }
                if (!this.isValidExitCode(toolResult = this.m_configLauncher.getResultFromLastTool())) {
                    toolResult = 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] logArr = new String[]{curToolName};
            OiisPostInstallTool pTool = null;
            pTool = bRecommended ? this.m_phase.getReqConfigToolDetails(i).getPostInstallTool() : this.m_phase.getOptALConfigToolDetails(i).getPostInstallTool();
            if (toolResult == 1) {
                OiisCompContext c = pTool.getCompContext();
                this.setPhase(c.getCompInstallID(), 40);
                if (this.m_pullSession.isInstallMode()) {
                    ((OiicInstallSession)this.m_pullSession).runOuica(false);
                }
            } else if (toolResult == -1) {
                OiisCompContext c = pTool.getCompContext();
                this.setPhase(c.getCompInstallID(), 40);
                if (this.m_pullSession.isInstallMode()) {
                    ((OiicInstallSession)this.m_pullSession).runOuica(false);
                }
            } else if (toolResult == 0) {
                OiisCompContext c = pTool.getCompContext();
                this.setPhase(c.getCompInstallID(), 50);
            } else {
                allSucceeded = false;
            }
            if (toolResult != 0) {
                allSucceeded = false;
                this.addToLogBuffer(toolDetails, nToolsType, i);
                if (ctInfo.getToolType() == 0) {
                    this.m_bSkipRemainingTools = true;
                    bRecommendedToolFailed = true;
                }
            }
            if (!isDebugTMD) continue;
            long lElapsedTime = System.currentTimeMillis();
            OiixDebug.printConfigDebugTMDMesages("Config Tool : " + curToolName, lElapsedTime, lElapsedTime - lCurTime, vVolumeInfo);
        }
        if (!allSucceeded) {
            String rerunStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", bRecommendedToolFailed ? "S_WARNING_FAILED_RECOMMENDED_TOOLS" : "S_WARNING_FAILED_OPTIONAL_TOOLS");
            if (this.m_bSkipAllConfigTools && !this.m_bNoConfigMsgPrinted) {
                if (this.noConfigSetForRootSh) {
                    OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOCONFIG_OPTION_SELECTED"));
                } else {
                    OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOCONFIG_OPTION_SELECTED_WITHOUT_ROOTSH"));
                }
                this.m_bNoConfigMsgPrinted = true;
            } else if (!this.m_bSkipAllConfigTools) {
                OiifmAlert.displayError(rerunStr);
            }
        }
        return allSucceeded;
    }

    public void workStarted(Object o) {
    }

    public void workCompleted(Object o) {
        if (o instanceof OiifbConfigLauncher) {
            OiifbConfigLauncher configLauncher = (OiifbConfigLauncher)o;
            int toolResult = configLauncher.getResultFromLastTool();
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_TOOL_RESULT");
            sMsg = MessageFormat.format(sMsg, new Integer(toolResult));
            OiiolTextLogger.writeToLogAndConsole(sMsg);
        }
        this.m_toolFinishSync.signal();
    }

    private boolean isValidExitCode(int code) {
        return code == -1 || code == 1 || code == 0;
    }

    private void addToLogBuffer(OiisConfigToolDetails toolDetails, int nToolType, int nToolIndex) {
        this.m_sbLogBuffer.append("echo ");
        this.m_sbLogBuffer.append(toolDetails.getExternalName());
        this.m_sbLogBuffer.append(OiiolTextLogger.NEW_LINE);
        String sCommandLine = this.m_configLauncher.getLogCommand(nToolType, nToolIndex);
        this.m_sbLogBuffer.append(sCommandLine);
        this.m_sbLogBuffer.append(OiiolTextLogger.NEW_LINE);
    }

    private void logUnsuccessfulTools() {
        OiixCFOps.logMsgForUnsuccessfulTools();
        HashMap<String, String> oraHomeBasedLog = new HashMap<String, String>();
        if (null != this.m_configTools && null != this.m_pluginList && this.m_pluginList.size() > 0) {
            for (int iCf = 0; iCf < this.m_pluginList.size(); ++iCf) {
                OiifbConfigToolInfo toolInfoCf = (OiifbConfigToolInfo)this.m_pluginList.elementAt(iCf);
                int nStatusCf = toolInfoCf.getToolStatus();
                if (nStatusCf == 3) continue;
                if (null != oraHomeBasedLog.get(toolInfoCf.getOraHome())) {
                    String cmd = (String)oraHomeBasedLog.get(toolInfoCf.getOraHome()) + System.getProperty("line.separator") + toolInfoCf.getToolArgs();
                    oraHomeBasedLog.put(toolInfoCf.getOraHome(), cmd);
                    continue;
                }
                oraHomeBasedLog.put(toolInfoCf.getOraHome(), toolInfoCf.getToolArgs());
            }
            if (!oraHomeBasedLog.isEmpty()) {
                Iterator it = oraHomeBasedLog.keySet().iterator();
                while (it.hasNext()) {
                    Object oraHomeName = it.next();
                    Object value = oraHomeBasedLog.get(oraHomeName);
                    try {
                        String tmpValue = OiixCFOps.getCommandForRunConfig((String)oraHomeName, true);
                        if (null != tmpValue) {
                            OiiolTextLogger.appendText("Since there is an Internal Plugin Invocation or a Java Plugin Invocation tool in the Oracle Home " + (String)oraHomeName + " we use the runConfig Command instead of the plugin's command");
                            OiiolTextLogger.writePlugInCommands((String)oraHomeName, tmpValue, true, OiixCFOps.isOverwriteConfigToolCommands());
                            continue;
                        }
                        OiiolTextLogger.writePlugInCommands((String)oraHomeName, (String)value, true, OiixCFOps.isOverwriteConfigToolCommands());
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
            }
        }
        String sToLog = this.m_sbLogBuffer.toString();
        OiiolTextLogger.writeToLogAndConsole(sToLog);
        OiiolTextLogger.writeToLogAndConsole("--------------------------------------");
    }

    private void logSkippedConfigTools() {
        try {
            String sToLog = this.m_sbLogBuffer.toString();
            OiiolTextLogger.writeToConfigToolCommandsFile(sToLog);
        }
        catch (IOException e) {
            e.printStackTrace();
            String sErr = e.getMessage();
            int nHomeType = 0;
            Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(nHomeType)};
            String sErrMsg = MessageFormat.format(sErr, sArgs);
            OiifmAlert.displayError(sErrMsg);
        }
    }

    public void setupInstallProgress(OiifwActionsPhaseWCDE installStatus, int phases, int lastPhase) {
        this.setProgressListener(new OiicSilentInstallPhaseProgressListener(true, phases, lastPhase));
    }

    public void setupAddNodeProgress(OiifwAddNodePhaseWCDE addNodeStatus, int phases, int lastPhase) {
        this.setProgressListener(new OiicSilentInstallPhaseProgressListener(true, phases, lastPhase));
    }

    public int doRebootOperations() {
        OiicPullSession oSession = (OiicPullSession)this.getSession();
        OiicInstallReboot oir = oSession.getRebootInfo();
        OiicSessionInterfaceManager interfaceMgr = OiicSessionInterfaceManager.getInterfaceManager();
        OiicInstallTimeSession instSession = interfaceMgr.getSession();
        String[] remoteNodes = (String[])instSession.getSessionContext().getVarValue("REMOTE_NODES");
        String sMessage = oir.getMessage();
        boolean bClusterMode = false;
        if (remoteNodes != null && remoteNodes.length > 0) {
            bClusterMode = true;
        }
        String remoteNodesStr = OiixFunctionOps.implodeList(remoteNodes, ",");
        Object[] obj = new String[]{remoteNodesStr};
        if ((sMessage == null || sMessage.trim().length() == 0) && instSession != null) {
            try {
                sMessage = bClusterMode ? (oir.isLaunchOUI() ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REBOOT_SILENT_LAUNCHOUI_CLUSTER_MESSAGE", obj) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REBOOT_SILENT_CLUSTER_MESSAGE", obj)) : (oir.isLaunchOUI() ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REBOOT_SILENT_LAUNCHOUI_MESSAGE") : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REBOOT_SILENT_MESSAGE"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean bNextSession = this.isNextSessionSet();
        boolean bRebootMode = false;
        boolean bRebootRemoteMode = false;
        if (!bNextSession) {
            bRebootMode = !this.isRestartVariableSet() ? false : this.getRestartVarValue();
            bRebootRemoteMode = !this.isRestartRemoteVariableSet() ? false : this.getRestartRemoteVarValue();
        }
        if (bClusterMode) {
            if (bRebootRemoteMode) {
                String srcLoc = (String)instSession.getSessionContext().getVarValue("ORACLE_HOME") + "\\bin";
                try {
                    String sProgressMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35202");
                    OiiolTextLogger.writeToLogAndConsole(sProgressMessage);
                    OiipwClusterWindowsOps.rebootNode(remoteNodes, srcLoc);
                }
                catch (OiipgRemoteOpsException oce) {
                    OiiolTextLogger.appendErrorText(oce.getMessage());
                }
                catch (OiipgRemoteFileOperationException oce) {
                    OiiolTextLogger.appendErrorText(oce.getMessage());
                }
            } else {
                String sMessageRemote = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35204", obj);
                OiiolTextLogger.writeToLogAndConsole(sMessageRemote);
            }
        }
        try {
            if (bRebootMode) {
                String sProgressMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35203");
                OiiolTextLogger.writeToLogAndConsole(sProgressMessage);
            }
            oir.reboot(bRebootMode, bNextSession);
            if (!bRebootMode && !bNextSession) {
                OiiolTextLogger.writeToLogAndConsole(sMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void showError(String sMsg) throws OiifbEndIterateException {
        throw new OiifbEndIterateException(sMsg);
    }

    public boolean showWarning(String sMsg) {
        OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING"), sMsg, 10, 5, 4, 2);
        return true;
    }

    public boolean showHostNameWarning(String sHostName, String sMsg) {
        int nShow = OiixOraparam.getShowHostNameValue();
        boolean bOraparam = this.canShowHostNameConditionally(sHostName);
        if (bOraparam) {
            return this.showWarning(sMsg);
        }
        return true;
    }

    public OipcpPrereqProgress getPrereqProgress(OiifwPrereqWCDE prereqWCDE) {
        this.m_oPrereqWCDE = prereqWCDE;
        return new OipfcSilentModeProgress();
    }

    public void setSkipAllConfigTools(boolean bSkipAllConfigTools) {
        this.m_bSkipAllConfigTools = bSkipAllConfigTools;
        this.noConfigSetForRootSh = true;
    }

    public void showNextSessionProgress() {
        OiicInstallSession oSession;
        String sText;
        if (this.getSession() instanceof OiicInstallSession && (sText = (String)(oSession = (OiicInstallSession)this.getSession()).getSessionContext().getVarValue("NEXT_SESSION_PROGRESS_TEXT")) != null) {
            OiiolTextLogger.writeToLogAndConsole(sText);
        }
    }
}

