/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiicSilentModeProgressListener
implements OiixProgressListener {
    private long m_nTotalBytes;
    private long m_nCurrentBytes;
    private int m_nCurrentPercent;
    private String m_sTitle;

    private void reset() {
        this.m_nTotalBytes = 0L;
        this.m_nCurrentBytes = 0L;
        this.m_nCurrentPercent = 0;
    }

    public void setTotalBytes(long bytes) {
        this.reset();
        this.m_nTotalBytes = bytes;
    }

    public void setStatus(String status) {
    }

    public void setTitle(String title) {
        this.m_sTitle = title;
        System.out.println("Starting, " + this.m_sTitle);
    }

    public void addBytes(int bytes) {
        int percent = this.getPercent(bytes);
        int percentDiff = this.getPercentDifference(bytes);
        this.printProgress(percent);
        if (percentDiff > 10) {
            this.m_nCurrentPercent += percentDiff;
            if (this.m_nCurrentPercent < 100) {
                System.out.print(this.m_nCurrentPercent + "%");
            }
        }
        this.m_nCurrentBytes += (long)bytes;
    }

    private int getPercentDifference(int bytes) {
        int diff = 0;
        if (this.m_nTotalBytes == 0L) {
            return 0;
        }
        diff = (int)((this.m_nCurrentBytes + (long)bytes) * 100L / this.m_nTotalBytes - (long)this.m_nCurrentPercent);
        if (diff < 0) {
            return 0;
        }
        return diff;
    }

    private int getPercent(int bytes) {
        if (this.m_nTotalBytes == 0L) {
            return 0;
        }
        return (int)((long)(bytes * 100) / this.m_nTotalBytes);
    }

    public void removeBytes(int bytes) {
    }

    public void onDoneProgress() {
        if (this.m_nCurrentPercent < 100) {
            this.printProgress(100 - this.m_nCurrentPercent);
        }
        System.out.println();
        System.out.println(this.m_sTitle + " COMPLETED. ");
    }

    private void printProgress(int nPrint) {
        for (int i = 0; i < nPrint; ++i) {
            System.out.print(".");
        }
    }

    public void addPercentage(int percent) {
        this.addBytes((int)((long)percent * this.m_nTotalBytes / 100L));
    }
}

