/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicStageSession;
import oracle.sysman.oii.oiic.OiicStageTimeSession;
import oracle.sysman.oii.oiic.OiicStagingPlanInfo;
import oracle.sysman.oii.oiic.OiicStagingProgressListener;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifj.OiifjRemoveDlg;
import oracle.sysman.oii.oiif.oiifp.OiifpWizInstallPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressUIListener;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageArchiveInfo;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisCompStaging;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceVariants;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicStageActionsPhase
implements OiifbWizOperation,
OiifrProgressUIListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private OiicStageTimeSession m_stgTimeSession;
    private int m_actionMode = 2;
    private OiicSessionPlan m_sessionPlan;
    private Thread m_stageThread;
    private OiifbProgressControl m_progCtrl = null;
    private OiicStagingProgressListener m_stgProgListener;
    private Exception m_stgException = null;
    OiifjRemoveDlg m_remDlg;
    private OiifrProgressActionListener m_actnLstn;
    private long m_totSize;
    private long m_sizeSoFar;
    private int m_pctSoFar;
    private boolean m_interruptedInstall;

    public OiicStageActionsPhase(OiicStageTimeSession stgTimeSession) {
        this(stgTimeSession, null);
    }

    public OiicStageActionsPhase(OiicStageTimeSession stgTimeSession, OiifjRemoveDlg remDlg) {
        this.m_stgTimeSession = stgTimeSession;
        this.m_sessionPlan = stgTimeSession.getSessionPlan();
        this.m_remDlg = remDlg;
        this.setProgressControl(new OiifbProgressControl());
    }

    public void setProgressControl(OiifbProgressControl progCtrl) {
        if (progCtrl != null) {
            this.m_progCtrl = progCtrl;
        }
    }

    public OiifbProgressControl getProgressControl() {
        return this.m_progCtrl;
    }

    public void setProgressActionListener(OiifrProgressActionListener actnLstn) {
        this.m_actnLstn = actnLstn;
    }

    public OiifrProgressActionListener getProgressActionListener() {
        return this.m_actnLstn;
    }

    public void dispose() {
    }

    public void setStagingProgressListener(OiicStagingProgressListener lstnr) {
        this.m_stgProgListener = lstnr;
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        try {
            if (this.m_sessionPlan.isEmpty() && this.m_remDlg == null) {
                this.m_stgTimeSession.getSessionContext().readContext();
                this.m_sessionPlan = OiicSessionPlan.readPlan((OiicPullSession)((Object)this.m_stgTimeSession));
                this.m_stgTimeSession.setSessionPlan(this.m_sessionPlan);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiifbEndIterateException(e.getMessage());
        }
        this.doOperationInner();
        try {
            this.m_stageThread.join();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        if (this.m_interruptedInstall) {
            System.out.println("Thread was interrupted");
            throw new OiifbEndIterateException(OiixResourceBundle.getString("S_INSTALL_INTRRUPT"));
        }
        if (this.m_stgException != null) {
            throw new OiifbEndIterateException(this.m_stgException);
        }
        return 0;
    }

    private void endProgress() {
        try {
            OiiiStageAreaControl stgAreaCtrl = this.m_stgTimeSession.getStageAreaControl();
            stgAreaCtrl.updateInventory();
        }
        catch (OiifbCancelException ioe) {
            ioe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (OiixJarModifyException jme) {
            jme.printStackTrace();
        }
        if (this.m_actnLstn != null) {
            this.m_actnLstn.onDoneProgress();
        }
    }

    public void doOperationInner() {
        if (this.m_remDlg == null) {
            if (this.m_stgTimeSession instanceof OiicStageSession) {
                OiicStageSession stgSession = (OiicStageSession)this.m_stgTimeSession;
                boolean bShowProgress = true;
                OiisVariable oShowProgress = stgSession.getSessionContext().getVariable("SHOW_INSTALL_PROGRESS_PAGE");
                if (oShowProgress.getValue() != null) {
                    Boolean oShow = (Boolean)oShowProgress.getValue();
                    bShowProgress = oShow;
                }
                if (stgSession.isSilentMode()) {
                    bShowProgress = false;
                }
                OiifpWizInstallPanel m_wizPanel = new OiifpWizInstallPanel(stgSession);
                m_wizPanel.addProgressUIListener(this);
                OiifwWizDialog wd = this.m_stgTimeSession.getWizardDialog();
                if (bShowProgress) {
                    if (!stgSession.getMainFrame().isVisible()) {
                        wd.hideSplashScr();
                        stgSession.getMainFrame().show();
                    }
                    wd.addWizardPanel(m_wizPanel);
                    wd.setEnabledButton(4, false);
                    wd.setEnabledButton(2, false);
                }
                this.setProgressActionListener(m_wizPanel.getProgressActionListener());
            }
        } else {
            this.setProgressActionListener(this.m_remDlg.getProgressActionListener());
            this.m_remDlg.addProgressUIListener(this);
        }
        this.m_stageThread = new Thread(new OiStageThread(this.m_progCtrl));
        this.m_stageThread.setDaemon(true);
        this.m_interruptedInstall = false;
        this.m_stgException = null;
        this.m_stageThread.start();
    }

    public void initialize() {
    }

    public void doDestages(Vector remInfos) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, OiifbCancelException {
        int numPlanInfos = remInfos.size();
        OiiiStageAreaControl stgAreaCtrl = this.m_stgTimeSession.getStageAreaControl();
        this.checkCancel();
        if (this.m_actnLstn != null) {
            this.m_actnLstn.setStatus(OiixResourceBundle.getString("S_START_DESTAGE"));
            this.m_actnLstn.onStartDeinstall();
        }
        System.out.println("In doDestages : #planInfos = " + numPlanInfos);
        for (int i = 0; i < numPlanInfos; ++i) {
            OiicStagingPlanInfo remInfo = (OiicStagingPlanInfo)remInfos.elementAt(i);
            OiiiStageCompInvEntry locscie = remInfo.getInvEntry();
            OiiiCompInstallID delID = locscie.getCompInstallID();
            if (this.m_actnLstn != null) {
                this.m_actnLstn.onCurrentComponent(delID.getName() + ", " + delID.getVersion().toString());
                this.m_actnLstn.addPercentage(100 / numPlanInfos);
            }
            if (this.m_stgProgListener != null) {
                this.m_stgProgListener.onStageRemoval(remInfo);
            }
            if (remInfo.shouldPreserveEntry() || !remInfo.isRemovingAllPlats()) {
                Vector curPlats = locscie.getPlatforms();
                Vector remPlats = remInfo.getPlatforms();
                locscie.setPlatforms(OiixVectorOps.subtract(curPlats, remPlats));
            } else {
                this.removeCompFromTarget(stgAreaCtrl, locscie);
            }
            if (this.m_stgProgListener != null) {
                this.m_stgProgListener.setPercent(100 * i / numPlanInfos);
            }
            this.checkCancel();
        }
    }

    private void removeCompFromTarget(OiiiStageAreaControl stgAreaCtrl, OiiiStageCompInvEntry locscie) {
        String parPath;
        OiiiStageInventory stgInv = stgAreaCtrl.getStageInventory();
        OiiiCompInstallID delID = locscie.getCompInstallID();
        String dfLoc = stgAreaCtrl.genFileSysLoc(locscie.getGroupFilesLoc());
        File dfDir = new File(OiixPathOps.getNativeForm(dfLoc));
        OiixFileOps.recdelete(dfDir);
        String cjLoc = stgAreaCtrl.genFileSysLoc(locscie.getLocation());
        File cjDir = new File(OiixPathOps.getNativeForm(cjLoc));
        OiixFileOps.recdelete(cjDir);
        File delFile = new File(cjDir.getParent());
        while ((delFile = new File(parPath = delFile.getParent())).delete()) {
        }
        Vector dependees = locscie.getDependees();
        Enumeration depEn = dependees.elements();
        while (depEn.hasMoreElements()) {
            OiiiCompInstallID depID = (OiiiCompInstallID)depEn.nextElement();
            OiiiCompInvEntry dCie = stgInv.getCompatCompEntry(depID, 0);
            if (dCie == null) continue;
            dCie.removeReferencer(new OiiiCompIdOhPair(delID, 0));
        }
        stgInv.removeCompInvEntry(delID, 0, locscie.getPlatforms());
    }

    public void doStages(Vector addInfos) throws IOException, OiifbCancelException, OiifbUserEndException {
        OiicStagingPlanInfo addInfo;
        int i;
        int numAdditions = addInfos.size();
        OiicStageSession stgSession = (OiicStageSession)this.m_stgTimeSession;
        this.checkCancel();
        if (this.m_actnLstn != null) {
            this.m_actnLstn.setStatus(OiixResourceBundle.getString("S_START_STAGE"));
            this.m_actnLstn.onStartPhase(2);
        }
        this.m_totSize = 0L;
        for (i = 0; i < numAdditions; ++i) {
            addInfo = (OiicStagingPlanInfo)addInfos.elementAt(i);
            OiiiStageCompInvEntry remscie = addInfo.getInvEntry();
            if (remscie.getCompInstallID().getCompType() == 4) continue;
            Vector plats = addInfo.getPlatforms();
            long compSize = remscie.getFileSizeInfoEx().getSizeEx(null, plats);
            this.m_totSize += compSize;
        }
        for (i = numAdditions - 1; i >= 0; --i) {
            addInfo = (OiicStagingPlanInfo)addInfos.elementAt(i);
            this.stageCompInPlan(addInfo);
        }
    }

    private void stageCompInPlan(OiicStagingPlanInfo addInfo) throws OiifbUserEndException, IOException, OiifbCancelException {
        block8: {
            OiicStageSession stgSession = (OiicStageSession)this.m_stgTimeSession;
            OiiiStageAreaControl stgAreaCtrl = stgSession.getStageAreaControl();
            OiiiStageInventory stgInv = stgAreaCtrl.getStageInventory();
            OiiiSourceAccess srcAcc = stgSession.getSourceAccess();
            try {
                OiiiStageCompInvEntry remscie = addInfo.getInvEntry();
                Vector plats = addInfo.getPlatforms();
                OiiiCompInstallID cid = remscie.getCompInstallID();
                if (this.m_actnLstn != null) {
                    this.m_actnLstn.onCurrentComponent(cid.getName() + ", " + cid.getVersion().toString());
                }
                OiisCompStaging cs = stgSession.getCompStage(remscie);
                OiiiStageCompInvEntry locscie = stgInv.getMatchCompInvEntry(remscie);
                if (locscie == null) {
                    locscie = this.makeTrgtSCIE(stgAreaCtrl, remscie);
                    this.checkLibraries(srcAcc, stgAreaCtrl, cs);
                    this.fetchCompDefnJars(srcAcc, stgAreaCtrl, remscie, locscie, plats);
                }
                addInfo.setEntryNum(this.getCIEEntryNum(locscie));
                if (this.m_stgProgListener != null) {
                    this.m_stgProgListener.onStageAddition(addInfo);
                }
                if (cid.getCompType() != 4) {
                    this.stageDataFiles(stgAreaCtrl, srcAcc, cs, remscie, locscie, plats);
                    Vector curPlats = OiixVectorOps.union(locscie.getPlatforms(), plats);
                    locscie.setPlatforms(curPlats);
                }
                if (locscie.isNewEntry()) {
                    stgInv.addCompInvEntry(locscie, 0);
                }
                this.checkCancel();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                boolean cont = true;
                if (this.m_stgProgListener != null) {
                    cont = this.m_stgProgListener.continueOnException(addInfo, ioe);
                }
                if (cont) break block8;
                throw new OiifbUserEndException("Session cancelled");
            }
        }
    }

    private int getCIEEntryNum(OiiiCompInvEntry cie) {
        int num = -1;
        String loc = OiixPathOps.getStandardForm(cie.getLocation());
        int lastSlashPos = loc.lastIndexOf(47);
        int penulSlashPos = -1;
        if (lastSlashPos != -1) {
            penulSlashPos = loc.lastIndexOf(47, lastSlashPos - 1);
        }
        if (penulSlashPos != -1) {
            String numStr = loc.substring(penulSlashPos + 1, lastSlashPos);
            System.out.println("In getCIEEntryNum : loc = " + loc + ", LSP = " + lastSlashPos + ", PSP = " + penulSlashPos + ", numStr = " + numStr);
            num = Integer.parseInt(numStr);
        }
        return num;
    }

    private OiiiStageCompInvEntry makeTrgtSCIE(OiiiStageAreaControl stgAreaCtrl, OiiiStageCompInvEntry remscie) throws IOException {
        OiiiStageCompInvEntry locscie;
        OiiiCompInstallID cid = remscie.getCompInstallID();
        String localLoc = stgAreaCtrl.genCompInstallLocation(cid);
        Vector langs = remscie.getLanguages();
        Vector plats = new Vector();
        if (remscie instanceof OiiiStagePatchInvEntry) {
            locscie = new OiiiStagePatchInvEntry((OiiiPatchInstallID)cid, localLoc, this.genDataFileLoc(localLoc), langs, plats, localLoc, remscie.getStageArchiveInfo());
            OiisPatchDeps patchDeps = ((OiiiStagePatchInvEntry)remscie).getPatchDeps();
            ((OiiiStagePatchInvEntry)locscie).setPatchDeps(patchDeps);
        } else {
            locscie = new OiiiStageCompInvEntry(cid, localLoc, this.genDataFileLoc(localLoc), langs, plats, localLoc, remscie.getStageArchiveInfo());
            locscie.setDeps(remscie.getDeps());
        }
        locscie.setFileSizeInfoEx(remscie.getFileSizeInfoEx());
        locscie.setInstVersions(remscie.getInstVersions());
        locscie.setTopLevel(remscie.isTopLevel());
        locscie.setNoPreReq(remscie.isNoPreReq());
        locscie.setNoProdHome(remscie.isNoProdHome());
        locscie.setSaveTimeTag(remscie.getSaveTimeTag());
        locscie.setUnsavedChanges(remscie.getUnsavedChanges());
        locscie.setStageTimeTag(remscie.getStageTimeTag());
        locscie.setSizeInfo(remscie.getSizeInfo());
        return locscie;
    }

    private String genDataFileLoc(String compLoc) {
        return OiixPathOps.directorify(OiixPathOps.concatPath(compLoc, "DataFiles"));
    }

    private void checkLibraries(OiiiSourceAccess srcAcc, OiiiStageAreaControl stgAreaCtrl, OiisCompStaging cs) throws OiifbCancelException {
        OiisCompProperties cp = cs.getProperties();
        for (int j = 0; j < 3; ++j) {
            Vector libDeps = cp.getLibraryDeps(j);
            Enumeration libs = libDeps.elements();
            while (libs.hasMoreElements()) {
                OiiiLibraryID lid = (OiiiLibraryID)libs.nextElement();
                this.checkStageLibrary(srcAcc, stgAreaCtrl, lid, j);
            }
        }
    }

    private void checkStageLibrary(OiiiSourceAccess srcAcc, OiiiStageAreaControl stgAreaCtrl, OiiiLibraryID lid, int libType) throws OiifbCancelException {
        OiiiStageInventory remStgInv;
        OiiiLibInvEntry remLie;
        this.checkCancel();
        OiiiLibInvEntry lie = null;
        OiiiStageInventory stgInv = stgAreaCtrl.getStageInventory();
        lie = stgInv.getCompatLibEntry(lid, libType);
        if (lie == null && (remLie = (remStgInv = srcAcc.getStageInventory()).getCompatLibEntry(lid, libType)) != null) {
            try {
                lid = remLie.getLibraryID();
                if (this.m_actnLstn != null) {
                    this.m_actnLstn.setStatus("Staging library : " + lid.getName());
                }
                String remLoc = remLie.getLocation();
                String localLoc = stgAreaCtrl.genLibLocation(lid, libType);
                String libName = OiixPathOps.getFileName(remLoc);
                String copyLoc = stgAreaCtrl.genLibLoc(OiixPathOps.concatPath(localLoc, libName));
                copyLoc = srcAcc.fetchLibJar(lid, copyLoc, libType);
                lie = new OiiiLibInvEntry(lid, localLoc + libName);
                stgInv.addLibInvEntry(lie, libType);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void fetchCompDefnJars(OiiiSourceAccess srcAcc, OiiiStageAreaControl stgAreaCtrl, OiiiStageCompInvEntry remscie, OiiiStageCompInvEntry locscie, Vector plats) throws IOException, OiifbCancelException {
        this.checkCancel();
        OiiiCompInstallID cid = remscie.getCompInstallID();
        String localLoc = locscie.getLocation();
        String compJarLoc = stgAreaCtrl.genFileSysLoc(OiixPathOps.concatPath(localLoc, "compIns.jar"));
        compJarLoc = srcAcc.fetchCompInsJar(cid, plats, compJarLoc);
        String compResLoc = stgAreaCtrl.genFileSysLoc(OiixPathOps.concatPath(localLoc, "resources/CompRes.jar"));
        compResLoc = srcAcc.fetchCompResJar(cid, plats, compResLoc);
        String remHelpPath = OiixPathOps.concatPath(remscie.getLocation(), "help");
        String locHelpPath = stgAreaCtrl.genFileSysLoc(OiixPathOps.concatPath(localLoc, "help"));
        Locale[] langs = OiixLanguage.getLanguages();
        Enumeration vars = OiixResourceVariants.genResourceVariants(langs);
        while (vars.hasMoreElements()) {
            String helpFile = "CompHelp" + (String)vars.nextElement() + ".jar";
            String remHelpLoc = OiixPathOps.concatPath(remHelpPath, helpFile);
            String locHelpLoc = OiixPathOps.concatPath(locHelpPath, helpFile);
            try {
                srcAcc.fetchSourceFile(remHelpLoc, locHelpLoc);
            }
            catch (Exception e) {}
        }
    }

    private void stageDataFiles(OiiiStageAreaControl stgAreaCtrl, OiiiSourceAccess srcAcc, OiisCompStaging cs, OiiiStageCompInvEntry remscie, OiiiStageCompInvEntry locscie, Vector plats) throws IOException, OiifbCancelException {
        this.checkCancel();
        String localDFLoc = stgAreaCtrl.genFileSysLoc(locscie.getGroupFilesLoc());
        File dataFilesDir = new File(OiixPathOps.getNativeForm(localDFLoc));
        dataFilesDir.mkdir();
        OiisFileMap fm = cs.getFileMap();
        OiiiCompInstallID cid = remscie.getCompInstallID();
        Vector oldPlats = locscie.getPlatforms();
        Vector curPlats = OiixVectorOps.union(oldPlats, plats);
        boolean expandedStage = false;
        OiiiStageArchiveInfo archInfo = remscie.getStageArchiveInfo();
        if (archInfo != null) {
            int numPlats = plats.size();
            for (int i = 0; i < numPlats; ++i) {
                int platI = (Integer)plats.elementAt(i);
                if (archInfo.isArchiveForPlat(platI)) continue;
                expandedStage = true;
            }
        }
        Enumeration fgs = fm.getFileGroupNames();
        while (fgs.hasMoreElements()) {
            String gpName = (String)fgs.nextElement();
            if (this.m_actnLstn != null) {
                this.m_actnLstn.setStatus("Copying files for group : " + gpName);
            }
            OiisFileGroup fg = fm.getFileGroup(gpName);
            Vector unionPlatSets = fg.getRelevantPlatSetList(curPlats);
            Vector oldPlatSets = fg.getRelevantPlatSetList(oldPlats);
            Vector newPlatSets = OiixVectorOps.subtract(unionPlatSets, oldPlatSets);
            Vector langSets = fg.getRelevantLangSetList((Vector)null);
            int numLS = langSets.size();
            int numPS = newPlatSets.size();
            for (int l = 0; l < numLS; ++l) {
                int lsInd = (Integer)langSets.elementAt(l);
                for (int j = 0; j < numPS; ++j) {
                    int psInd = (Integer)newPlatSets.elementAt(j);
                    this.stageFileGpSubset(srcAcc, cid, plats, localDFLoc, fg, lsInd, psInd, expandedStage);
                    if (this.m_actnLstn == null) continue;
                    long fgSubsetSize = fg.getSizeForLPSetVals(lsInd, psInd);
                    this.m_sizeSoFar += fgSubsetSize;
                    int curPercent = (int)Math.rint((double)(this.m_sizeSoFar * 100L) / (double)this.m_totSize);
                    int perAdd = curPercent - this.m_pctSoFar;
                    this.m_actnLstn.addPercentage(perAdd);
                    if (this.m_stgProgListener != null) {
                        this.m_stgProgListener.setPercent(curPercent);
                    }
                    this.m_pctSoFar = curPercent;
                }
            }
        }
    }

    private void stageFileGpSubset(OiiiSourceAccess srcAcc, OiiiCompInstallID cid, Vector plats, String localDFLoc, OiisFileGroup fg, int lsInd, int psInd, boolean expandedStage) throws IOException, OiifbCancelException {
        block8: {
            this.checkCancel();
            String fgName = fg.getName() + "." + lsInd + "." + psInd + ".jar";
            Vector gpEntries = fg.getEntriesForLangPlatSet(lsInd, psInd);
            int numGpEntries = gpEntries.size();
            if (numGpEntries <= 0) {
                return;
            }
            boolean fetchExpandedFiles = expandedStage || !fg.isGroupArchived();
            try {
                String localGpLoc = OiixPathOps.concatPath(localDFLoc, fgName);
                srcAcc.fetchCompFilesJar(cid, plats, fgName, localGpLoc);
            }
            catch (IOException ioe) {
                fetchExpandedFiles = true;
            }
            if (fetchExpandedFiles) {
                String localGpPath = OiixPathOps.concatPath(localDFLoc, "Expanded");
                String gpRelLoc = fg.getGroupLocation();
                if (!gpRelLoc.equals(".")) {
                    localGpPath = OiixPathOps.concatPath(localGpPath, gpRelLoc);
                }
                try {
                    for (int f = 0; f < numGpEntries; ++f) {
                        OiisFileEntry fEntry = (OiisFileEntry)gpEntries.elementAt(f);
                        String fileLoc = OiixPathOps.getStandardForm(fEntry.getSource());
                        String localGpFile = OiixPathOps.concatPath(localGpPath, fileLoc);
                        localGpFile = OiixPathOps.getNativeForm(localGpFile);
                        srcAcc.fetchCompFileForExpandedGroup(cid, plats, gpRelLoc, fileLoc, localGpFile);
                    }
                }
                catch (IOException ioe) {
                    if (fg.isGroupArchived()) break block8;
                    throw ioe;
                }
            }
        }
    }

    public int getActionMode() {
        return this.m_actionMode;
    }

    public void onInstall() {
    }

    public void onCancel() {
        this.m_progCtrl.suspend();
    }

    public void onCancelConfirm(boolean cancelSession) {
        this.m_interruptedInstall = true;
        this.m_progCtrl.confirmCancel(new Boolean(cancelSession));
    }

    public void onResume() {
        this.m_progCtrl.resume();
    }

    private void checkCancel() throws OiifbCancelException {
        if (!this.m_progCtrl.canContinue()) {
            String exMsg = OiixResourceBundle.getString("S_USER_CANCEL");
            throw new OiifbCancelException(exMsg, true);
        }
    }

    class OiStageThread
    implements Runnable {
        private OiifbProgressControl m_progCtrl = null;

        public OiStageThread(OiifbProgressControl progCtrl) {
            this.m_progCtrl = progCtrl;
        }

        public void run() {
            try {
                Vector remInfos = OiicStageActionsPhase.this.m_sessionPlan.getRemoves(10);
                Vector addInfos = OiicStageActionsPhase.this.m_sessionPlan.getAdditions(10);
                if (remInfos.size() > 0) {
                    OiicStageActionsPhase.this.doDestages(remInfos);
                }
                if (addInfos.size() > 0) {
                    OiicStageActionsPhase.this.doStages(addInfos);
                }
                OiicStageActionsPhase.this.endProgress();
            }
            catch (Exception e) {
                OiicStageActionsPhase.this.m_stgException = e;
                e.printStackTrace();
            }
        }
    }
}

