/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Locale;
import oracle.sysman.oii.oiic.OiicInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitDefaultConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitLockMonitor;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiit.OiitTargetLocker;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicStandardInventorySession
extends OiicInventorySession {
    private OiitLockHeartbeat m_lock;
    private OiiiInstallAreaControl m_instAreaControl;
    static final int DEFAULT_LOG = 0;
    static final int ALWAYS_LOG = 1;
    static final int DEFAULT_LOCK = 0;
    static final int ALWAYS_LOCK = 1;
    private int m_nLockType = 0;
    private int m_nAccessLevel = 0;
    private boolean m_bUsingExistingIAC;
    private boolean locklessRead = false;
    private final String libLocation = "lib";

    public OiicStandardInventorySession(String sAppID, String sAppVer) {
        super(sAppID, sAppVer);
    }

    public void initSession(int nAccessLevel) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, false);
    }

    public void initSession(int nAccessLevel, int iCreateLog, int iAquireLocks) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, false, iCreateLog, iAquireLocks);
    }

    public void initSession(int nAccessLevel, boolean bWow64) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, bWow64, 0, 0);
    }

    public void initSession(int nAccessLevel, boolean bWow64, int iCreateLog, int iAquireLocks) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        this.updateProperties();
        if (bWow64 && OiixPlatform.getCurrentPlatform() != 208 && OiixPlatform.getCurrentPlatform() != 233) {
            throw new OiiiInventoryDoesNotExistException();
        }
        OiipgPropertyLoader.setWOW64(bWow64);
        this.m_nAccessLevel = nAccessLevel;
        Locale.setDefault(OiixLanguage.getDefaultLocale());
        this.m_instAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (this.m_instAreaControl != null) {
            this.m_bUsingExistingIAC = true;
            OiiolTextLogger.appendText("Using an existing InstallAreaControl for this Inventory Session with existing access level " + this.m_instAreaControl.getAccessLevel());
        } else {
            OiiiInstallAreaControl.initAreaControl(nAccessLevel);
            OiiolTextLogger.appendText("Creating a new Install area Control for this inventory session with new  access level  " + nAccessLevel);
            this.m_instAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        }
        this.initLog(nAccessLevel, iCreateLog);
        if (nAccessLevel < 2) {
            this.acquireLocks(nAccessLevel, iAquireLocks);
        } else {
            this.locklessRead = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conflictingLocksDetected() throws IOException {
        boolean bLockDetected = true;
        if (this.m_nAccessLevel != 2) {
            if (this.m_nAccessLevel != 0) throw new IllegalStateException("This method cannot be called for read/write sessions");
            if (this.m_nLockType != 0) throw new IllegalStateException("This method cannot be called for read/write sessions");
            return ((OiitLockMonitor)this.m_lock).isLockDetected();
        }
        try {
            this.acquireLocks(0, 0);
            bLockDetected = false;
            this.releaseLocks();
            return bLockDetected;
        }
        catch (OiitTargetLockNotAvailableException ioe1) {
            return true;
        }
    }

    public void endSession() {
        OiiolTextLogger.appendText("Ending the inventory Session ");
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        this.releaseLocks();
        if (!this.m_bUsingExistingIAC) {
            OiiolTextLogger.appendText("Disposing the install area control objects");
            OiiiInstallAreaControl.dispose();
            this.m_instAreaControl = null;
        }
        this.dispose();
        OiiolTextLogger.setEnabled(true);
    }

    public OiiiInstallAreaControl getInstallAreaControl() {
        return this.m_instAreaControl;
    }

    private void acquireLocks(int nAccessLevel, int iLockType) throws OiitTargetLockNotAvailableException, IOException {
        OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
        OiitTargetLocker tl = new OiitTargetLocker(this.m_instAreaControl.getAreaRoot(), cl);
        if (nAccessLevel == 1 || iLockType == 1) {
            this.m_lock = tl.getWriterLock();
            this.m_nLockType = iLockType;
        } else {
            this.m_lock = tl.getWriterLockMonitor();
        }
    }

    private void releaseLocks() {
        if (this.m_lock != null) {
            this.m_lock.releaseLock();
            this.m_lock = null;
        }
    }

    private void updateProperties() {
        String sOUILoc = System.getProperty("oracle.installer.oui_loc");
        if (sOUILoc == null) {
            this.computeDefaultOUILoc();
        }
        if (sOUILoc != null && System.getProperty("oracle.installer.library_loc", null) == null) {
            String sLibraryLoc = OiixPathOps.concatPath(sOUILoc, "lib");
            sLibraryLoc = OiixPathOps.concatPath(sLibraryLoc, OiixPlatform.getCurrentPlatformDirectoryName());
            sLibraryLoc = OiixPathOps.getNativeForm(sLibraryLoc);
            System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        }
        String clusterSwitch = "false";
        if (this.m_nAccessLevel == 1) {
            clusterSwitch = System.getProperty("oracle.installer.clusterSwitch", "true");
        }
        System.setProperty("oracle.installer.clusterSwitch", clusterSwitch);
        OiipgPropertyLoader.setUnixPtrFileLocFromSysProps();
    }

    private void initLog(int nAccessLevel, int iCreateLog) throws IOException {
        if (nAccessLevel == 1 || iCreateLog == 1) {
            OiiolTextLogger.setLogLoc(this.m_instAreaControl.getLogsLoc(), this.getAppID());
        } else {
            OiiolTextLogger.setEnabled(false);
        }
    }

    private void computeDefaultOUILoc() {
        String sOUILoc;
        Class<?> oClass = null;
        try {
            oClass = Class.forName("oracle.sysman.oii.oiic.OiicStandardInventorySession");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            OiiolTextLogger.appendText("Error occurred while trying to find class oracle/sysman/oii/oiic/OiicStandardInventorySession");
        }
        if (oClass != null && (sOUILoc = oClass.getProtectionDomain().getCodeSource().getLocation().getPath()) != null && !sOUILoc.equalsIgnoreCase("")) {
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            System.setProperty("oracle.installer.oui_loc", sOUILoc);
        }
    }
}

