/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicUpdateHomeDeps
extends OiicBaseInventoryApp {
    private static OiicUpdateHomeDeps s_OiicUpdateHomeDeps = null;
    private static final String appName = "oui";
    private String[] m_hDeps;

    private OiicUpdateHomeDeps() {
        super(appName);
        Properties props = System.getProperties();
        props.put("oracle.installer.updateHomeDeps", "true");
        props.put("oracle.installer.silent", "true");
    }

    private OiicUpdateHomeDeps(String app) {
        super(app);
        Properties props = System.getProperties();
        props.put("oracle.installer.updateHomeDeps", "true");
        props.put("oracle.installer.silent", "true");
    }

    public static OiicUpdateHomeDeps getOiicUpdateHomeDepsInstance() {
        if (s_OiicUpdateHomeDeps == null) {
            s_OiicUpdateHomeDeps = new OiicUpdateHomeDeps();
        }
        return s_OiicUpdateHomeDeps;
    }

    protected void updateOHProperties(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext, boolean bSharedHome) throws OiisVarSettingException, OiifbCancelException, OiipgClusterException {
        homeInfo.updateDirtyFlags(8192L);
    }

    protected String getLogPrefix() {
        return "UpdateHomeDeps";
    }

    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiiiMultipleSOHException, OiiiMissingDependeeException, IOException, Exception, OiifbCancelException, OiisVarSettingException, OiipgClusterException {
        boolean allSuccess = true;
        OiiiInstallInventory instinv = iac.getInstallInventory();
        this.m_hDeps = (String[])oContext.getVarValue("HOME_DEPENDENCY_LIST");
        int iSize = this.m_hDeps != null ? this.m_hDeps.length : 0;
        try {
            for (int i = 0; i < iSize; ++i) {
                String[] homes = OiicUpdateHomeDeps.getHomes(this.m_hDeps[i]);
                for (int j = 0; j < homes.length; ++j) {
                    OiiiOracleHomeInfo homeInfo = instinv.getHomeWithLocation(homes[j]);
                    if (homeInfo == null) {
                        OiiolTextLogger.writeMessageToConsole("Home with location " + homes[j] + " is not found");
                        OiicExitCode.setExitCode(-1);
                        return;
                    }
                    boolean bSharedHome = this.isSharedHome(homeInfo.getLocation(), this.m_sLocalNode);
                    this.updateOHProperties(homeInfo, oContext, bSharedHome);
                }
                boolean isUpdated = instinv.updateHomeDeps(homes[0], homes[1]);
                if (isUpdated) continue;
                OiiolTextLogger.writeMessageToConsole("A dependency relation could not be established between " + homes[0] + " and " + homes[1]);
                OiicExitCode.setExitCode(-1);
                allSuccess = false;
            }
            iac.saveInstallInventory(null);
            if (allSuccess) {
                OiicExitCode.setExitCode(0);
            }
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            OiiolTextLogger.appendText(msg);
            throw ex;
        }
    }

    public void performValidations(OiicSessionContext oContext) throws OiisVarSettingException {
        String[] hDepsList = (String[])oContext.getVarValue("HOME_DEPENDENCY_LIST");
        if (hDepsList == null) {
            OiiolTextLogger.writeMessageToConsole("HOME_DEPENDENCY_LIST variable is missing");
            OiicExitCode.setExitCode(-1);
            System.exit(OiicExitCode.getExitCode());
        }
        if (hDepsList.length == 0) {
            String sMsg = null;
            Object[] args = new String[]{"HOME_DEPENDENCY_LIST"};
            sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22014", args);
            OiiolTextLogger.writeToLogAndConsole(sMsg);
            throw new OiisVarSettingException(null, null, sMsg);
        }
        if (hDepsList != null) {
            for (int i = 0; i < hDepsList.length; ++i) {
                String[] homes = OiicUpdateHomeDeps.getHomes(hDepsList[i]);
                if (homes != null && homes.length == 2) continue;
                OiiolTextLogger.writeMessageToConsole("HOME_DEPENDENCY_LIST variable is of incorrect format.Please specify a dependee relation separated by a \":\"");
                OiicExitCode.setExitCode(-1);
                System.exit(OiicExitCode.getExitCode());
            }
        }
    }

    private static String[] getHomes(String depRelation) {
        String[] homes;
        String[] stringArray = homes = depRelation.contains("::") ? depRelation.split("\\::") : depRelation.split("\\:");
        if (homes != null && homes.length == 4) {
            boolean isWin;
            boolean bl = isWin = -3 == OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
            if (isWin && homes[0].trim().length() == 1 && homes[2].trim().length() == 1) {
                String[] tmp = new String[]{homes[0] + ":" + homes[1], homes[2] + ":" + homes[3]};
                homes = tmp;
            }
        }
        return homes;
    }

    public static void main(String[] args) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Entering OiicUpdateHomeDeps.main()", OiiolTextLogger.LOG_TRACE);
        }
        OiicUpdateHomeDeps oUpdateHomeDeps = OiicUpdateHomeDeps.getOiicUpdateHomeDepsInstance();
        oUpdateHomeDeps.main_helper(args);
    }
}

