/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicUpdateNodeList;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class OiicUpdateNodeListEx {
    private static OiicUpdateNodeListEx s_oUpdateNodeListEx = null;
    public static final String S_DELIMITER_COMMA = ",";

    public static OiicUpdateNodeListEx getOiicUpdateNodeListExInstance() {
        if (s_oUpdateNodeListEx == null) {
            s_oUpdateNodeListEx = new OiicUpdateNodeListEx();
        }
        return s_oUpdateNodeListEx;
    }

    public static void main(String[] args) {
        Properties p1 = new Properties(System.getProperties());
        HashMap h1 = new HashMap();
        h1 = (HashMap)p1.get("prop");
    }

    public List updateNodeListEx(String[] hostsToUpdate, String[] nodesWhereUpdate, String oracleHome, boolean isCRS, boolean isShared, boolean isLocal) {
        return this.updateNodeListEx(hostsToUpdate, nodesWhereUpdate, oracleHome, isCRS, isShared, isLocal, true);
    }

    public List updateNodeListEx(String[] hostsToUpdate, String[] nodesWhereUpdate, String oracleHome, boolean isCRS, boolean isShared, boolean isLocal, boolean m_updateLocalInventory) {
        List failedNodes = null;
        String logDir = OiiolTextLogger.getLogDir();
        String m_nodesWhereUpdate = OiixFunctionOps.implodeList(nodesWhereUpdate, S_DELIMITER_COMMA);
        String m_hostsToUpdate = OiixFunctionOps.implodeList(hostsToUpdate, S_DELIMITER_COMMA);
        System.setProperty("oracle.installer.bigCluster", "true");
        System.setProperty("oracle.installer.ouiApiMode", "true");
        System.setProperty("oracle.installer.ignoreExitCode", "true");
        OiicExitCode.setExitCodeToSuccess();
        Vector<String> cmdArgs = new Vector<String>();
        cmdArgs.add(new String("-updateNodeList"));
        cmdArgs.add(new String("-bigCluster"));
        cmdArgs.add(new String("ORACLE_HOME=" + oracleHome));
        cmdArgs.add(new String("CLUSTER_NODES=" + m_nodesWhereUpdate));
        cmdArgs.add(new String("NODES_TO_SET={" + m_hostsToUpdate + "}"));
        if (isCRS) {
            cmdArgs.add(new String("CRS=true"));
        }
        if (isShared) {
            cmdArgs.add(new String("-cfs"));
        }
        if (isLocal) {
            cmdArgs.add(new String("-local"));
        }
        if (cmdArgs.size() > 0) {
            String[] sampleStringList = new String[cmdArgs.size()];
            String[] cmdStrList = cmdArgs.toArray(sampleStringList);
            OiicUpdateNodeList oUpdateNodeList = OiicUpdateNodeList.getOiicUpdateNodeListInstance();
            oUpdateNodeList.setBigClusterNodeList(hostsToUpdate);
            oUpdateNodeList.setClusterListForUpdateEx(nodesWhereUpdate);
            if (isCRS) {
                oUpdateNodeList.setCRSForUpdateEx(true);
            }
            oUpdateNodeList.updateLocalInventory(m_updateLocalInventory);
            oUpdateNodeList.main_helper(cmdStrList);
            failedNodes = oUpdateNodeList.getFailedNodesList();
            OiiolTextLogger.setLogLoc(logDir);
        }
        return failedNodes;
    }

    public int getStatus() {
        return OiicExitCode.getExitCode();
    }
}

