/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiApplyUpdates;
import oracle.sysman.oii.oiii.OiiiParseMetadata;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicUpdatesForInstallWCCE
implements OiifbWizOperation {
    private OiicPullSession m_pullSession;
    private String m_oracleHome;
    public static String FILE_SEP = File.separator;

    public OiicUpdatesForInstallWCCE(OiicPullSession pullSession) {
        this.m_pullSession = pullSession;
    }

    public void initialize() throws OiifbEndIterateException {
        this.m_oracleHome = OiixPathOps.getStandardForm((String)this.m_pullSession.getContext().getVariable("ORACLE_HOME").getValue());
        OiiolTextLogger.appendText("Oracle Home value set as " + this.m_oracleHome, OiiolTextLogger.LOG_TRACE);
    }

    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (!Boolean.parseBoolean(System.getProperty("oracle.installer.installUpdates", "false"))) {
            OiiolTextLogger.appendText("oracle.installer.installUpdates property is set to false, so skipping the checking of updates");
            return 0;
        }
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        String downloadLoc = System.getProperty("oracle.installer.downloadLocation");
        if (downloadLoc != null) {
            String CPULoc = OiiiApplyUpdates.getLatestUpdatesLoc(downloadLoc, "CPUs");
            String OneOffLoc = OiiiApplyUpdates.getLatestUpdatesLoc(downloadLoc, "OneOffs");
            ArrayList cpus = this.storeLocationOfPatches(CPULoc);
            ArrayList OneOffs = this.storeLocationOfPatches(OneOffLoc);
            OiixVectorOps.unionInPlace(OneOffs, cpus);
            ArrayList conflictFree = new ArrayList();
            OiiiParseMetadata pm = new OiiiParseMetadata();
            if (pm != null) {
                conflictFree = pm.checkConflictAmongPatches(this.m_oracleHome, OneOffs);
            }
            OiiiApplyUpdates au = new OiiiApplyUpdates(this.m_pullSession);
            boolean retry = false;
            do {
                boolean isSuccess;
                if (!(isSuccess = au.applyOneOffs(downloadLoc, downloadLoc, this.m_oracleHome, conflictFree))) {
                    OiiolTextLogger.appendText("Applying updates failed");
                    OiiolTextLogger.writeToLogAndConsole("Error in execution of applying updates");
                    int buttonOps = 0;
                    buttonOps = 0;
                    buttonOps |= 2;
                    buttonOps |= 4;
                    OiicUpdatesForInstallWCCE oiicUpdatesForInstallWCCE = this;
                    if (!oiicUpdatesForInstallWCCE.m_pullSession.isSilentMode()) {
                        retry = this.showRetryDialog(buttonOps, "Error in execution of applying updates");
                        continue;
                    }
                    throw new OiifbEndIterateException("opatch application failed");
                }
                OiiolTextLogger.appendText("Applying updates succeeded");
            } while (retry);
        } else {
            OiiolTextLogger.appendText("No DownloadLocation specified,ignoring updates");
        }
        return 0;
    }

    public ArrayList storeLocationOfPatches(String Loc) {
        File dir;
        ArrayList<OiiiPatchMetadata> patchList = new ArrayList<OiiiPatchMetadata>();
        if (Loc != null && (dir = new File(Loc)).isDirectory() && !dir.getName().startsWith(".ade_path")) {
            String[] fileList = dir.list();
            String fileName = null;
            OiiiPatchMetadata pm = null;
            block0: for (int i = 0; i < fileList.length; ++i) {
                fileName = fileList[i];
                pm = new OiiiPatchMetadata(Integer.parseInt(fileName), -1);
                String filePath = dir.getAbsolutePath() + FILE_SEP + fileName;
                File f = new File(filePath);
                if (!f.isDirectory() || f.getName().startsWith(".ade_path")) continue;
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".ade_path");
                    }
                };
                String[] fullPath = f.list(filter);
                for (int j = 0; j < fullPath.length; ++j) {
                    String loc = f.getAbsolutePath() + FILE_SEP + fullPath[j];
                    File f1 = new File(loc);
                    if (!f1.isDirectory()) continue;
                    pm.setDownloadLocation(loc);
                    patchList.add(pm);
                    continue block0;
                }
            }
        }
        return patchList;
    }

    private boolean showRetryDialog(int buttonOps, String prompt) throws OiifbEndIterateException {
        int userInput = 0;
        boolean retry = false;
        try {
            OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(prompt, buttonOps, 1);
            userInput = actionDlg.doModal();
            actionDlg = null;
            Thread.yield();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        switch (userInput) {
            case 2: {
                retry = true;
                break;
            }
            case 4: {
                retry = false;
                break;
            }
            case 32: {
                throw new OiifbEndIterateException(prompt);
            }
            case 16: {
                throw new OiifbEndIterateException(prompt);
            }
        }
        return retry;
    }

    public void dispose() {
    }
}

