/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;

public class OiifbCondIterator
implements OiifbWizIterator {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16;
    private static long s_lStartTime;
    protected List m_elems;
    protected int m_current;
    private Stack m_stack;
    private boolean m_noBack;

    public OiifbCondIterator(Vector arr) {
        this(arr, false);
    }

    public OiifbCondIterator(Vector arr, boolean noBack) {
        this.m_noBack = noBack;
        this.m_stack = new Stack();
        this.m_elems = new ArrayList(arr.size());
        this.m_elems.addAll(arr);
        this.m_current = 0;
    }

    public synchronized void dispose() {
        if (this.m_elems != null) {
            int numElems = this.m_elems.size();
            for (int i = 0; i < numElems; ++i) {
                OiifbWizOperation wop = (OiifbWizOperation)this.m_elems.get(i);
                if (wop == null) continue;
                wop.dispose();
            }
            this.m_elems.clear();
            this.m_elems = null;
        }
    }

    public int iterate(boolean isBack) throws OiifbEndIterateException {
        int btype;
        OiifbWizOperation elem;
        if (this.m_elems == null || this.m_elems.isEmpty()) {
            return isBack ? 1 : 0;
        }
        int size = this.m_elems.size();
        if (isBack) {
            elem = (OiifbWizOperation)this.m_stack.pop();
        } else {
            this.m_current = 0;
            elem = (OiifbWizOperation)this.m_elems.get(this.m_current);
        }
        while (true) {
            long lCurTime;
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifbCondIterator:In iterate - loop.. : elem is " + elem.getClass(), OiiolTextLogger.LOG_DETAILED);
            }
            String sElemName = elem.toString();
            if (!isBack) {
                if (OiixDebug.PRINT_TIME) {
                    s_lStartTime = System.currentTimeMillis();
                }
                elem.initialize();
                if (OiixDebug.PRINT_TIME) {
                    lCurTime = System.currentTimeMillis();
                    OiixDebug.printTimeMsg(sElemName + ":initialize", lCurTime - s_lStartTime);
                    s_lStartTime = lCurTime;
                }
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("OiifbLinearIterator:Calling doOperation(" + isBack + ") on:" + elem.getClass(), OiiolTextLogger.LOG_TRACE);
            }
            if (OiixDebug.PRINT_TIME) {
                s_lStartTime = System.currentTimeMillis();
            }
            btype = elem.doOperation(isBack);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("OiifbLinearIterator:Result of doOperation(" + isBack + ") on:" + btype, OiiolTextLogger.LOG_TRACE);
            }
            if (btype == 0) {
                isBack = false;
                this.m_stack.push(elem);
                if (elem instanceof OiifbCondWizOperation) {
                    int index = ((OiifbCondWizOperation)elem).getNext();
                    if (index == -1) {
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("OiifbLinearIterator:Result of getNext:" + index, OiiolTextLogger.LOG_TRACE);
                        }
                        if (!OiixDebug.PRINT_TIME) break;
                        long lCurTime2 = System.currentTimeMillis();
                        OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime2 - s_lStartTime);
                        s_lStartTime = lCurTime2;
                        break;
                    }
                    this.m_current = index;
                } else {
                    ++this.m_current;
                    if (this.m_current >= size) {
                        if (!OiixDebug.PRINT_TIME) break;
                        long lCurTime3 = System.currentTimeMillis();
                        OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime3 - s_lStartTime);
                        s_lStartTime = lCurTime3;
                        break;
                    }
                }
                elem = (OiifbWizOperation)this.m_elems.get(this.m_current);
            } else {
                isBack = true;
                if (this.m_stack.empty()) {
                    if (!OiixDebug.PRINT_TIME) break;
                    lCurTime = System.currentTimeMillis();
                    OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime - s_lStartTime);
                    s_lStartTime = lCurTime;
                    break;
                }
                elem = (OiifbWizOperation)this.m_stack.pop();
                this.m_current = this.m_elems.indexOf(elem);
            }
            if (!OiixDebug.PRINT_TIME) continue;
            long lCurTime4 = System.currentTimeMillis();
            OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime4 - s_lStartTime);
            s_lStartTime = lCurTime4;
        }
        return btype;
    }

    public void clearIterElements(int nElements) {
        if (this.m_elems == null) {
            return;
        }
        if (this.m_elems.size() <= nElements) {
            return;
        }
        for (int i = 0; i <= nElements; ++i) {
            OiifbWizOperation wop = (OiifbWizOperation)this.m_elems.get(i);
            this.m_stack.remove(wop);
            wop.dispose();
            this.m_elems.remove(i);
            this.m_elems.add(i, null);
        }
    }
}

