/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwProgressMonitor;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSilentInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfo;
import oracle.sysman.oii.oiif.oiifb.OiifbIConfigActionHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicConfigPageHandler;
import oracle.sysman.oii.oiif.oiifp.OiifpAutoConfigPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpConfigTablePanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwAutoConfigWCDE;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifbConfigController {
    public static final int TOOLS_SUCCEEDED = 0;
    public static final int TOOLS_FAILED = 1;
    public static final int TOOLS_SKIPPED = 3;
    private static boolean CFGDEBUG = true;
    private static final String COMMAND = "Command = ";
    private static final String OUICA = "OUICA";
    private static final String OUICA_TIMESTAMP = "OUICA_TIMESTAMP";
    private static final String OUICA_LOGDIR = "OUICA_LOGDIR";
    private static final String OUICA_CLASSPATH = "OUICA_CLASSPATH";
    private static final String JLIB = "jlib";
    private static final String ORAINSTALLER_JAR = "OraInstaller.jar";
    private static final String OUICA_JAR = "ouica.jar";
    private static final String XMLPARSERV2_JAR = "xmlparserv2.jar";
    private static final String SRVM_JAR = "srvm.jar";
    private static final String BIN = "bin";
    private static final boolean s_debug = new Boolean(System.getProperty("oracle.installer.debug", "false"));
    private static final boolean s_logConfigArgs = new Boolean(System.getProperty("oracle.installer.logConfigArgs", "true"));
    private static String m_sOuiCaActionType = "custom:OuiCA";
    private static final int TOOL_TYPE_RECOMMENDED = 101;
    private static final int TOOL_TYPE_OPTIONAL = 102;
    private static final int TOOL_TYPE_RECOMMENDED_AND_OPTIONAL = 103;
    private OiicInstPostActionsPhase m_postActionsPhase;
    private boolean m_bSkipRemainingTools;
    private OiifpAutoConfigPanel m_wizPanel;
    private OiifmGraphicConfigPageHandler m_graphicConfigPageHandler;
    private OiicPullSession m_pullSession;
    private boolean m_recommendedToolFailed = false;
    private boolean m_optionalToolFailed = false;
    private boolean m_recommendedToolSkipped = false;
    private boolean m_optionalToolSkipped = false;
    private boolean m_bStop = false;
    private boolean m_bSkipAllConfigTools = !Boolean.getBoolean("oracle.installer.config");
    private boolean bOUICARunning = false;
    private boolean bActionEnded = false;
    private IAction m_aCurrentAction;
    private CFPrintStream outStream;
    private String sTxtAreaContents = null;
    private Vector selectedTools = new Vector();
    private CfwSession session;
    private CfwClient c;
    private IAggregate m_aggregate;
    private IAggregateReference m_aggRef;
    private MyProgress progressListener;
    private String m_sFailedSkippedToolsInfo = "";
    private boolean ranOUICA = false;
    private int actionState = 1;
    private OiicSilentInterfaceManager m_silentManager;
    private boolean isSilentInstall = false;
    private boolean isDeinstall = false;
    private boolean isSilentDeinstall = false;
    private CFStreamThread m_StreamThread = new CFStreamThread();
    private Object m_lock = new Object();
    private boolean m_bIgnoreActionEvents = false;
    private OiifrProgressActionListener m_oDeinstallListener;
    private int currentLength = -1;
    private boolean m_bBlocking = true;
    private static char RETURN = (char)13;
    private static char ZERO = '\u0000';
    private static char NEWLINE = (char)10;
    private boolean isSilentExecution = false;
    private OiifbIConfigActionHandler oCfgActionHandler = null;

    public OiifbConfigController() {
    }

    public OiifbConfigController(OiifmGraphicConfigPageHandler gch, boolean bSkipAllConfigTools, OiifpAutoConfigPanel wizPanel, OiifwAutoConfigWCDE wizElem, OiicInstPostActionsPhase postActionsPhase) {
        this.m_bSkipRemainingTools = bSkipAllConfigTools;
        this.m_wizPanel = wizPanel;
        this.m_graphicConfigPageHandler = gch;
        this.m_pullSession = wizElem.getInstallSession();
        this.m_postActionsPhase = postActionsPhase;
    }

    public void initialize(OiicSilentInterfaceManager sch, boolean bSkipAllConfigTools, OiicInstPostActionsPhase postActionsPhase, OiicPullSession pullSession) {
        this.printDebugMessages("Initializing for silent execution of configuration tools");
        this.m_silentManager = sch;
        this.m_bSkipRemainingTools = bSkipAllConfigTools;
        this.m_postActionsPhase = postActionsPhase;
        this.m_pullSession = pullSession;
        this.isSilentInstall = true;
        this.printDebugMessages("Initialization done");
    }

    public void initializeForDeinstall(boolean isSilent, IAggregate oAggregate, CfwSession oSession) {
        if (isSilent) {
            this.printDebugMessages("Initializing for silent deinstall mode execution of configuration tools");
        } else {
            this.printDebugMessages("Initializing for deinstall mode execution of configuration tools");
        }
        this.isDeinstall = true;
        this.isSilentDeinstall = isSilent;
        this.m_aggregate = oAggregate;
        this.printDebugMessages("Aggregate for deinstall mode :" + oAggregate.getSelfID());
        this.session = oSession;
        this.printDebugMessages("Initializing done");
    }

    public void initialize(OiifmGraphicConfigPageHandler gch, boolean bSkipAllConfigTools, OiifpAutoConfigPanel wizPanel, OiifwAutoConfigWCDE wizElem, OiicInstPostActionsPhase postActionsPhase) {
        this.printDebugMessages("Initializing for UI execution of configuration tools");
        this.m_bSkipRemainingTools = bSkipAllConfigTools;
        this.m_wizPanel = wizPanel;
        this.m_graphicConfigPageHandler = gch;
        this.m_pullSession = wizElem.getInstallSession();
        this.m_postActionsPhase = postActionsPhase;
        this.isSilentInstall = false;
        this.printDebugMessages("Initializing done");
    }

    public void registerConfigActionHandler(OiifbIConfigActionHandler oHandler) {
        this.oCfgActionHandler = oHandler;
    }

    public void initializeForAdditionalUtilityExecution(boolean isSilent, IAggregate oAggregate, CfwSession oSession, OiicPullSession pullSession) {
        this.printDebugMessages("Initializing for execution of configuration tools for Additional Utility");
        this.m_aggregate = oAggregate;
        this.session = oSession;
        this.isDeinstall = false;
        this.isSilentDeinstall = false;
        this.isSilentInstall = false;
        this.isSilentExecution = isSilent;
        this.m_wizPanel = null;
        this.m_pullSession = pullSession;
    }

    public int launchConfigToolsForAdditionalUtilityExecution(ActionType oActionType, boolean bRetry, IMicroStepStateReference[] pluginList) {
        this.printDebugMessages(" launchConfigToolsForAdditionalUtilityExecution start");
        int nRetVal = 1;
        this.m_bStop = false;
        this.bOUICARunning = false;
        this.bActionEnded = false;
        this.actionState = 1;
        try {
            this.launchAggregatesForAdditionalUtil(oActionType, bRetry, pluginList);
        }
        catch (CfwException e) {
            this.bActionEnded = true;
            OiiolTextLogger.appendException((Exception)((Object)e));
        }
        nRetVal = this.actionState;
        if (null != this.session) {
            OiixCFOps.letCFSaveConfigInfo(this.session);
        }
        this.printDebugMessages(" launchConfigToolsForAdditionalUtilityExecution end with return value" + nRetVal);
        return nRetVal;
    }

    private void launchAggregatesForAdditionalUtil(ActionType oActionType, boolean bRetry, IMicroStepStateReference[] pluginList) throws CfwException {
        this.printDebugMessages("launchAggregatesForAdditionalUtil start");
        this.outStream = new CFPrintStream();
        PrintStream ps = new PrintStream(this.outStream);
        this.session.registerStreams(ps, System.err);
        IAggregate agg = null;
        agg = this.m_aggregate;
        this.m_aggRef = OiixCFOps.getAggregateReference(this.session, this.m_aggregate.getSelfID());
        this.progressListener = new MyProgress(this.session, this.m_aggRef, this, false, true);
        agg.addProgressListener((IProgressMonitor)this.progressListener);
        this.progressListener.setOUICA(false);
        this.m_aCurrentAction = OiixCFOps.getAction(this.m_aggregate, oActionType);
        if (null != this.m_aCurrentAction) {
            agg.performAction(true, this.isSilentExecution, bRetry, true, pluginList, oActionType);
        } else {
            this.bActionEnded = true;
        }
        this.printDebugMessages("launchAggregatesForAdditionalUtil end");
    }

    public void launchConfigToolsForDeinstall(OiifrProgressActionListener deinstProgressListener) {
        this.printDebugMessages(" launchConfigToolsForDeinstall start");
        ActionType at = ActionType.PURGING_DRASTIC;
        IAction action = null;
        if (this.m_aggregate != null) {
            action = OiixCFOps.getAction(this.m_aggregate, at);
        }
        if (action != null) {
            try {
                this.m_bStop = false;
                this.bOUICARunning = false;
                this.bActionEnded = false;
                this.actionState = 1;
                this.m_sFailedSkippedToolsInfo = "";
                this.m_recommendedToolFailed = false;
                this.m_optionalToolFailed = false;
                this.m_optionalToolSkipped = false;
                this.m_recommendedToolSkipped = false;
                String sStartOfToolsMsg = OiixResourceBundle.getString("S_LOG_BEGIN_TOOLS");
                OiiolTextLogger.appendText(sStartOfToolsMsg);
                this.outStream = new CFPrintStream();
                PrintStream ps = new PrintStream(this.outStream);
                this.session.registerStreams(ps, System.err);
                this.m_oDeinstallListener = deinstProgressListener;
                MyProgress progressListener = new MyProgress(this.session, null, this, false, false);
                this.m_aggregate.addProgressListener((IProgressMonitor)progressListener);
                this.m_aggregate.performAction(true, this.isSilentDeinstall, false, false, at);
            }
            catch (CfwException ce) {
                OiiolTextLogger.appendText(ce.getMessage());
                this.printDebugMessages("CfwException got ", (Exception)((Object)ce));
            }
        } else {
            this.printDebugMessages("There is no Purging:Drastic type");
            OiiolTextLogger.appendText("no Purging:Drastic type of Action found by CF");
        }
        this.printDebugMessages(" launchConfigToolsForDeinstall end");
    }

    public int launchConfigToolsForSilent() {
        this.printDebugMessages(" launchConfigToolsForSilent start");
        int nRetVal = 1;
        if (!this.m_bSkipRemainingTools) {
            this.m_bStop = false;
            this.bOUICARunning = false;
            this.bActionEnded = false;
            this.actionState = 1;
            this.m_sFailedSkippedToolsInfo = "";
            this.m_recommendedToolFailed = false;
            this.m_optionalToolFailed = false;
            this.m_optionalToolSkipped = false;
            this.m_recommendedToolSkipped = false;
            try {
                this.launchAggregatesForSilent();
            }
            catch (CfwException e) {
                this.bActionEnded = true;
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
            nRetVal = this.actionState;
            if (nRetVal == 1 && this.m_pullSession.isInstallMode()) {
                this.ranOUICA = true;
            }
        } else {
            this.m_silentManager.setAllToolStatus(6);
            nRetVal = 3;
        }
        if (null != this.session) {
            OiixCFOps.letCFSaveConfigInfo(this.session);
        }
        this.printDebugMessages(" launchConfigToolsForSilent end with return value" + nRetVal);
        return nRetVal;
    }

    public int launchConfigTools(boolean bRetry) {
        this.printDebugMessages(" launchConfigTools start");
        this.selectedTools = this.m_graphicConfigPageHandler.getSelectedTools();
        int nRetVal = 1;
        long lTime = 0L;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        Object vVolumeInfo = null;
        String sStartOfToolsMsg = OiixResourceBundle.getString("S_LOG_BEGIN_TOOLS");
        OiiolTextLogger.appendText(sStartOfToolsMsg);
        this.m_wizPanel.setStopAllowed(true);
        this.m_wizPanel.setRunAllowed(false);
        boolean bSkipRemainingTools = false;
        bSkipRemainingTools = bRetry ? (this.m_bSkipAllConfigTools ? false : false) : this.m_bSkipAllConfigTools;
        int size = this.m_graphicConfigPageHandler.getToolCount();
        if (!bSkipRemainingTools) {
            this.m_bStop = false;
            this.bOUICARunning = false;
            this.bActionEnded = false;
            this.outStream = new CFPrintStream();
            this.actionState = 1;
            this.m_sFailedSkippedToolsInfo = "";
            this.m_recommendedToolFailed = false;
            this.m_optionalToolFailed = false;
            this.m_recommendedToolSkipped = false;
            this.m_optionalToolSkipped = false;
            try {
                this.launchAggregates(bRetry);
            }
            catch (CfwException e) {
                this.bActionEnded = true;
                OiiolTextLogger.appendException((Exception)((Object)e));
            }
            nRetVal = this.actionState;
            if (nRetVal == 1 && this.m_pullSession.isInstallMode()) {
                this.ranOUICA = true;
            }
        } else {
            int iToolCount = this.m_graphicConfigPageHandler.getToolCount();
            if (iToolCount > 0) {
                for (int i = 0; i < iToolCount; ++i) {
                    OiifbConfigToolInfo toolInfo = this.m_wizPanel.getToolInfo(i);
                    this.m_wizPanel.setStatus(toolInfo.getToolName(), toolInfo.getOraHome(), toolInfo.getTopLevelCompName(), toolInfo.getAggrName(), toolInfo.getActionID(), toolInfo.getStepIndex(), toolInfo.getMicroStepIndex(), 6, null, "");
                    this.m_sFailedSkippedToolsInfo = this.m_sFailedSkippedToolsInfo + toolInfo.getToolName() + "\n";
                    if (toolInfo.getToolType() == 0) {
                        this.m_recommendedToolSkipped = true;
                        continue;
                    }
                    if (toolInfo.getToolType() != 1) continue;
                    this.m_optionalToolSkipped = true;
                }
                this.m_wizPanel.setStopAllowed(false);
                nRetVal = 3;
            }
        }
        if (null != this.session) {
            OiixCFOps.letCFSaveConfigInfo(this.session);
        }
        this.printDebugMessages(" launchConfigTools end with return value " + nRetVal);
        return nRetVal;
    }

    public void onStop() {
        if (!this.bActionEnded) {
            this.m_bStop = true;
            this.m_wizPanel.setRunAllowed(true);
            this.m_wizPanel.setStopAllowed(false);
            if (null != this.m_aCurrentAction) {
                try {
                    this.m_aCurrentAction.cancel(this.m_bBlocking);
                }
                catch (CfwException ce) {
                    OiiolTextLogger.appendException((Exception)((Object)ce));
                }
                catch (Exception e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }
    }

    public synchronized void OuiCAactionStart(IActionStateReference actionID, IActionStepStateReference[] items) throws CfwException {
        this.bOUICARunning = true;
    }

    public synchronized void OuiCAactionEnd(IActionStateReference actionID, int actState) throws CfwException {
        this.bOUICARunning = false;
    }

    public synchronized void actionStart(IActionStateReference actionID, IActionStepStateReference[] items) throws CfwException {
        if (OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_TIME) {
            OiixDebug.printConfigDebugTMDMesages("Start of launching config tools ", System.currentTimeMillis(), 0L, this.m_pullSession.getVolumeInfo());
        }
        this.printDebugMessages(" actionStart event received from config fw , actionID.getSelfID() = " + actionID.getSelfID());
        this.bActionEnded = false;
        this.m_StreamThread = new CFStreamThread();
        this.m_StreamThread.startListening();
        Thread th = new Thread(this.m_StreamThread);
        th.start();
    }

    public synchronized void actionEnd(IActionStateReference actionID, int actState) throws CfwException {
        if (OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_TIME) {
            OiixDebug.printConfigDebugTMDMesages("End of launching config tools ", System.currentTimeMillis(), System.currentTimeMillis(), this.m_pullSession.getVolumeInfo());
        }
        this.printDebugMessages(" actionEnd event received from config fw , actionID.getSelfID() = " + actionID.getSelfID() + " action State = " + actState);
        if (actState == 0) {
            this.printDebugMessages("Action state is TOOLS SUCCEEDED");
            this.actionState = 0;
            OiiolTextLogger.appendText("All the tools have been executed Successfully");
        }
        this.m_StreamThread.stopListening();
        if (this.m_bStop) {
            int iToolCount;
            this.printDebugMessages("The stop has been called while executing the tools");
            if (!this.isSilentInstall && !this.isDeinstall && (iToolCount = this.m_graphicConfigPageHandler.getToolCount()) > 0) {
                this.printDebugMessages("Setting the status of the tools to cancelled whichever wasn't executed yet");
                for (int i = 0; i < iToolCount; ++i) {
                    OiifbConfigToolInfo toolInfo = this.m_wizPanel.getToolInfo(i);
                    if (toolInfo.getToolStatus() == 4 || toolInfo.getToolStatus() == 6 || toolInfo.getToolStatus() == 3 || null == this.m_wizPanel) continue;
                    this.m_wizPanel.setStatus(toolInfo.getToolName(), toolInfo.getOraHome(), toolInfo.getTopLevelCompName(), toolInfo.getAggrName(), toolInfo.getActionID(), toolInfo.getStepIndex(), toolInfo.getMicroStepIndex(), 5, "Tools Cancelled \n", "");
                }
            }
            this.printDebugMessages("Action state is TOOLS FAILED");
            this.actionState = 1;
        }
        if ((!this.m_bIgnoreActionEvents || this.m_bIgnoreActionEvents && this.actionState == 1) && !this.isSilentInstall && !this.isDeinstall) {
            this.printDebugMessages("It is not a silent install and not a deinstall session,\n so trying to have the UI updation done by calling GraphicConfigPageHandler.handleActionEnd()");
            if (null != this.m_graphicConfigPageHandler) {
                this.m_graphicConfigPageHandler.handleActionEnd();
            }
        }
        this.printDebugMessages("Trying to close the output stream");
        try {
            if (null != this.outStream) {
                this.outStream.close();
            }
        }
        catch (Exception ie) {
            OiiolTextLogger.appendException(ie);
        }
        if (!this.m_bIgnoreActionEvents || this.m_bIgnoreActionEvents && this.actionState == 1) {
            this.bActionEnded = true;
        }
    }

    public void handlePlugInStart(String sPlugInID, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, String sCmdArg) {
        this.printDebugStartMessages(sPlugInID);
        this.printDebugMessages("handlePlugInStart event called with \nplugin id = " + sPlugInID + " \noracle home = " + oraHomeName + " \ntop level comp name = " + toplevelName + " \ncomp name = " + compName + " \naction name = " + actionName + " \nstep index = " + stepIdx + " \nmicro step index = " + microStepIdx + " \ncommand with arg = " + sCmdArg);
        if (!this.isSilentInstall && !this.isDeinstall && null != this.m_wizPanel) {
            this.m_wizPanel.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 1, null, sCmdArg + "\n");
        }
        if (this.isDeinstall && null != this.m_oDeinstallListener) {
            this.m_oDeinstallListener.setStatus(MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_DEINSTALL_CONFIG_TOOL_START"), sPlugInID));
        }
        if (null != this.oCfgActionHandler) {
            this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 1, null, sCmdArg + "\n");
        }
        OiiolTextLogger.appendText(sCmdArg + "\n");
        this.m_StreamThread.startOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlugInEnd(String sPlugInID, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, int iStatus, String sMsg, String sCmdArg) {
        String resMsg;
        this.m_StreamThread.stopOutput();
        this.printDebugMessages("handlePlugInEnd event called with \nplugin id = " + sPlugInID + " \noracle home = " + oraHomeName + " \ntop level comp name = " + toplevelName + " \ncomp name = " + compName + " \naction name = " + actionName + " \nstep index = " + stepIdx + " \nmicro step index = " + microStepIdx + " \ncommand with arg = " + sCmdArg + " \n msg = " + sMsg);
        String toWrite = "";
        Object object = this.m_lock;
        synchronized (object) {
            int iStreamLength = this.outStream.getLength();
            char[] cStreamChars = this.outStream.getChars(0, iStreamLength);
            if (null != cStreamChars) {
                toWrite = String.valueOf(cStreamChars);
                toWrite = this.formatNewlines(toWrite);
                this.currentLength = iStreamLength;
                cStreamChars = null;
            }
        }
        this.printDebugStopMessages(sPlugInID);
        if (!this.isSilentInstall && !this.isDeinstall) {
            this.printDebugMessages("setting the status for UI install configuration ");
            switch (iStatus) {
                case 3: {
                    if (null != this.m_wizPanel) {
                        this.m_wizPanel.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 3, null, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 3, null, sCmdArg + "\n");
                    break;
                }
                case 4: {
                    if (null != this.m_wizPanel) {
                        this.m_wizPanel.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 4, null, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 4, null, sCmdArg + "\n");
                    break;
                }
                case 5: {
                    if (null != this.m_wizPanel) {
                        this.m_wizPanel.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 5, null, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 5, null, sCmdArg + "\n");
                }
            }
            this.writeMessages(toWrite, sMsg, "", "");
            this.logToolResult(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, sMsg + "\n" + toWrite);
        } else if (this.isSilentInstall && !this.isDeinstall) {
            this.printDebugMessages("setting the status for silent install configuration ");
            resMsg = this.getResourceMessage(iStatus);
            switch (iStatus) {
                case 3: {
                    if (null != this.m_silentManager) {
                        this.m_silentManager.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 3, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 3, null, sCmdArg + "\n");
                    break;
                }
                case 4: {
                    if (null != this.m_silentManager) {
                        this.m_silentManager.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 4, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 4, null, sCmdArg + "\n");
                    break;
                }
                case 5: {
                    if (null != this.m_silentManager) {
                        this.m_silentManager.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 5, sCmdArg);
                    }
                    if (null == this.oCfgActionHandler) break;
                    this.oCfgActionHandler.setStatus(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx, 5, null, sCmdArg + "\n");
                }
            }
            if (resMsg.compareToIgnoreCase("") != 0) {
                OiifbConfigToolInfo toolInfo = this.m_silentManager.getToolInfo(sPlugInID, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx);
                resMsg = null != toolInfo ? MessageFormat.format(resMsg, toolInfo.getExternalName()) : MessageFormat.format(resMsg, sPlugInID);
            }
            this.writeMessages(toWrite, sMsg, resMsg, resMsg);
        } else if (this.isDeinstall) {
            if (this.isSilentDeinstall) {
                this.printDebugMessages("setting the status for silent deinstall configuration ");
            } else {
                this.printDebugMessages("setting the status for UI deinstall configuration ");
            }
            resMsg = this.getResourceMessage(iStatus);
            if (resMsg.compareToIgnoreCase("") != 0) {
                resMsg = MessageFormat.format(resMsg, sPlugInID);
            }
            if (this.isSilentDeinstall) {
                this.writeMessages(toWrite, sMsg, resMsg, resMsg);
            } else {
                this.writeMessages(toWrite, sMsg, resMsg, "");
            }
        }
    }

    private String getResourceMessage(int iStatus) {
        String resMsg = "";
        switch (iStatus) {
            case 3: {
                resMsg = OiixResourceBundle.getString("S_LOG_TOOL_SUCCEEDED");
                break;
            }
            case 4: {
                resMsg = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                break;
            }
            case 5: {
                resMsg = OiixResourceBundle.getString("S_LOG_TOOL_CANCELED");
            }
        }
        return resMsg;
    }

    private void writeMessages(String sMsg1, String sMsg2, String sMsg3, String silentMsg) {
        this.printDebugMessages("sMsg 1 = " + sMsg1 + " \nsMsg 2 = " + sMsg2 + " \nsMsg3 = " + sMsg3 + " \nsilent Message = " + silentMsg);
        if (sMsg1.trim().length() > 0) {
            OiiolTextLogger.appendText(sMsg1, OiiolTextLogger.LOG_WITHOUT_LEVEL);
        }
        if (sMsg2.trim().length() > 0) {
            OiiolTextLogger.appendText(sMsg2, OiiolTextLogger.LOG_WITHOUT_LEVEL);
        }
        if (sMsg3.trim().length() > 0) {
            OiiolTextLogger.appendText(sMsg3, OiiolTextLogger.LOG_WITHOUT_LEVEL);
        }
        if (silentMsg.trim().length() > 0) {
            OiiolTextLogger.writeMessageToConsole(silentMsg);
        }
    }

    public void runOuicaViaCfw(boolean bExitCondition) {
        this.printDebugMessages("execution of ouica to be done bExitcondition =" + bExitCondition + " isReboot info set = " + this.m_pullSession.isRebootInfoSet() + " is successful insatllation done = " + this.m_pullSession.isSuccessfullInstallation());
        if (!bExitCondition || !this.m_pullSession.isRebootInfoSet() && this.m_pullSession.isSuccessfullInstallation()) {
            try {
                if (this.bActionEnded) {
                    this.launchOUICAAggregate();
                }
            }
            catch (Exception e) {
                this.bActionEnded = true;
                OiiolTextLogger.appendText("Exception : " + e.getMessage());
                this.printDebugMessages("got an exception while running ouica ", e);
            }
        }
    }

    private void launchAggregatesForSilent() throws CfwException {
        this.printDebugMessages("launchAggregatesForSilent start");
        String[] expectedAggregates = new String[]{this.m_postActionsPhase.getTopLevelAggregateName()};
        List<String> aggregatesToLoad = Arrays.asList(expectedAggregates);
        this.printDebugMessages("aggregate to be loaded = " + this.m_postActionsPhase.getTopLevelAggregateName());
        this.session = OiicInstaller.getConfigContext().getCfwSession();
        this.outStream = new CFPrintStream();
        PrintStream ps = new PrintStream(this.outStream);
        this.session.registerStreams(ps, System.err);
        IAggregateReference[] aggregateRefs = this.session.getAggregateReferences("common");
        IAggregateReference aggref = null;
        IAggregate agg = null;
        if (aggregateRefs != null) {
            for (int i = 0; i < aggregateRefs.length; ++i) {
                IActionReference[] actionref;
                aggref = aggregateRefs[i];
                agg = this.session.getAggregate(aggref);
                if (this.m_postActionsPhase.getTopLevelAggregate().getSelfID().compareToIgnoreCase(agg.getSelfID()) != 0) continue;
                this.m_aggregate = agg;
                this.m_aggRef = aggref;
                this.progressListener = new MyProgress(this.session, aggref, this, false, true);
                agg.addProgressListener((IProgressMonitor)this.progressListener);
                this.progressListener.setOUICA(false);
                this.m_aCurrentAction = null;
                if (null != this.m_postActionsPhase.getActionType() && (actionref = agg.getActionReferences()) != null) {
                    for (int k = 0; k < actionref.length; ++k) {
                        IAction action = agg.getAction(actionref[k]);
                        if (!action.isType(this.m_postActionsPhase.getActionType())) continue;
                        this.m_aCurrentAction = action;
                        boolean bRetry = false;
                        boolean skipExitOnly = true;
                        boolean skipOptional = true;
                        if (OiixOraparam.runRecommendedConfigToolsFirst()) {
                            this.m_bIgnoreActionEvents = true;
                            agg.performActionRecommended(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitOnly, skipOptional, this.m_postActionsPhase.getActionType());
                            this.m_bIgnoreActionEvents = false;
                            if (this.actionState != 0) break;
                            agg.performActionOptional(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitOnly, this.m_postActionsPhase.getActionType());
                            break;
                        }
                        agg.performAction(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitOnly, this.m_postActionsPhase.getActionType());
                        break;
                    }
                }
                if (null != this.m_aCurrentAction) continue;
                this.bActionEnded = true;
            }
        }
        this.printDebugMessages("launchAggregatesForSilent end");
    }

    private IMicroStepStateReference[] getSelectedToolsForPerform(int iToolType, Vector vToolList, boolean bUpdateAttempts) {
        IMicroStepStateReference[] oPluginList = null;
        Vector<IMicroStepStateReference> toolList = new Vector<IMicroStepStateReference>();
        boolean iPluginCount = false;
        if (null != vToolList) {
            for (int k = 0; k < vToolList.size(); ++k) {
                OiifbConfigToolInfo toolInfo = (OiifbConfigToolInfo)vToolList.elementAt(k);
                if (bUpdateAttempts) {
                    toolInfo.setAttempts(toolInfo.getAttempts() + 1);
                }
                boolean bAddTool = false;
                switch (iToolType) {
                    case 101: {
                        if (toolInfo.getToolType() != 0) break;
                        bAddTool = true;
                        break;
                    }
                    case 102: {
                        if (toolInfo.getToolType() != 1) break;
                        bAddTool = true;
                        break;
                    }
                    default: {
                        bAddTool = true;
                    }
                }
                if (!bAddTool || toolList.contains(toolInfo.getPluginReference())) continue;
                toolList.add(toolInfo.getPluginReference());
            }
            if (null != toolList && toolList.size() > 0) {
                oPluginList = new IMicroStepStateReference[toolList.size()];
                oPluginList = toolList.toArray(new IMicroStepStateReference[0]);
            }
        }
        return oPluginList;
    }

    private void launchAggregates(boolean bRetry) throws CfwException {
        this.printDebugMessages("launchAggregates start with retry = " + bRetry);
        String[] expectedAggregates = new String[]{this.m_postActionsPhase.getTopLevelAggregateName()};
        this.printDebugMessages("aggregate to be loaded = " + this.m_postActionsPhase.getTopLevelAggregateName());
        List<String> aggregatesToLoad = Arrays.asList(expectedAggregates);
        this.session = OiicInstaller.getConfigContext().getCfwSession();
        this.outStream = new CFPrintStream();
        PrintStream ps = new PrintStream(this.outStream);
        this.session.registerStreams(ps, System.err);
        IAggregateReference[] aggregateRefs = this.session.getAggregateReferences("common");
        IAggregateReference aggref = null;
        IAggregate agg = null;
        if (aggregateRefs != null) {
            for (int i = 0; i < aggregateRefs.length; ++i) {
                IActionReference[] actionref;
                aggref = aggregateRefs[i];
                agg = this.session.getAggregate(aggref);
                if (this.m_postActionsPhase.getTopLevelAggregate().getSelfID().compareToIgnoreCase(agg.getSelfID()) != 0) continue;
                this.m_aggregate = agg;
                this.m_aggRef = aggref;
                if (!bRetry || null == this.progressListener) {
                    this.progressListener = new MyProgress(this.session, aggref, this, false, false);
                    agg.addProgressListener((IProgressMonitor)this.progressListener);
                }
                this.progressListener.setOUICA(false);
                this.m_aCurrentAction = null;
                boolean bUpdateAttempts = false;
                if (null != this.m_postActionsPhase.getActionType() && (actionref = agg.getActionReferences()) != null) {
                    for (int k = 0; k < actionref.length; ++k) {
                        IAction action = agg.getAction(actionref[k]);
                        if (!action.isType(this.m_postActionsPhase.getActionType())) continue;
                        boolean skipExitonly = true;
                        this.m_aCurrentAction = action;
                        if (OiixOraparam.runRecommendedConfigToolsFirst()) {
                            IMicroStepStateReference[] selectedPlugins;
                            this.m_bIgnoreActionEvents = true;
                            if (bRetry) {
                                bUpdateAttempts = true;
                            }
                            if (null != (selectedPlugins = this.getSelectedToolsForPerform(101, this.m_graphicConfigPageHandler.getSelectedTools(), bUpdateAttempts)) && selectedPlugins.length > 0) {
                                agg.performAction(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitonly, selectedPlugins, this.m_postActionsPhase.getActionType());
                            } else {
                                this.actionState = 0;
                            }
                            this.m_bIgnoreActionEvents = false;
                            if (this.actionState != 0) break;
                            if (bRetry) {
                                bUpdateAttempts = true;
                            }
                            if (null == (selectedPlugins = this.getSelectedToolsForPerform(102, this.m_graphicConfigPageHandler.getSelectedTools(), bUpdateAttempts)) || selectedPlugins.length <= 0) break;
                            agg.performAction(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitonly, selectedPlugins, this.m_postActionsPhase.getActionType());
                            break;
                        }
                        if (bRetry) {
                            bUpdateAttempts = true;
                        }
                        agg.performAction(this.m_bBlocking, this.isSilentInstall, bRetry, skipExitonly, this.getSelectedToolsForPerform(103, this.m_graphicConfigPageHandler.getSelectedTools(), bUpdateAttempts), this.m_postActionsPhase.getActionType());
                        break;
                    }
                }
                if (null != this.m_aCurrentAction) continue;
                this.bActionEnded = true;
            }
        }
        this.printDebugMessages("launchAggregates end");
    }

    private void launchOUICAAggregate() throws CfwException, InterruptedException {
        this.printDebugMessages("launchOUICAAggregate start ");
        try {
            IAggregateReference[] ouicaaggregateRefs = this.session.getAggregateReferences("common");
            int iAggregateIdx = -1;
            for (int i = 0; i < ouicaaggregateRefs.length; ++i) {
                if (ouicaaggregateRefs[i].getSelfID().compareToIgnoreCase(OiiiInstallAreaControl.getOuiConfigVariablesXMLFileName()) != 0) continue;
                iAggregateIdx = i;
                break;
            }
            if (iAggregateIdx > -1) {
                IAggregate aggrRef = this.session.getAggregate(ouicaaggregateRefs[iAggregateIdx]);
                if (null != this.progressListener) {
                    this.progressListener.setOUICA(true);
                }
                IActionReference[] aRefs = aggrRef.getActionReferences();
                int iActionIdx = -1;
                for (int j = 0; j < aRefs.length; ++j) {
                    if (aRefs[j].getSelfID().compareToIgnoreCase(OUICA) != 0) continue;
                    iActionIdx = j;
                    break;
                }
                if (iActionIdx > -1) {
                    IParameterReference[] paramRefs;
                    String[] ouicacmd = ((OiicInstallSession)this.m_pullSession).getOuicaCommand();
                    if (null != ouicacmd && ouicacmd.length > 0 && null != (paramRefs = aggrRef.getParameterReferences()) && paramRefs.length > 0) {
                        for (int paramIndex = 0; paramIndex < paramRefs.length; ++paramIndex) {
                            String ouiloc;
                            IParameter param = aggrRef.getParameter(paramRefs[paramIndex]);
                            if (param.getSelfID().compareToIgnoreCase(OUICA_TIMESTAMP) == 0 && param.isSettable()) {
                                this.printDebugMessages("timestamp = -Doracle.installer.timestamp=" + ouicacmd[1]);
                                param.setSimplestAsString("-Doracle.installer.timestamp=" + ouicacmd[1]);
                                continue;
                            }
                            if (param.getSelfID().compareToIgnoreCase(OUICA_LOGDIR) == 0 && param.isSettable()) {
                                this.printDebugMessages("log dir = " + ouicacmd[2]);
                                param.setSimplestAsString(ouicacmd[2]);
                                continue;
                            }
                            if (param.getSelfID().compareToIgnoreCase(OUICA_CLASSPATH) != 0 || !param.isSettable()) continue;
                            String ouicaShLoc = ouicacmd[0];
                            String prodHomeValue = ouiloc = ouicaShLoc.substring(0, ouicaShLoc.indexOf(BIN));
                            String classpath = prodHomeValue + File.separator + JLIB + File.separator + ORAINSTALLER_JAR + File.pathSeparator + prodHomeValue + File.separator + JLIB + File.separator + OUICA_JAR + File.pathSeparator + prodHomeValue + File.separator + JLIB + File.separator + XMLPARSERV2_JAR + File.pathSeparator + prodHomeValue + File.separator + JLIB + File.separator + SRVM_JAR + File.pathSeparator;
                            this.printDebugMessages("classpath  = " + classpath);
                            param.setSimplestAsString(classpath);
                        }
                    }
                    IAction act = aggrRef.getAction(aRefs[iActionIdx]);
                    aggrRef.performAction(this.m_bBlocking, false, false, true, ActionType.getType((String)m_sOuiCaActionType));
                }
            }
        }
        catch (CfwException e) {
            throw new CfwException(e.getMessage());
        }
        this.printDebugMessages("launchOUICAAggregate end ");
    }

    public CfwSession getSession() {
        return this.session;
    }

    public boolean isRecommendedToolFailed() {
        return this.m_recommendedToolFailed;
    }

    public boolean isOptionalToolFailed() {
        return this.m_optionalToolFailed;
    }

    public boolean isRecommendedSkipped() {
        return this.m_recommendedToolSkipped;
    }

    public boolean isOptionalSkipped() {
        return this.m_optionalToolSkipped;
    }

    public void setOptionalToolsSkipped() {
        this.m_optionalToolSkipped = true;
    }

    public void setRecommendedToolsSkipped() {
        this.m_recommendedToolSkipped = true;
    }

    public String getFailedSkipppedToolInfo() {
        return this.m_sFailedSkippedToolsInfo;
    }

    private String formatNewlines(String s) {
        StringBuffer sBuff = new StringBuffer(s.length());
        try {
            int iStringLength = s.length();
            for (int i = 0; i < iStringLength; ++i) {
                char c = s.charAt(i);
                if (c != RETURN) {
                    if (c == ZERO) continue;
                    sBuff.append(c);
                    continue;
                }
                if (i + 1 < iStringLength && s.charAt(i + 1) == NEWLINE) continue;
                sBuff.append(NEWLINE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sBuff.toString();
    }

    private void printDebugStartMessages(String sConfigToolName) {
        if (OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY) {
            OiixDebug.printStartTimeMsg("Starting the execution of tool : " + sConfigToolName);
            OiixDebug.printMemory("Starting the execution of tool : " + sConfigToolName, System.currentTimeMillis());
        }
    }

    private void printDebugStopMessages(String sConfigToolName) {
        if (OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY) {
            OiixDebug.printEndTimeMsg();
            OiixDebug.printMemory("Completed the execution of tool : " + sConfigToolName, System.currentTimeMillis());
        }
    }

    private int getToolIndex(String sToolName, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx) {
        int toolIndex = -1;
        int iToolCount = this.m_graphicConfigPageHandler.getToolCount();
        if (iToolCount > 0) {
            for (int i = 0; i < iToolCount; ++i) {
                OiifbConfigToolInfo toolInfo = this.m_wizPanel.getToolInfo(i);
                if (!sToolName.equals(toolInfo.getToolName()) || !oraHomeName.equals(toolInfo.getOraHome()) || !compName.equals(toolInfo.getAggrName()) || !actionName.equals(toolInfo.getActionID()) || !stepIdx.equals(toolInfo.getStepIndex()) || !microStepIdx.equals(toolInfo.getMicroStepIndex())) continue;
                toolIndex = i;
                break;
            }
        }
        return toolIndex;
    }

    private void logToolResult(String sToolName, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, String sFailMsg) {
        int toolIndex = -1;
        int iToolCount = this.m_graphicConfigPageHandler.getToolCount();
        if (iToolCount > 0) {
            toolIndex = this.getToolIndex(sToolName, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx);
            OiifbConfigToolInfo toolInfo = this.m_wizPanel.getToolInfo(toolIndex);
            int nStatus = toolInfo.getToolStatus();
            String sMsg = null;
            switch (nStatus) {
                case 3: {
                    sMsg = OiixResourceBundle.getString("S_LOG_TOOL_SUCCEEDED");
                    break;
                }
                case 4: {
                    sMsg = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                    break;
                }
                case 5: {
                    sMsg = OiixResourceBundle.getString("S_LOG_TOOL_CANCELED");
                }
            }
            OiifpConfigTablePanel.DetailsTextArea detailsArea = this.m_wizPanel.getDetailsArea();
            if (sMsg != null) {
                sMsg = MessageFormat.format(sMsg, toolInfo.getToolName());
                try {
                    OiiolTextLogger.appendText(sMsg);
                    detailsArea.append("\n" + sMsg + "\n");
                    detailsArea.append("-----------------------------------------------------------------------------\n");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void printDebugMessages(String msg) {
        if (s_debug) {
            System.out.println("OiifbConfigController::" + msg);
        }
    }

    private void printDebugMessages(String msg, Exception e) {
        if (s_debug) {
            System.out.println("OiifbConfigController::" + msg);
            System.out.println("OiifbConfigController::" + OiixDebug.getThrowableBuf(e));
        }
    }

    class CFStreamThread
    implements Runnable {
        private boolean bStartListening = false;
        private boolean bStartOutput = false;

        CFStreamThread() {
        }

        public void startListening() {
            this.bStartListening = true;
        }

        public void stopListening() {
            this.bStartListening = false;
        }

        public void startOutput() {
            this.bStartOutput = true;
        }

        public void stopOutput() {
            this.bStartOutput = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.bStartListening) {
                    while (this.bStartOutput) {
                        Object object = OiifbConfigController.this.m_lock;
                        synchronized (object) {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            String toWrite = "";
                            int iStreamLength = OiifbConfigController.this.outStream.getLength();
                            char[] cStreamChars = OiifbConfigController.this.outStream.getChars(0, iStreamLength);
                            if (null != cStreamChars) {
                                toWrite = String.valueOf(cStreamChars);
                                toWrite = OiifbConfigController.this.formatNewlines(toWrite);
                                OiifbConfigController.this.currentLength = iStreamLength;
                                cStreamChars = null;
                            }
                            if (toWrite.length() > 0) {
                                OiiolTextLogger.appendText(toWrite, OiiolTextLogger.LOG_WITHOUT_LEVEL);
                                if (null != OiifbConfigController.this.m_wizPanel && null != OiifbConfigController.this.m_wizPanel.getDetailsArea()) {
                                    OiifbConfigController.this.m_wizPanel.getDetailsArea().append(toWrite);
                                }
                            }
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }

    class CFPrintStream
    extends OutputStream {
        private StringBuffer m_sbuf = new StringBuffer();
        private ByteArrayOutputStream m_oStream = new ByteArrayOutputStream();
        private int m_charCount = 0;

        public synchronized void write(int b) throws IOException {
            this.m_oStream.write(b);
            ++this.m_charCount;
        }

        public synchronized void write(String str) throws IOException {
            this.m_oStream.write(str.getBytes());
            this.m_charCount += str.length();
        }

        public synchronized int getLength() {
            return this.m_charCount;
        }

        public synchronized char[] getChars(int srcBegin, int srcEnd) {
            this.m_sbuf = new StringBuffer(this.m_oStream.toString());
            int stringBufLen = this.m_sbuf.length();
            if (srcEnd > stringBufLen) {
                srcEnd = stringBufLen;
            }
            int numChars = srcEnd - srcBegin + 1;
            char[] retChars = null;
            if (numChars > 0) {
                retChars = new char[numChars];
                this.m_sbuf.getChars(srcBegin, srcEnd, retChars, 0);
                this.m_oStream.reset();
                this.m_sbuf = null;
                this.m_charCount = 0;
            }
            return retChars;
        }

        public String getContents() {
            this.m_sbuf = new StringBuffer(this.m_oStream.toString());
            StringBuffer sBuff = new StringBuffer(this.m_sbuf.length());
            try {
                for (int i = 0; i < this.m_sbuf.length(); ++i) {
                    char c = this.m_sbuf.charAt(i);
                    if (c != '\r') {
                        sBuff.append(c);
                        continue;
                    }
                    if (i + 1 < this.m_sbuf.length() && this.m_sbuf.charAt(i + 1) == '\n') continue;
                    sBuff.append('\n');
                }
            }
            catch (Exception e) {
                return this.m_sbuf.toString();
            }
            return sBuff.toString();
        }
    }

    class MyProgress
    extends CfwProgressMonitor {
        OiifbConfigController controller;
        boolean isOUICA;
        boolean isSilent;

        public MyProgress(CfwSession session, IAggregateReference aggrRef, OiifbConfigController ctroller, boolean bOuiCA, boolean bSilent) throws CfwException {
            super(session);
            this.controller = null;
            this.isOUICA = false;
            this.isSilent = false;
            this.controller = ctroller;
            this.isSilent = bSilent;
            this.isOUICA = bOuiCA;
        }

        public void setOUICA(boolean bOuiCA) {
            this.isOUICA = bOuiCA;
        }

        public synchronized void plugInStart(IMicroStepStateReference microStepStateReference) throws CfwException {
            OiifbConfigController.this.printDebugMessages("MyProgress:  PluginStart Event Received from CFW");
            IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
            MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
            IPlugInInvocationState pState = state.getPlugInInvocationState();
            IActionStepState aState = state.getActionStepState();
            IActionState actState = state.getActionState();
            String oraHome = actState.getOriginator().getOracleHome();
            String topLevelName = OiifbConfigController.this.m_aggregate.getSelfID();
            String compName = actState.getOriginator().getSelfID();
            String actionName = microStepStateReference.getActionID();
            String stepIdx = Integer.toString(microStepStateReference.getStepIndex());
            String mstepIdx = Integer.toString(microStepStateReference.getMicroStepIndex());
            if (!this.isOUICA) {
                this.controller.handlePlugInStart(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, OiifbConfigController.COMMAND + pState.getCommand() + " " + (s_logConfigArgs ? pState.getArg() : ""));
                OiifbConfigController.this.printDebugMessages("MyProgress:  oracle home = " + oraHome + " top level comp name = " + topLevelName + " comp name = " + compName + " actionName = " + actionName + " stepIdx = " + stepIdx + " mstepIdx = " + mstepIdx + " command = " + pState.getCommand() + " argument = " + pState.getArg());
            }
        }

        public synchronized void plugInEnd(IMicroStepStateReference microStepStateReference) throws CfwException {
            OiifbConfigController.this.printDebugMessages("MyProgress : Plugin End event received");
            IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
            MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
            IPlugInInvocationState pState = state.getPlugInInvocationState();
            IActionStepState aState = state.getActionStepState();
            IActionState actState = state.getActionState();
            String oraHome = actState.getOriginator().getOracleHome();
            String topLevelName = OiifbConfigController.this.m_aggregate.getSelfID();
            String compName = actState.getOriginator().getSelfID();
            String actionName = microStepStateReference.getActionID();
            String stepIdx = Integer.toString(microStepStateReference.getStepIndex());
            String mstepIdx = Integer.toString(microStepStateReference.getMicroStepIndex());
            OiifbConfigController.this.printDebugMessages("MyProgress:  oracle home = " + oraHome + " top level comp name = " + topLevelName + " comp name = " + compName + " actionName = " + actionName + " stepIdx = " + stepIdx + " mstepIdx = " + mstepIdx + " command = " + pState.getCommand() + " argument = " + pState.getArg());
            if (microStatus.equals((Object)MicroStepStatus.PERFORMED_SUCCESS)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = Performed_Success");
                if (!this.isOUICA) {
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 3, "", "");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            } else if (microStatus.equals((Object)MicroStepStatus.PERFORMED_FAILED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = PERFORMED_FAILED");
                if (!this.isOUICA) {
                    String errMsg = "";
                    OiifbConfigController.this.m_recommendedToolFailed = true;
                    errMsg = OiifbConfigController.COMMAND + pState.getCommand() + " has failed \n";
                    try {
                        if (pState.getException().compareToIgnoreCase("") != 0) {
                            errMsg = errMsg + " Exception : " + pState.getException() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (pState.getStderr().compareToIgnoreCase("") != 0) {
                            errMsg = errMsg + " Execution Error : " + pState.getStderr() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 4, errMsg, "");
                    OiifbConfigController.this.m_sFailedSkippedToolsInfo = OiifbConfigController.this.m_sFailedSkippedToolsInfo + ("Plugin ID = " + pState.getPlugInID() + OiifbConfigController.COMMAND + pState.getCommand() + (s_logConfigArgs ? " Arguments = " + pState.getArg() : "") + " Error message : " + errMsg + "\n");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            } else if (microStatus.equals((Object)MicroStepStatus.NOT_PERFORMED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = NOT_PERFORMED");
                if (!this.isOUICA) {
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 6, "Execution of the plugin has not been performed", "");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            } else if (microStatus.equals((Object)MicroStepStatus.WAS_ABORTED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = WAS_ABORTED");
                if (!this.isOUICA) {
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 5, "Execution of the plugin was aborted", "");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            } else if (microStatus.equals((Object)MicroStepStatus.FAILED_NOTREQUIRED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = FAILED_NOTREQUIRED");
                if (!this.isOUICA) {
                    String errFMsg = "";
                    OiifbConfigController.this.m_optionalToolFailed = true;
                    errFMsg = OiifbConfigController.COMMAND + pState.getCommand() + " has failed  \n";
                    try {
                        if (pState.getException().compareToIgnoreCase("") != 0) {
                            errFMsg = errFMsg + " Exception : " + pState.getException() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (pState.getStderr().compareToIgnoreCase("") != 0) {
                            errFMsg = errFMsg + " Execution Error : " + pState.getStderr() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 4, errFMsg, "");
                    OiifbConfigController.this.m_sFailedSkippedToolsInfo = OiifbConfigController.this.m_sFailedSkippedToolsInfo + ("Plugin ID = " + pState.getPlugInID() + OiifbConfigController.COMMAND + pState.getCommand() + (s_logConfigArgs ? " Arguments = " + pState.getArg() : "") + " Error message : " + errFMsg + "\n");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            } else {
                OiifbConfigController.this.printDebugMessages("MyProgress: Status = Some other Event");
                if (!this.isOUICA) {
                    String errMsg = "";
                    if (aState.isRequired()) {
                        OiifbConfigController.this.m_recommendedToolFailed = true;
                    } else {
                        OiifbConfigController.this.m_optionalToolFailed = true;
                    }
                    errMsg = OiifbConfigController.COMMAND + pState.getCommand() + " has failed \n";
                    try {
                        if (pState.getException().compareToIgnoreCase("") != 0) {
                            errMsg = errMsg + " Exception : " + pState.getException() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (pState.getStderr().compareToIgnoreCase("") != 0) {
                            errMsg = errMsg + " Execution Error : " + pState.getStderr() + "\n";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.controller.handlePlugInEnd(state.getPlugInID(), oraHome, topLevelName, compName, actionName, stepIdx, mstepIdx, 4, errMsg, "");
                } else {
                    OiifbConfigController.this.bOUICARunning = false;
                }
            }
        }

        public synchronized void actionStart(IActionStateReference actionReference, IActionStepStateReference[] items) throws CfwException {
            OiifbConfigController.this.printDebugMessages("MyProgress: Action start event received");
            if (!this.isOUICA) {
                if (null != OiifbConfigController.this.m_aggregate && OiifbConfigController.this.m_aggregate.getSelfID().compareToIgnoreCase(actionReference.getOwnerID()) == 0) {
                    this.controller.actionStart(actionReference, items);
                }
            } else {
                this.controller.OuiCAactionStart(actionReference, items);
            }
        }

        public synchronized void actionEnd(IActionStateReference actionID) throws CfwException {
            OiifbConfigController.this.printDebugMessages("MyProgress: Action end event received");
            IActionState aState = this.controller.getSession().getActionState(actionID);
            ActionStatus actStatus = (ActionStatus)aState.getStatus();
            if (actStatus.equals((Object)ActionStatus.PERFORMED_SUCCESS)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Action status = PERFORMED_SUCCESS");
                if (!this.isOUICA) {
                    if (null != OiifbConfigController.this.m_aggregate && OiifbConfigController.this.m_aggregate.getSelfID().compareToIgnoreCase(actionID.getOwnerID()) == 0) {
                        this.controller.actionEnd(actionID, 0);
                    }
                } else {
                    this.controller.OuiCAactionEnd(actionID, 0);
                }
            } else if (actStatus.equals((Object)ActionStatus.PERFORMED_FAILED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Action status = PERFORMED_FAILED");
                if (!this.isOUICA) {
                    if (null != OiifbConfigController.this.m_aggregate && OiifbConfigController.this.m_aggregate.getSelfID().compareToIgnoreCase(actionID.getOwnerID()) == 0) {
                        this.controller.actionEnd(actionID, 1);
                    }
                } else {
                    this.controller.OuiCAactionEnd(actionID, 1);
                }
            } else if (actStatus.equals((Object)ActionStatus.WAS_ABORTED) || actStatus.equals((Object)ActionStatus.NOT_PERFORMED)) {
                OiifbConfigController.this.printDebugMessages("MyProgress: Action status = WAS_ABORTED  or  NOT_PERFORMED ");
                if (!this.isOUICA) {
                    if (null != OiifbConfigController.this.m_aggregate && OiifbConfigController.this.m_aggregate.getSelfID().compareToIgnoreCase(actionID.getOwnerID()) == 0) {
                        if (CFGDEBUG) {
                            // empty if block
                        }
                        this.controller.actionEnd(actionID, 3);
                    }
                } else {
                    this.controller.OuiCAactionEnd(actionID, 3);
                }
            } else {
                OiifbConfigController.this.printDebugMessages("MyProgress: Action status = any other events");
                if (!this.isOUICA) {
                    if (null != OiifbConfigController.this.m_aggregate && OiifbConfigController.this.m_aggregate.getSelfID().compareToIgnoreCase(actionID.getOwnerID()) == 0) {
                        this.controller.actionEnd(actionID, 1);
                    }
                } else {
                    this.controller.OuiCAactionEnd(actionID, 1);
                }
            }
        }
    }
}

