/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLConfigLog;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisConfigArgElem;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRunnableCmd;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixThreadLaunchException;
import oracle.sysman.oii.oiix.OiixThreadLauncher;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;

public class OiifbConfigLauncher
implements OiixWorkNotifiable {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16;
    public static final int reqAL = 1;
    public static final int optAL = 2;
    public static final int optNonAL = 3;
    public static final int FAILED = 1;
    public static final int SUCCEEDED = 0;
    public static final int CANCELED = -1;
    private OiixWorkNotifiable myClient = null;
    private OiicInstPostActionsPhase m_phase;
    private String m_toolName = null;
    private OiisPostInstallTool m_pTool;
    private OiixRunnableCmd m_runCmd = null;
    private int m_configToolResult = 1;
    private boolean m_bToolCanceled = false;
    private OutputStream m_configToolStream = null;
    private OiixThreadLauncher m_thrLauncher = null;
    private static String LOG_SEPARATOR = "------------------------------------------------";

    public OiifbConfigLauncher(OiicInstPostActionsPhase phase) {
        this.m_phase = phase;
        this.m_thrLauncher = new OiixThreadLauncher();
    }

    public int onSelectConfig(String elementSelected, int index, int toolType, OutputStream results) {
        block10: {
            this.m_configToolResult = 1;
            this.m_bToolCanceled = false;
            this.m_configToolStream = results;
            this.m_pTool = null;
            this.m_toolName = null;
            this.m_pTool = this.getConfigToolDetails(toolType, index).getPostInstallTool();
            this.m_toolName = this.getConfigToolDetails(toolType, index).getExternalName();
            int nToolLaunchType = this.getToolLaunchType(this.m_phase, this.m_pTool);
            String command = this.m_pTool.getCommand(nToolLaunchType);
            String[] args = this.m_pTool.getCommandLineArgs(nToolLaunchType);
            boolean bUseCommandArray = this.m_pTool.isUseCommmandArray();
            OutputStream errStream = this.m_configToolStream != null ? this.m_configToolStream : new OiixBufferOutputStream();
            OutputStream outStream = this.m_configToolStream != null ? this.m_configToolStream : new OiixBufferOutputStream();
            OutputStream configStream = OiiolTextLogger.getConfigLogStream();
            ArrayList<OutputStream> outStreams = new ArrayList<OutputStream>(2);
            outStreams.add(outStream);
            outStreams.add(configStream);
            ArrayList<OutputStream> errStreams = new ArrayList<OutputStream>(2);
            errStreams.add(errStream);
            errStreams.add(configStream);
            this.m_runCmd = new OiixRunnableCmd(command, args, outStreams, errStreams, bUseCommandArray);
            OiisCompContext oCompContext = this.m_pTool.getCompContext();
            OiicPullSession pullSession = oCompContext.getSession();
            OiicSessionPlan oSessionPlan = pullSession.getSessionPlan();
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)oSessionPlan.getAdditionInfo(oCompContext.getCompInstallID());
            if (icie != null) {
                String sCompLoc;
                OiiiCompInstallID oCompId = icie.getCompInstallID();
                int ohIndex = pullSession.getHomeIndex(oCompId);
                OiiiInstallAreaControl oInstAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                String sConfigLogLoc = oInstAreaControl.getXMLConfigLogLoc(ohIndex, sCompLoc = icie.getLocationInXMLInventory());
                OiiolXMLConfigLog oConfigLog = this.m_phase.getConfigLog(sConfigLogLoc);
                if (oConfigLog != null) {
                    oConfigLog.setCompID(oCompId);
                    oConfigLog.addConfigToolForLog(this.m_pTool);
                }
            }
            try {
                OiisConfigArgElem logLocArg;
                this.m_thrLauncher.setWorkNotifiable(this);
                String sMsg = OiixResourceBundle.getString("S_LOG_LAUNCHED_TOOL");
                sMsg = MessageFormat.format(sMsg, this.m_toolName);
                OiiolTextLogger.appendText(sMsg);
                this.m_phase.getSession();
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                }
                OiiolTextLogger.writeToConfigLog(OiiolTextLogger.NEW_LINE);
                OiiolTextLogger.writeToConfigLog(LOG_SEPARATOR);
                OiiolTextLogger.writeToConfigLog(sMsg);
                OiiolTextLogger.writeToConfigLog(LOG_SEPARATOR);
                OiiolTextLogger.writeToConfigLog(OiiolTextLogger.NEW_LINE);
                String sToolTypeStr = null;
                sToolTypeStr = toolType == 1 ? OiixResourceBundle.getString("S_TOOLTYPE_RECOMMENDED") : OiixResourceBundle.getString("S_TOOLTYPE_OPTIONAL");
                sMsg = OiixResourceBundle.getString("S_LOG_TOOL_TYPE", new Object[]{sToolTypeStr});
                OiiolTextLogger.appendText(sMsg);
                OiiolTextLogger.writeToConfigLog(sMsg);
                this.m_phase.getSession();
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                }
                String sCommandToLog = this.m_pTool.constructLogCommand(nToolLaunchType);
                sMsg = OiixResourceBundle.getString("S_LOG_COMMAND_SPAWNED");
                sMsg = MessageFormat.format(sMsg, sCommandToLog);
                OiiolTextLogger.appendText(sMsg);
                OiiolTextLogger.writeToConfigLog(sMsg);
                OiiolTextLogger.writeToConfigLog(OiiolTextLogger.NEW_LINE);
                this.m_phase.getSession();
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                }
                if ((logLocArg = this.m_pTool.getArgument("LogLocation")) != null) {
                    String logLoc = logLocArg.getValue();
                    sMsg = OiixResourceBundle.getString("S_LOG_DIR_POINTER");
                    sMsg = MessageFormat.format(sMsg, logLoc);
                    OiiolTextLogger.appendText(sMsg);
                    OiiolTextLogger.writeToConfigLog(sMsg);
                    OiiolTextLogger.writeToConfigLog(OiiolTextLogger.NEW_LINE);
                }
                this.m_thrLauncher.setWork(this.m_runCmd);
            }
            catch (OiixThreadLaunchException e) {
                if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                    OiiolTextLogger.appendErrorText(errStream.toString());
                    OiiolTextLogger.writeMessageToConsole(errStream.toString());
                } else {
                    OiiolTextLogger.appendText(errStream.toString());
                }
                OiiolTextLogger.writeToConfigLog(errStream.toString());
                this.m_configToolResult = 1;
                this.m_thrLauncher.clearClient();
                if (this.myClient == null) break block10;
                this.myClient.workCompleted(this);
            }
        }
        return 1;
    }

    private int getToolLaunchType(OiicInstPostActionsPhase phase, OiisPostInstallTool pTool) {
        int nToolLaunchType = 1;
        phase.getSession();
        if (OiicPullSession.isSilentMode()) {
            nToolLaunchType = 3;
        }
        if (phase.getSession().isCloneMode()) {
            if (pTool.isClone()) {
                nToolLaunchType = 5;
            } else {
                phase.getSession();
                nToolLaunchType = OiicPullSession.isSilentMode() ? 3 : 1;
            }
        }
        return nToolLaunchType;
    }

    public int getResultFromLastTool() {
        return this.m_configToolResult;
    }

    public void setWorkNotifiable(OiixWorkNotifiable c) throws Exception {
        if (this.myClient != null) {
            throw new Exception("Too many listeners");
        }
        this.myClient = c;
    }

    public void clearClient() {
        this.myClient = null;
        this.m_runCmd = null;
    }

    public void stopRunningTool() {
        this.m_bToolCanceled = true;
        if (this.m_runCmd != null) {
            this.m_runCmd.stopRunningProcess();
        }
    }

    private boolean isValidExitCode(int code) {
        return code == -1 || code == 1 || code == 0;
    }

    public void workStarted(Object o) {
        if (this.myClient != null) {
            this.myClient.workStarted(this);
        }
    }

    public void workCompleted(Object o) {
        block32: {
            Object[] tarr = new String[]{this.m_toolName};
            try {
                String lTxt;
                if (this.m_runCmd.isExceptionThrown()) {
                    throw this.m_runCmd.getException();
                }
                this.m_configToolResult = !this.m_bToolCanceled ? this.m_runCmd.getResultCode() : -1;
                if (!this.isValidExitCode(this.m_configToolResult)) {
                    this.m_configToolResult = 1;
                    String sMsg = OiixResourceBundle.getString("S_LOG_INVALID_EXIT_CODE") + this.m_configToolResult;
                    if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                        OiiolTextLogger.appendErrorText(sMsg);
                        OiiolTextLogger.writeMessageToConsole(sMsg);
                    } else {
                        OiiolTextLogger.appendText(sMsg);
                    }
                    OiiolTextLogger.writeToConfigLog(sMsg);
                }
                if (this.m_configToolResult == 1) {
                    lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                    lTxt = MessageFormat.format(lTxt, tarr);
                    if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                        OiiolTextLogger.appendErrorText(lTxt);
                        OiiolTextLogger.writeMessageToConsole(lTxt);
                    } else {
                        OiiolTextLogger.appendText(lTxt);
                    }
                    OiiolTextLogger.writeToConfigLog(lTxt);
                    if (this.m_configToolStream != null && this.m_configToolStream instanceof OiixBufferOutputStream) {
                        OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                        if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                            OiiolTextLogger.appendErrorText(err.getContents());
                            OiiolTextLogger.writeMessageToConsole(err.getContents());
                        } else {
                            OiiolTextLogger.appendText(err.getContents());
                        }
                    }
                }
                if (this.m_configToolResult == -1) {
                    lTxt = OiixResourceBundle.getString("S_LOG_TOOL_CANCELED");
                    lTxt = MessageFormat.format(lTxt, tarr);
                    if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                        OiiolTextLogger.appendErrorText(lTxt);
                        OiiolTextLogger.writeMessageToConsole(lTxt);
                    } else {
                        OiiolTextLogger.appendText(lTxt);
                    }
                    OiiolTextLogger.writeToConfigLog(lTxt);
                }
                if (this.m_configToolResult == 0) {
                    OiisCompContext oCompContext = this.m_pTool.getCompContext();
                    OiicPullSession pullSession = oCompContext.getSession();
                    OiicSessionPlan oSessionPlan = pullSession.getSessionPlan();
                    String lTxt2 = OiixResourceBundle.getString("S_LOG_TOOL_SUCCEEDED");
                    lTxt2 = MessageFormat.format(lTxt2, tarr);
                    OiiolTextLogger.appendText(lTxt2);
                    OiiolTextLogger.writeToConfigLog(lTxt2);
                    if (pullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                        OiiolTextLogger.writeMessageToConsole(lTxt2);
                    }
                    if (this.m_pTool.isRequired()) {
                        oSessionPlan.setAdditionPhase(oCompContext.getCompInstallID(), 50);
                    }
                    if (this.m_pTool.needDeinstallLog()) {
                        this.m_pTool.setDeinstall(true);
                    }
                }
            }
            catch (OiixSpawnException spx) {
                this.m_configToolResult = 1;
                String lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                lTxt = MessageFormat.format(lTxt, tarr);
                if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                    OiiolTextLogger.appendErrorText(lTxt);
                    OiiolTextLogger.writeMessageToConsole(lTxt);
                } else {
                    OiiolTextLogger.appendText(lTxt);
                }
                OiiolTextLogger.writeToConfigLog(lTxt);
                if (this.m_configToolStream != null && this.m_configToolStream instanceof OiixBufferOutputStream) {
                    OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                    if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                        OiiolTextLogger.appendErrorText(err.getContents());
                        OiiolTextLogger.writeMessageToConsole(err.getContents());
                    } else {
                        OiiolTextLogger.appendText(err.getContents());
                    }
                }
            }
            catch (Exception e) {
                this.m_configToolResult = 1;
                String lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                lTxt = MessageFormat.format(lTxt, tarr);
                if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                    OiiolTextLogger.appendErrorText(lTxt);
                    OiiolTextLogger.writeMessageToConsole(lTxt);
                } else {
                    OiiolTextLogger.appendText(lTxt);
                }
                OiiolTextLogger.writeToConfigLog(lTxt);
                if (this.m_configToolStream == null || !(this.m_configToolStream instanceof OiixBufferOutputStream)) break block32;
                OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                    OiiolTextLogger.appendErrorText(err.getContents());
                    OiiolTextLogger.writeMessageToConsole(err.getContents());
                }
                OiiolTextLogger.appendText(err.getContents());
            }
        }
        if (this.m_configToolStream != null) {
            try {
                this.m_configToolStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_thrLauncher.clearClient();
        if (this.myClient != null) {
            this.myClient.workCompleted(this);
        }
    }

    public OiixRunnableCmd getCurrentConfigToolCmd() {
        return this.m_runCmd;
    }

    public String getCurrentToolName() {
        return this.m_toolName;
    }

    public String getLogCommand(int nToolType, int nToolIndex) {
        OiisPostInstallTool pTool = this.getConfigToolDetails(nToolType, nToolIndex).getPostInstallTool();
        int nToolLaunchType = this.getToolLaunchType(this.m_phase, pTool);
        String sCommandLine = pTool.constructLogCommand(nToolLaunchType);
        return sCommandLine;
    }

    private OiisConfigToolDetails getConfigToolDetails(int toolType, int index) {
        OiisConfigToolDetails toolDetails = null;
        switch (toolType) {
            case 1: {
                toolDetails = this.m_phase.getReqConfigToolDetails(index);
                break;
            }
            case 2: {
                toolDetails = this.m_phase.getOptALConfigToolDetails(index);
                break;
            }
            case 3: {
                toolDetails = this.m_phase.getOptNonALConfigToolDetails(index);
            }
        }
        return toolDetails;
    }
}

