/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;

public class OiifbLinearIterator
implements OiifbWizIterator {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16;
    private static long s_lStartTime;
    protected List m_elems;
    protected int m_current;
    private boolean m_noBack;

    public OiifbLinearIterator() {
        this(false);
    }

    public OiifbLinearIterator(boolean noBack) {
        this.m_noBack = noBack;
        this.m_elems = new ArrayList();
    }

    public void setElements(Vector arr) {
        this.m_elems = new ArrayList(arr);
        this.m_current = 0;
    }

    public synchronized void dispose() {
        if (this.m_elems != null) {
            int numElems = this.m_elems.size();
            for (int i = 0; i < numElems; ++i) {
                OiifbWizOperation wop = (OiifbWizOperation)this.m_elems.get(i);
                wop.dispose();
            }
            this.m_elems.clear();
            this.m_elems = null;
        }
    }

    public synchronized void addElement(OiifbWizOperation wop) {
        this.m_elems.add(wop);
    }

    public int iterate(boolean isBack) throws OiifbEndIterateException {
        int btype;
        if (this.m_elems == null || this.m_elems.isEmpty()) {
            return isBack ? 1 : 0;
        }
        int size = this.m_elems.size();
        while (true) {
            long lCurTime;
            OiifbWizOperation elem = (OiifbWizOperation)this.m_elems.get(this.m_current);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifbLinearIterator:In iterate - loop.. : elem is " + elem.getClass(), OiiolTextLogger.LOG_DETAILED);
            }
            String sElemName = elem.toString();
            if (!isBack) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("OiifbLinearIterator:Calling initialize on:" + elem.getClass(), OiiolTextLogger.LOG_TRACE);
                }
                if (OiixDebug.PRINT_TIME) {
                    s_lStartTime = System.currentTimeMillis();
                }
                elem.initialize();
                if (OiixDebug.PRINT_TIME) {
                    lCurTime = System.currentTimeMillis();
                    OiixDebug.printTimeMsg(sElemName + ":initialize", lCurTime - s_lStartTime);
                    s_lStartTime = lCurTime;
                }
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("OiifbLinearIterator:Calling doOperation(" + isBack + ") on:" + elem.getClass(), OiiolTextLogger.LOG_TRACE);
            }
            if (OiixDebug.PRINT_TIME) {
                s_lStartTime = System.currentTimeMillis();
            }
            btype = elem.doOperation(isBack);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("OiifbLinearIterator:Result of doOperation(" + isBack + ") on:" + btype, OiiolTextLogger.LOG_TRACE);
            }
            if (btype == 0) {
                isBack = false;
                if (this.m_current + 1 >= size) {
                    if (!OiixDebug.PRINT_TIME) break;
                    lCurTime = System.currentTimeMillis();
                    OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime - s_lStartTime);
                    s_lStartTime = lCurTime;
                    break;
                }
                ++this.m_current;
            } else {
                isBack = true;
                if (this.m_current - 1 < 0) {
                    if (!OiixDebug.PRINT_TIME) break;
                    lCurTime = System.currentTimeMillis();
                    OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime - s_lStartTime);
                    s_lStartTime = lCurTime;
                    break;
                }
                --this.m_current;
            }
            if (!OiixDebug.PRINT_TIME) continue;
            lCurTime = System.currentTimeMillis();
            OiixDebug.printTimeMsg(sElemName + ":doOperation", lCurTime - s_lStartTime);
            s_lStartTime = lCurTime;
        }
        return btype;
    }
}

