/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Locale;

public class OiifbStackLayout
implements LayoutManager {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int orientation = 0;
    int margin = 2;
    Hashtable codeTable = new Hashtable();
    static final int CENTER = 0;
    static final int FRONT = 1;
    static final int BACK = 2;
    static final int FILL = 4;
    static final int ABS = 8;
    static final int FLUSH = 16;
    static final int POSMASK = 3;
    static final int SIZEMASK = 12;
    int[] defaultCode = new int[]{0, 0, 0, 0};

    public OiifbStackLayout() {
    }

    public OiifbStackLayout(int orientation) {
        this.orientation = orientation;
    }

    public OiifbStackLayout(int orientation, int margin) {
        this.orientation = orientation;
        this.margin = margin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addLayoutComponent(String tag, Component comp) {
        tag = tag.toUpperCase(Locale.ENGLISH).trim();
        int hcode = 0;
        int vcode = 0;
        int harg = 0;
        int varg = 0;
        int l = tag.length();
        int i = 0;
        while (i < l) {
            block33: {
                int n;
                if (tag.startsWith("CENTER", i)) {
                    i += 6;
                } else if (tag.startsWith("LEFT", i)) {
                    i += 4;
                    hcode |= 1;
                } else if (tag.startsWith("TOP", i)) {
                    i += 3;
                    vcode |= 1;
                } else if (tag.startsWith("RIGHT", i)) {
                    i += 5;
                    hcode |= 2;
                } else if (tag.startsWith("BOTTOM", i)) {
                    i += 6;
                    vcode |= 2;
                } else if (tag.startsWith("WIDE", i)) {
                    hcode |= 4;
                    if (tag.startsWith("*", i += 4)) {
                        n = this.countDigits(tag, ++i);
                        harg = this.parseArg(tag, i, n);
                        i += n;
                    } else {
                        harg = 1;
                    }
                } else if (tag.startsWith("TALL", i)) {
                    vcode |= 4;
                    if (tag.startsWith("*", i += 4)) {
                        n = this.countDigits(tag, ++i);
                        varg = this.parseArg(tag, i, n);
                        i += n;
                    } else {
                        varg = 1;
                    }
                } else if (tag.startsWith("FILL", i)) {
                    hcode |= 4;
                    vcode |= 4;
                    if (tag.startsWith("*", i += 4)) {
                        n = this.countDigits(tag, ++i);
                        harg = varg = this.parseArg(tag, i, n);
                        i += n;
                    } else {
                        varg = 1;
                        harg = 1;
                    }
                } else {
                    if (tag.startsWith("WIDTH", i)) {
                        hcode |= 8;
                        if (tag.startsWith("=", i += 5)) {
                            n = this.countDigits(tag, ++i);
                            harg = this.parseArg(tag, i, n);
                            i += n;
                            break block33;
                        } else {
                            harg = -1;
                            break;
                        }
                    }
                    if (tag.startsWith("HEIGHT", i)) {
                        vcode |= 8;
                        if (tag.startsWith("=", i += 6)) {
                            n = this.countDigits(tag, ++i);
                            varg = this.parseArg(tag, i, n);
                            i += n;
                            break block33;
                        } else {
                            varg = -1;
                            break;
                        }
                    }
                    if (tag.startsWith("FLUSH", i)) {
                        i += 5;
                        hcode |= 0x10;
                        vcode |= 0x10;
                    } else {
                        harg = -1;
                        break;
                    }
                }
            }
            while (i < l && Character.isWhitespace(tag.charAt(i))) {
                ++i;
            }
        }
        if (harg != -1 && varg != -1) {
            int[] codes = new int[]{hcode, vcode, harg, varg};
            this.codeTable.put(comp, codes);
            return;
        }
        System.out.println("OiifbStackLayout: can't understand \"" + tag + "\"");
    }

    int countDigits(String tag, int i) {
        int j;
        int l = tag.length();
        for (j = i; j < l && Character.isDigit(tag.charAt(j)); ++j) {
        }
        return j - i;
    }

    int parseArg(String tag, int i, int n) {
        int num = -1;
        try {
            num = Integer.parseInt(tag.substring(i, i + n));
        }
        catch (Exception e) {
            // empty catch block
        }
        return num;
    }

    public void removeLayoutComponent(Component comp) {
        this.codeTable.remove(comp);
    }

    int[] getCode(Component comp) {
        int[] code = (int[])this.codeTable.get(comp);
        return code == null ? this.defaultCode : code;
    }

    boolean stretches(Component comp) {
        int[] c = this.getCode(comp);
        return c[this.orientation] == 4;
    }

    Dimension computeLayoutSize(Container parent, boolean preferred) {
        Insets in = parent.getInsets();
        int inW = in.left + in.right;
        int inH = in.top + in.bottom;
        int n = parent.getComponentCount();
        if (this.orientation == 0) {
            int maxH = 0;
            int totW = 0;
            for (int i = 0; i < n; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                int code = this.getCode(comp)[this.orientation];
                int m = (code & 0x10) == 0 ? this.margin : 0;
                Dimension d = preferred && (code & 0xC) == 4 ? comp.getPreferredSize() : comp.getMinimumSize();
                maxH = Math.max(maxH, d.height + 2 * m);
                totW += d.width + 2 * m;
            }
            return new Dimension(totW + inW, maxH + inH);
        }
        int maxW = 0;
        int totH = 0;
        for (int i = 0; i < n; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            int code = this.getCode(comp)[this.orientation];
            int m = (code & 0x10) == 0 ? this.margin : 0;
            Dimension d = preferred && (code & 0xC) == 4 ? comp.getPreferredSize() : comp.getMinimumSize();
            maxW = Math.max(maxW, d.width + 2 * m);
            totH += d.height + 2 * m;
        }
        return new Dimension(maxW + inW, totH + inH);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, false);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, true);
    }

    public void layoutContainer(Container parent) {
        int l;
        int along = this.orientation;
        int across = (this.orientation + 1) % 2;
        int n = parent.getComponentCount();
        Insets in = parent.getInsets();
        Dimension sz = parent.getSize();
        int W = sz.width - in.left - in.right;
        int H = sz.height - in.top - in.bottom;
        int L = this.orientation == 0 ? W : H;
        int D = this.orientation == 0 ? H : W;
        int nFills = 0;
        int nRubber = 0;
        int sum = 0;
        int prev = 1;
        int[][] codes = new int[n][];
        int[][] sizes = new int[n][2];
        for (int i = 0; i < n; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            Dimension d = comp.getMinimumSize();
            int[] code = this.getCode(comp);
            int[] size = sizes[i];
            codes[i] = code;
            size[0] = d.width;
            size[1] = d.height;
            l = size[along];
            int c = code[along];
            switch (c & 0xC) {
                case 4: {
                    nFills += code[along + 2];
                    break;
                }
                case 8: {
                    sum += code[along + 2];
                    break;
                }
                default: {
                    sum += l;
                }
            }
            switch (c & 3) {
                case 0: {
                    ++nRubber;
                    break;
                }
                case 2: {
                    if (prev == 2) break;
                    ++nRubber;
                }
            }
            if ((c & 0x10) == 0) {
                sum += 2 * this.margin;
            }
            prev = c & 3;
        }
        if (prev == 0) {
            ++nRubber;
        }
        int rubber = nFills != 0 || nRubber == 0 ? 0 : Math.max(0, (L - sum) / nRubber);
        int fill = nFills == 0 ? 0 : Math.max(0, (L - sum) / nFills);
        int r = this.orientation == 0 ? in.left : in.top;
        int s0 = this.orientation == 0 ? in.top : in.left;
        prev = 1;
        for (int i = 0; i < n; ++i) {
            int[] code = codes[i];
            int[] size = sizes[i];
            if (code == null) continue;
            int c = code[along];
            int ca = code[across];
            int m = (c & 0x10) == 0 ? this.margin : 0;
            r += m;
            int s = s0 + m;
            l = size[along];
            int d = size[across];
            switch (c & 0xC) {
                case 4: {
                    if (fill <= 0) break;
                    l = fill * code[along + 2];
                    break;
                }
                case 8: {
                    l = code[along + 2];
                }
            }
            switch (c & 3) {
                case 0: {
                    r += rubber;
                    break;
                }
                case 2: {
                    if (prev == 2) break;
                    r += rubber;
                }
            }
            prev = c & 3;
            switch (ca & 0xC) {
                case 4: {
                    d = D - 2 * m;
                    break;
                }
                case 8: {
                    d = code[across + 2];
                }
            }
            switch (ca & 3) {
                case 2: {
                    s += D - d;
                    break;
                }
                case 0: {
                    s += (D - d) / 2;
                }
            }
            Component comp = parent.getComponent(i);
            if (this.orientation == 0) {
                comp.setBounds(r, s, l, d);
            } else {
                comp.setBounds(s, r, d, l);
            }
            r += l + m;
        }
    }
}

