/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifc;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.grid.hGrid.HDataObject;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.sysman.oii.oiif.oiifc.OiifcCTPaintContext;
import oracle.sysman.oii.oiif.oiifc.OiifcCTUtils;
import oracle.sysman.oii.oiif.oiifc.OiifcCompTreeObject;

public class OiifcHCellHandlerJoiner
extends ProxyInputHandler
implements Painter {
    private static final int HGAP = 2;
    protected static final boolean MAIN_PAINTER = true;
    protected static final boolean SECOND_PAINTER = false;
    protected Painter m_secondPainter;
    protected Painter m_mainPainter;
    protected CellInputHandler m_mainInput;
    protected Grid m_grid;

    public OiifcHCellHandlerJoiner(Painter mainPainter, CellInputHandler mainInputHandler, Painter secondPainter, CellInputHandler secondInputHandler) {
        super(secondInputHandler);
        this.m_mainPainter = mainPainter == null ? NullPainter.getPainter() : mainPainter;
        this.m_mainInput = mainInputHandler == null ? NullInputHandler.getCellInputHandler() : mainInputHandler;
        this.m_secondPainter = secondPainter == null ? NullPainter.getPainter() : secondPainter;
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        boolean processed = false;
        if (this.displayEnabled(grid, column, row, true) && !e.isConsumed()) {
            processed = this.processMousePressed(e, grid, column, row);
        }
        if (!e.isConsumed() && !processed) {
            super.mousePressed(e, grid, column, row);
        }
    }

    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        if (this.displayEnabled(grid, column, row, true)) {
            this.m_mainInput.keyTyped(e, grid, column, row);
        }
        if (!e.isConsumed()) {
            super.keyTyped(e, grid, column, row);
        }
    }

    public Rectangle getEditControlBounds(Grid grid, int column, int row) {
        Rectangle bounds = super.getEditControlBounds(grid, column, row);
        if (bounds == null) {
            int rowHeight = grid.getRowHeight(row);
            int columnWidth = grid.getColumnWidth(column);
            bounds = new Rectangle(0, 0, columnWidth, rowHeight);
        }
        OiifcPaintBounds pData = this.getPaintBounds(grid, column, row);
        int altWidth = grid.getColumnWidth(column) - pData.x;
        bounds.x = pData.x;
        bounds.width = Math.min(pData.width, altWidth);
        return bounds;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        if (data instanceof HDataObject) {
            data = ((HDataObject)data).getData();
        }
        super.startEdit(grid, column, row, data);
    }

    protected void translateMouseEvent(MouseEvent e, Grid grid, int column, int row, boolean toWrapped) {
        OiifcPaintBounds pData = this.getPaintBounds(grid, column, row);
        int indent = pData.x;
        if (toWrapped) {
            indent = -indent;
        }
        e.translatePoint(indent, 0);
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Dimension size = this.getPreferredSize(context);
        if (size.width > availableWidth) {
            size.width = availableWidth;
        }
        if (size.height > availableHeight) {
            size.height = availableHeight;
        }
        return size;
    }

    public Dimension getPreferredSize(PaintContext context) {
        Dimension mainSize = this.m_mainPainter.getPreferredSize(context);
        Dimension secondSize = this.m_secondPainter.getPreferredSize(context);
        return new Dimension(mainSize.width + secondSize.width + 2, Math.max(mainSize.height, secondSize.height));
    }

    public Dimension getMinimumSize(PaintContext context) {
        Dimension p1 = this.m_secondPainter.getMinimumSize(context);
        Dimension p2 = this.m_mainPainter.getMinimumSize(context);
        return new Dimension(p1.width + p2.width + 2, Math.max(p1.height, p2.height));
    }

    public Dimension getMaximumSize(PaintContext context) {
        Dimension p1 = this.m_secondPainter.getMaximumSize(context);
        Dimension p2 = this.m_mainPainter.getMaximumSize(context);
        return new Dimension(p1.width + p2.width + 2, Math.max(p1.height, p2.height));
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        OiifcCTPaintContext mainContext = new OiifcCTPaintContext(context);
        mainContext.setDisabled(!this.displayEnabled(context, true));
        Dimension mainSize = this.m_mainPainter.getPreferredSize(context);
        int mainX = x;
        int mainY = y + (height - mainSize.height) / 2;
        this.m_mainPainter.paint((PaintContext)mainContext, g, mainX, mainY, mainSize.width, mainSize.height);
        OiifcCTPaintContext secondContext = new OiifcCTPaintContext(context);
        secondContext.setDisabled(!this.displayEnabled(context, false));
        Dimension secondSize = this.m_secondPainter.getPreferredSize(context);
        int secondX = x + mainSize.width + 2;
        int secondY = y + (height - secondSize.height) / 2;
        int secondWidth = width - mainSize.width - 2;
        this.m_secondPainter.paint((PaintContext)secondContext, g, secondX, secondY, secondWidth, secondSize.height);
        OiifcPaintBounds pData = this.getPaintBounds(context);
        pData.x = mainSize.width + 2;
        pData.width = x + Math.min(secondSize.width + 8, secondWidth);
    }

    public boolean contains(PaintContext context, int availableWidth, int availableHeight, int x, int y) {
        return this.getPainterAt(context, availableWidth, availableHeight, x, y, null) != null;
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        if (x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            return this;
        }
        return null;
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        return this.m_secondPainter.getRepaintFlags(context);
    }

    public int getInvalidateFlags(PaintContext context) {
        return this.m_secondPainter.getInvalidateFlags(context);
    }

    protected boolean processMousePressed(MouseEvent e, Grid grid, int visibleCol, int visibleRow) {
        Object data = OiifcCTUtils.getDataFromHGrid(grid, visibleCol, visibleRow);
        if (data != null) {
            int rowHeight = grid.getRowHeight(visibleRow);
            int columnWidth = grid.getColumnWidth(visibleCol);
            OiifcPaintBounds pData = this.getPaintBounds(grid, visibleCol, visibleRow);
            if (e.getX() <= pData.x) {
                this.m_mainInput.mousePressed(e, grid, visibleCol, visibleRow);
                return true;
            }
        }
        return false;
    }

    protected boolean displayEnabled(PaintContext context, boolean forMainP) {
        Object data = context.getPaintData(null);
        return this.displayEnabled(data, forMainP);
    }

    protected boolean displayEnabled(Grid grid, int column, int row, boolean forMainP) {
        OiifcCompTreeObject data = OiifcCTUtils.getCTObjectFromHGrid(grid, column, row);
        return this.displayEnabled(data, forMainP);
    }

    protected boolean displayEnabled(Object data, boolean forMainP) {
        if (data instanceof OiifcCompTreeObject) {
            return ((OiifcCompTreeObject)data).isEnabled();
        }
        return true;
    }

    protected OiifcPaintBounds getPaintBounds(PaintContext context) {
        Object data = context.getPaintData(null);
        return this.getPaintBounds(data);
    }

    protected OiifcPaintBounds getPaintBounds(Grid grid, int column, int row) {
        OiifcCompTreeObject data = OiifcCTUtils.getCTObjectFromHGrid(grid, column, row);
        return this.getPaintBounds(data);
    }

    protected OiifcPaintBounds getPaintBounds(Object data) {
        Vector v;
        if (data instanceof OiifcCompTreeObject && (v = ((OiifcCompTreeObject)data).getPaintDataVector()) != null) {
            OiifcPaintBounds pData;
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                pData = (OiifcPaintBounds)v.elementAt(i);
                if (pData.painter != this) continue;
                return pData;
            }
            pData = new OiifcPaintBounds(this, 0, 0);
            v.addElement(pData);
            return pData;
        }
        return null;
    }

    private class OiifcPaintBounds
    extends Rectangle {
        public Painter painter;

        public OiifcPaintBounds(Painter p, int xCoord, int paintWidth) {
            this.painter = p;
            this.x = xCoord;
            this.width = paintWidth;
        }
    }
}

