/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmImagePanel;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdCompInfoDlg
extends BufferedDialog
implements ActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int OK = 0;
    public static final int HELP = 2;
    private static final int INSETS = 10;
    private static final int BUTTON_IMAGE_GAP = 15;
    private static final int BUTTON_DESC_GAP = 15;
    private static final int BUTTON_BUTTON_GAP = 15;
    private LWButton m_ok;
    private LWButton m_help;
    private LWLabel m_name;
    private LWLabel m_version;
    private LWContainer centerPanel;
    private MultiLineLabel m_description;
    private OiifmImagePanel m_imagePanel;
    private OiiiAreaInventory m_inventory;

    public OiifdCompInfoDlg(Frame f, OiiiAreaInventory inventory) {
        super(f, OiixResourceBundle.getString("S_INFORMATION"), true);
        OiifmKeyActionConverter keyActionConverter = new OiifmKeyActionConverter();
        this.addKeyListener(keyActionConverter);
        keyActionConverter.setActionListener(this);
        this.m_inventory = inventory;
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        LWContainer mainPanel = new LWContainer();
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.centerPanel = new LWContainer();
        this.centerPanel.setLayout((LayoutManager)gridbag);
        mainPanel.add((Component)this.centerPanel, (Object)"Center");
        c.insets = new Insets(0, 0, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridwidth = -1;
        c.gridheight = -1;
        this.m_imagePanel = new OiifmImagePanel("2000");
        gridbag.setConstraints((Component)((Object)this.m_imagePanel), c);
        this.centerPanel.add((Component)((Object)this.m_imagePanel));
        c.insets.right = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        c.gridheight = 1;
        this.m_name = new LWLabel(OiixResourceBundle.getString("S_PROD_NAME_LABEL"));
        gridbag.setConstraints((Component)this.m_name, c);
        this.centerPanel.add((Component)this.m_name);
        this.m_version = new LWLabel(OiixResourceBundle.getString("S_VERSION_LABEL"));
        gridbag.setConstraints((Component)this.m_version, c);
        this.centerPanel.add((Component)this.m_version);
        c.fill = 2;
        c.gridheight = -1;
        this.m_description = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        gridbag.setConstraints((Component)this.m_description, c);
        this.centerPanel.add((Component)this.m_description);
        c.insets.top = 10;
        c.fill = 1;
        c.gridheight = 0;
        LWContainer buttonPanel = new LWContainer();
        buttonPanel.setLayout((LayoutManager)new GridLayout(1, 2, 15, 1));
        gridbag.setConstraints((Component)buttonPanel, c);
        this.centerPanel.add((Component)buttonPanel);
        this.m_help = new LWButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        buttonPanel.add((Component)this.m_help);
        this.m_help.addActionListener((ActionListener)this);
        this.m_ok = new LWButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        buttonPanel.add((Component)this.m_ok);
        this.m_ok.addActionListener((ActionListener)this);
        keyActionConverter.setHelpButton((PushButton)this.m_help);
        this.add((Component)mainPanel, "Center");
        this.addWindowListener(this);
        this.validate();
    }

    public OiifdCompInfoDlg(Frame f, OiiiAreaInventory inventory, OiiiCompIdOhPair comp) {
        this(f, inventory);
        this.setComponent(comp);
    }

    public OiifdCompInfoDlg(Frame f, OiiiAreaInventory inventory, OiiiCompInstallID comp, int ohIndex) {
        this(f, inventory);
        this.setComponent(comp, ohIndex);
    }

    public void setComponent(OiiiCompIdOhPair pair) {
        this.setComponent(pair.getCompID(), pair.getOHIndex());
    }

    public void setComponent(OiiiCompInstallID comp, int ohIndex) {
        OiiiCompInvEntry entry = this.m_inventory instanceof OiiiInstallInventory ? ((OiiiInstallInventory)this.m_inventory).getInstallCompInvEntry(comp, ohIndex) : ((OiiiStageInventory)this.m_inventory).getStageCompInvEntry(comp);
        String name = entry.getName();
        String version = entry.getVersion().toString();
        String description = entry.getDescription();
        this.m_name.setText(name);
        Object[] objs = new String[]{version};
        String msg = OiixResourceBundle.getString("S_VERSION_LABEL");
        this.m_version.setText(MessageFormat.format(msg, objs));
        this.m_description.setText(description);
        this.validate();
        this.repaint();
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this.m_ok.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return 0;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_ok) {
            this.setVisible(false);
        } else if (source == this.m_help) {
            OiixHelp.displayInstHelp("OiifdCompInfoDlg");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private void debug(String msg) {
    }
}

