/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiif.oiifp.OiifpInventoryTree;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdConfirmRemoveDlg
extends BufferedDialog
implements ActionListener,
WindowListener {
    public static final int REMOVE = 0;
    public static final int CANCEL = 1;
    public static final int HELP = 2;
    private OiifpInventoryTree m_rmTree;
    private int m_buttonPressed;
    private Dimension m_prefSize;
    private LWButton m_remove;
    private LWButton m_cancel;
    private LWButton m_help;
    private Vector m_rmComps;
    private List m_rmHomes;
    private OiiiAreaInventory m_inventory;
    private ScrollBox m_scrollbox;
    private Vector m_allComps;
    private Vector m_allOneoffs;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 300;
    private static final int INSETS = 10;
    private static final int LIST_ITEM_GAP = 10;
    private static final int BUTTON_BUTTON_GAP = 10;

    public OiifdConfirmRemoveDlg(Frame f, OiiiAreaInventory inventory) {
        super(f, OiixResourceBundle.getString("S_CONFIRMATION"), true);
        this.m_inventory = inventory;
        this.m_prefSize = new Dimension(350, 300);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        LWContainer centerPanel = new LWContainer();
        centerPanel.setLayout((LayoutManager)new BorderLayout(10, 10));
        centerPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.add((Component)centerPanel, "Center");
        String prompt = OiixResourceBundle.getString("S_CONF_REMOVE_PROMPT");
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        promptLabel.setPreferredAspectRatio(0.0f);
        promptLabel.setFont(new Font(OiixResourceBundle.getFont(), 0, 12));
        centerPanel.add((Component)promptLabel, (Object)"North");
        this.m_rmTree = new OiifpInventoryTree();
        this.m_scrollbox = new ScrollBox((Component)((Object)this.m_rmTree), 0, 0);
        centerPanel.add((Component)this.m_scrollbox, (Object)"Center");
        LWContainer buttonPanel = new LWContainer();
        buttonPanel.setLayout((LayoutManager)new GridLayout(1, 4, 10, 1));
        centerPanel.add((Component)buttonPanel, (Object)"South");
        this.m_help = new LWButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        buttonPanel.add((Component)this.m_help);
        this.m_help.addActionListener((ActionListener)this);
        this.m_help.setLeftmost(true);
        this.m_help.setRightmost(true);
        LWContainer dummy = new LWContainer();
        buttonPanel.add((Component)dummy);
        this.m_remove = new LWButton(OiixResourceBundle.getString("S_YES_BUTTON"));
        buttonPanel.add((Component)this.m_remove);
        this.m_remove.addActionListener((ActionListener)this);
        this.m_remove.setLeftmost(true);
        this.m_cancel = new LWButton(OiixResourceBundle.getString("S_NO_BUTTON"));
        buttonPanel.add((Component)this.m_cancel);
        this.m_cancel.addActionListener((ActionListener)this);
        this.m_cancel.setRightmost(true);
        OiifmKeyActionConverter keyActionConverter = new OiifmKeyActionConverter((PushButton)this.m_cancel, (PushButton)this.m_help, this);
        this.addKeyListener(keyActionConverter);
        OiifmMnemonicOps.processMnemonic((Container)centerPanel);
        this.addWindowListener(this);
        this.validate();
    }

    private void fillRemoveTree() {
        String iStr = OiixResourceBundle.getString("S_INDEP_PRODS_LABEL");
        OiifmTreeItem treeItem = new OiifmTreeItem(iStr, null, null);
        this.m_rmTree.getSimpleRoot().addItem((DTreeItem)treeItem);
        treeItem.setExpanded(true);
        Vector OHs = ((OiiiInstallInventory)this.m_inventory).getHomes();
        for (int i = 0; i < OHs.size(); ++i) {
            OiiiOracleHomeInfo currOH = (OiiiOracleHomeInfo)OHs.elementAt(i);
            OiifmTreeItem OHtreeItem = new OiifmTreeItem(currOH.getLocation(), null, currOH);
            this.m_rmTree.getSimpleRoot().addItem((DTreeItem)OHtreeItem);
            OHtreeItem.setExpanded(true);
        }
        this.m_allOneoffs = new Vector();
        Hashtable hOneoffs = new Hashtable();
        if (this.m_rmComps != null) {
            OiiiCompIdOhPair currIdOhPair;
            for (int j = 0; j < this.m_rmComps.size(); ++j) {
                currIdOhPair = (OiiiCompIdOhPair)this.m_rmComps.get(j);
                Vector refComps = OiiodDepEngineHelper.getRefsToDeinstall(this.m_inventory, currIdOhPair, this.m_rmComps, this.m_allOneoffs);
                for (int i = 0; i < refComps.size(); ++i) {
                    if (this.m_rmComps.contains(refComps.elementAt(i))) continue;
                    this.m_rmComps.add(refComps.elementAt(i));
                }
            }
            this.m_allComps = OiiodDepEngineHelper.getDependeesToDeinstall(this.m_inventory, this.m_rmComps, this.m_allOneoffs, hOneoffs);
            for (int i = 0; i < this.m_allComps.size(); ++i) {
                currIdOhPair = (OiiiCompIdOhPair)this.m_allComps.elementAt(i);
                OiiiCompInstallID currComp = currIdOhPair.getCompID();
                OiiiCompInvEntry entry = this.m_inventory instanceof OiiiInstallInventory ? ((OiiiInstallInventory)this.m_inventory).getInstallCompInvEntry(currComp, currIdOhPair.getOHIndex()) : ((OiiiStageInventory)this.m_inventory).getStageCompInvEntry(currComp);
                String compLabel = " " + entry.getFullDisplayName();
                OiifmTreeItem currItem = new OiifmTreeItem(compLabel, null, entry);
                this.getOHRoot(currIdOhPair).addItem((DTreeItem)currItem);
                currItem.setExpanded(true);
            }
            int iOneoffs = this.m_allOneoffs.size();
            for (int k = 0; k < iOneoffs; ++k) {
                OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)this.m_allOneoffs.get(k);
                String oneoffLabel = oPair.getOneoffID().getDisplayString();
                OiifmTreeItem currItem = new OiifmTreeItem(oneoffLabel, null, oPair);
                this.getOHRoot(oPair).addItem((DTreeItem)currItem);
                currItem.setExpanded(true);
            }
        }
        boolean bHomesNodeExists = false;
        if (this.m_rmHomes != null && !this.m_rmHomes.isEmpty()) {
            OiifmTreeItem homesNode = new OiifmTreeItem(OiixResourceBundle.getString("S_HOMES_TO_REMOVE_NODE"), null, null);
            homesNode.setExpanded(true);
            this.m_rmTree.getSimpleRoot().addItem((DTreeItem)homesNode);
            bHomesNodeExists = true;
            Iterator iter = this.m_rmHomes.iterator();
            while (iter.hasNext()) {
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)iter.next();
                String sHomeLabel = "{0} ({1})";
                sHomeLabel = MessageFormat.format(sHomeLabel, homeInfo.getLocation(), homeInfo.getName());
                OiifmTreeItem homeItem = new OiifmTreeItem(sHomeLabel, null, null);
                homesNode.addItem((DTreeItem)homeItem);
            }
        }
        this.m_rmTree.cleanupTree();
        DTreeSimpleRoot treeroot = this.m_rmTree.getSimpleRoot();
        int rootCount = treeroot.getItemCount();
        if (bHomesNodeExists) {
            --rootCount;
        }
        for (int i = 0; i < rootCount; ++i) {
            DTreeSimpleParent ohroot = (DTreeSimpleParent)treeroot.getItem(i);
            String ohrootLabel = ohroot.getLabel();
            int compCount = ohroot.getItemCount();
            if (compCount == 1) {
                ohrootLabel = ohrootLabel + OiixResourceBundle.getString("S_PRODUCT");
            } else {
                ohrootLabel = ohrootLabel + OiixResourceBundle.getString("S_PRODUCTS");
                Object[] arr = new String[]{"" + compCount};
                ohrootLabel = MessageFormat.format(ohrootLabel, arr);
            }
            ohroot.setLabel(ohrootLabel);
        }
    }

    private OiifmTreeItem getOHRoot(OiiiCompIdOhPair idOhPair) {
        int OHIndex = idOhPair.getOHIndex();
        return this.getOHRoot(OHIndex);
    }

    private OiifmTreeItem getOHRoot(OiiiOneoffIdOhPair idOhPair) {
        int OHIndex = idOhPair.getHomeIndex();
        return this.getOHRoot(OHIndex);
    }

    private OiifmTreeItem getOHRoot(int OHIndex) {
        DTreeSimpleRoot root = this.m_rmTree.getSimpleRoot();
        for (int i = 0; i < root.getItemCount(); ++i) {
            Object id;
            OiifmTreeItem currRoot = (OiifmTreeItem)root.getItem(i);
            if (!(currRoot.getID() == null ? OHIndex == 0 : (id = currRoot.getID()) instanceof OiiiOracleHomeInfo && ((OiiiOracleHomeInfo)id).getIndex() == OHIndex)) continue;
            return currRoot;
        }
        return null;
    }

    public void initialize(Vector rmComps, ArrayList rmHomes) {
        this.m_rmComps = rmComps;
        this.m_rmHomes = rmHomes;
        this.fillRemoveTree();
        try {
            this.m_scrollbox.setScrollPosition(0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshTree() {
        this.m_rmTree.removeAll();
        this.refreshTree();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_remove) {
            this.m_buttonPressed = 0;
            this.setVisible(false);
        } else if (source == this.m_cancel) {
            this.m_buttonPressed = 1;
            this.setVisible(false);
        } else if (source == this.m_help) {
            OiixHelp.displayInstHelp("OiifdConfirmRemoveDlg");
        }
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this.m_cancel.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        if (this.m_buttonPressed == 0) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_CONFIRM_DEINSTALL"), OiiolTextLogger.LOG_BASIC);
            this.m_rmTree.logTree(null, "", OiiolTextLogger.LOG_BASIC);
        } else {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_CANCEL_DEINSTALL"), OiiolTextLogger.LOG_BASIC);
        }
        return this.m_buttonPressed;
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public void dispose() {
        if (this.m_rmTree != null) {
            this.m_rmTree.dispose();
            this.m_rmTree = null;
        }
    }

    public Vector getCompsToDeinstall() {
        return this.m_allComps;
    }

    public List getHomesToRemove() {
        return this.m_rmHomes;
    }

    public Vector getOneoffsToDeinstall() {
        return this.m_allOneoffs;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.m_buttonPressed = 1;
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

