/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmDummyPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdDriverPanel
extends LWContainer
implements ActionListener {
    private static final int INSETS = 15;
    private static final int TEXT_BUTTON_GAP = 10;
    private LWTextField m_driverText;
    private boolean m_editable;
    private LWButton m_browse;

    public OiifdDriverPanel(boolean editable) {
        this.m_editable = editable;
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)new OiifmDummyPanel(15, 15)), "North");
        this.add((Component)((Object)new OiifmDummyPanel(15, 15)), "South");
        this.add((Component)((Object)new OiifmDummyPanel(15, 15)), "East");
        this.add((Component)((Object)new OiifmDummyPanel(15, 15)), "West");
        LWContainer centerPanel = new LWContainer();
        centerPanel.setLayout((LayoutManager)new BorderLayout());
        this.add((Component)centerPanel, "Center");
        String prompt = this.m_editable ? OiixResourceBundle.getString("S_DRIVER_PROMPT") : OiixResourceBundle.getString("S_DRIVER_PROMPT_STATIC");
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        promptLabel.setFont(new Font(OiixResourceBundle.getFont(), 0, 12));
        centerPanel.add((Component)promptLabel, (Object)"North");
        LWContainer ePanel = new LWContainer();
        ePanel.setLayout((LayoutManager)new BorderLayout(1, 10));
        centerPanel.add((Component)ePanel, (Object)"Center");
        if (this.m_editable) {
            this.m_driverText = new LWTextField();
            ePanel.add((Component)this.m_driverText, (Object)"North");
            LWContainer tmpPanel = new LWContainer();
            tmpPanel.setLayout((LayoutManager)new BorderLayout());
            LWContainer bPanel = new LWContainer();
            bPanel.setLayout((LayoutManager)new BorderLayout());
            this.m_browse = new LWButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
            this.m_browse.addActionListener((ActionListener)this);
            bPanel.add((Component)this.m_browse, (Object)"West");
            tmpPanel.add((Component)bPanel, (Object)"North");
            ePanel.add((Component)tmpPanel, (Object)"Center");
        } else {
            String driver = this.getCurrentDriver();
            LWLabel l1 = new LWLabel(driver);
            ePanel.add((Component)l1, (Object)"North");
        }
        this.validate();
    }

    private String getCurrentDriver() {
        return "Current Driver goes here";
    }

    public OiifdDriverPanel() {
        this(true);
    }

    public String getSelDriver() {
        if (this.m_editable) {
            return this.m_driverText.getText();
        }
        return "";
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_browse) {
            FileDialog fd = new FileDialog(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("S_DRIVER"), 0);
            fd.show();
            if (fd.getDirectory() != null && fd.getFile() != null) {
                this.m_driverText.setText(fd.getDirectory() + fd.getFile());
            }
        }
    }

    public void setDefaultFocus() {
        if (this.m_editable) {
            this.m_driverText.requestFocus();
        }
    }
}

