/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifd.OiifdGenericDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdExitRebootDlg
extends OiifdGenericDlg
implements ItemListener {
    public static final int S_YES = 0;
    public static final int S_NO = 1;
    public static final int S_LOCAL_ONLY_YES = 2;
    private int m_nSelection = 0;
    private boolean m_bClusterMode = false;
    private String m_sPromptMsg;
    private LWCheckbox m_radioBtnNo;
    private LWCheckbox m_radioBtnYes;
    private LWCheckbox m_radioBtnLocalOnlyYes;

    public OiifdExitRebootDlg(Frame f, String sMessage) {
        this(f, sMessage, false);
    }

    public OiifdExitRebootDlg(Frame f, String sMessage, boolean bClusterMode) {
        super(f, null, true, 3);
        this.unsetPrefSize();
        this.m_sPromptMsg = sMessage;
        this.m_bClusterMode = bClusterMode;
        super.setPanel(this.createMainPanel());
        this.setTitle(OiixResourceBundle.getString("S_EXIT_TITLE"));
        this.setHelpID("OiifdExitRebootDlg");
    }

    private LWContainer createMainPanel() {
        LWContainer panel = new LWContainer();
        panel.setLayout((LayoutManager)new BorderLayout(10, 10));
        MultiLineLabel label = new MultiLineLabel(this.m_sPromptMsg);
        label.setTextWrapper(WordWrapper.getTextWrapper());
        panel.add((Component)label, (Object)"North");
        panel.add((Component)this.createCenterPanel(), (Object)"Center");
        return panel;
    }

    private LWContainer createCenterPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new EqualColumnLayout(10, 0, 0));
        String sYes = null;
        String sNo = null;
        String sLocalYes = null;
        if (this.m_bClusterMode) {
            sYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_YES");
            sNo = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_NO");
            sLocalYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_LOCAL_YES");
        } else {
            sYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_YES");
            sNo = OiixResourceBundle.getString("S_REBOOT_MESSAGE_NO");
        }
        LWCheckboxGroup group = new LWCheckboxGroup();
        this.m_radioBtnYes = new LWCheckbox(sYes, true, group);
        panel.add((Component)this.m_radioBtnYes);
        this.m_radioBtnYes.addItemListener((ItemListener)this);
        if (this.m_bClusterMode) {
            this.m_radioBtnLocalOnlyYes = new LWCheckbox(sLocalYes, false, group);
            panel.add((Component)this.m_radioBtnLocalOnlyYes);
            this.m_radioBtnLocalOnlyYes.addItemListener((ItemListener)this);
        }
        this.m_radioBtnNo = new LWCheckbox(sNo, false, group);
        panel.add((Component)this.m_radioBtnNo);
        this.m_radioBtnNo.addItemListener((ItemListener)this);
        OiifmMnemonicOps.processMnemonic((Container)panel);
        return panel;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof LWCheckbox) {
            this.m_nSelection = source == this.m_radioBtnNo ? 1 : (source == this.m_radioBtnLocalOnlyYes ? 2 : 0);
        }
    }

    public boolean isRebootNowSelected() {
        return this.m_nSelection == 0;
    }

    public boolean isRebootLocalOnlyNowSelected() {
        return this.m_nSelection == 2;
    }
}

