/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdInvInfoPanel
extends EwtContainer {
    private static final int INSETS = 10;
    private static final int ITEM_GAP = 5;
    private String m_naStr;
    private LWLabel m_locLabel;
    private OiifmInfo m_info;

    public OiifdInvInfoPanel(OiifmInfo info) {
        this.setLayout(new BorderLayout());
        this.m_naStr = OiixResourceBundle.getString("S_NOT_AVAIL");
        this.m_info = info;
        String pinfolabel = OiixResourceBundle.getString("S_INV_PROD_INFO_LABEL");
        BorderPainter gbBorder = UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(0, 10, 10, 10), (String)pinfolabel);
        this.setBorderPainter(gbBorder);
        LWContainer piPanel = this.createProdInfoPanel();
        this.add((Component)piPanel, "Center");
    }

    private LWContainer createProdInfoPanel() {
        String locStr = OiixResourceBundle.getString("S_INV_LOCATION_LABEL");
        Font font = new Font(OiixResourceBundle.getFont(), 0, 11);
        Font font_bold = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 11);
        LWContainer framedPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        framedPanel.setLayout((LayoutManager)gridbag);
        LWLabel label = new LWLabel(locStr);
        label.setFont(font_bold);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 16;
        gridbag.setConstraints((Component)label, c);
        framedPanel.add((Component)label);
        this.m_locLabel = new LWLabel(this.m_naStr);
        this.m_locLabel.setFont(font);
        c.anchor = 18;
        gridbag.setConstraints((Component)this.m_locLabel, c);
        framedPanel.add((Component)this.m_locLabel);
        this.refreshLocation();
        return framedPanel;
    }

    public void refreshLocation() {
        this.repaint();
        this.validate();
        if (this.m_locLabel != null) {
            if (this.m_info.loc != null) {
                this.m_locLabel.setText(this.m_info.loc);
                this.m_locLabel.setToolTipValue(this.m_info.loc);
                return;
            }
            this.m_locLabel.setText(this.m_naStr);
            this.m_locLabel.setToolTipValue((String)null);
        }
    }

    public void setInfo(OiifmInfo info) {
        this.m_info = info != null ? info : new OiifmInfo();
        this.refreshLocation();
    }
}

