/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpContentsTabPanel;
import oracle.sysman.oii.oiif.oiifp.OiifpEnvironmentTabPanel;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdInventoryDialog
extends BufferedDialog
implements ActionListener,
TabPanelListener,
WindowListener {
    private static Toolkit s_toolkit = null;
    private TabPanel m_mainPage = null;
    private TabPanelPage m_tabInv = null;
    private TabPanelPage m_tabEnv = null;
    private LWButton m_btnHelp = null;
    private LWButton m_btnSaveAs = null;
    private LWButton m_btnClose = null;
    private static final int HEIGHT = 450;
    private static final int WIDTH = 450;
    private static final int INSETS = 10;
    private static final int BUTTON_H_GAP = 10;
    private static final int BUTTON_V_GAP = 10;
    private OiifpContentsTabPanel m_contentsTab = null;
    private OiifpEnvironmentTabPanel m_grid = null;
    private Frame m_parentFrame = null;

    public OiifdInventoryDialog(Frame parentFrame, boolean viewOnly, boolean bDeinstallSession, boolean bShowConfirmation, boolean bShowProgress) {
        super(parentFrame, OiixResourceBundle.getString("S_INVENTORY"), true);
        LWContainer btnPanel = this.createButtonPanel();
        this.m_contentsTab = new OiifpContentsTabPanel(parentFrame, this, viewOnly, bDeinstallSession, bShowConfirmation, bShowProgress);
        this.m_parentFrame = parentFrame;
        this.addWindowListener(this);
        EwtContainer dlg = new EwtContainer();
        dlg.setLayout((LayoutManager)new BorderLayout(10, 10));
        FixedBorderPainter tenPixelMargin = new FixedBorderPainter(10, 10, 10, 10);
        dlg.setBorderPainter((BorderPainter)tenPixelMargin);
        this.m_mainPage = new TabPanel();
        this.initTab();
        this.setLayout(new BorderLayout(10, 10));
        dlg.add((Component)this.m_mainPage, (Object)"Center");
        dlg.add((Component)btnPanel, (Object)"South");
        this.add((Component)dlg, "Center");
        OiifmMnemonicOps.processMnemonic(this.m_mainPage);
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int x = maxWidth / 2 - 225;
        int y = maxHeight / 2 - 225;
        this.setBounds(x, y, 450, 450);
        this.setBackground(new Color(204, 204, 204));
        s_toolkit = Toolkit.getDefaultToolkit();
    }

    public OiifdInventoryDialog(Frame parentFrame, boolean viewOnly) {
        this(parentFrame, viewOnly, false, true, true);
    }

    public void enableSave(boolean bEnable) {
        if (this.m_btnSaveAs != null) {
            this.m_btnSaveAs.setEnabled(bEnable);
        }
    }

    public static void main(String[] s) {
        final Frame f = new Frame("Dummy Frame");
        f.setSize(500, 500);
        LWButton instProds = new LWButton("Installed Products");
        f.add((Component)instProds);
        instProds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OiifdInventoryDialog inv = new OiifdInventoryDialog(f, true);
                inv.show();
            }
        });
        f.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.m_btnSaveAs) {
            OiifmCursorUtil.setCursor(3, (Component)((Object)this));
            FileDialog fd = new FileDialog(this.m_parentFrame, OiixResourceBundle.getString("S_SAVE_AS_TITLE"));
            fd.setDirectory(System.getProperty("user.home"));
            fd.setMode(1);
            fd.show();
            if (null != fd.getFile()) {
                String fileName = fd.getDirectory() + fd.getFile();
                boolean bWriteToFile = true;
                if (OiixPlatform.getCurrentPlatform() == 46) {
                    bWriteToFile = this.confirmFileOverWrite(fileName);
                }
                if (bWriteToFile) {
                    try {
                        FileOutputStream fos = new FileOutputStream(fileName);
                        PrintWriter writer = new PrintWriter(fos);
                        this.m_contentsTab.saveAs(writer);
                        if (this.m_grid != null) {
                            this.m_grid.saveAs(writer);
                        }
                        writer.flush();
                        writer.close();
                    }
                    catch (FileNotFoundException e) {
                        this.showFileSavingErrorAlert(fileName);
                    }
                    catch (IOException e) {
                        this.showFileSavingErrorAlert(fileName);
                    }
                }
            }
            OiifmCursorUtil.setCursor(0, (Component)((Object)this));
            this.m_btnSaveAs.requestFocus();
        } else if (evt.getSource() == this.m_btnHelp) {
            TabPanelPage page = this.m_mainPage.getSelectedPage();
            Component oSelectedTab = page.getContent();
            String v_sKey = oSelectedTab instanceof OiifpEnvironmentTabPanel ? "OiifdHomeSelector" : "OiifdInventoryDlg";
            OiixHelp.displayInstHelp(v_sKey);
        } else if (evt.getSource() == this.m_btnClose) {
            this.setVisible(false);
        }
    }

    private void showFileSavingErrorAlert(String fileName) {
        Object[] args = new String[]{fileName};
        String sMsg = OiixResourceBundle.getString("S_ERR_SAVE_FILE");
        sMsg = MessageFormat.format(sMsg, args);
        OiifmAlert.displayError(sMsg);
    }

    private boolean confirmFileOverWrite(String fileName) {
        boolean bWriteToFile = true;
        File invSaveFile = new File(fileName);
        if (invSaveFile.exists()) {
            String message = OiixResourceBundle.getString("S_WARNING_SAVE_FILE_EXISTS");
            int userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), message, 30, 3, 1, 10);
            bWriteToFile = userChoice == 1;
        }
        return bWriteToFile;
    }

    private void initTab() {
        this.m_tabInv = new TabPanelPage((Component)((Object)this.m_contentsTab), OiixResourceBundle.getString("S_CONTENTS_TAB_TITLE"));
        this.m_mainPage.addPage(this.m_tabInv);
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            OiiiInstallInventory inv = this.m_contentsTab.getInventory();
            this.m_grid = new OiifpEnvironmentTabPanel(inv);
            this.m_tabEnv = new TabPanelPage((Component)this.m_grid, OiixResourceBundle.getString("S_ENVIRONMENT_TAB_TITLE"));
            this.m_mainPage.addPage(this.m_tabEnv);
        }
        this.m_mainPage.setBackground(new Color(204, 204, 204));
        this.m_mainPage.addTabPanelListener((TabPanelListener)this);
    }

    private LWContainer createButtonPanel() {
        LWContainer buttonPanel = new LWContainer();
        GridLayout gLayout = new GridLayout(1, 4, 10, 10);
        buttonPanel.setLayout((LayoutManager)gLayout);
        this.m_btnHelp = new LWButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this.m_btnHelp.addActionListener((ActionListener)this);
        this.m_btnHelp.setLeftmost(true);
        this.m_btnHelp.setRightmost(true);
        buttonPanel.add((Component)this.m_btnHelp);
        PushButton dummyBtn = new PushButton();
        dummyBtn.setVisible(false);
        buttonPanel.add((Component)dummyBtn);
        this.m_btnSaveAs = new LWButton(OiixResourceBundle.getString("S_SAVE_AS_BUTTON"));
        this.m_btnSaveAs.addActionListener((ActionListener)this);
        this.m_btnSaveAs.setLeftmost(true);
        buttonPanel.add((Component)this.m_btnSaveAs);
        this.m_btnClose = new LWButton(OiixResourceBundle.getString("S_CLOSE_BUTTON"));
        this.m_btnClose.addActionListener((ActionListener)this);
        this.m_btnClose.setRightmost(true);
        buttonPanel.add((Component)this.m_btnClose);
        OiifmMnemonicOps.processMnemonic((Container)buttonPanel);
        return buttonPanel;
    }

    public void tabPanelSelectionChanged(TabPanelEvent event) {
        Component comp = event.getPage().getContent();
        if (comp instanceof OiifpEnvironmentTabPanel) {
            ((OiifpEnvironmentTabPanel)comp).refresh();
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent event) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void doModal(boolean p_bVisible) {
        this.m_contentsTab.prepareInvTree();
        OiifmKeyActionConverter keyActionConverter = new OiifmKeyActionConverter((PushButton)this.m_btnClose, (PushButton)this.m_btnHelp, this);
        keyActionConverter.setActionListener(this);
        this.setModal(p_bVisible);
        if (p_bVisible) {
            s_toolkit.beep();
        }
        this.setVisible(p_bVisible);
        this.m_contentsTab.disposeRemoveDlg();
    }

    public void setDelSession(OiicDeinstallSession delSession) {
        this.m_contentsTab.setDelSession(delSession);
    }

    public Vector getDeinstallComps() {
        return this.m_contentsTab.getDeinstallComps();
    }
}

