/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpWizLangsPanel;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdLangsDlg
extends BufferedDialog
implements ActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HELP = 2;
    private OiifpWizLangsPanel m_langPanel;
    private LWButton m_ok;
    private LWButton m_cancel;
    private LWButton m_help;
    private int m_buttonPressed;
    private Dimension m_prefSize;
    private Frame m_frame;
    private OiicInstallSession m_instSession;
    private static final int WIDTH = 380;
    private static final int HEIGHT = 400;
    private static final int INSETS = 10;
    private static final int BUTTON_BUTTON_GAP = 10;
    private static final int SOUTH_MARGIN = 20;

    public OiifdLangsDlg(Frame f, OiicInstallSession session) {
        super(f, OiixResourceBundle.getString("S_LANG_SEL"), true);
        this.m_frame = f;
        this.m_instSession = session;
        this.setLayout(new BorderLayout());
        this.m_prefSize = new Dimension(380, 400);
        this.setBackground(Color.lightGray);
        LWContainer centerPanel = new LWContainer();
        centerPanel.setLayout((LayoutManager)new BorderLayout());
        centerPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.add((Component)centerPanel, "Center");
        this.m_langPanel = new OiifpWizLangsPanel(this.m_instSession);
        centerPanel.add((Component)((Object)this.m_langPanel), (Object)"Center");
        LWContainer dummyPanel = new LWContainer();
        dummyPanel.setLayout((LayoutManager)new BorderLayout());
        dummyPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 20, 0));
        centerPanel.add((Component)dummyPanel, (Object)"South");
        LWContainer buttonPanel = new LWContainer();
        buttonPanel.setLayout((LayoutManager)new GridLayout(1, 4, 10, 1));
        dummyPanel.add((Component)buttonPanel, (Object)"South");
        this.m_help = new LWButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this.m_help.addActionListener((ActionListener)this);
        this.m_help.setRightmost(true);
        this.m_help.setLeftmost(true);
        buttonPanel.add((Component)this.m_help);
        LWContainer dummySpace = new LWContainer();
        buttonPanel.add((Component)dummySpace);
        this.m_ok = new LWButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        this.m_ok.setLeftmost(true);
        this.m_ok.addActionListener((ActionListener)this);
        buttonPanel.add((Component)this.m_ok);
        this.m_cancel = new LWButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.m_cancel.addActionListener((ActionListener)this);
        this.m_cancel.setRightmost(true);
        buttonPanel.add((Component)this.m_cancel);
        OiifmKeyActionConverter oka = new OiifmKeyActionConverter((PushButton)this.m_cancel, (PushButton)this.m_help, this);
        OiifmMnemonicOps.processMnemonic((Container)centerPanel);
        this.addWindowListener(this);
        this.addKeyListener(oka);
        this.validate();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_ok) {
            if (this.setLanguages()) {
                this.setVisible(false);
                this.m_buttonPressed = 0;
            }
        } else if (source == this.m_cancel) {
            this.setVisible(false);
            this.m_buttonPressed = 1;
        } else if (source == this.m_help) {
            OiixHelp.displayInstHelp("OiifpLangsSelWCDE");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.m_buttonPressed = 1;
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private boolean setLanguages() {
        Vector v = this.m_langPanel.getSelectedLangs();
        if (v.size() == 0) {
            String errString = OiixResourceBundle.getString("S_NUM_LANGS_ERR");
            OiifmAlert.displayError(errString);
            return false;
        }
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
        try {
            if (!OiicPullSession.isLangAddonMode() && v.indexOf(OiixLanguage.ENGLISH) == -1) {
                v.addElement(OiixLanguage.ENGLISH);
            }
            String[] strList = OiixLanguage.getStringArray(v);
            oLangs.setValue(strList);
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)this.m_frame);
        this.m_langPanel.init();
        this.m_langPanel.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this.m_buttonPressed;
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public Dimension getMaximumSize() {
        return this.m_prefSize;
    }

    public Dimension getMinimumSize() {
        return this.m_prefSize;
    }
}

