/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressUIListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdRemoveDlg
extends BufferedDialog
implements ActionListener,
KeyListener,
OiifrProgressActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int CANCEL = 1;
    private static final int INSETS = 5;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 200;
    private OiifrProgressPanel m_progress;
    private LWButton m_cancel;
    private OiifrProgressUIListener m_listener;
    private Dimension m_prefSize;

    public OiifdRemoveDlg(Frame f) {
        super(f, OiixResourceBundle.getString("S_REMOVE"), true);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(5, 5));
        this.m_listener = null;
        LWContainer mainPanel = new LWContainer();
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.add((Component)mainPanel, "Center");
        LWContainer contents = new LWContainer();
        contents.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_progress = new OiifrProgressPanel(1);
        contents.add((Component)((Object)this.m_progress), (Object)"Center");
        LWContainer cPanel = new LWContainer();
        cPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_cancel = new LWButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.m_cancel.addActionListener((ActionListener)this);
        this.m_cancel.setRightmost(true);
        this.m_cancel.setLeftmost(true);
        this.m_cancel.addKeyListener((KeyListener)this);
        this.m_cancel.setVisible(true);
        this.m_cancel.setEnabled(true);
        cPanel.add((Component)this.m_cancel, (Object)"West");
        contents.add((Component)cPanel, (Object)"South");
        mainPanel.add((Component)contents, (Object)"Center");
        this.m_prefSize = new Dimension(350, 200);
        OiifmMnemonicOps.processMnemonic((Container)mainPanel);
        this.addWindowListener(this);
        this.validate();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_cancel) {
            this.onCancel();
        }
    }

    private void onCancel() {
        if (this.m_listener != null) {
            this.m_listener.onCancel();
        }
        int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_CONFIRMATION"), OiixResourceBundle.getString("S_CONF_REMOVE_CANCEL_PROMPT"), 30, 3, 4, 10);
        switch (result) {
            case 1: {
                if (this.m_listener != null) {
                    this.m_listener.onCancelConfirm(true);
                }
                this.m_progress.onDoneProgress();
                this.setVisible(false);
                break;
            }
            case 2: {
                if (this.m_listener == null) break;
                this.m_listener.onResume();
            }
        }
    }

    public void onDoneProgress() {
        this.m_progress.onDoneProgress();
        this.setVisible(false);
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this.m_progress.startProgressPainter();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        this.m_cancel.requestFocus();
        return 0;
    }

    public boolean isNewProgressUsed() {
        return true;
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public void addProgressUIListener(OiifrProgressUIListener plistener) {
        this.m_listener = plistener;
    }

    public OiifrProgressActionListener getProgressActionListener() {
        return this;
    }

    public void onCurrentComponent(String Comp) {
        this.m_progress.onCurrentComponent(Comp);
    }

    public void addPercentage(int percent) {
        this.m_progress.addPercentage(percent);
    }

    public void addBytes(int bytes) {
        this.m_progress.addBytes(bytes);
    }

    public void onStartDeinstall() {
        this.m_progress.onStartDeinstall();
    }

    public void onDoneDeinstall() {
        this.m_progress.onDoneDeinstall();
    }

    public void onStartPhase(int phase) {
        this.m_progress.onStartPhase(phase);
    }

    public void onDonePhase(int phase) {
        this.m_progress.onDonePhase(phase);
    }

    public void onSuspend() {
        this.m_progress.onSuspend();
    }

    public void onResume() {
        this.m_progress.onResume();
    }

    public void setStatus(String status) {
        this.m_progress.setStatus(status);
    }

    public void setTotalBytes(long bytes) {
        this.m_progress.setTotalBytes(bytes);
    }

    public void removeBytes(int bytes) {
        this.m_progress.removeBytes(bytes);
    }

    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 10: {
                if (event.getSource() != this.m_cancel) break;
                event.consume();
                this.onCancel();
                break;
            }
            case 27: {
                event.consume();
                this.onCancel();
            }
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.onCancel();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

