/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicNotifChecker;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertyPage;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertySheet;
import oracle.sysman.oii.oiif.oiifd.OiifdScrollableTable;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiig.OiigNotifConfig;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdUpdatePg
extends OiifdPropertyPage
implements ItemListener,
ActionListener {
    private static final int THIS_SESSION = 0;
    private static final int ALL_COMPS = 1;
    protected short m_totalColumns = (short)4;
    private final int m_extMargin = 5;
    private static final short CHECK_COL = 0;
    private static final short PROD_COL = 1;
    private static final short VERSION_COL = 2;
    private static final short OBJ_COL = 3;
    private static final short CHECK_COL_WIDTH = 20;
    private static final short PROD_COL_WIDTH = 340;
    private static final short VERSION_COL_WIDTH = 70;
    private static final String INTERNAL = "internal";
    private LWCheckbox m_selProdsChk = null;
    private PushButton m_deleteBtn;
    private LWLabel m_emailLabel = null;
    private LWLabel m_hostLabel = null;
    private boolean m_bHasDeletion = false;
    private LWChoice m_viewChoice = null;
    private String m_emailId = null;
    private String m_hostName = null;
    private LWTextField m_emailTF = null;
    private LWTextField m_hostTF = null;
    private boolean m_bSpecify = false;
    private Hashtable[] m_perHomes = new Hashtable[2];
    private Hashtable[] m_perComps = new Hashtable[2];
    private OiifdScrollableTable m_prodsTable = null;
    private SortableTwoDDataSource m_prodsTableData = null;
    private OiicInstallSession m_insSession = null;
    private OiiiInstallInventory m_inventory = null;

    public OiifdUpdatePg(OiicInstallSession insSession) {
        super(OiixResourceBundle.getString("S_UPDATES_TITLE"));
        this.m_insSession = insSession;
        OiicNotifChecker notifChecker = this.m_insSession.getNotifChecker();
        OiigNotifConfig notifCfg = notifChecker.getNotifConfig();
        this.m_bSpecify = notifCfg.shouldRegisterForNotifs();
        this.m_emailId = notifCfg.getEmailId();
        this.m_hostName = notifCfg.getHostName();
        this.m_perHomes[0] = notifChecker.getPatchCheckComps();
        this.m_inventory = this.m_insSession.getInstallAreaControl().getInstallInventory();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_selProdsChk) {
            this.enableSpecify(this.m_selProdsChk.getState());
        } else if (source == this.m_viewChoice) {
            this.refreshList();
        }
    }

    protected short getColumnCount() {
        return this.m_totalColumns;
    }

    protected OiifdScrollableTable getMCW() {
        return this.m_prodsTable;
    }

    protected SortableTwoDDataSource getTableData() {
        return this.m_prodsTableData;
    }

    protected Grid getGrid() {
        return this.m_prodsTable.getTable().getGrid();
    }

    protected ArrayOneDDataSource getColumnHeaders() {
        return new ArrayOneDDataSource((Object[])new String[]{"", OiixResourceBundle.getString("S_REG_PRODUCT"), OiixResourceBundle.getString("S_REG_VERSION"), ""});
    }

    public void setSelectedRow(int row) {
        Grid grid = this.m_prodsTable.getTable().getGrid();
        if (grid.getRowCount() == 0) {
            return;
        }
        grid.getGridSelection().setRowSelected(row, true);
    }

    private void clearInputFields() {
        this.m_emailTF.setText("");
        this.m_hostTF.setText("");
    }

    private void refreshList() {
        int viewSel = this.m_viewChoice.getSelectedIndex();
        if (viewSel == 1 && this.m_perHomes[1] == null) {
            this.m_perHomes[1] = this.getInterestingInvComps(this.m_inventory);
        }
        this.populateIPList(viewSel);
    }

    private void enableSpecify(boolean bEnabled) {
        this.m_emailTF.setEnabled(bEnabled);
        this.m_hostTF.setEnabled(bEnabled);
        this.m_viewChoice.setEnabled(bEnabled);
        this.m_prodsTable.getGrid().setEnabled(bEnabled);
    }

    void addControls() {
        EwtContainer gbPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        EwtContainer prodsPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        this.m_selProdsChk = new LWCheckbox(OiixResourceBundle.getString("S_REG_SEL_PRODS"));
        this.m_selProdsChk.setState(this.m_bSpecify);
        LWLabel insProdsLabel = new LWLabel(OiixResourceBundle.getString("S_REG_INS_PRODS"));
        GroupBoxContainer gb = new GroupBoxContainer((Component)insProdsLabel, (Component)prodsPanel);
        this.m_emailLabel = new LWLabel(OiixResourceBundle.getString("S_REG_EMAIL"));
        this.m_hostLabel = new LWLabel(OiixResourceBundle.getString("S_REG_HOSTNAME"));
        LWLabel viewByLabel = new LWLabel(OiixResourceBundle.getString("S_REG_VIEWBY"));
        this.m_hostTF = new LWTextField(30);
        this.m_hostTF.setText(this.m_hostName);
        this.m_emailTF = new LWTextField(30);
        this.m_emailTF.setText(this.m_emailId);
        this.m_viewChoice = new LWChoice();
        this.m_viewChoice.addItem(OiixResourceBundle.getString("S_REG_CUR_INS"));
        this.m_viewChoice.addItem(OiixResourceBundle.getString("S_REG_ALL"));
        this.add((Component)this.m_selProdsChk, 0, 0, 2, 1, 2, 17, 0.0, 0.0, 10, 8, 0, 8, 0, 0);
        this.add((Component)this.m_emailLabel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 8, 0, 2, 0, 0);
        this.add((Component)this.m_emailTF, 1, 1, 0, 1, 2, 17, 1.0, 0.0, 5, 2, 0, 8, 0, 0);
        this.add((Component)this.m_hostLabel, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 5, 8, 5, 2, 0, 0);
        this.add((Component)this.m_hostTF, 1, 2, 1, 1, 2, 17, 1.0, 0.0, 5, 2, 0, 8, 0, 0);
        this.add((Component)gb, 0, 3, 2, 1, 1, 17, 1.0, 1.0, 15, 8, 8, 8, 0, 0);
        this.add(prodsPanel, (Component)viewByLabel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 5, 0, 5, 8, 0, 0);
        this.add(prodsPanel, (Component)this.m_viewChoice, 1, 0, 1, 1, 2, 13, 0.0, 0.0, 5, 0, 5, 8, 0, 0);
        this.add(prodsPanel, (Component)((Object)this.m_prodsTable), 0, 1, 3, 1, 1, 17, 1.0, 1.0, 5, 8, 8, 8, 0, 0);
        this.enableSpecify(this.m_bSpecify);
    }

    protected void initializePage() {
        this.initTableData();
    }

    protected void onCreatePage() {
        OiifdPropertySheet _ps = null;
        if (_ps == null) {
            Object c = this;
            while ((c = ((Component)c).getParent()) != null) {
                if (!(c instanceof OiifdPropertySheet)) continue;
                _ps = (OiifdPropertySheet)c;
            }
        }
        LWCheckboxGroup actionGroup = new LWCheckboxGroup();
        LWCheckboxGroup triggerGroup = new LWCheckboxGroup();
        LWCheckboxGroup typeGroup = new LWCheckboxGroup();
        ArrayOneDDataSource columnHeaders = this.getColumnHeaders();
        this.m_prodsTableData = new SortableTwoDDataSource((int)this.getColumnCount(), 0);
        this.m_prodsTable = new OiifdScrollableTable((TwoDDataSource)this.m_prodsTableData, (OneDDataSource)columnHeaders, null, this);
        Grid grid = this.m_prodsTable.getGrid();
        this.setupGrid(grid);
        this.populateIPList(0);
        this.add((Component)((Object)this.m_prodsTable), 0, 1, 4, 6, 1, 18, 1.0, 1.0, 2, 8, 8, 8, 0, 0);
        this.addControls();
        this.validate();
        this.addActionListeners();
        this.populateIPList(0);
    }

    protected void addComponents() {
    }

    private void addActionListeners() {
        this.m_selProdsChk.addItemListener((ItemListener)this);
        this.m_viewChoice.addItemListener((ItemListener)this);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean validateControls() {
        String msg = null;
        String email = this.m_emailTF.getText().trim();
        String host = this.m_hostTF.getText().trim();
        this.m_bSpecify = this.m_selProdsChk.getState();
        if (this.m_bSpecify) {
            if (email.equals("") || host.equals("")) {
                msg = OiixResourceBundle.getString("S_REG_ERROR");
            }
            if (msg != null) {
                OiifmAlert.displayAlert("Warning", msg, 50, 1, 1, 10);
                return false;
            }
        }
        this.notifyBkend(email, host);
        return true;
    }

    public void propagateChecks() {
        OiifdCompOHs compOH = null;
        OiiiInstallCompInvEntry icie = null;
        Vector insInvEntryV = new Vector();
        int len = this.m_prodsTableData.getRowCount();
        for (int i = 0; i < len; ++i) {
            boolean bChk = (Boolean)this.m_prodsTableData.getData(0, i);
            compOH = (OiifdCompOHs)this.m_prodsTableData.getData(3, i);
            Vector icies = compOH.getCompEntries();
            int numEntries = icies.size();
            for (int j = 0; j < numEntries; ++j) {
                icie = (OiiiInstallCompInvEntry)icies.elementAt(j);
                icie.setNotifRequested(bChk);
            }
        }
    }

    private void notifyBkend(String email, String host) {
        OiicNotifChecker notifChecker = null;
        notifChecker = this.m_insSession.getNotifChecker();
        OiigNotifConfig notifCfg = notifChecker.getNotifConfig();
        notifCfg.setEmailId(email);
        notifCfg.setHostName(host);
        notifCfg.setRegisterForNotifs(this.m_bSpecify);
        this.propagateChecks();
        int viewSel = this.m_viewChoice.getSelectedIndex();
        if (viewSel == 1) {
            notifChecker.setAllReqs(true);
            this.addReqCompsToNotifChecker(notifChecker, this.m_perHomes[1]);
        }
    }

    private void addReqCompsToNotifChecker(OiicNotifChecker notifChecker, Hashtable perHomeComps) {
        Enumeration ohIds = perHomeComps.keys();
        while (ohIds.hasMoreElements()) {
            Integer ohIdObj = (Integer)ohIds.nextElement();
            int ohId = ohIdObj;
            Vector comps = (Vector)perHomeComps.get(ohIdObj);
            notifChecker.addNotifReqComps(ohId, comps);
        }
    }

    protected void setupGrid(Grid grid) {
        ComplexAppearanceManager am = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)am);
        this.m_prodsTable.setColumnWidth(0, 20);
        this.m_prodsTable.setColumnWidth(1, 340);
        this.m_prodsTable.setColumnWidth(2, 70);
        this.m_prodsTable.setColumnWidth(3, 0);
        grid.setColumnVisible(3, false);
        grid.setColumnPainter(1, (Painter)new TruncatingTextPainter());
        grid.setColumnPainter(2, (Painter)new TruncatingTextPainter());
        grid.setToolTipValue(GridToolTipClient.getToolTipClient());
        grid.setColumnPainter(0, CheckPainter.getPainter());
        grid.setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        for (int i = 1; i < this.m_totalColumns; ++i) {
            Appearance colApp = am.getColumnAppearance(i);
            colApp.setHorizontalJustify(1);
            colApp.setVerticalJustify(1);
            am.setColumnAppearance(i, colApp);
        }
    }

    private void initTableData() {
        int len = 0;
        Vector svrConfigsV = new Vector();
        Grid grid = this.m_prodsTable.getGrid();
        grid.setPreferredRowsOnScreen(5);
        if (len > 0) {
            this.setSelectedRow(0);
        }
    }

    public void populateIPList(int viewSel) {
        int rowNum = this.m_prodsTableData.getRowCount();
        if (rowNum > 0) {
            this.m_prodsTableData.removeRows(0, rowNum);
        }
        if (this.m_perComps[viewSel] == null) {
            this.m_perComps[viewSel] = this.convertPerHomesToPerComps(this.m_perHomes[viewSel]);
        }
        int len = this.m_perComps[viewSel].size();
        this.m_prodsTableData.addRows(0, len);
        int i = 0;
        Enumeration compOHs = this.m_perComps[viewSel].elements();
        while (compOHs.hasMoreElements()) {
            OiifdCompOHs compOH = (OiifdCompOHs)compOHs.nextElement();
            this.setAllColsAtRow(i, compOH);
            ++i;
        }
    }

    private void setAllColsAtRow(int row, OiifdCompOHs compOH) {
        String compLabel = null;
        String compVer = null;
        OiiiInstallCompInvEntry icie = compOH.getCompInvEntry();
        compLabel = icie.getFullDisplayName();
        compVer = icie.getVersion().getVerString();
        this.m_prodsTableData.setData(1, row, (Object)compLabel);
        this.m_prodsTableData.setData(2, row, (Object)compVer);
        this.m_prodsTableData.setData(3, row, (Object)compOH);
        this.m_prodsTableData.setData(0, row, (Object)new Boolean(compOH.isChecked()));
    }

    private Hashtable getInterestingInvComps(OiiiInstallInventory instInv) {
        Hashtable ht = new Hashtable();
        Vector ohIds = this.getOracleHomeIds(instInv);
        int numOHs = ohIds.size();
        for (int i = 0; i < numOHs; ++i) {
            Vector<OiiiInstallCompInvEntry> icomps = new Vector<OiiiInstallCompInvEntry>();
            Integer ohIndObj = (Integer)ohIds.elementAt(i);
            int ohInd = ohIndObj;
            Vector allComps = instInv.getAllCompsVect(ohInd);
            int numComps = allComps.size();
            for (int j = 0; j < numComps; ++j) {
                String upLoc;
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)allComps.elementAt(j);
                if (icie.isDeleted() || (upLoc = icie.getUpdateSiteLoc()) == null || upLoc.length() <= 0) continue;
                icomps.addElement(icie);
            }
            ht.put(ohIndObj, icomps);
        }
        return ht;
    }

    private Vector getOracleHomeIds(OiiiInstallInventory instInv) {
        Vector<Integer> ohIds = new Vector<Integer>();
        ohIds.addElement(new Integer(0));
        Vector ohs = instInv.getHomes();
        int numOHs = ohs.size();
        for (int i = 0; i < numOHs; ++i) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)ohs.elementAt(i);
            ohIds.addElement(new Integer(ohi.getIndex()));
        }
        return ohIds;
    }

    private Hashtable convertPerHomesToPerComps(Hashtable perHomeComps) {
        Hashtable<String, OiifdCompOHs> perComps = new Hashtable<String, OiifdCompOHs>();
        Enumeration ohIds = perHomeComps.keys();
        while (ohIds.hasMoreElements()) {
            Integer ohIndObj = (Integer)ohIds.nextElement();
            int ohInd = ohIndObj;
            Vector ohComps = (Vector)perHomeComps.get(ohIndObj);
            int numohComps = ohComps.size();
            for (int i = 0; i < numohComps; ++i) {
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)ohComps.elementAt(i);
                if (icie.isDeleted()) continue;
                OiiiCompInstallID cid = icie.getCompInstallID();
                String hash = cid.getName() + "&" + cid.getVersion().toString();
                OiifdCompOHs compOH = (OiifdCompOHs)perComps.get(hash);
                if (compOH == null) {
                    compOH = new OiifdCompOHs(icie);
                    perComps.put(hash, compOH);
                }
                compOH.addOHInd(ohInd, icie);
                if (!icie.isNotifRequested()) continue;
                compOH.setChecked(true);
            }
        }
        return perComps;
    }

    private class OiifdCompOHs {
        private OiiiInstallCompInvEntry m_icie = null;
        private Vector m_ohIds = null;
        private Vector m_icies = null;
        private boolean m_checked = false;

        public OiifdCompOHs(OiiiInstallCompInvEntry icie) {
            this.m_icie = icie;
            this.m_ohIds = new Vector();
            this.m_icies = new Vector();
        }

        public OiiiInstallCompInvEntry getCompInvEntry() {
            return this.m_icie;
        }

        public void addOHInd(int ohInd, OiiiCompInvEntry icie) {
            this.m_ohIds.addElement(new Integer(ohInd));
            this.m_icies.addElement(icie);
        }

        public Vector getOHIds() {
            return this.m_ohIds;
        }

        public boolean isChecked() {
            return this.m_checked;
        }

        public void setChecked(boolean checked) {
            this.m_checked = checked;
        }

        public Vector getCompEntries() {
            return this.m_icies;
        }
    }
}

