/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.sysman.oii.oiif.oiifj.OiifjDirectoryDlg;
import oracle.sysman.oii.oiif.oiifj.OiifjGenericDlg;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjDiskPromptDialog
extends OiifjGenericDlg {
    private String m_sPrompt;
    private JPanel m_pBrowsePanel;
    private String m_sDefLocation;
    private JButton m_fromBrowse;
    private OiifjDirectoryDlg m_fromDlg;
    private JTextField m_fromField;
    private String m_sLabel;
    private int m_nDiskNum;

    public OiifjDiskPromptDialog(Frame f, String defLoc, int nDiskNum, String sLabel) {
        super(f, new JPanel(), true, 3, true);
        this.m_sDefLocation = defLoc;
        this.m_nDiskNum = nDiskNum;
        this.m_sLabel = sLabel;
        this.initDlg();
    }

    private void initDlg() {
        this.setTitle(OiixResourceBundle.getString("S_MULTI_DISK_TITLE"));
        Object[] mArr = new String[]{this.m_sLabel, new Integer(this.m_nDiskNum).toString()};
        String mStr = OiixResourceBundle.getString("S_MULTI_DISK_PROMPT");
        this.m_sPrompt = MessageFormat.format(mStr, mArr);
        this.m_pBrowsePanel = this.createFromPanel(this.m_sPrompt);
        this.setHelpID("OiifdDiskPromptDlg");
        this.setPanel(this.m_pBrowsePanel);
        this.setPrefSize(390, 170);
    }

    private JPanel createFromPanel(String prompt) {
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new BorderLayout());
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        promptLabel.setPreferredAspectRatio(0.0f);
        pPanel.add((Component)promptLabel, "North");
        JPanel dPanel = new JPanel();
        pPanel.add((Component)dPanel, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        dPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 0, 10, 10);
        c.anchor = 18;
        c.weightx = 0.01;
        c.weighty = 0.98;
        c.gridwidth = 1;
        c.fill = 2;
        String locStr = OiixResourceBundle.getString("S_PATH_LABEL");
        JLabel locLabel = new JLabel(locStr);
        gridbag.setConstraints(locLabel, c);
        dPanel.add(locLabel);
        c.weightx = 0.98;
        c.gridwidth = -1;
        this.m_fromField = new JTextField(this.m_sDefLocation);
        locLabel.setLabelFor(this.m_fromField);
        gridbag.setConstraints(this.m_fromField, c);
        dPanel.add(this.m_fromField);
        JButton m_browse = new JButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        m_browse.addActionListener(this);
        c.weightx = 0.01;
        c.gridwidth = 0;
        this.m_fromBrowse = new JButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        this.m_fromBrowse.addActionListener(this);
        gridbag.setConstraints(this.m_fromBrowse, c);
        dPanel.add(this.m_fromBrowse);
        return pPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_fromBrowse) {
            this.onBrowse();
        }
        super.actionPerformed(event);
    }

    private void onBrowse() {
        File curDir;
        String selItem;
        OiipgFileSystem pgFS = new OiipgFileSystem();
        this.m_fromDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)this), OiixResourceBundle.getString("S_CHOOSE_DIR"));
        Object[] mArr = new String[]{this.m_sLabel, new Integer(this.m_nDiskNum).toString()};
        String sPrompt = OiixResourceBundle.getString("S_MULTI_DISK_BROWSE_PROMPT", mArr);
        DirectoryDrive[] volumes = pgFS.getDirectoryDrives();
        if (volumes != null) {
            // empty if block
        }
        if ((selItem = (selItem = this.m_fromField.getText()) != null ? selItem.trim() : "").length() == 0) {
            curDir = new File(System.getProperty("user.dir"));
        } else {
            curDir = new File(selItem);
            if (!curDir.exists()) {
                curDir = new File(System.getProperty("user.dir"));
            } else {
                try {
                    String sFileName = OiixPathOps.getFileCanonicalPath(selItem);
                    curDir = new File(sFileName);
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
        }
        File chosenDir = this.m_fromDlg.runDialog(curDir);
        if (chosenDir != null) {
            String dirStr = chosenDir.getAbsolutePath();
            this.m_fromField.setText(dirStr);
        }
        this.m_fromDlg = null;
    }

    public String getDiskLocation() {
        return this.m_fromField.getText();
    }

    public static void main(String[] args) {
        OiifjDiskPromptDialog dpd = new OiifjDiskPromptDialog(new Frame("Testing"), "/scratch/test", 1, "SDFDS");
        int buttonPressed = dpd.runDialog();
    }
}

