/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.sysman.oii.oiif.oiifj.OiifjGenericDlg;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjExitRebootDlg
extends OiifjGenericDlg
implements ItemListener {
    public static final int S_YES = 0;
    public static final int S_NO = 1;
    public static final int S_LOCAL_ONLY_YES = 2;
    private int m_nSelection = 0;
    private boolean m_bClusterMode = false;
    private String m_sPromptMsg;
    private JRadioButton m_radioBtnNo;
    private JRadioButton m_radioBtnYes;
    private JRadioButton m_radioBtnLocalOnlyYes;

    public OiifjExitRebootDlg(Frame f, String sMessage) {
        this(f, sMessage, false);
    }

    public OiifjExitRebootDlg(Frame f, String sMessage, boolean bClusterMode) {
        super(f, null, true, 3);
        this.unsetPrefSize();
        this.m_sPromptMsg = sMessage;
        this.m_bClusterMode = bClusterMode;
        super.setPanel(this.createMainPanel());
        this.setTitle(OiixResourceBundle.getString("S_EXIT_TITLE"));
        this.setHelpID("OiifdExitRebootDlg");
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        MultiLineLabel label = new MultiLineLabel(this.m_sPromptMsg);
        label.setTextWrapper(WordWrapper.getTextWrapper());
        panel.add((Component)label, "North");
        panel.add((Component)this.createCenterPanel(), "Center");
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel((LayoutManager)new EqualColumnLayout(10, 0, 0));
        String sYes = null;
        String sNo = null;
        String sLocalYes = null;
        if (this.m_bClusterMode) {
            sYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_YES");
            sNo = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_NO");
            sLocalYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_CLUSTER_LOCAL_YES");
        } else {
            sYes = OiixResourceBundle.getString("S_REBOOT_MESSAGE_YES");
            sNo = OiixResourceBundle.getString("S_REBOOT_MESSAGE_NO");
        }
        ButtonGroup group = new ButtonGroup();
        this.m_radioBtnYes = new JRadioButton(sYes, true);
        group.add(this.m_radioBtnYes);
        panel.add(this.m_radioBtnYes);
        this.m_radioBtnYes.addItemListener(this);
        if (this.m_bClusterMode) {
            this.m_radioBtnLocalOnlyYes = new JRadioButton(sLocalYes, false);
            group.add(this.m_radioBtnLocalOnlyYes);
            panel.add(this.m_radioBtnLocalOnlyYes);
            this.m_radioBtnLocalOnlyYes.addItemListener(this);
        }
        this.m_radioBtnNo = new JRadioButton(sNo, false);
        group.add(this.m_radioBtnNo);
        panel.add(this.m_radioBtnNo);
        this.m_radioBtnNo.addItemListener(this);
        return panel;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            this.m_nSelection = source == this.m_radioBtnNo ? 1 : (source == this.m_radioBtnLocalOnlyYes ? 2 : 0);
        }
    }

    public boolean isRebootNowSelected() {
        return this.m_nSelection == 0;
    }

    public boolean isRebootLocalOnlyNowSelected() {
        return this.m_nSelection == 2;
    }

    public static void main(String[] args) {
        Frame f = new Frame("testing");
        OiifjExitRebootDlg dlg = new OiifjExitRebootDlg(f, "testing");
        dlg.runDialog();
    }
}

