/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiif.oiifj.OiifjContentsTabPanel;
import oracle.sysman.oii.oiif.oiifj.OiifjKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpEnvironmentTabPanel;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjInventoryDialog
extends JDialog
implements ActionListener,
ChangeListener,
WindowListener {
    private static Toolkit s_toolkit = null;
    private static final int HEIGHT = 450;
    private static final int WIDTH = 450;
    private static final int INSETS = 10;
    private static final int BUTTON_H_GAP = 10;
    private static final int BUTTON_V_GAP = 10;
    private JTabbedPane m_mainPage = null;
    private JButton m_btnHelp = null;
    private JButton m_btnSaveAs = null;
    private JButton m_btnClose = null;
    private OiifjContentsTabPanel m_contentsTab = null;
    private OiifpEnvironmentTabPanel m_grid = null;
    private Frame m_parentFrame = null;

    public OiifjInventoryDialog(Frame parentFrame, boolean viewOnly, boolean bDeinstallSession, boolean bShowConfirmation, boolean bShowProgress) {
        super(parentFrame, OiixResourceBundle.getString("S_INVENTORY"), true);
        JPanel btnPanel = this.createButtonPanel();
        this.m_contentsTab = new OiifjContentsTabPanel(parentFrame, this, viewOnly, bDeinstallSession, bShowConfirmation, bShowProgress);
        this.m_parentFrame = parentFrame;
        this.addWindowListener(this);
        JPanel dlg = new JPanel();
        dlg.setLayout(new BorderLayout(10, 10));
        EmptyBorder tenPixelMargin = new EmptyBorder(10, 10, 10, 10);
        dlg.setBorder(tenPixelMargin);
        this.m_mainPage = new JTabbedPane();
        this.initTab();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        dlg.add((Component)this.m_mainPage, "Center");
        dlg.add((Component)btnPanel, "South");
        this.getContentPane().add((Component)dlg, "Center");
        OiifmMnemonicOps.processMnemonic(this.m_mainPage);
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int x = maxWidth / 2 - 225;
        int y = maxHeight / 2 - 225;
        this.setBounds(x, y, 450, 450);
        this.setBackground(new Color(204, 204, 204));
        s_toolkit = Toolkit.getDefaultToolkit();
    }

    public OiifjInventoryDialog(Frame parentFrame, boolean viewOnly) {
        this(parentFrame, viewOnly, false, true, true);
    }

    public void enableSave(boolean bEnable) {
        if (this.m_btnSaveAs != null) {
            this.m_btnSaveAs.setEnabled(bEnable);
        }
    }

    public static void main(String[] s) {
        Frame f = new Frame("Dummy Frame");
        f.setSize(500, 500);
        OiifjInventoryDialog inv = new OiifjInventoryDialog(f, true);
        inv.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.m_btnSaveAs) {
            OiifmCursorUtil.setCursor(3, (Component)this);
            FileDialog fd = new FileDialog(this.m_parentFrame, OiixResourceBundle.getString("S_SAVE_AS_TITLE"));
            fd.setDirectory(System.getProperty("user.home"));
            fd.setMode(1);
            fd.show();
            if (null != fd.getFile()) {
                String fileName = fd.getDirectory() + fd.getFile();
                boolean bWriteToFile = true;
                if (OiixPlatform.getCurrentPlatform() == 46) {
                    bWriteToFile = this.confirmFileOverWrite(fileName);
                }
                if (bWriteToFile) {
                    try {
                        FileOutputStream fos = new FileOutputStream(fileName);
                        PrintWriter writer = new PrintWriter(fos);
                        this.m_contentsTab.saveAs(writer);
                        if (this.m_grid != null) {
                            this.m_grid.saveAs(writer);
                        }
                        writer.flush();
                        writer.close();
                    }
                    catch (FileNotFoundException e) {
                        this.showFileSavingErrorAlert(fileName);
                    }
                    catch (IOException e) {
                        this.showFileSavingErrorAlert(fileName);
                    }
                }
            }
            OiifmCursorUtil.setCursor(0, (Component)this);
            this.m_btnSaveAs.requestFocus();
        } else if (evt.getSource() == this.m_btnHelp) {
            int page = this.m_mainPage.getSelectedIndex();
            Component oSelectedTab = this.m_mainPage.getComponentAt(page);
            String v_sKey = oSelectedTab instanceof OiifpEnvironmentTabPanel ? "OiifdHomeSelector" : "OiifdInventoryDlg";
            OiixHelp.displayInstHelp(v_sKey, this);
        } else if (evt.getSource() == this.m_btnClose) {
            this.setVisible(false);
        }
    }

    private void showFileSavingErrorAlert(String fileName) {
        Object[] args = new String[]{fileName};
        String sMsg = OiixResourceBundle.getString("S_ERR_SAVE_FILE");
        sMsg = MessageFormat.format(sMsg, args);
        OiifmAlert.displayError(sMsg);
    }

    private boolean confirmFileOverWrite(String fileName) {
        boolean bWriteToFile = true;
        File invSaveFile = new File(fileName);
        if (invSaveFile.exists()) {
            String message = OiixResourceBundle.getString("S_WARNING_SAVE_FILE_EXISTS");
            int userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), message, 30, 3, 1, 10);
            bWriteToFile = userChoice == 1;
        }
        return bWriteToFile;
    }

    private void initTab() {
        String sTitle = OiixResourceBundle.getString("S_CONTENTS_TAB_TITLE");
        this.m_mainPage.add(StringUtils.stripMnemonic((String)sTitle), this.m_contentsTab);
        int iKeyCode = StringUtils.getMnemonicKeyCode((String)sTitle);
        this.m_mainPage.setMnemonicAt(this.m_mainPage.indexOfTab(StringUtils.stripMnemonic((String)sTitle)), iKeyCode);
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            OiiiInstallInventory inv = this.m_contentsTab.getInventory();
            this.m_grid = new OiifpEnvironmentTabPanel(inv);
            String sTitle1 = OiixResourceBundle.getString("S_ENVIRONMENT_TAB_TITLE");
            this.m_mainPage.add(StringUtils.stripMnemonic((String)sTitle1), this.m_grid);
            int iKeyCode1 = StringUtils.getMnemonicKeyCode((String)sTitle1);
            this.m_mainPage.setMnemonicAt(this.m_mainPage.indexOfTab(StringUtils.stripMnemonic((String)sTitle1)), iKeyCode1);
        }
        this.m_mainPage.setBackground(new Color(204, 204, 204));
        this.m_mainPage.addChangeListener(this);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        GridLayout gLayout = new GridLayout(1, 4, 10, 10);
        buttonPanel.setLayout(gLayout);
        this.m_btnHelp = new JButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this.m_btnHelp.addActionListener(this);
        buttonPanel.add(this.m_btnHelp);
        JButton dummyBtn = new JButton();
        dummyBtn.setVisible(false);
        buttonPanel.add(dummyBtn);
        this.m_btnSaveAs = new JButton(OiixResourceBundle.getString("S_SAVE_AS_BUTTON"));
        this.m_btnSaveAs.addActionListener(this);
        buttonPanel.add(this.m_btnSaveAs);
        this.m_btnClose = new JButton(OiixResourceBundle.getString("S_CLOSE_BUTTON"));
        this.m_btnClose.addActionListener(this);
        buttonPanel.add(this.m_btnClose);
        OiifmMnemonicOps.processMnemonic(buttonPanel);
        return buttonPanel;
    }

    public void stateChanged(ChangeEvent evt) {
        JTabbedPane tabSource = (JTabbedPane)evt.getSource();
        String tab = tabSource.getTitleAt(tabSource.getSelectedIndex());
        int index = tabSource.getSelectedIndex();
        Component comp = tabSource.getComponentAt(index);
        if (comp instanceof OiifpEnvironmentTabPanel) {
            ((OiifpEnvironmentTabPanel)comp).refresh();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void doModal(boolean p_bVisible) {
        this.m_contentsTab.prepareInvTree();
        OiifjKeyActionConverter keyActionConverter = new OiifjKeyActionConverter(this.m_btnClose, this.m_btnHelp, this);
        keyActionConverter.setActionListener(this);
        this.setModal(p_bVisible);
        if (p_bVisible) {
            s_toolkit.beep();
        }
        this.setVisible(p_bVisible);
        this.m_contentsTab.disposeRemoveDlg();
    }

    public void setDelSession(OiicDeinstallSession delSession) {
        this.m_contentsTab.setDelSession(delSession);
    }

    public Vector getDeinstallComps() {
        return this.m_contentsTab.getDeinstallComps();
    }
}

